// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"go.opentelemetry.io/collector/pdata/internal/data"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigProfile(dest, src *otlpprofiles.Profile) {
	dest.SampleType = CopyOrigValueTypeSlice(dest.SampleType, src.SampleType)
	dest.Sample = CopyOrigSampleSlice(dest.Sample, src.Sample)
	dest.LocationIndices = CopyOrigInt32Slice(dest.LocationIndices, src.LocationIndices)
	dest.TimeNanos = src.TimeNanos
	dest.DurationNanos = src.DurationNanos
	CopyOrigValueType(&dest.PeriodType, &src.PeriodType)
	dest.Period = src.Period
	dest.CommentStrindices = CopyOrigInt32Slice(dest.CommentStrindices, src.CommentStrindices)
	dest.DefaultSampleTypeIndex = src.DefaultSampleTypeIndex
	dest.ProfileId = src.ProfileId
	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.OriginalPayloadFormat = src.OriginalPayloadFormat
	dest.OriginalPayload = CopyOrigByteSlice(dest.OriginalPayload, src.OriginalPayload)
	dest.AttributeIndices = CopyOrigInt32Slice(dest.AttributeIndices, src.AttributeIndices)
}

func FillOrigTestProfile(orig *otlpprofiles.Profile) {
	orig.SampleType = GenerateOrigTestValueTypeSlice()
	orig.Sample = GenerateOrigTestSampleSlice()
	orig.LocationIndices = GenerateOrigTestInt32Slice()
	orig.TimeNanos = 1234567890
	orig.DurationNanos = 1234567890
	FillOrigTestValueType(&orig.PeriodType)
	orig.Period = int64(13)
	orig.CommentStrindices = GenerateOrigTestInt32Slice()
	orig.DefaultSampleTypeIndex = int32(13)
	orig.ProfileId = data.ProfileID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	orig.DroppedAttributesCount = uint32(13)
	orig.OriginalPayloadFormat = "test_originalpayloadformat"
	orig.OriginalPayload = GenerateOrigTestByteSlice()
	orig.AttributeIndices = GenerateOrigTestInt32Slice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigProfile(orig *otlpprofiles.Profile, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.SampleType) > 0 {
		dest.WriteObjectField("sampleType")
		dest.WriteArrayStart()
		MarshalJSONOrigValueType(orig.SampleType[0], dest)
		for i := 1; i < len(orig.SampleType); i++ {
			dest.WriteMore()
			MarshalJSONOrigValueType(orig.SampleType[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.Sample) > 0 {
		dest.WriteObjectField("sample")
		dest.WriteArrayStart()
		MarshalJSONOrigSample(orig.Sample[0], dest)
		for i := 1; i < len(orig.Sample); i++ {
			dest.WriteMore()
			MarshalJSONOrigSample(orig.Sample[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.LocationIndices) > 0 {
		dest.WriteObjectField("locationIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.LocationIndices[0])
		for i := 1; i < len(orig.LocationIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.LocationIndices[i])
		}
		dest.WriteArrayEnd()
	}
	if orig.TimeNanos != int64(0) {
		dest.WriteObjectField("timeNanos")
		dest.WriteInt64(orig.TimeNanos)
	}
	if orig.DurationNanos != int64(0) {
		dest.WriteObjectField("durationNanos")
		dest.WriteInt64(orig.DurationNanos)
	}
	dest.WriteObjectField("periodType")
	MarshalJSONOrigValueType(&orig.PeriodType, dest)
	if orig.Period != int64(0) {
		dest.WriteObjectField("period")
		dest.WriteInt64(orig.Period)
	}
	if len(orig.CommentStrindices) > 0 {
		dest.WriteObjectField("commentStrindices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.CommentStrindices[0])
		for i := 1; i < len(orig.CommentStrindices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.CommentStrindices[i])
		}
		dest.WriteArrayEnd()
	}
	if orig.DefaultSampleTypeIndex != int32(0) {
		dest.WriteObjectField("defaultSampleTypeIndex")
		dest.WriteInt32(orig.DefaultSampleTypeIndex)
	}
	if orig.ProfileId != data.ProfileID([16]byte{}) {
		dest.WriteObjectField("profileId")
		MarshalJSONOrigProfileID(&orig.ProfileId, dest)
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if orig.OriginalPayloadFormat != "" {
		dest.WriteObjectField("originalPayloadFormat")
		dest.WriteString(orig.OriginalPayloadFormat)
	}

	if len(orig.OriginalPayload) > 0 {
		dest.WriteObjectField("originalPayload")
		dest.WriteBytes(orig.OriginalPayload)
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigProfile unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigProfile(orig *otlpprofiles.Profile, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "sampleType", "sample_type":
			orig.SampleType = UnmarshalJSONOrigValueTypeSlice(iter)
		case "sample":
			orig.Sample = UnmarshalJSONOrigSampleSlice(iter)
		case "locationIndices", "location_indices":
			orig.LocationIndices = UnmarshalJSONOrigInt32Slice(iter)
		case "timeNanos", "time_nanos":
			orig.TimeNanos = iter.ReadInt64()
		case "durationNanos", "duration_nanos":
			orig.DurationNanos = iter.ReadInt64()
		case "periodType", "period_type":
			UnmarshalJSONOrigValueType(&orig.PeriodType, iter)
		case "period":
			orig.Period = iter.ReadInt64()
		case "commentStrindices", "comment_strindices":
			orig.CommentStrindices = UnmarshalJSONOrigInt32Slice(iter)
		case "defaultSampleTypeIndex", "default_sample_type_index":
			orig.DefaultSampleTypeIndex = iter.ReadInt32()
		case "profileId", "profile_id":
			orig.ProfileId.UnmarshalJSONIter(iter)
		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "originalPayloadFormat", "original_payload_format":
			orig.OriginalPayloadFormat = iter.ReadString()
		case "originalPayload", "original_payload":
			orig.OriginalPayload = UnmarshalJSONOrigByteSlice(iter)
		case "attributeIndices", "attribute_indices":
			orig.AttributeIndices = UnmarshalJSONOrigInt32Slice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigProfile(orig *otlpprofiles.Profile) int {
	var n int
	var l int
	_ = l
	for i := range orig.SampleType {
		l = SizeProtoOrigValueType(orig.SampleType[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.Sample {
		l = SizeProtoOrigSample(orig.Sample[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.LocationIndices) > 0 {
		l = 0
		for _, e := range orig.LocationIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.TimeNanos != 0 {
		n += 1 + proto.Sov(uint64(orig.TimeNanos))
	}
	if orig.DurationNanos != 0 {
		n += 1 + proto.Sov(uint64(orig.DurationNanos))
	}
	l = SizeProtoOrigValueType(&orig.PeriodType)
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Period != 0 {
		n += 1 + proto.Sov(uint64(orig.Period))
	}
	if len(orig.CommentStrindices) > 0 {
		l = 0
		for _, e := range orig.CommentStrindices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DefaultSampleTypeIndex != 0 {
		n += 1 + proto.Sov(uint64(orig.DefaultSampleTypeIndex))
	}
	l = SizeProtoOrigProfileID(&orig.ProfileId)
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	l = len(orig.OriginalPayloadFormat)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.OriginalPayload)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigProfile(orig *otlpprofiles.Profile, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.SampleType {
		l = MarshalProtoOrigValueType(orig.SampleType[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	for i := range orig.Sample {
		l = MarshalProtoOrigSample(orig.Sample[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.LocationIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.LocationIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x1a
	}
	if orig.TimeNanos != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.TimeNanos))
		pos--
		buf[pos] = 0x20
	}
	if orig.DurationNanos != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DurationNanos))
		pos--
		buf[pos] = 0x28
	}

	l = MarshalProtoOrigValueType(&orig.PeriodType, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x32

	if orig.Period != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Period))
		pos--
		buf[pos] = 0x38
	}
	l = len(orig.CommentStrindices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.CommentStrindices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x42
	}
	if orig.DefaultSampleTypeIndex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DefaultSampleTypeIndex))
		pos--
		buf[pos] = 0x48
	}

	l = MarshalProtoOrigProfileID(&orig.ProfileId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x52

	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x58
	}
	l = len(orig.OriginalPayloadFormat)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.OriginalPayloadFormat)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x62
	}
	l = len(orig.OriginalPayload)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.OriginalPayload)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x6a
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x72
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigProfile(orig *otlpprofiles.Profile, buf []byte) error {
	return orig.Unmarshal(buf)
}
