// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSample(t *testing.T) {
	src := &otlpprofiles.Sample{}
	dest := &otlpprofiles.Sample{}
	CopyOrigSample(dest, src)
	assert.Equal(t, &otlpprofiles.Sample{}, dest)
	FillOrigTestSample(src)
	CopyOrigSample(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigSampleUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.Sample{}
	UnmarshalJSONOrigSample(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.Sample{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigSample(t *testing.T) {
	for name, src := range getEncodingTestValuesSample() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigSample(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.Sample{}
			UnmarshalJSONOrigSample(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSample(t *testing.T) {
	for name, src := range getEncodingTestValuesSample() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSample(src))
			gotSize := MarshalProtoOrigSample(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.Sample{}
			require.NoError(t, UnmarshalProtoOrigSample(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesSample() map[string]*otlpprofiles.Sample {
	return map[string]*otlpprofiles.Sample{
		"empty": {},
		"fill_test": func() *otlpprofiles.Sample {
			src := &otlpprofiles.Sample{}
			FillOrigTestSample(src)
			return src
		}(),
		"default_linkindex": {LinkIndex_: &otlpprofiles.Sample_LinkIndex{LinkIndex: int32(0)}},
	}
}
