// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSpan(t *testing.T) {
	src := &otlptrace.Span{}
	dest := &otlptrace.Span{}
	CopyOrigSpan(dest, src)
	assert.Equal(t, &otlptrace.Span{}, dest)
	FillOrigTestSpan(src)
	CopyOrigSpan(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigSpanUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlptrace.Span{}
	UnmarshalJSONOrigSpan(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlptrace.Span{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigSpan(t *testing.T) {
	for name, src := range getEncodingTestValuesSpan() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigSpan(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlptrace.Span{}
			UnmarshalJSONOrigSpan(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSpan(t *testing.T) {
	for name, src := range getEncodingTestValuesSpan() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSpan(src))
			gotSize := MarshalProtoOrigSpan(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlptrace.Span{}
			require.NoError(t, UnmarshalProtoOrigSpan(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesSpan() map[string]*otlptrace.Span {
	return map[string]*otlptrace.Span{
		"empty": {},
		"fill_test": func() *otlptrace.Span {
			src := &otlptrace.Span{}
			FillOrigTestSpan(src)
			return src
		}(),
	}
}
