// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"go.opentelemetry.io/collector/pdata/internal/json"
)

type StringSlice struct {
	orig  *[]string
	state *State
}

func GetOrigStringSlice(ms StringSlice) *[]string {
	return ms.orig
}

func GetStringSliceState(ms StringSlice) *State {
	return ms.state
}

func NewStringSlice(orig *[]string, state *State) StringSlice {
	return StringSlice{orig: orig, state: state}
}

func GenerateTestStringSlice() StringSlice {
	orig := GenerateOrigTestStringSlice()
	state := StateMutable
	return NewStringSlice(&orig, &state)
}

func CopyOrigStringSlice(dst, src []string) []string {
	return append(dst[:0], src...)
}

func GenerateOrigTestStringSlice() []string {
	return []string{"a", "b", "c"}
}

// UnmarshalJSONOrigStringSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigStringSlice(iter *json.Iterator) []string {
	var orig []string
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, iter.ReadString())
		return true
	})
	return orig
}
