// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigSummary(dest, src *otlpmetrics.Summary) {
	dest.DataPoints = CopyOrigSummaryDataPointSlice(dest.DataPoints, src.DataPoints)
}

func FillOrigTestSummary(orig *otlpmetrics.Summary) {
	orig.DataPoints = GenerateOrigTestSummaryDataPointSlice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSummary(orig *otlpmetrics.Summary, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		MarshalJSONOrigSummaryDataPoint(orig.DataPoints[0], dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			MarshalJSONOrigSummaryDataPoint(orig.DataPoints[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSummary unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSummary(orig *otlpmetrics.Summary, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "dataPoints", "data_points":
			orig.DataPoints = UnmarshalJSONOrigSummaryDataPointSlice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigSummary(orig *otlpmetrics.Summary) int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = SizeProtoOrigSummaryDataPoint(orig.DataPoints[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigSummary(orig *otlpmetrics.Summary, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = MarshalProtoOrigSummaryDataPoint(orig.DataPoints[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigSummary(orig *otlpmetrics.Summary, buf []byte) error {
	return orig.Unmarshal(buf)
}
