// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSummary(t *testing.T) {
	src := &otlpmetrics.Summary{}
	dest := &otlpmetrics.Summary{}
	CopyOrigSummary(dest, src)
	assert.Equal(t, &otlpmetrics.Summary{}, dest)
	FillOrigTestSummary(src)
	CopyOrigSummary(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigSummaryUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.Summary{}
	UnmarshalJSONOrigSummary(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.Summary{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigSummary(t *testing.T) {
	for name, src := range getEncodingTestValuesSummary() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigSummary(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.Summary{}
			UnmarshalJSONOrigSummary(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSummary(t *testing.T) {
	for name, src := range getEncodingTestValuesSummary() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSummary(src))
			gotSize := MarshalProtoOrigSummary(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.Summary{}
			require.NoError(t, UnmarshalProtoOrigSummary(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesSummary() map[string]*otlpmetrics.Summary {
	return map[string]*otlpmetrics.Summary{
		"empty": {},
		"fill_test": func() *otlpmetrics.Summary {
			src := &otlpmetrics.Summary{}
			FillOrigTestSummary(src)
			return src
		}(),
	}
}
