// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSummaryDataPoint_ValueAtQuantile(t *testing.T) {
	src := &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
	dest := &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
	CopyOrigSummaryDataPoint_ValueAtQuantile(dest, src)
	assert.Equal(t, &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}, dest)
	FillOrigTestSummaryDataPoint_ValueAtQuantile(src)
	CopyOrigSummaryDataPoint_ValueAtQuantile(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigSummaryDataPoint_ValueAtQuantileUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
	UnmarshalJSONOrigSummaryDataPoint_ValueAtQuantile(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigSummaryDataPoint_ValueAtQuantile(t *testing.T) {
	for name, src := range getEncodingTestValuesSummaryDataPoint_ValueAtQuantile() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigSummaryDataPoint_ValueAtQuantile(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
			UnmarshalJSONOrigSummaryDataPoint_ValueAtQuantile(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(t *testing.T) {
	for name, src := range getEncodingTestValuesSummaryDataPoint_ValueAtQuantile() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSummaryDataPoint_ValueAtQuantile(src))
			gotSize := MarshalProtoOrigSummaryDataPoint_ValueAtQuantile(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
			require.NoError(t, UnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesSummaryDataPoint_ValueAtQuantile() map[string]*otlpmetrics.SummaryDataPoint_ValueAtQuantile {
	return map[string]*otlpmetrics.SummaryDataPoint_ValueAtQuantile{
		"empty": {},
		"fill_test": func() *otlpmetrics.SummaryDataPoint_ValueAtQuantile {
			src := &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
			FillOrigTestSummaryDataPoint_ValueAtQuantile(src)
			return src
		}(),
	}
}
