// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigValueType(t *testing.T) {
	src := &otlpprofiles.ValueType{}
	dest := &otlpprofiles.ValueType{}
	CopyOrigValueType(dest, src)
	assert.Equal(t, &otlpprofiles.ValueType{}, dest)
	FillOrigTestValueType(src)
	CopyOrigValueType(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigValueTypeUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.ValueType{}
	UnmarshalJSONOrigValueType(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.ValueType{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigValueType(t *testing.T) {
	for name, src := range getEncodingTestValuesValueType() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigValueType(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.ValueType{}
			UnmarshalJSONOrigValueType(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigValueType(t *testing.T) {
	for name, src := range getEncodingTestValuesValueType() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigValueType(src))
			gotSize := MarshalProtoOrigValueType(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.ValueType{}
			require.NoError(t, UnmarshalProtoOrigValueType(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesValueType() map[string]*otlpprofiles.ValueType {
	return map[string]*otlpprofiles.ValueType{
		"empty": {},
		"fill_test": func() *otlpprofiles.ValueType {
			src := &otlpprofiles.ValueType{}
			FillOrigTestValueType(src)
			return src
		}(),
	}
}
