// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package plog

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestScopeLogs_MoveTo(t *testing.T) {
	ms := generateTestScopeLogs()
	dest := NewScopeLogs()
	ms.MoveTo(dest)
	assert.Equal(t, NewScopeLogs(), ms)
	assert.Equal(t, generateTestScopeLogs(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestScopeLogs(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newScopeLogs(&otlplogs.ScopeLogs{}, &sharedState)) })
	assert.Panics(t, func() { newScopeLogs(&otlplogs.ScopeLogs{}, &sharedState).MoveTo(dest) })
}

func TestScopeLogs_CopyTo(t *testing.T) {
	ms := NewScopeLogs()
	orig := NewScopeLogs()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestScopeLogs()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newScopeLogs(&otlplogs.ScopeLogs{}, &sharedState)) })
}

func TestScopeLogs_Scope(t *testing.T) {
	ms := NewScopeLogs()
	assert.Equal(t, pcommon.NewInstrumentationScope(), ms.Scope())
	internal.FillOrigTestInstrumentationScope(&ms.orig.Scope)
	assert.Equal(t, pcommon.InstrumentationScope(internal.GenerateTestInstrumentationScope()), ms.Scope())
}

func TestScopeLogs_LogRecords(t *testing.T) {
	ms := NewScopeLogs()
	assert.Equal(t, NewLogRecordSlice(), ms.LogRecords())
	ms.orig.LogRecords = internal.GenerateOrigTestLogRecordSlice()
	assert.Equal(t, generateTestLogRecordSlice(), ms.LogRecords())
}

func TestScopeLogs_SchemaUrl(t *testing.T) {
	ms := NewScopeLogs()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newScopeLogs(&otlplogs.ScopeLogs{}, &sharedState).SetSchemaUrl("test_schemaurl") })
}

func generateTestScopeLogs() ScopeLogs {
	ms := NewScopeLogs()
	internal.FillOrigTestScopeLogs(ms.orig)
	return ms
}
