// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectortrace "go.opentelemetry.io/proto/slim/otlp/collector/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportTraceServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportTraceServiceRequest()
				CopyOrigExportTraceServiceRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportTraceServiceRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportTraceServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportTraceServiceRequest()
	UnmarshalJSONOrigExportTraceServiceRequest(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportTraceServiceRequest(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTraceServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportTraceServiceRequest(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportTraceServiceRequest()
				UnmarshalJSONOrigExportTraceServiceRequest(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportTraceServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTraceServiceRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportTraceServiceRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportTraceServiceRequest()
			require.Error(t, UnmarshalProtoOrigExportTraceServiceRequest(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTraceServiceRequestUnknown(t *testing.T) {
	dest := NewOrigExportTraceServiceRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportTraceServiceRequest(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportTraceServiceRequest(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportTraceServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportTraceServiceRequest(src))
				gotSize := MarshalProtoOrigExportTraceServiceRequest(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportTraceServiceRequest()
				require.NoError(t, UnmarshalProtoOrigExportTraceServiceRequest(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportTraceServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportTraceServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportTraceServiceRequest(src))
			gotSize := MarshalProtoOrigExportTraceServiceRequest(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectortrace.ExportTraceServiceRequest{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportTraceServiceRequest()
			require.NoError(t, UnmarshalProtoOrigExportTraceServiceRequest(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportTraceServiceRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                 {0x02},
		"ResourceSpans/wrong_wire_type": {0xc},
		"ResourceSpans/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportTraceServiceRequest() map[string]*otlpcollectortrace.ExportTraceServiceRequest {
	return map[string]*otlpcollectortrace.ExportTraceServiceRequest{
		"empty":                          NewOrigExportTraceServiceRequest(),
		"ResourceSpans/default_and_test": {ResourceSpans: []*otlptrace.ResourceSpans{{}, GenTestOrigResourceSpans()}},
	}
}
