// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigLocationSlice(t *testing.T) {
	src := []*otlpprofiles.Location{}
	dest := []*otlpprofiles.Location{}
	// Test CopyTo empty
	dest = CopyOrigLocationSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.Location{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestLocationSlice()
	dest = CopyOrigLocationSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLocationSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigLocationSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLocationSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigLocationSlice(dest, []*otlpprofiles.Location{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigLocationSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLocationSlice(), dest)
}
