// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestAttributeUnit_MoveTo(t *testing.T) {
	ms := generateTestAttributeUnit()
	dest := NewAttributeUnit()
	ms.MoveTo(dest)
	assert.Equal(t, NewAttributeUnit(), ms)
	assert.Equal(t, generateTestAttributeUnit(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestAttributeUnit(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newAttributeUnit(internal.NewOrigAttributeUnit(), sharedState)) })
	assert.Panics(t, func() { newAttributeUnit(internal.NewOrigAttributeUnit(), sharedState).MoveTo(dest) })
}

func TestAttributeUnit_CopyTo(t *testing.T) {
	ms := NewAttributeUnit()
	orig := NewAttributeUnit()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestAttributeUnit()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newAttributeUnit(internal.NewOrigAttributeUnit(), sharedState)) })
}

func TestAttributeUnit_AttributeKeyStrindex(t *testing.T) {
	ms := NewAttributeUnit()
	assert.Equal(t, int32(0), ms.AttributeKeyStrindex())
	ms.SetAttributeKeyStrindex(int32(13))
	assert.Equal(t, int32(13), ms.AttributeKeyStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newAttributeUnit(&otlpprofiles.AttributeUnit{}, sharedState).SetAttributeKeyStrindex(int32(13))
	})
}

func TestAttributeUnit_UnitStrindex(t *testing.T) {
	ms := NewAttributeUnit()
	assert.Equal(t, int32(0), ms.UnitStrindex())
	ms.SetUnitStrindex(int32(13))
	assert.Equal(t, int32(13), ms.UnitStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newAttributeUnit(&otlpprofiles.AttributeUnit{}, sharedState).SetUnitStrindex(int32(13)) })
}

func generateTestAttributeUnit() AttributeUnit {
	ms := newAttributeUnit(internal.GenTestOrigAttributeUnit(), internal.NewState())
	return ms
}
