// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run cmd/pdatagen/main.go".

package pdata

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/internal/data/protogen/metrics/v1"
)

func TestResourceMetricsSlice(t *testing.T) {
	es := NewResourceMetricsSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newResourceMetricsSlice(&[]*otlpmetrics.ResourceMetrics{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewResourceMetrics()
	testVal := generateTestResourceMetrics()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestResourceMetrics(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestResourceMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestResourceMetricsSlice()
	dest := NewResourceMetricsSlice()
	src := generateTestResourceMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestResourceMetricsSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestResourceMetricsSlice_CopyTo(t *testing.T) {
	dest := NewResourceMetricsSlice()
	// Test CopyTo to empty
	NewResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, NewResourceMetricsSlice(), dest)

	// Test CopyTo larger slice
	generateTestResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)

	// Test CopyTo same size slice
	generateTestResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
}

func TestResourceMetricsSlice_Resize(t *testing.T) {
	es := generateTestResourceMetricsSlice()
	emptyVal := NewResourceMetrics()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ResourceMetrics]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ResourceMetrics]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestResourceMetricsSlice_Append(t *testing.T) {
	es := generateTestResourceMetricsSlice()

	emptyVal := NewResourceMetrics()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewResourceMetrics()
	fillTestResourceMetrics(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestResourceMetrics_CopyTo(t *testing.T) {
	ms := NewResourceMetrics()
	generateTestResourceMetrics().CopyTo(ms)
	assert.EqualValues(t, generateTestResourceMetrics(), ms)
}

func TestResourceMetrics_Resource(t *testing.T) {
	ms := NewResourceMetrics()
	fillTestResource(ms.Resource())
	assert.EqualValues(t, generateTestResource(), ms.Resource())
}

func TestResourceMetrics_InstrumentationLibraryMetrics(t *testing.T) {
	ms := NewResourceMetrics()
	assert.EqualValues(t, NewInstrumentationLibraryMetricsSlice(), ms.InstrumentationLibraryMetrics())
	fillTestInstrumentationLibraryMetricsSlice(ms.InstrumentationLibraryMetrics())
	testValInstrumentationLibraryMetrics := generateTestInstrumentationLibraryMetricsSlice()
	assert.EqualValues(t, testValInstrumentationLibraryMetrics, ms.InstrumentationLibraryMetrics())
}

func TestInstrumentationLibraryMetricsSlice(t *testing.T) {
	es := NewInstrumentationLibraryMetricsSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newInstrumentationLibraryMetricsSlice(&[]*otlpmetrics.InstrumentationLibraryMetrics{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewInstrumentationLibraryMetrics()
	testVal := generateTestInstrumentationLibraryMetrics()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestInstrumentationLibraryMetrics(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestInstrumentationLibraryMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestInstrumentationLibraryMetricsSlice()
	dest := NewInstrumentationLibraryMetricsSlice()
	src := generateTestInstrumentationLibraryMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestInstrumentationLibraryMetricsSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestInstrumentationLibraryMetricsSlice_CopyTo(t *testing.T) {
	dest := NewInstrumentationLibraryMetricsSlice()
	// Test CopyTo to empty
	NewInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, NewInstrumentationLibraryMetricsSlice(), dest)

	// Test CopyTo larger slice
	generateTestInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)

	// Test CopyTo same size slice
	generateTestInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
}

func TestInstrumentationLibraryMetricsSlice_Resize(t *testing.T) {
	es := generateTestInstrumentationLibraryMetricsSlice()
	emptyVal := NewInstrumentationLibraryMetrics()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestInstrumentationLibraryMetricsSlice_Append(t *testing.T) {
	es := generateTestInstrumentationLibraryMetricsSlice()

	emptyVal := NewInstrumentationLibraryMetrics()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewInstrumentationLibraryMetrics()
	fillTestInstrumentationLibraryMetrics(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestInstrumentationLibraryMetrics_CopyTo(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	generateTestInstrumentationLibraryMetrics().CopyTo(ms)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetrics(), ms)
}

func TestInstrumentationLibraryMetrics_InstrumentationLibrary(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	fillTestInstrumentationLibrary(ms.InstrumentationLibrary())
	assert.EqualValues(t, generateTestInstrumentationLibrary(), ms.InstrumentationLibrary())
}

func TestInstrumentationLibraryMetrics_Metrics(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	assert.EqualValues(t, NewMetricSlice(), ms.Metrics())
	fillTestMetricSlice(ms.Metrics())
	testValMetrics := generateTestMetricSlice()
	assert.EqualValues(t, testValMetrics, ms.Metrics())
}

func TestMetricSlice(t *testing.T) {
	es := NewMetricSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newMetricSlice(&[]*otlpmetrics.Metric{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewMetric()
	testVal := generateTestMetric()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestMetric(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestMetricSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestMetricSlice()
	dest := NewMetricSlice()
	src := generateTestMetricSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestMetricSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestMetricSlice_CopyTo(t *testing.T) {
	dest := NewMetricSlice()
	// Test CopyTo to empty
	NewMetricSlice().CopyTo(dest)
	assert.EqualValues(t, NewMetricSlice(), dest)

	// Test CopyTo larger slice
	generateTestMetricSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)

	// Test CopyTo same size slice
	generateTestMetricSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
}

func TestMetricSlice_Resize(t *testing.T) {
	es := generateTestMetricSlice()
	emptyVal := NewMetric()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.Metric]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.Metric]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestMetricSlice_Append(t *testing.T) {
	es := generateTestMetricSlice()

	emptyVal := NewMetric()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewMetric()
	fillTestMetric(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestMetric_CopyTo(t *testing.T) {
	ms := NewMetric()
	generateTestMetric().CopyTo(ms)
	assert.EqualValues(t, generateTestMetric(), ms)
}

func TestMetric_Name(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Name())
	testValName := "test_name"
	ms.SetName(testValName)
	assert.EqualValues(t, testValName, ms.Name())
}

func TestMetric_Description(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Description())
	testValDescription := "test_description"
	ms.SetDescription(testValDescription)
	assert.EqualValues(t, testValDescription, ms.Description())
}

func TestMetric_Unit(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Unit())
	testValUnit := "1"
	ms.SetUnit(testValUnit)
	assert.EqualValues(t, testValUnit, ms.Unit())
}

func TestIntGauge_CopyTo(t *testing.T) {
	ms := NewIntGauge()
	generateTestIntGauge().CopyTo(ms)
	assert.EqualValues(t, generateTestIntGauge(), ms)
}

func TestIntGauge_DataPoints(t *testing.T) {
	ms := NewIntGauge()
	assert.EqualValues(t, NewIntDataPointSlice(), ms.DataPoints())
	fillTestIntDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestIntDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestDoubleGauge_CopyTo(t *testing.T) {
	ms := NewDoubleGauge()
	generateTestDoubleGauge().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleGauge(), ms)
}

func TestDoubleGauge_DataPoints(t *testing.T) {
	ms := NewDoubleGauge()
	assert.EqualValues(t, NewDoubleDataPointSlice(), ms.DataPoints())
	fillTestDoubleDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestDoubleDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestIntSum_CopyTo(t *testing.T) {
	ms := NewIntSum()
	generateTestIntSum().CopyTo(ms)
	assert.EqualValues(t, generateTestIntSum(), ms)
}

func TestIntSum_AggregationTemporality(t *testing.T) {
	ms := NewIntSum()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestIntSum_IsMonotonic(t *testing.T) {
	ms := NewIntSum()
	assert.EqualValues(t, false, ms.IsMonotonic())
	testValIsMonotonic := true
	ms.SetIsMonotonic(testValIsMonotonic)
	assert.EqualValues(t, testValIsMonotonic, ms.IsMonotonic())
}

func TestIntSum_DataPoints(t *testing.T) {
	ms := NewIntSum()
	assert.EqualValues(t, NewIntDataPointSlice(), ms.DataPoints())
	fillTestIntDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestIntDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestDoubleSum_CopyTo(t *testing.T) {
	ms := NewDoubleSum()
	generateTestDoubleSum().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleSum(), ms)
}

func TestDoubleSum_AggregationTemporality(t *testing.T) {
	ms := NewDoubleSum()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestDoubleSum_IsMonotonic(t *testing.T) {
	ms := NewDoubleSum()
	assert.EqualValues(t, false, ms.IsMonotonic())
	testValIsMonotonic := true
	ms.SetIsMonotonic(testValIsMonotonic)
	assert.EqualValues(t, testValIsMonotonic, ms.IsMonotonic())
}

func TestDoubleSum_DataPoints(t *testing.T) {
	ms := NewDoubleSum()
	assert.EqualValues(t, NewDoubleDataPointSlice(), ms.DataPoints())
	fillTestDoubleDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestDoubleDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestIntHistogram_CopyTo(t *testing.T) {
	ms := NewIntHistogram()
	generateTestIntHistogram().CopyTo(ms)
	assert.EqualValues(t, generateTestIntHistogram(), ms)
}

func TestIntHistogram_AggregationTemporality(t *testing.T) {
	ms := NewIntHistogram()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestIntHistogram_DataPoints(t *testing.T) {
	ms := NewIntHistogram()
	assert.EqualValues(t, NewIntHistogramDataPointSlice(), ms.DataPoints())
	fillTestIntHistogramDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestIntHistogramDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestDoubleHistogram_CopyTo(t *testing.T) {
	ms := NewDoubleHistogram()
	generateTestDoubleHistogram().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleHistogram(), ms)
}

func TestDoubleHistogram_AggregationTemporality(t *testing.T) {
	ms := NewDoubleHistogram()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestDoubleHistogram_DataPoints(t *testing.T) {
	ms := NewDoubleHistogram()
	assert.EqualValues(t, NewDoubleHistogramDataPointSlice(), ms.DataPoints())
	fillTestDoubleHistogramDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestDoubleHistogramDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestDoubleSummary_CopyTo(t *testing.T) {
	ms := NewDoubleSummary()
	generateTestDoubleSummary().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleSummary(), ms)
}

func TestDoubleSummary_DataPoints(t *testing.T) {
	ms := NewDoubleSummary()
	assert.EqualValues(t, NewDoubleSummaryDataPointSlice(), ms.DataPoints())
	fillTestDoubleSummaryDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestDoubleSummaryDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestIntDataPointSlice(t *testing.T) {
	es := NewIntDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newIntDataPointSlice(&[]*otlpmetrics.IntDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewIntDataPoint()
	testVal := generateTestIntDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestIntDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestIntDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestIntDataPointSlice()
	dest := NewIntDataPointSlice()
	src := generateTestIntDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestIntDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestIntDataPointSlice_CopyTo(t *testing.T) {
	dest := NewIntDataPointSlice()
	// Test CopyTo to empty
	NewIntDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewIntDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestIntDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestIntDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntDataPointSlice(), dest)
}

func TestIntDataPointSlice_Resize(t *testing.T) {
	es := generateTestIntDataPointSlice()
	emptyVal := NewIntDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.IntDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.IntDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.IntDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.IntDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestIntDataPointSlice_Append(t *testing.T) {
	es := generateTestIntDataPointSlice()

	emptyVal := NewIntDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewIntDataPoint()
	fillTestIntDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestIntDataPoint_CopyTo(t *testing.T) {
	ms := NewIntDataPoint()
	generateTestIntDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestIntDataPoint(), ms)
}

func TestIntDataPoint_LabelsMap(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestIntDataPoint_StartTime(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTime())
	testValStartTime := Timestamp(1234567890)
	ms.SetStartTime(testValStartTime)
	assert.EqualValues(t, testValStartTime, ms.StartTime())
}

func TestIntDataPoint_Timestamp(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestIntDataPoint_Value(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, int64(0), ms.Value())
	testValValue := int64(-17)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestIntDataPoint_Exemplars(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, NewIntExemplarSlice(), ms.Exemplars())
	fillTestIntExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestIntExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestDoubleDataPointSlice(t *testing.T) {
	es := NewDoubleDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newDoubleDataPointSlice(&[]*otlpmetrics.DoubleDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewDoubleDataPoint()
	testVal := generateTestDoubleDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestDoubleDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestDoubleDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestDoubleDataPointSlice()
	dest := NewDoubleDataPointSlice()
	src := generateTestDoubleDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestDoubleDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestDoubleDataPointSlice_CopyTo(t *testing.T) {
	dest := NewDoubleDataPointSlice()
	// Test CopyTo to empty
	NewDoubleDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewDoubleDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestDoubleDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestDoubleDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleDataPointSlice(), dest)
}

func TestDoubleDataPointSlice_Resize(t *testing.T) {
	es := generateTestDoubleDataPointSlice()
	emptyVal := NewDoubleDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestDoubleDataPointSlice_Append(t *testing.T) {
	es := generateTestDoubleDataPointSlice()

	emptyVal := NewDoubleDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewDoubleDataPoint()
	fillTestDoubleDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestDoubleDataPoint_CopyTo(t *testing.T) {
	ms := NewDoubleDataPoint()
	generateTestDoubleDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleDataPoint(), ms)
}

func TestDoubleDataPoint_LabelsMap(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestDoubleDataPoint_StartTime(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTime())
	testValStartTime := Timestamp(1234567890)
	ms.SetStartTime(testValStartTime)
	assert.EqualValues(t, testValStartTime, ms.StartTime())
}

func TestDoubleDataPoint_Timestamp(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestDoubleDataPoint_Value(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Value())
	testValValue := float64(17.13)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestDoubleDataPoint_Exemplars(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, NewDoubleExemplarSlice(), ms.Exemplars())
	fillTestDoubleExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestDoubleExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestIntHistogramDataPointSlice(t *testing.T) {
	es := NewIntHistogramDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newIntHistogramDataPointSlice(&[]*otlpmetrics.IntHistogramDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewIntHistogramDataPoint()
	testVal := generateTestIntHistogramDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestIntHistogramDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestIntHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestIntHistogramDataPointSlice()
	dest := NewIntHistogramDataPointSlice()
	src := generateTestIntHistogramDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestIntHistogramDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestIntHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewIntHistogramDataPointSlice()
	// Test CopyTo to empty
	NewIntHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewIntHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestIntHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestIntHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntHistogramDataPointSlice(), dest)
}

func TestIntHistogramDataPointSlice_Resize(t *testing.T) {
	es := generateTestIntHistogramDataPointSlice()
	emptyVal := NewIntHistogramDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.IntHistogramDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.IntHistogramDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.IntHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.IntHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestIntHistogramDataPointSlice_Append(t *testing.T) {
	es := generateTestIntHistogramDataPointSlice()

	emptyVal := NewIntHistogramDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewIntHistogramDataPoint()
	fillTestIntHistogramDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestIntHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	generateTestIntHistogramDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestIntHistogramDataPoint(), ms)
}

func TestIntHistogramDataPoint_LabelsMap(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestIntHistogramDataPoint_StartTime(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTime())
	testValStartTime := Timestamp(1234567890)
	ms.SetStartTime(testValStartTime)
	assert.EqualValues(t, testValStartTime, ms.StartTime())
}

func TestIntHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestIntHistogramDataPoint_Count(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestIntHistogramDataPoint_Sum(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, int64(0.0), ms.Sum())
	testValSum := int64(1713)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestIntHistogramDataPoint_BucketCounts(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, []uint64(nil), ms.BucketCounts())
	testValBucketCounts := []uint64{1, 2, 3}
	ms.SetBucketCounts(testValBucketCounts)
	assert.EqualValues(t, testValBucketCounts, ms.BucketCounts())
}

func TestIntHistogramDataPoint_ExplicitBounds(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, []float64(nil), ms.ExplicitBounds())
	testValExplicitBounds := []float64{1, 2, 3}
	ms.SetExplicitBounds(testValExplicitBounds)
	assert.EqualValues(t, testValExplicitBounds, ms.ExplicitBounds())
}

func TestIntHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, NewIntExemplarSlice(), ms.Exemplars())
	fillTestIntExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestIntExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestDoubleHistogramDataPointSlice(t *testing.T) {
	es := NewDoubleHistogramDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newDoubleHistogramDataPointSlice(&[]*otlpmetrics.DoubleHistogramDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewDoubleHistogramDataPoint()
	testVal := generateTestDoubleHistogramDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestDoubleHistogramDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestDoubleHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestDoubleHistogramDataPointSlice()
	dest := NewDoubleHistogramDataPointSlice()
	src := generateTestDoubleHistogramDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestDoubleHistogramDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestDoubleHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewDoubleHistogramDataPointSlice()
	// Test CopyTo to empty
	NewDoubleHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewDoubleHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestDoubleHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestDoubleHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleHistogramDataPointSlice(), dest)
}

func TestDoubleHistogramDataPointSlice_Resize(t *testing.T) {
	es := generateTestDoubleHistogramDataPointSlice()
	emptyVal := NewDoubleHistogramDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleHistogramDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleHistogramDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestDoubleHistogramDataPointSlice_Append(t *testing.T) {
	es := generateTestDoubleHistogramDataPointSlice()

	emptyVal := NewDoubleHistogramDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewDoubleHistogramDataPoint()
	fillTestDoubleHistogramDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestDoubleHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	generateTestDoubleHistogramDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleHistogramDataPoint(), ms)
}

func TestDoubleHistogramDataPoint_LabelsMap(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestDoubleHistogramDataPoint_StartTime(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTime())
	testValStartTime := Timestamp(1234567890)
	ms.SetStartTime(testValStartTime)
	assert.EqualValues(t, testValStartTime, ms.StartTime())
}

func TestDoubleHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestDoubleHistogramDataPoint_Count(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestDoubleHistogramDataPoint_Sum(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestDoubleHistogramDataPoint_BucketCounts(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	assert.EqualValues(t, []uint64(nil), ms.BucketCounts())
	testValBucketCounts := []uint64{1, 2, 3}
	ms.SetBucketCounts(testValBucketCounts)
	assert.EqualValues(t, testValBucketCounts, ms.BucketCounts())
}

func TestDoubleHistogramDataPoint_ExplicitBounds(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	assert.EqualValues(t, []float64(nil), ms.ExplicitBounds())
	testValExplicitBounds := []float64{1, 2, 3}
	ms.SetExplicitBounds(testValExplicitBounds)
	assert.EqualValues(t, testValExplicitBounds, ms.ExplicitBounds())
}

func TestDoubleHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewDoubleHistogramDataPoint()
	assert.EqualValues(t, NewDoubleExemplarSlice(), ms.Exemplars())
	fillTestDoubleExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestDoubleExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestDoubleSummaryDataPointSlice(t *testing.T) {
	es := NewDoubleSummaryDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newDoubleSummaryDataPointSlice(&[]*otlpmetrics.DoubleSummaryDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewDoubleSummaryDataPoint()
	testVal := generateTestDoubleSummaryDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestDoubleSummaryDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestDoubleSummaryDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestDoubleSummaryDataPointSlice()
	dest := NewDoubleSummaryDataPointSlice()
	src := generateTestDoubleSummaryDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleSummaryDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleSummaryDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestDoubleSummaryDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestDoubleSummaryDataPointSlice_CopyTo(t *testing.T) {
	dest := NewDoubleSummaryDataPointSlice()
	// Test CopyTo to empty
	NewDoubleSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewDoubleSummaryDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestDoubleSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleSummaryDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestDoubleSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleSummaryDataPointSlice(), dest)
}

func TestDoubleSummaryDataPointSlice_Resize(t *testing.T) {
	es := generateTestDoubleSummaryDataPointSlice()
	emptyVal := NewDoubleSummaryDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleSummaryDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleSummaryDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleSummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleSummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestDoubleSummaryDataPointSlice_Append(t *testing.T) {
	es := generateTestDoubleSummaryDataPointSlice()

	emptyVal := NewDoubleSummaryDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewDoubleSummaryDataPoint()
	fillTestDoubleSummaryDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestDoubleSummaryDataPoint_CopyTo(t *testing.T) {
	ms := NewDoubleSummaryDataPoint()
	generateTestDoubleSummaryDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleSummaryDataPoint(), ms)
}

func TestDoubleSummaryDataPoint_LabelsMap(t *testing.T) {
	ms := NewDoubleSummaryDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestDoubleSummaryDataPoint_StartTime(t *testing.T) {
	ms := NewDoubleSummaryDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTime())
	testValStartTime := Timestamp(1234567890)
	ms.SetStartTime(testValStartTime)
	assert.EqualValues(t, testValStartTime, ms.StartTime())
}

func TestDoubleSummaryDataPoint_Timestamp(t *testing.T) {
	ms := NewDoubleSummaryDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestDoubleSummaryDataPoint_Count(t *testing.T) {
	ms := NewDoubleSummaryDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestDoubleSummaryDataPoint_Sum(t *testing.T) {
	ms := NewDoubleSummaryDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestDoubleSummaryDataPoint_QuantileValues(t *testing.T) {
	ms := NewDoubleSummaryDataPoint()
	assert.EqualValues(t, NewValueAtQuantileSlice(), ms.QuantileValues())
	fillTestValueAtQuantileSlice(ms.QuantileValues())
	testValQuantileValues := generateTestValueAtQuantileSlice()
	assert.EqualValues(t, testValQuantileValues, ms.QuantileValues())
}

func TestValueAtQuantileSlice(t *testing.T) {
	es := NewValueAtQuantileSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newValueAtQuantileSlice(&[]*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewValueAtQuantile()
	testVal := generateTestValueAtQuantile()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestValueAtQuantile(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestValueAtQuantileSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestValueAtQuantileSlice()
	dest := NewValueAtQuantileSlice()
	src := generateTestValueAtQuantileSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestValueAtQuantileSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestValueAtQuantileSlice_CopyTo(t *testing.T) {
	dest := NewValueAtQuantileSlice()
	// Test CopyTo to empty
	NewValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, NewValueAtQuantileSlice(), dest)

	// Test CopyTo larger slice
	generateTestValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)

	// Test CopyTo same size slice
	generateTestValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
}

func TestValueAtQuantileSlice_Resize(t *testing.T) {
	es := generateTestValueAtQuantileSlice()
	emptyVal := NewValueAtQuantile()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestValueAtQuantileSlice_Append(t *testing.T) {
	es := generateTestValueAtQuantileSlice()

	emptyVal := NewValueAtQuantile()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewValueAtQuantile()
	fillTestValueAtQuantile(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestValueAtQuantile_CopyTo(t *testing.T) {
	ms := NewValueAtQuantile()
	generateTestValueAtQuantile().CopyTo(ms)
	assert.EqualValues(t, generateTestValueAtQuantile(), ms)
}

func TestValueAtQuantile_Quantile(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.EqualValues(t, float64(0.0), ms.Quantile())
	testValQuantile := float64(17.13)
	ms.SetQuantile(testValQuantile)
	assert.EqualValues(t, testValQuantile, ms.Quantile())
}

func TestValueAtQuantile_Value(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.EqualValues(t, float64(0.0), ms.Value())
	testValValue := float64(17.13)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestIntExemplarSlice(t *testing.T) {
	es := NewIntExemplarSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newIntExemplarSlice(&[]otlpmetrics.IntExemplar{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewIntExemplar()
	testVal := generateTestIntExemplar()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestIntExemplar(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestIntExemplarSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestIntExemplarSlice()
	dest := NewIntExemplarSlice()
	src := generateTestIntExemplarSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestIntExemplarSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestIntExemplarSlice_CopyTo(t *testing.T) {
	dest := NewIntExemplarSlice()
	// Test CopyTo to empty
	NewIntExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, NewIntExemplarSlice(), dest)

	// Test CopyTo larger slice
	generateTestIntExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntExemplarSlice(), dest)

	// Test CopyTo same size slice
	generateTestIntExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntExemplarSlice(), dest)
}

func TestIntExemplarSlice_Resize(t *testing.T) {
	es := generateTestIntExemplarSlice()
	emptyVal := NewIntExemplar()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.IntExemplar]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.IntExemplar]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.IntExemplar]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.IntExemplar]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestIntExemplarSlice_Append(t *testing.T) {
	es := generateTestIntExemplarSlice()

	emptyVal := NewIntExemplar()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal, es.At(7))

	value := NewIntExemplar()
	fillTestIntExemplar(value)
	es.Append(value)
	assert.EqualValues(t, value, es.At(8))

	assert.Equal(t, 9, es.Len())
}

func TestIntExemplar_CopyTo(t *testing.T) {
	ms := NewIntExemplar()
	generateTestIntExemplar().CopyTo(ms)
	assert.EqualValues(t, generateTestIntExemplar(), ms)
}

func TestIntExemplar_Timestamp(t *testing.T) {
	ms := NewIntExemplar()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestIntExemplar_Value(t *testing.T) {
	ms := NewIntExemplar()
	assert.EqualValues(t, int64(0), ms.Value())
	testValValue := int64(-17)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestIntExemplar_FilteredLabels(t *testing.T) {
	ms := NewIntExemplar()
	assert.EqualValues(t, NewStringMap(), ms.FilteredLabels())
	fillTestStringMap(ms.FilteredLabels())
	testValFilteredLabels := generateTestStringMap()
	assert.EqualValues(t, testValFilteredLabels, ms.FilteredLabels())
}

func TestDoubleExemplarSlice(t *testing.T) {
	es := NewDoubleExemplarSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newDoubleExemplarSlice(&[]otlpmetrics.DoubleExemplar{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewDoubleExemplar()
	testVal := generateTestDoubleExemplar()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestDoubleExemplar(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestDoubleExemplarSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestDoubleExemplarSlice()
	dest := NewDoubleExemplarSlice()
	src := generateTestDoubleExemplarSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestDoubleExemplarSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestDoubleExemplarSlice_CopyTo(t *testing.T) {
	dest := NewDoubleExemplarSlice()
	// Test CopyTo to empty
	NewDoubleExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, NewDoubleExemplarSlice(), dest)

	// Test CopyTo larger slice
	generateTestDoubleExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleExemplarSlice(), dest)

	// Test CopyTo same size slice
	generateTestDoubleExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleExemplarSlice(), dest)
}

func TestDoubleExemplarSlice_Resize(t *testing.T) {
	es := generateTestDoubleExemplarSlice()
	emptyVal := NewDoubleExemplar()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleExemplar]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleExemplar]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleExemplar]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleExemplar]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestDoubleExemplarSlice_Append(t *testing.T) {
	es := generateTestDoubleExemplarSlice()

	emptyVal := NewDoubleExemplar()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal, es.At(7))

	value := NewDoubleExemplar()
	fillTestDoubleExemplar(value)
	es.Append(value)
	assert.EqualValues(t, value, es.At(8))

	assert.Equal(t, 9, es.Len())
}

func TestDoubleExemplar_CopyTo(t *testing.T) {
	ms := NewDoubleExemplar()
	generateTestDoubleExemplar().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleExemplar(), ms)
}

func TestDoubleExemplar_Timestamp(t *testing.T) {
	ms := NewDoubleExemplar()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestDoubleExemplar_Value(t *testing.T) {
	ms := NewDoubleExemplar()
	assert.EqualValues(t, float64(0.0), ms.Value())
	testValValue := float64(17.13)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestDoubleExemplar_FilteredLabels(t *testing.T) {
	ms := NewDoubleExemplar()
	assert.EqualValues(t, NewStringMap(), ms.FilteredLabels())
	fillTestStringMap(ms.FilteredLabels())
	testValFilteredLabels := generateTestStringMap()
	assert.EqualValues(t, testValFilteredLabels, ms.FilteredLabels())
}

func generateTestResourceMetricsSlice() ResourceMetricsSlice {
	tv := NewResourceMetricsSlice()
	fillTestResourceMetricsSlice(tv)
	return tv
}

func fillTestResourceMetricsSlice(tv ResourceMetricsSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestResourceMetrics(tv.At(i))
	}
}

func generateTestResourceMetrics() ResourceMetrics {
	tv := NewResourceMetrics()
	fillTestResourceMetrics(tv)
	return tv
}

func fillTestResourceMetrics(tv ResourceMetrics) {
	fillTestResource(tv.Resource())
	fillTestInstrumentationLibraryMetricsSlice(tv.InstrumentationLibraryMetrics())
}

func generateTestInstrumentationLibraryMetricsSlice() InstrumentationLibraryMetricsSlice {
	tv := NewInstrumentationLibraryMetricsSlice()
	fillTestInstrumentationLibraryMetricsSlice(tv)
	return tv
}

func fillTestInstrumentationLibraryMetricsSlice(tv InstrumentationLibraryMetricsSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestInstrumentationLibraryMetrics(tv.At(i))
	}
}

func generateTestInstrumentationLibraryMetrics() InstrumentationLibraryMetrics {
	tv := NewInstrumentationLibraryMetrics()
	fillTestInstrumentationLibraryMetrics(tv)
	return tv
}

func fillTestInstrumentationLibraryMetrics(tv InstrumentationLibraryMetrics) {
	fillTestInstrumentationLibrary(tv.InstrumentationLibrary())
	fillTestMetricSlice(tv.Metrics())
}

func generateTestMetricSlice() MetricSlice {
	tv := NewMetricSlice()
	fillTestMetricSlice(tv)
	return tv
}

func fillTestMetricSlice(tv MetricSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestMetric(tv.At(i))
	}
}

func generateTestMetric() Metric {
	tv := NewMetric()
	fillTestMetric(tv)
	return tv
}

func fillTestMetric(tv Metric) {
	tv.SetName("test_name")
	tv.SetDescription("test_description")
	tv.SetUnit("1")
	(*tv.orig).Data = &otlpmetrics.Metric_IntGauge{IntGauge: &otlpmetrics.IntGauge{}}
	fillTestIntGauge(tv.IntGauge())
}

func generateTestIntGauge() IntGauge {
	tv := NewIntGauge()
	fillTestIntGauge(tv)
	return tv
}

func fillTestIntGauge(tv IntGauge) {
	fillTestIntDataPointSlice(tv.DataPoints())
}

func generateTestDoubleGauge() DoubleGauge {
	tv := NewDoubleGauge()
	fillTestDoubleGauge(tv)
	return tv
}

func fillTestDoubleGauge(tv DoubleGauge) {
	fillTestDoubleDataPointSlice(tv.DataPoints())
}

func generateTestIntSum() IntSum {
	tv := NewIntSum()
	fillTestIntSum(tv)
	return tv
}

func fillTestIntSum(tv IntSum) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	tv.SetIsMonotonic(true)
	fillTestIntDataPointSlice(tv.DataPoints())
}

func generateTestDoubleSum() DoubleSum {
	tv := NewDoubleSum()
	fillTestDoubleSum(tv)
	return tv
}

func fillTestDoubleSum(tv DoubleSum) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	tv.SetIsMonotonic(true)
	fillTestDoubleDataPointSlice(tv.DataPoints())
}

func generateTestIntHistogram() IntHistogram {
	tv := NewIntHistogram()
	fillTestIntHistogram(tv)
	return tv
}

func fillTestIntHistogram(tv IntHistogram) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	fillTestIntHistogramDataPointSlice(tv.DataPoints())
}

func generateTestDoubleHistogram() DoubleHistogram {
	tv := NewDoubleHistogram()
	fillTestDoubleHistogram(tv)
	return tv
}

func fillTestDoubleHistogram(tv DoubleHistogram) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	fillTestDoubleHistogramDataPointSlice(tv.DataPoints())
}

func generateTestDoubleSummary() DoubleSummary {
	tv := NewDoubleSummary()
	fillTestDoubleSummary(tv)
	return tv
}

func fillTestDoubleSummary(tv DoubleSummary) {
	fillTestDoubleSummaryDataPointSlice(tv.DataPoints())
}

func generateTestIntDataPointSlice() IntDataPointSlice {
	tv := NewIntDataPointSlice()
	fillTestIntDataPointSlice(tv)
	return tv
}

func fillTestIntDataPointSlice(tv IntDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestIntDataPoint(tv.At(i))
	}
}

func generateTestIntDataPoint() IntDataPoint {
	tv := NewIntDataPoint()
	fillTestIntDataPoint(tv)
	return tv
}

func fillTestIntDataPoint(tv IntDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTime(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetValue(int64(-17))
	fillTestIntExemplarSlice(tv.Exemplars())
}

func generateTestDoubleDataPointSlice() DoubleDataPointSlice {
	tv := NewDoubleDataPointSlice()
	fillTestDoubleDataPointSlice(tv)
	return tv
}

func fillTestDoubleDataPointSlice(tv DoubleDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestDoubleDataPoint(tv.At(i))
	}
}

func generateTestDoubleDataPoint() DoubleDataPoint {
	tv := NewDoubleDataPoint()
	fillTestDoubleDataPoint(tv)
	return tv
}

func fillTestDoubleDataPoint(tv DoubleDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTime(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetValue(float64(17.13))
	fillTestDoubleExemplarSlice(tv.Exemplars())
}

func generateTestIntHistogramDataPointSlice() IntHistogramDataPointSlice {
	tv := NewIntHistogramDataPointSlice()
	fillTestIntHistogramDataPointSlice(tv)
	return tv
}

func fillTestIntHistogramDataPointSlice(tv IntHistogramDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestIntHistogramDataPoint(tv.At(i))
	}
}

func generateTestIntHistogramDataPoint() IntHistogramDataPoint {
	tv := NewIntHistogramDataPoint()
	fillTestIntHistogramDataPoint(tv)
	return tv
}

func fillTestIntHistogramDataPoint(tv IntHistogramDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTime(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(int64(1713))
	tv.SetBucketCounts([]uint64{1, 2, 3})
	tv.SetExplicitBounds([]float64{1, 2, 3})
	fillTestIntExemplarSlice(tv.Exemplars())
}

func generateTestDoubleHistogramDataPointSlice() DoubleHistogramDataPointSlice {
	tv := NewDoubleHistogramDataPointSlice()
	fillTestDoubleHistogramDataPointSlice(tv)
	return tv
}

func fillTestDoubleHistogramDataPointSlice(tv DoubleHistogramDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestDoubleHistogramDataPoint(tv.At(i))
	}
}

func generateTestDoubleHistogramDataPoint() DoubleHistogramDataPoint {
	tv := NewDoubleHistogramDataPoint()
	fillTestDoubleHistogramDataPoint(tv)
	return tv
}

func fillTestDoubleHistogramDataPoint(tv DoubleHistogramDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTime(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	tv.SetBucketCounts([]uint64{1, 2, 3})
	tv.SetExplicitBounds([]float64{1, 2, 3})
	fillTestDoubleExemplarSlice(tv.Exemplars())
}

func generateTestDoubleSummaryDataPointSlice() DoubleSummaryDataPointSlice {
	tv := NewDoubleSummaryDataPointSlice()
	fillTestDoubleSummaryDataPointSlice(tv)
	return tv
}

func fillTestDoubleSummaryDataPointSlice(tv DoubleSummaryDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestDoubleSummaryDataPoint(tv.At(i))
	}
}

func generateTestDoubleSummaryDataPoint() DoubleSummaryDataPoint {
	tv := NewDoubleSummaryDataPoint()
	fillTestDoubleSummaryDataPoint(tv)
	return tv
}

func fillTestDoubleSummaryDataPoint(tv DoubleSummaryDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTime(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	fillTestValueAtQuantileSlice(tv.QuantileValues())
}

func generateTestValueAtQuantileSlice() ValueAtQuantileSlice {
	tv := NewValueAtQuantileSlice()
	fillTestValueAtQuantileSlice(tv)
	return tv
}

func fillTestValueAtQuantileSlice(tv ValueAtQuantileSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestValueAtQuantile(tv.At(i))
	}
}

func generateTestValueAtQuantile() ValueAtQuantile {
	tv := NewValueAtQuantile()
	fillTestValueAtQuantile(tv)
	return tv
}

func fillTestValueAtQuantile(tv ValueAtQuantile) {
	tv.SetQuantile(float64(17.13))
	tv.SetValue(float64(17.13))
}

func generateTestIntExemplarSlice() IntExemplarSlice {
	tv := NewIntExemplarSlice()
	fillTestIntExemplarSlice(tv)
	return tv
}

func fillTestIntExemplarSlice(tv IntExemplarSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestIntExemplar(tv.At(i))
	}
}

func generateTestIntExemplar() IntExemplar {
	tv := NewIntExemplar()
	fillTestIntExemplar(tv)
	return tv
}

func fillTestIntExemplar(tv IntExemplar) {
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetValue(int64(-17))
	fillTestStringMap(tv.FilteredLabels())
}

func generateTestDoubleExemplarSlice() DoubleExemplarSlice {
	tv := NewDoubleExemplarSlice()
	fillTestDoubleExemplarSlice(tv)
	return tv
}

func fillTestDoubleExemplarSlice(tv DoubleExemplarSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestDoubleExemplar(tv.At(i))
	}
}

func generateTestDoubleExemplar() DoubleExemplar {
	tv := NewDoubleExemplar()
	fillTestDoubleExemplar(tv)
	return tv
}

func fillTestDoubleExemplar(tv DoubleExemplar) {
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetValue(float64(17.13))
	fillTestStringMap(tv.FilteredLabels())
}
