// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/trace/v1/trace.proto

package v1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"

	go_opentelemetry_io_collector_model_internal_data "go.opentelemetry.io/collector/model/internal/data"
	v11 "go.opentelemetry.io/collector/model/internal/data/protogen/common/v1"
	v1 "go.opentelemetry.io/collector/model/internal/data/protogen/resource/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// SpanKind is the type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type Span_SpanKind int32

const (
	// Unspecified. Do NOT use as default.
	// Implementations MAY assume SpanKind to be INTERNAL when receiving UNSPECIFIED.
	Span_SPAN_KIND_UNSPECIFIED Span_SpanKind = 0
	// Indicates that the span represents an internal operation within an application,
	// as opposed to an operation happening at the boundaries. Default value.
	Span_SPAN_KIND_INTERNAL Span_SpanKind = 1
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	Span_SPAN_KIND_SERVER Span_SpanKind = 2
	// Indicates that the span describes a request to some remote service.
	Span_SPAN_KIND_CLIENT Span_SpanKind = 3
	// Indicates that the span describes a producer sending a message to a broker.
	// Unlike CLIENT and SERVER, there is often no direct critical path latency relationship
	// between producer and consumer spans. A PRODUCER span ends when the message was accepted
	// by the broker while the logical processing of the message might span a much longer time.
	Span_SPAN_KIND_PRODUCER Span_SpanKind = 4
	// Indicates that the span describes consumer receiving a message from a broker.
	// Like the PRODUCER kind, there is often no direct critical path latency relationship
	// between producer and consumer spans.
	Span_SPAN_KIND_CONSUMER Span_SpanKind = 5
)

var Span_SpanKind_name = map[int32]string{
	0: "SPAN_KIND_UNSPECIFIED",
	1: "SPAN_KIND_INTERNAL",
	2: "SPAN_KIND_SERVER",
	3: "SPAN_KIND_CLIENT",
	4: "SPAN_KIND_PRODUCER",
	5: "SPAN_KIND_CONSUMER",
}

var Span_SpanKind_value = map[string]int32{
	"SPAN_KIND_UNSPECIFIED": 0,
	"SPAN_KIND_INTERNAL":    1,
	"SPAN_KIND_SERVER":      2,
	"SPAN_KIND_CLIENT":      3,
	"SPAN_KIND_PRODUCER":    4,
	"SPAN_KIND_CONSUMER":    5,
}

func (x Span_SpanKind) String() string {
	return proto.EnumName(Span_SpanKind_name, int32(x))
}

func (Span_SpanKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{2, 0}
}

type Status_DeprecatedStatusCode int32

const (
	Status_DEPRECATED_STATUS_CODE_OK                  Status_DeprecatedStatusCode = 0
	Status_DEPRECATED_STATUS_CODE_CANCELLED           Status_DeprecatedStatusCode = 1
	Status_DEPRECATED_STATUS_CODE_UNKNOWN_ERROR       Status_DeprecatedStatusCode = 2
	Status_DEPRECATED_STATUS_CODE_INVALID_ARGUMENT    Status_DeprecatedStatusCode = 3
	Status_DEPRECATED_STATUS_CODE_DEADLINE_EXCEEDED   Status_DeprecatedStatusCode = 4
	Status_DEPRECATED_STATUS_CODE_NOT_FOUND           Status_DeprecatedStatusCode = 5
	Status_DEPRECATED_STATUS_CODE_ALREADY_EXISTS      Status_DeprecatedStatusCode = 6
	Status_DEPRECATED_STATUS_CODE_PERMISSION_DENIED   Status_DeprecatedStatusCode = 7
	Status_DEPRECATED_STATUS_CODE_RESOURCE_EXHAUSTED  Status_DeprecatedStatusCode = 8
	Status_DEPRECATED_STATUS_CODE_FAILED_PRECONDITION Status_DeprecatedStatusCode = 9
	Status_DEPRECATED_STATUS_CODE_ABORTED             Status_DeprecatedStatusCode = 10
	Status_DEPRECATED_STATUS_CODE_OUT_OF_RANGE        Status_DeprecatedStatusCode = 11
	Status_DEPRECATED_STATUS_CODE_UNIMPLEMENTED       Status_DeprecatedStatusCode = 12
	Status_DEPRECATED_STATUS_CODE_INTERNAL_ERROR      Status_DeprecatedStatusCode = 13
	Status_DEPRECATED_STATUS_CODE_UNAVAILABLE         Status_DeprecatedStatusCode = 14
	Status_DEPRECATED_STATUS_CODE_DATA_LOSS           Status_DeprecatedStatusCode = 15
	Status_DEPRECATED_STATUS_CODE_UNAUTHENTICATED     Status_DeprecatedStatusCode = 16
)

var Status_DeprecatedStatusCode_name = map[int32]string{
	0:  "DEPRECATED_STATUS_CODE_OK",
	1:  "DEPRECATED_STATUS_CODE_CANCELLED",
	2:  "DEPRECATED_STATUS_CODE_UNKNOWN_ERROR",
	3:  "DEPRECATED_STATUS_CODE_INVALID_ARGUMENT",
	4:  "DEPRECATED_STATUS_CODE_DEADLINE_EXCEEDED",
	5:  "DEPRECATED_STATUS_CODE_NOT_FOUND",
	6:  "DEPRECATED_STATUS_CODE_ALREADY_EXISTS",
	7:  "DEPRECATED_STATUS_CODE_PERMISSION_DENIED",
	8:  "DEPRECATED_STATUS_CODE_RESOURCE_EXHAUSTED",
	9:  "DEPRECATED_STATUS_CODE_FAILED_PRECONDITION",
	10: "DEPRECATED_STATUS_CODE_ABORTED",
	11: "DEPRECATED_STATUS_CODE_OUT_OF_RANGE",
	12: "DEPRECATED_STATUS_CODE_UNIMPLEMENTED",
	13: "DEPRECATED_STATUS_CODE_INTERNAL_ERROR",
	14: "DEPRECATED_STATUS_CODE_UNAVAILABLE",
	15: "DEPRECATED_STATUS_CODE_DATA_LOSS",
	16: "DEPRECATED_STATUS_CODE_UNAUTHENTICATED",
}

var Status_DeprecatedStatusCode_value = map[string]int32{
	"DEPRECATED_STATUS_CODE_OK":                  0,
	"DEPRECATED_STATUS_CODE_CANCELLED":           1,
	"DEPRECATED_STATUS_CODE_UNKNOWN_ERROR":       2,
	"DEPRECATED_STATUS_CODE_INVALID_ARGUMENT":    3,
	"DEPRECATED_STATUS_CODE_DEADLINE_EXCEEDED":   4,
	"DEPRECATED_STATUS_CODE_NOT_FOUND":           5,
	"DEPRECATED_STATUS_CODE_ALREADY_EXISTS":      6,
	"DEPRECATED_STATUS_CODE_PERMISSION_DENIED":   7,
	"DEPRECATED_STATUS_CODE_RESOURCE_EXHAUSTED":  8,
	"DEPRECATED_STATUS_CODE_FAILED_PRECONDITION": 9,
	"DEPRECATED_STATUS_CODE_ABORTED":             10,
	"DEPRECATED_STATUS_CODE_OUT_OF_RANGE":        11,
	"DEPRECATED_STATUS_CODE_UNIMPLEMENTED":       12,
	"DEPRECATED_STATUS_CODE_INTERNAL_ERROR":      13,
	"DEPRECATED_STATUS_CODE_UNAVAILABLE":         14,
	"DEPRECATED_STATUS_CODE_DATA_LOSS":           15,
	"DEPRECATED_STATUS_CODE_UNAUTHENTICATED":     16,
}

func (x Status_DeprecatedStatusCode) String() string {
	return proto.EnumName(Status_DeprecatedStatusCode_name, int32(x))
}

func (Status_DeprecatedStatusCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{3, 0}
}

// For the semantics of status codes see
// https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/api.md#set-status
type Status_StatusCode int32

const (
	// The default status.
	Status_STATUS_CODE_UNSET Status_StatusCode = 0
	// The Span has been validated by an Application developers or Operator to have
	// completed successfully.
	Status_STATUS_CODE_OK Status_StatusCode = 1
	// The Span contains an error.
	Status_STATUS_CODE_ERROR Status_StatusCode = 2
)

var Status_StatusCode_name = map[int32]string{
	0: "STATUS_CODE_UNSET",
	1: "STATUS_CODE_OK",
	2: "STATUS_CODE_ERROR",
}

var Status_StatusCode_value = map[string]int32{
	"STATUS_CODE_UNSET": 0,
	"STATUS_CODE_OK":    1,
	"STATUS_CODE_ERROR": 2,
}

func (x Status_StatusCode) String() string {
	return proto.EnumName(Status_StatusCode_name, int32(x))
}

func (Status_StatusCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{3, 1}
}

// A collection of InstrumentationLibrarySpans from a Resource.
type ResourceSpans struct {
	// The resource for the spans in this message.
	// If this field is not set then no resource info is known.
	Resource v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource"`
	// A list of InstrumentationLibrarySpans that originate from a resource.
	InstrumentationLibrarySpans []*InstrumentationLibrarySpans `protobuf:"bytes,2,rep,name=instrumentation_library_spans,json=instrumentationLibrarySpans,proto3" json:"instrumentation_library_spans,omitempty"`
	// This schema_url applies to the data in the "resource" field. It does not apply
	// to the data in the "instrumentation_library_spans" field which have their own
	// schema_url field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ResourceSpans) Reset()         { *m = ResourceSpans{} }
func (m *ResourceSpans) String() string { return proto.CompactTextString(m) }
func (*ResourceSpans) ProtoMessage()    {}
func (*ResourceSpans) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{0}
}
func (m *ResourceSpans) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceSpans) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceSpans.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceSpans) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceSpans.Merge(m, src)
}
func (m *ResourceSpans) XXX_Size() int {
	return m.Size()
}
func (m *ResourceSpans) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceSpans.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceSpans proto.InternalMessageInfo

func (m *ResourceSpans) GetResource() v1.Resource {
	if m != nil {
		return m.Resource
	}
	return v1.Resource{}
}

func (m *ResourceSpans) GetInstrumentationLibrarySpans() []*InstrumentationLibrarySpans {
	if m != nil {
		return m.InstrumentationLibrarySpans
	}
	return nil
}

func (m *ResourceSpans) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A collection of Spans produced by an InstrumentationLibrary.
type InstrumentationLibrarySpans struct {
	// The instrumentation library information for the spans in this message.
	// Semantically when InstrumentationLibrary isn't set, it is equivalent with
	// an empty instrumentation library name (unknown).
	InstrumentationLibrary v11.InstrumentationLibrary `protobuf:"bytes,1,opt,name=instrumentation_library,json=instrumentationLibrary,proto3" json:"instrumentation_library"`
	// A list of Spans that originate from an instrumentation library.
	Spans []*Span `protobuf:"bytes,2,rep,name=spans,proto3" json:"spans,omitempty"`
	// This schema_url applies to all spans and span events in the "spans" field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *InstrumentationLibrarySpans) Reset()         { *m = InstrumentationLibrarySpans{} }
func (m *InstrumentationLibrarySpans) String() string { return proto.CompactTextString(m) }
func (*InstrumentationLibrarySpans) ProtoMessage()    {}
func (*InstrumentationLibrarySpans) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{1}
}
func (m *InstrumentationLibrarySpans) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstrumentationLibrarySpans) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstrumentationLibrarySpans.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstrumentationLibrarySpans) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstrumentationLibrarySpans.Merge(m, src)
}
func (m *InstrumentationLibrarySpans) XXX_Size() int {
	return m.Size()
}
func (m *InstrumentationLibrarySpans) XXX_DiscardUnknown() {
	xxx_messageInfo_InstrumentationLibrarySpans.DiscardUnknown(m)
}

var xxx_messageInfo_InstrumentationLibrarySpans proto.InternalMessageInfo

func (m *InstrumentationLibrarySpans) GetInstrumentationLibrary() v11.InstrumentationLibrary {
	if m != nil {
		return m.InstrumentationLibrary
	}
	return v11.InstrumentationLibrary{}
}

func (m *InstrumentationLibrarySpans) GetSpans() []*Span {
	if m != nil {
		return m.Spans
	}
	return nil
}

func (m *InstrumentationLibrarySpans) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// Span represents a single operation within a trace. Spans can be
// nested to form a trace tree. Spans may also be linked to other spans
// from the same or different trace and form graphs. Often, a trace
// contains a root span that describes the end-to-end latency, and one
// or more subspans for its sub-operations. A trace can also contain
// multiple root spans, or none at all. Spans do not need to be
// contiguous - there may be gaps or overlaps between spans in a trace.
//
// The next available field id is 17.
type Span struct {
	// A unique identifier for a trace. All spans from the same trace share
	// the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes
	// is considered invalid.
	//
	// This field is semantically required. Receiver should generate new
	// random trace_id if empty or invalid trace_id was received.
	//
	// This field is required.
	TraceId go_opentelemetry_io_collector_model_internal_data.TraceID `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.TraceID" json:"trace_id"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array. An ID with all zeroes is considered
	// invalid.
	//
	// This field is semantically required. Receiver should generate new
	// random span_id if empty or invalid span_id was received.
	//
	// This field is required.
	SpanId go_opentelemetry_io_collector_model_internal_data.SpanID `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.SpanID" json:"span_id"`
	// trace_state conveys information about request position in multiple distributed tracing graphs.
	// It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
	// See also https://github.com/w3c/distributed-tracing for more details about this field.
	TraceState string `protobuf:"bytes,3,opt,name=trace_state,json=traceState,proto3" json:"trace_state,omitempty"`
	// The `span_id` of this span's parent span. If this is a root span, then this
	// field must be empty. The ID is an 8-byte array.
	ParentSpanId go_opentelemetry_io_collector_model_internal_data.SpanID `protobuf:"bytes,4,opt,name=parent_span_id,json=parentSpanId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.SpanID" json:"parent_span_id"`
	// A description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name at the same call point in an application.
	// This makes it easier to correlate spans in different traces.
	//
	// This field is semantically required to be set to non-empty string.
	// When null or empty string received - receiver may use string "name"
	// as a replacement. There might be smarted algorithms implemented by
	// receiver to fix the empty span name.
	//
	// This field is required.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `CLIENT` (caller)
	// and `SERVER` (callee) to identify queueing latency associated with the span.
	Kind Span_SpanKind `protobuf:"varint,6,opt,name=kind,proto3,enum=opentelemetry.proto.trace.v1.Span_SpanKind" json:"kind,omitempty"`
	// start_time_unix_nano is the start time of the span. On the client side, this is the time
	// kept by the local machine where the span execution starts. On the server side, this
	// is the time when the server's application handler starts running.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// This field is semantically required and it is expected that end_time >= start_time.
	StartTimeUnixNano uint64 `protobuf:"fixed64,7,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// end_time_unix_nano is the end time of the span. On the client side, this is the time
	// kept by the local machine where the span execution ends. On the server side, this
	// is the time when the server application handler stops running.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// This field is semantically required and it is expected that end_time >= start_time.
	EndTimeUnixNano uint64 `protobuf:"fixed64,8,opt,name=end_time_unix_nano,json=endTimeUnixNano,proto3" json:"end_time_unix_nano,omitempty"`
	// attributes is a collection of key/value pairs. The value can be a string,
	// an integer, a double or the Boolean values `true` or `false`. Note, global attributes
	// like server name can be set using the resource API. Examples of attributes:
	//
	//     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
	//     "/http/server_latency": 300
	//     "abc.com/myattribute": true
	//     "abc.com/score": 10.239
	Attributes []v11.KeyValue `protobuf:"bytes,9,rep,name=attributes,proto3" json:"attributes"`
	// dropped_attributes_count is the number of attributes that were discarded. Attributes
	// can be discarded because their keys are too long or because there are too many
	// attributes. If this value is 0, then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,10,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	// events is a collection of Event items.
	Events []*Span_Event `protobuf:"bytes,11,rep,name=events,proto3" json:"events,omitempty"`
	// dropped_events_count is the number of dropped events. If the value is 0, then no
	// events were dropped.
	DroppedEventsCount uint32 `protobuf:"varint,12,opt,name=dropped_events_count,json=droppedEventsCount,proto3" json:"dropped_events_count,omitempty"`
	// links is a collection of Links, which are references from this span to a span
	// in the same or different trace.
	Links []*Span_Link `protobuf:"bytes,13,rep,name=links,proto3" json:"links,omitempty"`
	// dropped_links_count is the number of dropped links after the maximum size was
	// enforced. If this value is 0, then no links were dropped.
	DroppedLinksCount uint32 `protobuf:"varint,14,opt,name=dropped_links_count,json=droppedLinksCount,proto3" json:"dropped_links_count,omitempty"`
	// An optional final status for this span. Semantically when Status isn't set, it means
	// span's status code is unset, i.e. assume STATUS_CODE_UNSET (code = 0).
	Status Status `protobuf:"bytes,15,opt,name=status,proto3" json:"status"`
}

func (m *Span) Reset()         { *m = Span{} }
func (m *Span) String() string { return proto.CompactTextString(m) }
func (*Span) ProtoMessage()    {}
func (*Span) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{2}
}
func (m *Span) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Span) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Span.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Span) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span.Merge(m, src)
}
func (m *Span) XXX_Size() int {
	return m.Size()
}
func (m *Span) XXX_DiscardUnknown() {
	xxx_messageInfo_Span.DiscardUnknown(m)
}

var xxx_messageInfo_Span proto.InternalMessageInfo

func (m *Span) GetTraceState() string {
	if m != nil {
		return m.TraceState
	}
	return ""
}

func (m *Span) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Span) GetKind() Span_SpanKind {
	if m != nil {
		return m.Kind
	}
	return Span_SPAN_KIND_UNSPECIFIED
}

func (m *Span) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *Span) GetEndTimeUnixNano() uint64 {
	if m != nil {
		return m.EndTimeUnixNano
	}
	return 0
}

func (m *Span) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

func (m *Span) GetEvents() []*Span_Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *Span) GetDroppedEventsCount() uint32 {
	if m != nil {
		return m.DroppedEventsCount
	}
	return 0
}

func (m *Span) GetLinks() []*Span_Link {
	if m != nil {
		return m.Links
	}
	return nil
}

func (m *Span) GetDroppedLinksCount() uint32 {
	if m != nil {
		return m.DroppedLinksCount
	}
	return 0
}

func (m *Span) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status{}
}

// Event is a time-stamped annotation of the span, consisting of user-supplied
// text description and key-value pairs.
type Span_Event struct {
	// time_unix_nano is the time the event occurred.
	TimeUnixNano uint64 `protobuf:"fixed64,1,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// name of the event.
	// This field is semantically required to be set to non-empty string.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// attributes is a collection of attribute key/value pairs on the event.
	Attributes []v11.KeyValue `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes"`
	// dropped_attributes_count is the number of dropped attributes. If the value is 0,
	// then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,4,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (m *Span_Event) Reset()         { *m = Span_Event{} }
func (m *Span_Event) String() string { return proto.CompactTextString(m) }
func (*Span_Event) ProtoMessage()    {}
func (*Span_Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{2, 0}
}
func (m *Span_Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Span_Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Span_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Span_Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Event.Merge(m, src)
}
func (m *Span_Event) XXX_Size() int {
	return m.Size()
}
func (m *Span_Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Event proto.InternalMessageInfo

func (m *Span_Event) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *Span_Event) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Span_Event) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span_Event) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// A pointer from the current span to another span in the same trace or in a
// different trace. For example, this can be used in batching operations,
// where a single batch handler processes multiple requests from different
// traces or when the handler receives a request from a different project.
type Span_Link struct {
	// A unique identifier of a trace that this linked span is part of. The ID is a
	// 16-byte array.
	TraceId go_opentelemetry_io_collector_model_internal_data.TraceID `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.TraceID" json:"trace_id"`
	// A unique identifier for the linked span. The ID is an 8-byte array.
	SpanId go_opentelemetry_io_collector_model_internal_data.SpanID `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.SpanID" json:"span_id"`
	// The trace_state associated with the link.
	TraceState string `protobuf:"bytes,3,opt,name=trace_state,json=traceState,proto3" json:"trace_state,omitempty"`
	// attributes is a collection of attribute key/value pairs on the link.
	Attributes []v11.KeyValue `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes"`
	// dropped_attributes_count is the number of dropped attributes. If the value is 0,
	// then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,5,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (m *Span_Link) Reset()         { *m = Span_Link{} }
func (m *Span_Link) String() string { return proto.CompactTextString(m) }
func (*Span_Link) ProtoMessage()    {}
func (*Span_Link) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{2, 1}
}
func (m *Span_Link) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Span_Link) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Span_Link.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Span_Link) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Link.Merge(m, src)
}
func (m *Span_Link) XXX_Size() int {
	return m.Size()
}
func (m *Span_Link) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Link.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Link proto.InternalMessageInfo

func (m *Span_Link) GetTraceState() string {
	if m != nil {
		return m.TraceState
	}
	return ""
}

func (m *Span_Link) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span_Link) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// The Status type defines a logical error model that is suitable for different
// programming environments, including REST APIs and RPC APIs.
type Status struct {
	// The deprecated status code. This is an optional field.
	//
	// This field is deprecated and is replaced by the `code` field below. See backward
	// compatibility notes below. According to our stability guarantees this field
	// will be removed in 12 months, on Oct 22, 2021. All usage of old senders and
	// receivers that do not understand the `code` field MUST be phased out by then.
	DeprecatedCode Status_DeprecatedStatusCode `protobuf:"varint,1,opt,name=deprecated_code,json=deprecatedCode,proto3,enum=opentelemetry.proto.trace.v1.Status_DeprecatedStatusCode" json:"deprecated_code,omitempty"` // Deprecated: Do not use.
	// A developer-facing human readable error message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// The status code.
	Code Status_StatusCode `protobuf:"varint,3,opt,name=code,proto3,enum=opentelemetry.proto.trace.v1.Status_StatusCode" json:"code,omitempty"`
}

func (m *Status) Reset()         { *m = Status{} }
func (m *Status) String() string { return proto.CompactTextString(m) }
func (*Status) ProtoMessage()    {}
func (*Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c407ac9c675a601, []int{3}
}
func (m *Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Status.Merge(m, src)
}
func (m *Status) XXX_Size() int {
	return m.Size()
}
func (m *Status) XXX_DiscardUnknown() {
	xxx_messageInfo_Status.DiscardUnknown(m)
}

var xxx_messageInfo_Status proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *Status) GetDeprecatedCode() Status_DeprecatedStatusCode {
	if m != nil {
		return m.DeprecatedCode
	}
	return Status_DEPRECATED_STATUS_CODE_OK
}

func (m *Status) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Status) GetCode() Status_StatusCode {
	if m != nil {
		return m.Code
	}
	return Status_STATUS_CODE_UNSET
}

func init() {
	proto.RegisterEnum("opentelemetry.proto.trace.v1.Span_SpanKind", Span_SpanKind_name, Span_SpanKind_value)
	proto.RegisterEnum("opentelemetry.proto.trace.v1.Status_DeprecatedStatusCode", Status_DeprecatedStatusCode_name, Status_DeprecatedStatusCode_value)
	proto.RegisterEnum("opentelemetry.proto.trace.v1.Status_StatusCode", Status_StatusCode_name, Status_StatusCode_value)
	proto.RegisterType((*ResourceSpans)(nil), "opentelemetry.proto.trace.v1.ResourceSpans")
	proto.RegisterType((*InstrumentationLibrarySpans)(nil), "opentelemetry.proto.trace.v1.InstrumentationLibrarySpans")
	proto.RegisterType((*Span)(nil), "opentelemetry.proto.trace.v1.Span")
	proto.RegisterType((*Span_Event)(nil), "opentelemetry.proto.trace.v1.Span.Event")
	proto.RegisterType((*Span_Link)(nil), "opentelemetry.proto.trace.v1.Span.Link")
	proto.RegisterType((*Status)(nil), "opentelemetry.proto.trace.v1.Status")
}

func init() {
	proto.RegisterFile("opentelemetry/proto/trace/v1/trace.proto", fileDescriptor_5c407ac9c675a601)
}

var fileDescriptor_5c407ac9c675a601 = []byte{
	// 1253 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x57, 0x41, 0x6f, 0xdb, 0x46,
	0x13, 0x15, 0x6d, 0x49, 0xb6, 0xc7, 0xb6, 0xcc, 0xec, 0xe7, 0xe4, 0x63, 0x9c, 0x46, 0x16, 0x54,
	0x37, 0x51, 0x92, 0x56, 0x6a, 0x52, 0x14, 0x48, 0x0e, 0x45, 0x43, 0x91, 0xeb, 0x84, 0x30, 0x4d,
	0x0a, 0x4b, 0xd2, 0x4d, 0x8a, 0x02, 0x04, 0x23, 0x6e, 0x5c, 0x22, 0x12, 0x29, 0x90, 0x94, 0x91,
	0x1c, 0x0a, 0xf4, 0x07, 0xf4, 0xd0, 0x6b, 0xff, 0x51, 0xd0, 0x53, 0x8e, 0x45, 0x0e, 0x41, 0x11,
	0x9f, 0x0a, 0xf4, 0x17, 0x14, 0x3d, 0x14, 0xbb, 0xa4, 0x6c, 0xcb, 0x30, 0xe5, 0x04, 0x68, 0x2e,
	0xbd, 0x18, 0xf4, 0xcc, 0x9b, 0xf7, 0xde, 0xce, 0x0c, 0x17, 0x22, 0xb4, 0xa2, 0x11, 0x0d, 0x53,
	0x3a, 0xa0, 0x43, 0x9a, 0xc6, 0x2f, 0x3a, 0xa3, 0x38, 0x4a, 0xa3, 0x4e, 0x1a, 0x7b, 0x7d, 0xda,
	0x39, 0xb8, 0x9d, 0x3d, 0xb4, 0x79, 0x10, 0x7d, 0x34, 0x85, 0xcc, 0x82, 0xed, 0x0c, 0x70, 0x70,
	0x7b, 0x63, 0x7d, 0x3f, 0xda, 0x8f, 0xb2, 0x6a, 0xf6, 0x94, 0xa5, 0x37, 0x6e, 0x9e, 0xc5, 0xde,
	0x8f, 0x86, 0xc3, 0x28, 0x64, 0xf4, 0xd9, 0x53, 0x8e, 0x6d, 0x9f, 0x85, 0x8d, 0x69, 0x12, 0x8d,
	0xe3, 0xcc, 0xcc, 0xe4, 0x39, 0xc3, 0x37, 0xff, 0x12, 0x60, 0x95, 0xe4, 0x21, 0x6b, 0xe4, 0x85,
	0x09, 0xda, 0x81, 0xc5, 0x09, 0x46, 0x12, 0x1a, 0x42, 0x6b, 0xf9, 0xce, 0x8d, 0xf6, 0x59, 0xa6,
	0x8f, 0x88, 0x0e, 0x6e, 0xb7, 0x27, 0x0c, 0xdd, 0xf2, 0xcb, 0x37, 0x9b, 0x25, 0x72, 0x44, 0x80,
	0x7e, 0x80, 0xab, 0x41, 0x98, 0xa4, 0xf1, 0x78, 0x48, 0xc3, 0xd4, 0x4b, 0x83, 0x28, 0x74, 0x07,
	0xc1, 0x93, 0xd8, 0x8b, 0x5f, 0xb8, 0x09, 0x53, 0x93, 0xe6, 0x1a, 0xf3, 0xad, 0xe5, 0x3b, 0xf7,
	0xda, 0xb3, 0xda, 0xd2, 0xd6, 0xa6, 0x29, 0xf4, 0x8c, 0x81, 0xdb, 0x25, 0x57, 0x82, 0xe2, 0x24,
	0xba, 0x0a, 0x90, 0xf4, 0xbf, 0xa7, 0x43, 0xcf, 0x1d, 0xc7, 0x03, 0x69, 0xbe, 0x21, 0xb4, 0x96,
	0xc8, 0x52, 0x16, 0x71, 0xe2, 0x41, 0xf3, 0x4f, 0x01, 0xae, 0xcc, 0xe0, 0x46, 0x29, 0xfc, 0xbf,
	0xc0, 0x7d, 0xde, 0x99, 0x2f, 0xcf, 0xf4, 0x9d, 0x0f, 0xa4, 0xd0, 0x78, 0xde, 0xa5, 0x4b, 0x67,
	0x3b, 0x47, 0x77, 0xa1, 0x72, 0xb2, 0x37, 0xcd, 0xd9, 0xbd, 0x61, 0x4e, 0x49, 0x56, 0x70, 0xde,
	0x71, 0x7f, 0x5c, 0x85, 0x32, 0x83, 0xa3, 0xef, 0x60, 0x91, 0xd7, 0xbb, 0x81, 0xcf, 0x0f, 0xb2,
	0xd2, 0x95, 0x99, 0xa3, 0xd7, 0x6f, 0x36, 0xef, 0xed, 0x47, 0xa7, 0xe4, 0x02, 0xb6, 0x6a, 0x83,
	0x01, 0xed, 0xa7, 0x51, 0xdc, 0x19, 0x46, 0x3e, 0x1d, 0x74, 0x82, 0x30, 0xa5, 0x71, 0xe8, 0x0d,
	0x3a, 0xbe, 0x97, 0x7a, 0x6d, 0x9b, 0x31, 0x69, 0x2a, 0x59, 0xe0, 0x94, 0x9a, 0x8f, 0x1e, 0xc3,
	0x02, 0xb3, 0xc3, 0xc8, 0xe7, 0x38, 0xf9, 0xfd, 0x9c, 0xfc, 0xee, 0xfb, 0x93, 0x33, 0xbb, 0x9a,
	0x4a, 0xaa, 0x8c, 0x50, 0xf3, 0xd1, 0x26, 0x2c, 0x67, 0xc6, 0x93, 0xd4, 0x4b, 0x69, 0x7e, 0x42,
	0xe0, 0x21, 0x8b, 0x45, 0xd0, 0x53, 0xa8, 0x8d, 0xbc, 0x98, 0x86, 0xa9, 0x3b, 0xb1, 0x50, 0xfe,
	0x97, 0x2c, 0xac, 0x64, 0xbc, 0x56, 0x66, 0x04, 0x41, 0x39, 0xf4, 0x86, 0x54, 0xaa, 0x70, 0x07,
	0xfc, 0x19, 0x7d, 0x0d, 0xe5, 0x67, 0x41, 0xe8, 0x4b, 0xd5, 0x86, 0xd0, 0xaa, 0xdd, 0xb9, 0x75,
	0xfe, 0xd8, 0xf8, 0x9f, 0x9d, 0x20, 0xf4, 0x09, 0x2f, 0x44, 0x1d, 0x58, 0x4f, 0x52, 0x2f, 0x4e,
	0xdd, 0x34, 0x18, 0x52, 0x77, 0x1c, 0x06, 0xcf, 0xdd, 0xd0, 0x0b, 0x23, 0x69, 0xa1, 0x21, 0xb4,
	0xaa, 0xe4, 0x02, 0xcf, 0xd9, 0xc1, 0x90, 0x3a, 0x61, 0xf0, 0xdc, 0xf0, 0xc2, 0x08, 0xdd, 0x02,
	0x44, 0x43, 0xff, 0x34, 0x7c, 0x91, 0xc3, 0xd7, 0x68, 0xe8, 0x4f, 0x81, 0x77, 0x01, 0xbc, 0x34,
	0x8d, 0x83, 0x27, 0xe3, 0x94, 0x26, 0xd2, 0x12, 0xdf, 0xad, 0xeb, 0xe7, 0xec, 0xef, 0x0e, 0x7d,
	0xb1, 0xe7, 0x0d, 0xc6, 0x93, 0xf7, 0xfa, 0x04, 0x01, 0xba, 0x0b, 0x92, 0x1f, 0x47, 0xa3, 0x11,
	0xf5, 0xdd, 0xe3, 0xa8, 0xdb, 0x8f, 0xc6, 0x61, 0x2a, 0x41, 0x43, 0x68, 0xad, 0x92, 0x4b, 0x79,
	0x5e, 0x3e, 0x4a, 0x2b, 0x2c, 0x8b, 0xee, 0x43, 0x95, 0x1e, 0xd0, 0x30, 0x4d, 0xa4, 0x65, 0x6e,
	0xa2, 0xf5, 0x0e, 0x9d, 0xc2, 0xac, 0x80, 0xe4, 0x75, 0xe8, 0x73, 0x58, 0x9f, 0x68, 0x67, 0x91,
	0x5c, 0x77, 0x85, 0xeb, 0xa2, 0x3c, 0xc7, 0x6b, 0x72, 0xcd, 0xaf, 0xa0, 0x32, 0x08, 0xc2, 0x67,
	0x89, 0xb4, 0x3a, 0xe3, 0xdc, 0xd3, 0x92, 0x7a, 0x10, 0x3e, 0x23, 0x59, 0x15, 0x6a, 0xc3, 0xff,
	0x26, 0x82, 0x3c, 0x90, 0xeb, 0xd5, 0xb8, 0xde, 0x85, 0x3c, 0xc5, 0x0a, 0x72, 0xb9, 0x2e, 0x54,
	0xd9, 0x86, 0x8e, 0x13, 0x69, 0x8d, 0xdf, 0x13, 0x5b, 0xe7, 0xe8, 0x71, 0x6c, 0xde, 0xe4, 0xbc,
	0x72, 0xe3, 0x57, 0x01, 0x2a, 0xfc, 0x08, 0x68, 0x0b, 0x6a, 0xa7, 0x46, 0x2c, 0xf0, 0x11, 0xaf,
	0xa4, 0x27, 0xe7, 0x3b, 0x59, 0xc9, 0xb9, 0x13, 0x2b, 0x39, 0x3d, 0xf3, 0xf9, 0x0f, 0x39, 0xf3,
	0xf2, 0xac, 0x99, 0x6f, 0xfc, 0x31, 0x07, 0x65, 0xd6, 0x9f, 0xff, 0xf0, 0xd5, 0x33, 0xdd, 0xeb,
	0xf2, 0x87, 0xec, 0x75, 0x65, 0x56, 0xaf, 0x9b, 0xbf, 0x08, 0xb0, 0x38, 0xb9, 0x59, 0xd0, 0x65,
	0xb8, 0x68, 0xf5, 0x64, 0xc3, 0xdd, 0xd1, 0x0c, 0xd5, 0x75, 0x0c, 0xab, 0x87, 0x15, 0x6d, 0x5b,
	0xc3, 0xaa, 0x58, 0x42, 0x97, 0x00, 0x1d, 0xa7, 0x34, 0xc3, 0xc6, 0xc4, 0x90, 0x75, 0x51, 0x40,
	0xeb, 0x20, 0x1e, 0xc7, 0x2d, 0x4c, 0xf6, 0x30, 0x11, 0xe7, 0xa6, 0xa3, 0x8a, 0xae, 0x61, 0xc3,
	0x16, 0xe7, 0xa7, 0x39, 0x7a, 0xc4, 0x54, 0x1d, 0x05, 0x13, 0xb1, 0x3c, 0x1d, 0x57, 0x4c, 0xc3,
	0x72, 0x76, 0x31, 0x11, 0x2b, 0xcd, 0xbf, 0x17, 0xa0, 0x9a, 0x6d, 0x3b, 0x7a, 0x0a, 0x6b, 0x3e,
	0x1d, 0xc5, 0xb4, 0xef, 0xa5, 0xd4, 0x77, 0xfb, 0x91, 0x9f, 0xfd, 0xdc, 0xa8, 0x9d, 0xf7, 0x63,
	0x20, 0x2b, 0x6f, 0xab, 0x47, 0xb5, 0x59, 0x40, 0x89, 0x7c, 0xda, 0x9d, 0x93, 0x04, 0x52, 0x3b,
	0x66, 0x65, 0x31, 0x24, 0xc1, 0xc2, 0x90, 0x26, 0x89, 0xb7, 0x3f, 0x79, 0x35, 0x26, 0xff, 0x22,
	0x05, 0xca, 0x5c, 0x76, 0x9e, 0xcb, 0x76, 0xde, 0x49, 0xf6, 0x58, 0x8c, 0xf0, 0xe2, 0xe6, 0xeb,
	0x0a, 0xac, 0x9f, 0xe5, 0x05, 0x5d, 0x85, 0xcb, 0x2a, 0xee, 0x11, 0xac, 0xc8, 0x36, 0x56, 0x5d,
	0xcb, 0x96, 0x6d, 0xc7, 0x72, 0x15, 0x53, 0xc5, 0xae, 0xb9, 0x23, 0x96, 0xd0, 0x16, 0x34, 0x0a,
	0xd2, 0x8a, 0x6c, 0x28, 0x58, 0xd7, 0xb1, 0x2a, 0x0a, 0xa8, 0x05, 0x5b, 0x05, 0x28, 0xc7, 0xd8,
	0x31, 0xcc, 0x6f, 0x0c, 0x17, 0x13, 0x62, 0xb2, 0xf9, 0xdc, 0x82, 0xeb, 0x05, 0x48, 0xcd, 0xd8,
	0x93, 0x75, 0x4d, 0x75, 0x65, 0xf2, 0xc0, 0xd9, 0xcd, 0xc6, 0xf6, 0x29, 0xb4, 0x0a, 0xc0, 0x2a,
	0x96, 0x55, 0x5d, 0x33, 0xb0, 0x8b, 0x1f, 0x29, 0x18, 0xab, 0x58, 0x15, 0xcb, 0x33, 0xac, 0x1a,
	0xa6, 0xed, 0x6e, 0x9b, 0x8e, 0xa1, 0x8a, 0x15, 0x74, 0x03, 0x3e, 0x29, 0x40, 0xc9, 0x3a, 0xc1,
	0xb2, 0xfa, 0xd8, 0xc5, 0x8f, 0x34, 0xcb, 0xb6, 0xc4, 0xea, 0x0c, 0xf9, 0x1e, 0x26, 0xbb, 0x9a,
	0x65, 0x69, 0xa6, 0xe1, 0xaa, 0xd8, 0x60, 0x7b, 0xba, 0x80, 0x3e, 0x83, 0x1b, 0x05, 0x68, 0x82,
	0x2d, 0xd3, 0x21, 0x0a, 0x33, 0xfb, 0x50, 0x76, 0x2c, 0x1b, 0xab, 0xe2, 0x22, 0x6a, 0xc3, 0xcd,
	0x02, 0xf8, 0xb6, 0xac, 0xe9, 0x98, 0xad, 0x29, 0x56, 0x4c, 0x43, 0xd5, 0x6c, 0xcd, 0x34, 0xc4,
	0x25, 0xd4, 0x84, 0x7a, 0x91, 0xef, 0xae, 0x49, 0x18, 0x27, 0xa0, 0xeb, 0xf0, 0x71, 0xd1, 0x2c,
	0x1d, 0xdb, 0x35, 0xb7, 0x5d, 0x22, 0x1b, 0x0f, 0xb0, 0xb8, 0x3c, 0x73, 0x5e, 0xda, 0x6e, 0x4f,
	0xc7, 0x6c, 0x00, 0x58, 0x15, 0x57, 0x66, 0xb4, 0x6b, 0xf2, 0x2a, 0xe6, 0xa3, 0x5d, 0x45, 0xd7,
	0xa0, 0x59, 0x48, 0x2a, 0xef, 0xc9, 0x9a, 0x2e, 0x77, 0x75, 0x2c, 0xd6, 0x66, 0xcc, 0x49, 0x95,
	0x6d, 0xd9, 0xd5, 0x4d, 0xcb, 0x12, 0xd7, 0xd0, 0x4d, 0xb8, 0x56, 0xcc, 0xe6, 0xd8, 0x0f, 0xb1,
	0x61, 0x6b, 0x3c, 0x27, 0x8a, 0x4d, 0x03, 0xe0, 0xc4, 0x46, 0x5f, 0x84, 0x0b, 0xd3, 0x70, 0x0b,
	0xdb, 0x62, 0x09, 0x21, 0xa8, 0x9d, 0xda, 0x6e, 0xe1, 0x34, 0x34, 0x5f, 0xd2, 0xee, 0x4f, 0xc2,
	0xcb, 0xb7, 0x75, 0xe1, 0xd5, 0xdb, 0xba, 0xf0, 0xfb, 0xdb, 0xba, 0xf0, 0xf3, 0x61, 0xbd, 0xf4,
	0xea, 0xb0, 0x5e, 0xfa, 0xed, 0xb0, 0x5e, 0x82, 0xcd, 0x20, 0x9a, 0xf9, 0x02, 0x76, 0x81, 0xdf,
	0xf6, 0x3d, 0x16, 0xec, 0x09, 0xdf, 0x2a, 0xef, 0x7d, 0xa1, 0x67, 0xdf, 0x42, 0xfb, 0x34, 0x3c,
	0xfa, 0x30, 0x7b, 0x52, 0xe5, 0xa1, 0x2f, 0xfe, 0x09, 0x00, 0x00, 0xff, 0xff, 0x6e, 0x27, 0x69,
	0x6f, 0xbf, 0x0d, 0x00, 0x00,
}

func (m *ResourceSpans) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceSpans) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceSpans) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintTrace(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.InstrumentationLibrarySpans) > 0 {
		for iNdEx := len(m.InstrumentationLibrarySpans) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.InstrumentationLibrarySpans[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTrace(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTrace(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *InstrumentationLibrarySpans) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstrumentationLibrarySpans) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstrumentationLibrarySpans) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintTrace(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Spans) > 0 {
		for iNdEx := len(m.Spans) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Spans[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTrace(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.InstrumentationLibrary.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTrace(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Span) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Span) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTrace(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x7a
	if m.DroppedLinksCount != 0 {
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedLinksCount))
		i--
		dAtA[i] = 0x70
	}
	if len(m.Links) > 0 {
		for iNdEx := len(m.Links) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Links[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTrace(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6a
		}
	}
	if m.DroppedEventsCount != 0 {
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedEventsCount))
		i--
		dAtA[i] = 0x60
	}
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTrace(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x5a
		}
	}
	if m.DroppedAttributesCount != 0 {
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedAttributesCount))
		i--
		dAtA[i] = 0x50
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTrace(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.EndTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.EndTimeUnixNano))
		i--
		dAtA[i] = 0x41
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x39
	}
	if m.Kind != 0 {
		i = encodeVarintTrace(dAtA, i, uint64(m.Kind))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x2a
	}
	{
		size := m.ParentSpanId.Size()
		i -= size
		if _, err := m.ParentSpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintTrace(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if len(m.TraceState) > 0 {
		i -= len(m.TraceState)
		copy(dAtA[i:], m.TraceState)
		i = encodeVarintTrace(dAtA, i, uint64(len(m.TraceState)))
		i--
		dAtA[i] = 0x1a
	}
	{
		size := m.SpanId.Size()
		i -= size
		if _, err := m.SpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintTrace(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size := m.TraceId.Size()
		i -= size
		if _, err := m.TraceId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintTrace(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Span_Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Span_Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DroppedAttributesCount != 0 {
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedAttributesCount))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTrace(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func (m *Span_Link) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Link) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Span_Link) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DroppedAttributesCount != 0 {
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedAttributesCount))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTrace(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.TraceState) > 0 {
		i -= len(m.TraceState)
		copy(dAtA[i:], m.TraceState)
		i = encodeVarintTrace(dAtA, i, uint64(len(m.TraceState)))
		i--
		dAtA[i] = 0x1a
	}
	{
		size := m.SpanId.Size()
		i -= size
		if _, err := m.SpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintTrace(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size := m.TraceId.Size()
		i -= size
		if _, err := m.TraceId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintTrace(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Status) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Status) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		i = encodeVarintTrace(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if m.DeprecatedCode != 0 {
		i = encodeVarintTrace(dAtA, i, uint64(m.DeprecatedCode))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintTrace(dAtA []byte, offset int, v uint64) int {
	offset -= sovTrace(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ResourceSpans) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Resource.Size()
	n += 1 + l + sovTrace(uint64(l))
	if len(m.InstrumentationLibrarySpans) > 0 {
		for _, e := range m.InstrumentationLibrarySpans {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *InstrumentationLibrarySpans) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.InstrumentationLibrary.Size()
	n += 1 + l + sovTrace(uint64(l))
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *Span) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TraceId.Size()
	n += 1 + l + sovTrace(uint64(l))
	l = m.SpanId.Size()
	n += 1 + l + sovTrace(uint64(l))
	l = len(m.TraceState)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = m.ParentSpanId.Size()
	n += 1 + l + sovTrace(uint64(l))
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Kind != 0 {
		n += 1 + sovTrace(uint64(m.Kind))
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.EndTimeUnixNano != 0 {
		n += 9
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedAttributesCount))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedEventsCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedEventsCount))
	}
	if len(m.Links) > 0 {
		for _, e := range m.Links {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedLinksCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedLinksCount))
	}
	l = m.Status.Size()
	n += 1 + l + sovTrace(uint64(l))
	return n
}

func (m *Span_Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimeUnixNano != 0 {
		n += 9
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedAttributesCount))
	}
	return n
}

func (m *Span_Link) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TraceId.Size()
	n += 1 + l + sovTrace(uint64(l))
	l = m.SpanId.Size()
	n += 1 + l + sovTrace(uint64(l))
	l = len(m.TraceState)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedAttributesCount))
	}
	return n
}

func (m *Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DeprecatedCode != 0 {
		n += 1 + sovTrace(uint64(m.DeprecatedCode))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Code != 0 {
		n += 1 + sovTrace(uint64(m.Code))
	}
	return n
}

func sovTrace(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTrace(x uint64) (n int) {
	return sovTrace(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ResourceSpans) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceSpans: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceSpans: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibrarySpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstrumentationLibrarySpans = append(m.InstrumentationLibrarySpans, &InstrumentationLibrarySpans{})
			if err := m.InstrumentationLibrarySpans[len(m.InstrumentationLibrarySpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstrumentationLibrarySpans) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstrumentationLibrarySpans: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstrumentationLibrarySpans: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibrary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.InstrumentationLibrary.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, &Span{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Span: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Span: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TraceId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceState", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceState = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ParentSpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= Span_SpanKind(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 8:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTimeUnixNano", wireType)
			}
			m.EndTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.EndTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &Span_Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedEventsCount", wireType)
			}
			m.DroppedEventsCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedEventsCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Links", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Links = append(m.Links, &Span_Link{})
			if err := m.Links[len(m.Links)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedLinksCount", wireType)
			}
			m.DroppedLinksCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedLinksCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Link) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Link: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Link: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TraceId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceState", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceState = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedCode", wireType)
			}
			m.DeprecatedCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DeprecatedCode |= Status_DeprecatedStatusCode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTrace
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= Status_StatusCode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTrace(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTrace
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupTrace
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthTrace
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthTrace        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTrace          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupTrace = fmt.Errorf("proto: unexpected end of group")
)
