// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "model/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run model/internal/cmd/pdatagen/main.go".

package internal

import (
	"sort"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

// ResourceMetricsSlice logically represents a slice of ResourceMetrics.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewResourceMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetricsSlice struct {
	// orig points to the slice otlpmetrics.ResourceMetrics field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]*otlpmetrics.ResourceMetrics
}

func newResourceMetricsSlice(orig *[]*otlpmetrics.ResourceMetrics) ResourceMetricsSlice {
	return ResourceMetricsSlice{orig}
}

// NewResourceMetricsSlice creates a ResourceMetricsSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewResourceMetricsSlice() ResourceMetricsSlice {
	orig := []*otlpmetrics.ResourceMetrics(nil)
	return ResourceMetricsSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewResourceMetricsSlice()".
func (es ResourceMetricsSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es ResourceMetricsSlice) At(ix int) ResourceMetrics {
	return newResourceMetrics((*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es ResourceMetricsSlice) CopyTo(dest ResourceMetricsSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newResourceMetrics((*es.orig)[i]).CopyTo(newResourceMetrics((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.ResourceMetrics, srcLen)
	wrappers := make([]*otlpmetrics.ResourceMetrics, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newResourceMetrics((*es.orig)[i]).CopyTo(newResourceMetrics(wrappers[i]))
	}
	*dest.orig = wrappers
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new ResourceMetricsSlice can be initialized:
//
//	es := NewResourceMetricsSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es ResourceMetricsSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpmetrics.ResourceMetrics, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty ResourceMetrics.
// It returns the newly added ResourceMetrics.
func (es ResourceMetricsSlice) AppendEmpty() ResourceMetrics {
	*es.orig = append(*es.orig, &otlpmetrics.ResourceMetrics{})
	return es.At(es.Len() - 1)
}

// Sort sorts the ResourceMetrics elements within ResourceMetricsSlice given the
// provided less function so that two instances of ResourceMetricsSlice
// can be compared.
//
// Returns the same instance to allow nicer code like:
//
//	lessFunc := func(a, b ResourceMetrics) bool {
//	  return a.Name() < b.Name() // choose any comparison here
//	}
//	assert.EqualValues(t, expected.Sort(lessFunc), actual.Sort(lessFunc))
func (es ResourceMetricsSlice) Sort(less func(a, b ResourceMetrics) bool) ResourceMetricsSlice {
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
	return es
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ResourceMetricsSlice) MoveAndAppendTo(dest ResourceMetricsSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es ResourceMetricsSlice) RemoveIf(f func(ResourceMetrics) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// ResourceMetrics is a collection of metrics from a Resource.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetrics struct {
	orig *otlpmetrics.ResourceMetrics
}

func newResourceMetrics(orig *otlpmetrics.ResourceMetrics) ResourceMetrics {
	return ResourceMetrics{orig: orig}
}

// NewResourceMetrics creates a new empty ResourceMetrics.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewResourceMetrics() ResourceMetrics {
	return newResourceMetrics(&otlpmetrics.ResourceMetrics{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms ResourceMetrics) MoveTo(dest ResourceMetrics) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.ResourceMetrics{}
}

// Resource returns the resource associated with this ResourceMetrics.
func (ms ResourceMetrics) Resource() Resource {
	return newResource(&(*ms.orig).Resource)
}

// SchemaUrl returns the schemaurl associated with this ResourceMetrics.
func (ms ResourceMetrics) SchemaUrl() string {
	return (*ms.orig).SchemaUrl
}

// SetSchemaUrl replaces the schemaurl associated with this ResourceMetrics.
func (ms ResourceMetrics) SetSchemaUrl(v string) {
	(*ms.orig).SchemaUrl = v
}

// ScopeMetrics returns the ScopeMetrics associated with this ResourceMetrics.
func (ms ResourceMetrics) ScopeMetrics() ScopeMetricsSlice {
	return newScopeMetricsSlice(&(*ms.orig).ScopeMetrics)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ResourceMetrics) CopyTo(dest ResourceMetrics) {
	ms.Resource().CopyTo(dest.Resource())
	dest.SetSchemaUrl(ms.SchemaUrl())
	ms.ScopeMetrics().CopyTo(dest.ScopeMetrics())
}

// ScopeMetricsSlice logically represents a slice of ScopeMetrics.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewScopeMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ScopeMetricsSlice struct {
	// orig points to the slice otlpmetrics.ScopeMetrics field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]*otlpmetrics.ScopeMetrics
}

func newScopeMetricsSlice(orig *[]*otlpmetrics.ScopeMetrics) ScopeMetricsSlice {
	return ScopeMetricsSlice{orig}
}

// NewScopeMetricsSlice creates a ScopeMetricsSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewScopeMetricsSlice() ScopeMetricsSlice {
	orig := []*otlpmetrics.ScopeMetrics(nil)
	return ScopeMetricsSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewScopeMetricsSlice()".
func (es ScopeMetricsSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es ScopeMetricsSlice) At(ix int) ScopeMetrics {
	return newScopeMetrics((*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es ScopeMetricsSlice) CopyTo(dest ScopeMetricsSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newScopeMetrics((*es.orig)[i]).CopyTo(newScopeMetrics((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.ScopeMetrics, srcLen)
	wrappers := make([]*otlpmetrics.ScopeMetrics, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newScopeMetrics((*es.orig)[i]).CopyTo(newScopeMetrics(wrappers[i]))
	}
	*dest.orig = wrappers
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new ScopeMetricsSlice can be initialized:
//
//	es := NewScopeMetricsSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es ScopeMetricsSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpmetrics.ScopeMetrics, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty ScopeMetrics.
// It returns the newly added ScopeMetrics.
func (es ScopeMetricsSlice) AppendEmpty() ScopeMetrics {
	*es.orig = append(*es.orig, &otlpmetrics.ScopeMetrics{})
	return es.At(es.Len() - 1)
}

// Sort sorts the ScopeMetrics elements within ScopeMetricsSlice given the
// provided less function so that two instances of ScopeMetricsSlice
// can be compared.
//
// Returns the same instance to allow nicer code like:
//
//	lessFunc := func(a, b ScopeMetrics) bool {
//	  return a.Name() < b.Name() // choose any comparison here
//	}
//	assert.EqualValues(t, expected.Sort(lessFunc), actual.Sort(lessFunc))
func (es ScopeMetricsSlice) Sort(less func(a, b ScopeMetrics) bool) ScopeMetricsSlice {
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
	return es
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ScopeMetricsSlice) MoveAndAppendTo(dest ScopeMetricsSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es ScopeMetricsSlice) RemoveIf(f func(ScopeMetrics) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// ScopeMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewScopeMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ScopeMetrics struct {
	orig *otlpmetrics.ScopeMetrics
}

func newScopeMetrics(orig *otlpmetrics.ScopeMetrics) ScopeMetrics {
	return ScopeMetrics{orig: orig}
}

// NewScopeMetrics creates a new empty ScopeMetrics.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewScopeMetrics() ScopeMetrics {
	return newScopeMetrics(&otlpmetrics.ScopeMetrics{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms ScopeMetrics) MoveTo(dest ScopeMetrics) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.ScopeMetrics{}
}

// Scope returns the scope associated with this ScopeMetrics.
func (ms ScopeMetrics) Scope() InstrumentationScope {
	return newInstrumentationScope(&(*ms.orig).Scope)
}

// SchemaUrl returns the schemaurl associated with this ScopeMetrics.
func (ms ScopeMetrics) SchemaUrl() string {
	return (*ms.orig).SchemaUrl
}

// SetSchemaUrl replaces the schemaurl associated with this ScopeMetrics.
func (ms ScopeMetrics) SetSchemaUrl(v string) {
	(*ms.orig).SchemaUrl = v
}

// Metrics returns the Metrics associated with this ScopeMetrics.
func (ms ScopeMetrics) Metrics() MetricSlice {
	return newMetricSlice(&(*ms.orig).Metrics)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ScopeMetrics) CopyTo(dest ScopeMetrics) {
	ms.Scope().CopyTo(dest.Scope())
	dest.SetSchemaUrl(ms.SchemaUrl())
	ms.Metrics().CopyTo(dest.Metrics())
}

// MetricSlice logically represents a slice of Metric.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewMetricSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type MetricSlice struct {
	// orig points to the slice otlpmetrics.Metric field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]*otlpmetrics.Metric
}

func newMetricSlice(orig *[]*otlpmetrics.Metric) MetricSlice {
	return MetricSlice{orig}
}

// NewMetricSlice creates a MetricSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewMetricSlice() MetricSlice {
	orig := []*otlpmetrics.Metric(nil)
	return MetricSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewMetricSlice()".
func (es MetricSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es MetricSlice) At(ix int) Metric {
	return newMetric((*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es MetricSlice) CopyTo(dest MetricSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newMetric((*es.orig)[i]).CopyTo(newMetric((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.Metric, srcLen)
	wrappers := make([]*otlpmetrics.Metric, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newMetric((*es.orig)[i]).CopyTo(newMetric(wrappers[i]))
	}
	*dest.orig = wrappers
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new MetricSlice can be initialized:
//
//	es := NewMetricSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es MetricSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpmetrics.Metric, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty Metric.
// It returns the newly added Metric.
func (es MetricSlice) AppendEmpty() Metric {
	*es.orig = append(*es.orig, &otlpmetrics.Metric{})
	return es.At(es.Len() - 1)
}

// Sort sorts the Metric elements within MetricSlice given the
// provided less function so that two instances of MetricSlice
// can be compared.
//
// Returns the same instance to allow nicer code like:
//
//	lessFunc := func(a, b Metric) bool {
//	  return a.Name() < b.Name() // choose any comparison here
//	}
//	assert.EqualValues(t, expected.Sort(lessFunc), actual.Sort(lessFunc))
func (es MetricSlice) Sort(less func(a, b Metric) bool) MetricSlice {
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
	return es
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es MetricSlice) MoveAndAppendTo(dest MetricSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es MetricSlice) RemoveIf(f func(Metric) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// Metric represents one metric as a collection of datapoints.
// See Metric definition in OTLP: https://github.com/open-telemetry/opentelemetry-proto/blob/main/opentelemetry/proto/metrics/v1/metrics.proto
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetric function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Metric struct {
	orig *otlpmetrics.Metric
}

func newMetric(orig *otlpmetrics.Metric) Metric {
	return Metric{orig: orig}
}

// NewMetric creates a new empty Metric.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewMetric() Metric {
	return newMetric(&otlpmetrics.Metric{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms Metric) MoveTo(dest Metric) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.Metric{}
}

// Name returns the name associated with this Metric.
func (ms Metric) Name() string {
	return (*ms.orig).Name
}

// SetName replaces the name associated with this Metric.
func (ms Metric) SetName(v string) {
	(*ms.orig).Name = v
}

// Description returns the description associated with this Metric.
func (ms Metric) Description() string {
	return (*ms.orig).Description
}

// SetDescription replaces the description associated with this Metric.
func (ms Metric) SetDescription(v string) {
	(*ms.orig).Description = v
}

// Unit returns the unit associated with this Metric.
func (ms Metric) Unit() string {
	return (*ms.orig).Unit
}

// SetUnit replaces the unit associated with this Metric.
func (ms Metric) SetUnit(v string) {
	(*ms.orig).Unit = v
}

// DataType returns the type of the data for this Metric.
// Calling this function on zero-initialized Metric will cause a panic.
func (ms Metric) DataType() MetricDataType {
	switch ms.orig.Data.(type) {
	case *otlpmetrics.Metric_Gauge:
		return MetricDataTypeGauge
	case *otlpmetrics.Metric_Sum:
		return MetricDataTypeSum
	case *otlpmetrics.Metric_Histogram:
		return MetricDataTypeHistogram
	case *otlpmetrics.Metric_ExponentialHistogram:
		return MetricDataTypeExponentialHistogram
	case *otlpmetrics.Metric_Summary:
		return MetricDataTypeSummary
	}
	return MetricDataTypeNone
}

// Gauge returns the gauge associated with this Metric.
//
// Calling this function when DataType() != MetricDataTypeGauge returns an invalid
// zero-initialized instance of Gauge. Note that using such Gauge instance can cause panic.
//
// Calling this function on zero-initialized Metric will cause a panic.
func (ms Metric) Gauge() Gauge {
	v, ok := ms.orig.GetData().(*otlpmetrics.Metric_Gauge)
	if !ok {
		return Gauge{}
	}
	return newGauge(v.Gauge)
}

// Sum returns the sum associated with this Metric.
//
// Calling this function when DataType() != MetricDataTypeSum returns an invalid
// zero-initialized instance of Sum. Note that using such Sum instance can cause panic.
//
// Calling this function on zero-initialized Metric will cause a panic.
func (ms Metric) Sum() Sum {
	v, ok := ms.orig.GetData().(*otlpmetrics.Metric_Sum)
	if !ok {
		return Sum{}
	}
	return newSum(v.Sum)
}

// Histogram returns the histogram associated with this Metric.
//
// Calling this function when DataType() != MetricDataTypeHistogram returns an invalid
// zero-initialized instance of Histogram. Note that using such Histogram instance can cause panic.
//
// Calling this function on zero-initialized Metric will cause a panic.
func (ms Metric) Histogram() Histogram {
	v, ok := ms.orig.GetData().(*otlpmetrics.Metric_Histogram)
	if !ok {
		return Histogram{}
	}
	return newHistogram(v.Histogram)
}

// ExponentialHistogram returns the exponentialhistogram associated with this Metric.
//
// Calling this function when DataType() != MetricDataTypeExponentialHistogram returns an invalid
// zero-initialized instance of ExponentialHistogram. Note that using such ExponentialHistogram instance can cause panic.
//
// Calling this function on zero-initialized Metric will cause a panic.
func (ms Metric) ExponentialHistogram() ExponentialHistogram {
	v, ok := ms.orig.GetData().(*otlpmetrics.Metric_ExponentialHistogram)
	if !ok {
		return ExponentialHistogram{}
	}
	return newExponentialHistogram(v.ExponentialHistogram)
}

// Summary returns the summary associated with this Metric.
//
// Calling this function when DataType() != MetricDataTypeSummary returns an invalid
// zero-initialized instance of Summary. Note that using such Summary instance can cause panic.
//
// Calling this function on zero-initialized Metric will cause a panic.
func (ms Metric) Summary() Summary {
	v, ok := ms.orig.GetData().(*otlpmetrics.Metric_Summary)
	if !ok {
		return Summary{}
	}
	return newSummary(v.Summary)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Metric) CopyTo(dest Metric) {
	dest.SetName(ms.Name())
	dest.SetDescription(ms.Description())
	dest.SetUnit(ms.Unit())
	switch ms.DataType() {
	case MetricDataTypeGauge:
		dest.SetDataType(MetricDataTypeGauge)
		ms.Gauge().CopyTo(dest.Gauge())
	case MetricDataTypeSum:
		dest.SetDataType(MetricDataTypeSum)
		ms.Sum().CopyTo(dest.Sum())
	case MetricDataTypeHistogram:
		dest.SetDataType(MetricDataTypeHistogram)
		ms.Histogram().CopyTo(dest.Histogram())
	case MetricDataTypeExponentialHistogram:
		dest.SetDataType(MetricDataTypeExponentialHistogram)
		ms.ExponentialHistogram().CopyTo(dest.ExponentialHistogram())
	case MetricDataTypeSummary:
		dest.SetDataType(MetricDataTypeSummary)
		ms.Summary().CopyTo(dest.Summary())
	}

}

// Gauge represents the type of a numeric metric that always exports the "current value" for every data point.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewGauge function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Gauge struct {
	orig *otlpmetrics.Gauge
}

func newGauge(orig *otlpmetrics.Gauge) Gauge {
	return Gauge{orig: orig}
}

// NewGauge creates a new empty Gauge.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewGauge() Gauge {
	return newGauge(&otlpmetrics.Gauge{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms Gauge) MoveTo(dest Gauge) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.Gauge{}
}

// DataPoints returns the DataPoints associated with this Gauge.
func (ms Gauge) DataPoints() NumberDataPointSlice {
	return newNumberDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Gauge) CopyTo(dest Gauge) {
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// Sum represents the type of a numeric metric that is calculated as a sum of all reported measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSum function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Sum struct {
	orig *otlpmetrics.Sum
}

func newSum(orig *otlpmetrics.Sum) Sum {
	return Sum{orig: orig}
}

// NewSum creates a new empty Sum.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewSum() Sum {
	return newSum(&otlpmetrics.Sum{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms Sum) MoveTo(dest Sum) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.Sum{}
}

// AggregationTemporality returns the aggregationtemporality associated with this Sum.
func (ms Sum) AggregationTemporality() MetricAggregationTemporality {
	return MetricAggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this Sum.
func (ms Sum) SetAggregationTemporality(v MetricAggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// IsMonotonic returns the ismonotonic associated with this Sum.
func (ms Sum) IsMonotonic() bool {
	return (*ms.orig).IsMonotonic
}

// SetIsMonotonic replaces the ismonotonic associated with this Sum.
func (ms Sum) SetIsMonotonic(v bool) {
	(*ms.orig).IsMonotonic = v
}

// DataPoints returns the DataPoints associated with this Sum.
func (ms Sum) DataPoints() NumberDataPointSlice {
	return newNumberDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Sum) CopyTo(dest Sum) {
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	dest.SetIsMonotonic(ms.IsMonotonic())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// Histogram represents the type of a metric that is calculated by aggregating as a Histogram of all reported measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogram function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Histogram struct {
	orig *otlpmetrics.Histogram
}

func newHistogram(orig *otlpmetrics.Histogram) Histogram {
	return Histogram{orig: orig}
}

// NewHistogram creates a new empty Histogram.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewHistogram() Histogram {
	return newHistogram(&otlpmetrics.Histogram{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms Histogram) MoveTo(dest Histogram) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.Histogram{}
}

// AggregationTemporality returns the aggregationtemporality associated with this Histogram.
func (ms Histogram) AggregationTemporality() MetricAggregationTemporality {
	return MetricAggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this Histogram.
func (ms Histogram) SetAggregationTemporality(v MetricAggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// DataPoints returns the DataPoints associated with this Histogram.
func (ms Histogram) DataPoints() HistogramDataPointSlice {
	return newHistogramDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Histogram) CopyTo(dest Histogram) {
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// ExponentialHistogram represents the type of a metric that is calculated by aggregating
// as a ExponentialHistogram of all reported double measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewExponentialHistogram function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ExponentialHistogram struct {
	orig *otlpmetrics.ExponentialHistogram
}

func newExponentialHistogram(orig *otlpmetrics.ExponentialHistogram) ExponentialHistogram {
	return ExponentialHistogram{orig: orig}
}

// NewExponentialHistogram creates a new empty ExponentialHistogram.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewExponentialHistogram() ExponentialHistogram {
	return newExponentialHistogram(&otlpmetrics.ExponentialHistogram{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms ExponentialHistogram) MoveTo(dest ExponentialHistogram) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.ExponentialHistogram{}
}

// AggregationTemporality returns the aggregationtemporality associated with this ExponentialHistogram.
func (ms ExponentialHistogram) AggregationTemporality() MetricAggregationTemporality {
	return MetricAggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this ExponentialHistogram.
func (ms ExponentialHistogram) SetAggregationTemporality(v MetricAggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// DataPoints returns the DataPoints associated with this ExponentialHistogram.
func (ms ExponentialHistogram) DataPoints() ExponentialHistogramDataPointSlice {
	return newExponentialHistogramDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ExponentialHistogram) CopyTo(dest ExponentialHistogram) {
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// Summary represents the type of a metric that is calculated by aggregating as a Summary of all reported double measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummary function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Summary struct {
	orig *otlpmetrics.Summary
}

func newSummary(orig *otlpmetrics.Summary) Summary {
	return Summary{orig: orig}
}

// NewSummary creates a new empty Summary.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewSummary() Summary {
	return newSummary(&otlpmetrics.Summary{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms Summary) MoveTo(dest Summary) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.Summary{}
}

// DataPoints returns the DataPoints associated with this Summary.
func (ms Summary) DataPoints() SummaryDataPointSlice {
	return newSummaryDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Summary) CopyTo(dest Summary) {
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// NumberDataPointSlice logically represents a slice of NumberDataPoint.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewNumberDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type NumberDataPointSlice struct {
	// orig points to the slice otlpmetrics.NumberDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]*otlpmetrics.NumberDataPoint
}

func newNumberDataPointSlice(orig *[]*otlpmetrics.NumberDataPoint) NumberDataPointSlice {
	return NumberDataPointSlice{orig}
}

// NewNumberDataPointSlice creates a NumberDataPointSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewNumberDataPointSlice() NumberDataPointSlice {
	orig := []*otlpmetrics.NumberDataPoint(nil)
	return NumberDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewNumberDataPointSlice()".
func (es NumberDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es NumberDataPointSlice) At(ix int) NumberDataPoint {
	return newNumberDataPoint((*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es NumberDataPointSlice) CopyTo(dest NumberDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newNumberDataPoint((*es.orig)[i]).CopyTo(newNumberDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.NumberDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.NumberDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newNumberDataPoint((*es.orig)[i]).CopyTo(newNumberDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new NumberDataPointSlice can be initialized:
//
//	es := NewNumberDataPointSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es NumberDataPointSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpmetrics.NumberDataPoint, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty NumberDataPoint.
// It returns the newly added NumberDataPoint.
func (es NumberDataPointSlice) AppendEmpty() NumberDataPoint {
	*es.orig = append(*es.orig, &otlpmetrics.NumberDataPoint{})
	return es.At(es.Len() - 1)
}

// Sort sorts the NumberDataPoint elements within NumberDataPointSlice given the
// provided less function so that two instances of NumberDataPointSlice
// can be compared.
//
// Returns the same instance to allow nicer code like:
//
//	lessFunc := func(a, b NumberDataPoint) bool {
//	  return a.Name() < b.Name() // choose any comparison here
//	}
//	assert.EqualValues(t, expected.Sort(lessFunc), actual.Sort(lessFunc))
func (es NumberDataPointSlice) Sort(less func(a, b NumberDataPoint) bool) NumberDataPointSlice {
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
	return es
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es NumberDataPointSlice) MoveAndAppendTo(dest NumberDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es NumberDataPointSlice) RemoveIf(f func(NumberDataPoint) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// NumberDataPoint is a single data point in a timeseries that describes the time-varying value of a number metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewNumberDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type NumberDataPoint struct {
	orig *otlpmetrics.NumberDataPoint
}

func newNumberDataPoint(orig *otlpmetrics.NumberDataPoint) NumberDataPoint {
	return NumberDataPoint{orig: orig}
}

// NewNumberDataPoint creates a new empty NumberDataPoint.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewNumberDataPoint() NumberDataPoint {
	return newNumberDataPoint(&otlpmetrics.NumberDataPoint{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms NumberDataPoint) MoveTo(dest NumberDataPoint) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.NumberDataPoint{}
}

// Attributes returns the Attributes associated with this NumberDataPoint.
func (ms NumberDataPoint) Attributes() Map {
	return newMap(&(*ms.orig).Attributes)
}

// StartTimestamp returns the starttimestamp associated with this NumberDataPoint.
func (ms NumberDataPoint) StartTimestamp() Timestamp {
	return Timestamp((*ms.orig).StartTimeUnixNano)
}

// SetStartTimestamp replaces the starttimestamp associated with this NumberDataPoint.
func (ms NumberDataPoint) SetStartTimestamp(v Timestamp) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this NumberDataPoint.
func (ms NumberDataPoint) Timestamp() Timestamp {
	return Timestamp((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this NumberDataPoint.
func (ms NumberDataPoint) SetTimestamp(v Timestamp) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// ValueType returns the type of the value for this NumberDataPoint.
// Calling this function on zero-initialized NumberDataPoint will cause a panic.
func (ms NumberDataPoint) ValueType() NumberDataPointValueType {
	switch ms.orig.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		return NumberDataPointValueTypeDouble
	case *otlpmetrics.NumberDataPoint_AsInt:
		return NumberDataPointValueTypeInt
	}
	return NumberDataPointValueTypeNone
}

// DoubleVal returns the doubleval associated with this NumberDataPoint.
func (ms NumberDataPoint) DoubleVal() float64 {
	return (*ms.orig).GetAsDouble()
}

// SetDoubleVal replaces the doubleval associated with this NumberDataPoint.
func (ms NumberDataPoint) SetDoubleVal(v float64) {
	(*ms.orig).Value = &otlpmetrics.NumberDataPoint_AsDouble{
		AsDouble: v,
	}
}

// IntVal returns the intval associated with this NumberDataPoint.
func (ms NumberDataPoint) IntVal() int64 {
	return (*ms.orig).GetAsInt()
}

// SetIntVal replaces the intval associated with this NumberDataPoint.
func (ms NumberDataPoint) SetIntVal(v int64) {
	(*ms.orig).Value = &otlpmetrics.NumberDataPoint_AsInt{
		AsInt: v,
	}
}

// Exemplars returns the Exemplars associated with this NumberDataPoint.
func (ms NumberDataPoint) Exemplars() ExemplarSlice {
	return newExemplarSlice(&(*ms.orig).Exemplars)
}

// Flags returns the flags associated with this NumberDataPoint.
func (ms NumberDataPoint) Flags() MetricDataPointFlags {
	return newMetricDataPointFlags(&(*ms.orig).Flags)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms NumberDataPoint) CopyTo(dest NumberDataPoint) {
	ms.Attributes().CopyTo(dest.Attributes())
	dest.SetStartTimestamp(ms.StartTimestamp())
	dest.SetTimestamp(ms.Timestamp())
	switch ms.ValueType() {
	case NumberDataPointValueTypeDouble:
		dest.SetDoubleVal(ms.DoubleVal())
	case NumberDataPointValueTypeInt:
		dest.SetIntVal(ms.IntVal())
	}

	ms.Exemplars().CopyTo(dest.Exemplars())
	ms.Flags().CopyTo(dest.Flags())
}

// HistogramDataPointSlice logically represents a slice of HistogramDataPoint.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewHistogramDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramDataPointSlice struct {
	// orig points to the slice otlpmetrics.HistogramDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]*otlpmetrics.HistogramDataPoint
}

func newHistogramDataPointSlice(orig *[]*otlpmetrics.HistogramDataPoint) HistogramDataPointSlice {
	return HistogramDataPointSlice{orig}
}

// NewHistogramDataPointSlice creates a HistogramDataPointSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewHistogramDataPointSlice() HistogramDataPointSlice {
	orig := []*otlpmetrics.HistogramDataPoint(nil)
	return HistogramDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewHistogramDataPointSlice()".
func (es HistogramDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es HistogramDataPointSlice) At(ix int) HistogramDataPoint {
	return newHistogramDataPoint((*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es HistogramDataPointSlice) CopyTo(dest HistogramDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newHistogramDataPoint((*es.orig)[i]).CopyTo(newHistogramDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.HistogramDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.HistogramDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newHistogramDataPoint((*es.orig)[i]).CopyTo(newHistogramDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new HistogramDataPointSlice can be initialized:
//
//	es := NewHistogramDataPointSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es HistogramDataPointSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpmetrics.HistogramDataPoint, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty HistogramDataPoint.
// It returns the newly added HistogramDataPoint.
func (es HistogramDataPointSlice) AppendEmpty() HistogramDataPoint {
	*es.orig = append(*es.orig, &otlpmetrics.HistogramDataPoint{})
	return es.At(es.Len() - 1)
}

// Sort sorts the HistogramDataPoint elements within HistogramDataPointSlice given the
// provided less function so that two instances of HistogramDataPointSlice
// can be compared.
//
// Returns the same instance to allow nicer code like:
//
//	lessFunc := func(a, b HistogramDataPoint) bool {
//	  return a.Name() < b.Name() // choose any comparison here
//	}
//	assert.EqualValues(t, expected.Sort(lessFunc), actual.Sort(lessFunc))
func (es HistogramDataPointSlice) Sort(less func(a, b HistogramDataPoint) bool) HistogramDataPointSlice {
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
	return es
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es HistogramDataPointSlice) MoveAndAppendTo(dest HistogramDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es HistogramDataPointSlice) RemoveIf(f func(HistogramDataPoint) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// HistogramDataPoint is a single data point in a timeseries that describes the time-varying values of a Histogram of values.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramDataPoint struct {
	orig *otlpmetrics.HistogramDataPoint
}

func newHistogramDataPoint(orig *otlpmetrics.HistogramDataPoint) HistogramDataPoint {
	return HistogramDataPoint{orig: orig}
}

// NewHistogramDataPoint creates a new empty HistogramDataPoint.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewHistogramDataPoint() HistogramDataPoint {
	return newHistogramDataPoint(&otlpmetrics.HistogramDataPoint{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms HistogramDataPoint) MoveTo(dest HistogramDataPoint) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.HistogramDataPoint{}
}

// Attributes returns the Attributes associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Attributes() Map {
	return newMap(&(*ms.orig).Attributes)
}

// StartTimestamp returns the starttimestamp associated with this HistogramDataPoint.
func (ms HistogramDataPoint) StartTimestamp() Timestamp {
	return Timestamp((*ms.orig).StartTimeUnixNano)
}

// SetStartTimestamp replaces the starttimestamp associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetStartTimestamp(v Timestamp) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Timestamp() Timestamp {
	return Timestamp((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetTimestamp(v Timestamp) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Sum() float64 {
	return (*ms.orig).GetSum()
}

// HasSum returns true if the HistogramDataPoint contains a
// Sum value, false otherwise.
func (ms HistogramDataPoint) HasSum() bool {
	return ms.orig.Sum_ != nil
}

// SetSum replaces the sum associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetSum(v float64) {
	(*ms.orig).Sum_ = &otlpmetrics.HistogramDataPoint_Sum{Sum: v}
}

// BucketCounts returns the bucketcounts associated with this HistogramDataPoint.
func (ms HistogramDataPoint) BucketCounts() ImmutableUInt64Slice {
	return ImmutableUInt64Slice{value: (*ms.orig).BucketCounts}
}

// SetBucketCounts replaces the bucketcounts associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetBucketCounts(v ImmutableUInt64Slice) {
	(*ms.orig).BucketCounts = v.value
}

// ExplicitBounds returns the explicitbounds associated with this HistogramDataPoint.
func (ms HistogramDataPoint) ExplicitBounds() ImmutableFloat64Slice {
	return ImmutableFloat64Slice{value: (*ms.orig).ExplicitBounds}
}

// SetExplicitBounds replaces the explicitbounds associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetExplicitBounds(v ImmutableFloat64Slice) {
	(*ms.orig).ExplicitBounds = v.value
}

// Exemplars returns the Exemplars associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Exemplars() ExemplarSlice {
	return newExemplarSlice(&(*ms.orig).Exemplars)
}

// Flags returns the flags associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Flags() MetricDataPointFlags {
	return newMetricDataPointFlags(&(*ms.orig).Flags)
}

// Min returns the min associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Min() float64 {
	return (*ms.orig).GetMin()
}

// HasMin returns true if the HistogramDataPoint contains a
// Min value, false otherwise.
func (ms HistogramDataPoint) HasMin() bool {
	return ms.orig.Min_ != nil
}

// SetMin replaces the min associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetMin(v float64) {
	(*ms.orig).Min_ = &otlpmetrics.HistogramDataPoint_Min{Min: v}
}

// Max returns the max associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Max() float64 {
	return (*ms.orig).GetMax()
}

// HasMax returns true if the HistogramDataPoint contains a
// Max value, false otherwise.
func (ms HistogramDataPoint) HasMax() bool {
	return ms.orig.Max_ != nil
}

// SetMax replaces the max associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetMax(v float64) {
	(*ms.orig).Max_ = &otlpmetrics.HistogramDataPoint_Max{Max: v}
}

// CopyTo copies all properties from the current struct to the dest.
func (ms HistogramDataPoint) CopyTo(dest HistogramDataPoint) {
	ms.Attributes().CopyTo(dest.Attributes())
	dest.SetStartTimestamp(ms.StartTimestamp())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	if ms.HasSum() {
		dest.SetSum(ms.Sum())
	}

	if len(ms.orig.BucketCounts) == 0 {
		dest.orig.BucketCounts = nil
	} else {
		dest.orig.BucketCounts = make([]uint64, len(ms.orig.BucketCounts))
		copy(dest.orig.BucketCounts, ms.orig.BucketCounts)
	}

	if len(ms.orig.ExplicitBounds) == 0 {
		dest.orig.ExplicitBounds = nil
	} else {
		dest.orig.ExplicitBounds = make([]float64, len(ms.orig.ExplicitBounds))
		copy(dest.orig.ExplicitBounds, ms.orig.ExplicitBounds)
	}

	ms.Exemplars().CopyTo(dest.Exemplars())
	ms.Flags().CopyTo(dest.Flags())
	if ms.HasMin() {
		dest.SetMin(ms.Min())
	}

	if ms.HasMax() {
		dest.SetMax(ms.Max())
	}

}

// ExponentialHistogramDataPointSlice logically represents a slice of ExponentialHistogramDataPoint.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewExponentialHistogramDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ExponentialHistogramDataPointSlice struct {
	// orig points to the slice otlpmetrics.ExponentialHistogramDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]*otlpmetrics.ExponentialHistogramDataPoint
}

func newExponentialHistogramDataPointSlice(orig *[]*otlpmetrics.ExponentialHistogramDataPoint) ExponentialHistogramDataPointSlice {
	return ExponentialHistogramDataPointSlice{orig}
}

// NewExponentialHistogramDataPointSlice creates a ExponentialHistogramDataPointSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewExponentialHistogramDataPointSlice() ExponentialHistogramDataPointSlice {
	orig := []*otlpmetrics.ExponentialHistogramDataPoint(nil)
	return ExponentialHistogramDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewExponentialHistogramDataPointSlice()".
func (es ExponentialHistogramDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es ExponentialHistogramDataPointSlice) At(ix int) ExponentialHistogramDataPoint {
	return newExponentialHistogramDataPoint((*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es ExponentialHistogramDataPointSlice) CopyTo(dest ExponentialHistogramDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newExponentialHistogramDataPoint((*es.orig)[i]).CopyTo(newExponentialHistogramDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.ExponentialHistogramDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.ExponentialHistogramDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newExponentialHistogramDataPoint((*es.orig)[i]).CopyTo(newExponentialHistogramDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new ExponentialHistogramDataPointSlice can be initialized:
//
//	es := NewExponentialHistogramDataPointSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es ExponentialHistogramDataPointSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpmetrics.ExponentialHistogramDataPoint, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty ExponentialHistogramDataPoint.
// It returns the newly added ExponentialHistogramDataPoint.
func (es ExponentialHistogramDataPointSlice) AppendEmpty() ExponentialHistogramDataPoint {
	*es.orig = append(*es.orig, &otlpmetrics.ExponentialHistogramDataPoint{})
	return es.At(es.Len() - 1)
}

// Sort sorts the ExponentialHistogramDataPoint elements within ExponentialHistogramDataPointSlice given the
// provided less function so that two instances of ExponentialHistogramDataPointSlice
// can be compared.
//
// Returns the same instance to allow nicer code like:
//
//	lessFunc := func(a, b ExponentialHistogramDataPoint) bool {
//	  return a.Name() < b.Name() // choose any comparison here
//	}
//	assert.EqualValues(t, expected.Sort(lessFunc), actual.Sort(lessFunc))
func (es ExponentialHistogramDataPointSlice) Sort(less func(a, b ExponentialHistogramDataPoint) bool) ExponentialHistogramDataPointSlice {
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
	return es
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ExponentialHistogramDataPointSlice) MoveAndAppendTo(dest ExponentialHistogramDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es ExponentialHistogramDataPointSlice) RemoveIf(f func(ExponentialHistogramDataPoint) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// ExponentialHistogramDataPoint is a single data point in a timeseries that describes the
// time-varying values of a ExponentialHistogram of double values. A ExponentialHistogram contains
// summary statistics for a population of values, it may optionally contain the
// distribution of those values across a set of buckets.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewExponentialHistogramDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ExponentialHistogramDataPoint struct {
	orig *otlpmetrics.ExponentialHistogramDataPoint
}

func newExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint) ExponentialHistogramDataPoint {
	return ExponentialHistogramDataPoint{orig: orig}
}

// NewExponentialHistogramDataPoint creates a new empty ExponentialHistogramDataPoint.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewExponentialHistogramDataPoint() ExponentialHistogramDataPoint {
	return newExponentialHistogramDataPoint(&otlpmetrics.ExponentialHistogramDataPoint{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms ExponentialHistogramDataPoint) MoveTo(dest ExponentialHistogramDataPoint) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.ExponentialHistogramDataPoint{}
}

// Attributes returns the Attributes associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Attributes() Map {
	return newMap(&(*ms.orig).Attributes)
}

// StartTimestamp returns the starttimestamp associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) StartTimestamp() Timestamp {
	return Timestamp((*ms.orig).StartTimeUnixNano)
}

// SetStartTimestamp replaces the starttimestamp associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) SetStartTimestamp(v Timestamp) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Timestamp() Timestamp {
	return Timestamp((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) SetTimestamp(v Timestamp) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Sum() float64 {
	return (*ms.orig).GetSum()
}

// HasSum returns true if the ExponentialHistogramDataPoint contains a
// Sum value, false otherwise.
func (ms ExponentialHistogramDataPoint) HasSum() bool {
	return ms.orig.Sum_ != nil
}

// SetSum replaces the sum associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) SetSum(v float64) {
	(*ms.orig).Sum_ = &otlpmetrics.ExponentialHistogramDataPoint_Sum{Sum: v}
}

// Scale returns the scale associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Scale() int32 {
	return int32((*ms.orig).Scale)
}

// SetScale replaces the scale associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) SetScale(v int32) {
	(*ms.orig).Scale = int32(v)
}

// ZeroCount returns the zerocount associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) ZeroCount() uint64 {
	return uint64((*ms.orig).ZeroCount)
}

// SetZeroCount replaces the zerocount associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) SetZeroCount(v uint64) {
	(*ms.orig).ZeroCount = uint64(v)
}

// Positive returns the positive associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Positive() Buckets {
	return newBuckets(&(*ms.orig).Positive)
}

// Negative returns the negative associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Negative() Buckets {
	return newBuckets(&(*ms.orig).Negative)
}

// Exemplars returns the Exemplars associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Exemplars() ExemplarSlice {
	return newExemplarSlice(&(*ms.orig).Exemplars)
}

// Flags returns the flags associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Flags() MetricDataPointFlags {
	return newMetricDataPointFlags(&(*ms.orig).Flags)
}

// Min returns the min associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Min() float64 {
	return (*ms.orig).GetMin()
}

// HasMin returns true if the ExponentialHistogramDataPoint contains a
// Min value, false otherwise.
func (ms ExponentialHistogramDataPoint) HasMin() bool {
	return ms.orig.Min_ != nil
}

// SetMin replaces the min associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) SetMin(v float64) {
	(*ms.orig).Min_ = &otlpmetrics.ExponentialHistogramDataPoint_Min{Min: v}
}

// Max returns the max associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) Max() float64 {
	return (*ms.orig).GetMax()
}

// HasMax returns true if the ExponentialHistogramDataPoint contains a
// Max value, false otherwise.
func (ms ExponentialHistogramDataPoint) HasMax() bool {
	return ms.orig.Max_ != nil
}

// SetMax replaces the max associated with this ExponentialHistogramDataPoint.
func (ms ExponentialHistogramDataPoint) SetMax(v float64) {
	(*ms.orig).Max_ = &otlpmetrics.ExponentialHistogramDataPoint_Max{Max: v}
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ExponentialHistogramDataPoint) CopyTo(dest ExponentialHistogramDataPoint) {
	ms.Attributes().CopyTo(dest.Attributes())
	dest.SetStartTimestamp(ms.StartTimestamp())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	if ms.HasSum() {
		dest.SetSum(ms.Sum())
	}

	dest.SetScale(ms.Scale())
	dest.SetZeroCount(ms.ZeroCount())
	ms.Positive().CopyTo(dest.Positive())
	ms.Negative().CopyTo(dest.Negative())
	ms.Exemplars().CopyTo(dest.Exemplars())
	ms.Flags().CopyTo(dest.Flags())
	if ms.HasMin() {
		dest.SetMin(ms.Min())
	}

	if ms.HasMax() {
		dest.SetMax(ms.Max())
	}

}

// Buckets are a set of bucket counts, encoded in a contiguous array of counts.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewBuckets function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Buckets struct {
	orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets
}

func newBuckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets) Buckets {
	return Buckets{orig: orig}
}

// NewBuckets creates a new empty Buckets.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewBuckets() Buckets {
	return newBuckets(&otlpmetrics.ExponentialHistogramDataPoint_Buckets{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms Buckets) MoveTo(dest Buckets) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
}

// Offset returns the offset associated with this Buckets.
func (ms Buckets) Offset() int32 {
	return int32((*ms.orig).Offset)
}

// SetOffset replaces the offset associated with this Buckets.
func (ms Buckets) SetOffset(v int32) {
	(*ms.orig).Offset = int32(v)
}

// BucketCounts returns the bucketcounts associated with this Buckets.
func (ms Buckets) BucketCounts() ImmutableUInt64Slice {
	return ImmutableUInt64Slice{value: (*ms.orig).BucketCounts}
}

// SetBucketCounts replaces the bucketcounts associated with this Buckets.
func (ms Buckets) SetBucketCounts(v ImmutableUInt64Slice) {
	(*ms.orig).BucketCounts = v.value
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Buckets) CopyTo(dest Buckets) {
	dest.SetOffset(ms.Offset())
	if len(ms.orig.BucketCounts) == 0 {
		dest.orig.BucketCounts = nil
	} else {
		dest.orig.BucketCounts = make([]uint64, len(ms.orig.BucketCounts))
		copy(dest.orig.BucketCounts, ms.orig.BucketCounts)
	}

}

// SummaryDataPointSlice logically represents a slice of SummaryDataPoint.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewSummaryDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryDataPointSlice struct {
	// orig points to the slice otlpmetrics.SummaryDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]*otlpmetrics.SummaryDataPoint
}

func newSummaryDataPointSlice(orig *[]*otlpmetrics.SummaryDataPoint) SummaryDataPointSlice {
	return SummaryDataPointSlice{orig}
}

// NewSummaryDataPointSlice creates a SummaryDataPointSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewSummaryDataPointSlice() SummaryDataPointSlice {
	orig := []*otlpmetrics.SummaryDataPoint(nil)
	return SummaryDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewSummaryDataPointSlice()".
func (es SummaryDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es SummaryDataPointSlice) At(ix int) SummaryDataPoint {
	return newSummaryDataPoint((*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es SummaryDataPointSlice) CopyTo(dest SummaryDataPointSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newSummaryDataPoint((*es.orig)[i]).CopyTo(newSummaryDataPoint((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.SummaryDataPoint, srcLen)
	wrappers := make([]*otlpmetrics.SummaryDataPoint, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newSummaryDataPoint((*es.orig)[i]).CopyTo(newSummaryDataPoint(wrappers[i]))
	}
	*dest.orig = wrappers
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new SummaryDataPointSlice can be initialized:
//
//	es := NewSummaryDataPointSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es SummaryDataPointSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpmetrics.SummaryDataPoint, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty SummaryDataPoint.
// It returns the newly added SummaryDataPoint.
func (es SummaryDataPointSlice) AppendEmpty() SummaryDataPoint {
	*es.orig = append(*es.orig, &otlpmetrics.SummaryDataPoint{})
	return es.At(es.Len() - 1)
}

// Sort sorts the SummaryDataPoint elements within SummaryDataPointSlice given the
// provided less function so that two instances of SummaryDataPointSlice
// can be compared.
//
// Returns the same instance to allow nicer code like:
//
//	lessFunc := func(a, b SummaryDataPoint) bool {
//	  return a.Name() < b.Name() // choose any comparison here
//	}
//	assert.EqualValues(t, expected.Sort(lessFunc), actual.Sort(lessFunc))
func (es SummaryDataPointSlice) Sort(less func(a, b SummaryDataPoint) bool) SummaryDataPointSlice {
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
	return es
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es SummaryDataPointSlice) MoveAndAppendTo(dest SummaryDataPointSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es SummaryDataPointSlice) RemoveIf(f func(SummaryDataPoint) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// SummaryDataPoint is a single data point in a timeseries that describes the time-varying values of a Summary of double values.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryDataPoint struct {
	orig *otlpmetrics.SummaryDataPoint
}

func newSummaryDataPoint(orig *otlpmetrics.SummaryDataPoint) SummaryDataPoint {
	return SummaryDataPoint{orig: orig}
}

// NewSummaryDataPoint creates a new empty SummaryDataPoint.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewSummaryDataPoint() SummaryDataPoint {
	return newSummaryDataPoint(&otlpmetrics.SummaryDataPoint{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms SummaryDataPoint) MoveTo(dest SummaryDataPoint) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.SummaryDataPoint{}
}

// Attributes returns the Attributes associated with this SummaryDataPoint.
func (ms SummaryDataPoint) Attributes() Map {
	return newMap(&(*ms.orig).Attributes)
}

// StartTimestamp returns the starttimestamp associated with this SummaryDataPoint.
func (ms SummaryDataPoint) StartTimestamp() Timestamp {
	return Timestamp((*ms.orig).StartTimeUnixNano)
}

// SetStartTimestamp replaces the starttimestamp associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetStartTimestamp(v Timestamp) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this SummaryDataPoint.
func (ms SummaryDataPoint) Timestamp() Timestamp {
	return Timestamp((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetTimestamp(v Timestamp) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this SummaryDataPoint.
func (ms SummaryDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this SummaryDataPoint.
func (ms SummaryDataPoint) Sum() float64 {
	return (*ms.orig).Sum
}

// SetSum replaces the sum associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetSum(v float64) {
	(*ms.orig).Sum = v
}

// QuantileValues returns the QuantileValues associated with this SummaryDataPoint.
func (ms SummaryDataPoint) QuantileValues() ValueAtQuantileSlice {
	return newValueAtQuantileSlice(&(*ms.orig).QuantileValues)
}

// Flags returns the flags associated with this SummaryDataPoint.
func (ms SummaryDataPoint) Flags() MetricDataPointFlags {
	return newMetricDataPointFlags(&(*ms.orig).Flags)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms SummaryDataPoint) CopyTo(dest SummaryDataPoint) {
	ms.Attributes().CopyTo(dest.Attributes())
	dest.SetStartTimestamp(ms.StartTimestamp())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	dest.SetSum(ms.Sum())
	ms.QuantileValues().CopyTo(dest.QuantileValues())
	ms.Flags().CopyTo(dest.Flags())
}

// ValueAtQuantileSlice logically represents a slice of ValueAtQuantile.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewValueAtQuantileSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ValueAtQuantileSlice struct {
	// orig points to the slice otlpmetrics.SummaryDataPoint_ValueAtQuantile field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]*otlpmetrics.SummaryDataPoint_ValueAtQuantile
}

func newValueAtQuantileSlice(orig *[]*otlpmetrics.SummaryDataPoint_ValueAtQuantile) ValueAtQuantileSlice {
	return ValueAtQuantileSlice{orig}
}

// NewValueAtQuantileSlice creates a ValueAtQuantileSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewValueAtQuantileSlice() ValueAtQuantileSlice {
	orig := []*otlpmetrics.SummaryDataPoint_ValueAtQuantile(nil)
	return ValueAtQuantileSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewValueAtQuantileSlice()".
func (es ValueAtQuantileSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es ValueAtQuantileSlice) At(ix int) ValueAtQuantile {
	return newValueAtQuantile((*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es ValueAtQuantileSlice) CopyTo(dest ValueAtQuantileSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
		for i := range *es.orig {
			newValueAtQuantile((*es.orig)[i]).CopyTo(newValueAtQuantile((*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.SummaryDataPoint_ValueAtQuantile, srcLen)
	wrappers := make([]*otlpmetrics.SummaryDataPoint_ValueAtQuantile, srcLen)
	for i := range *es.orig {
		wrappers[i] = &origs[i]
		newValueAtQuantile((*es.orig)[i]).CopyTo(newValueAtQuantile(wrappers[i]))
	}
	*dest.orig = wrappers
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new ValueAtQuantileSlice can be initialized:
//
//	es := NewValueAtQuantileSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es ValueAtQuantileSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]*otlpmetrics.SummaryDataPoint_ValueAtQuantile, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty ValueAtQuantile.
// It returns the newly added ValueAtQuantile.
func (es ValueAtQuantileSlice) AppendEmpty() ValueAtQuantile {
	*es.orig = append(*es.orig, &otlpmetrics.SummaryDataPoint_ValueAtQuantile{})
	return es.At(es.Len() - 1)
}

// Sort sorts the ValueAtQuantile elements within ValueAtQuantileSlice given the
// provided less function so that two instances of ValueAtQuantileSlice
// can be compared.
//
// Returns the same instance to allow nicer code like:
//
//	lessFunc := func(a, b ValueAtQuantile) bool {
//	  return a.Name() < b.Name() // choose any comparison here
//	}
//	assert.EqualValues(t, expected.Sort(lessFunc), actual.Sort(lessFunc))
func (es ValueAtQuantileSlice) Sort(less func(a, b ValueAtQuantile) bool) ValueAtQuantileSlice {
	sort.SliceStable(*es.orig, func(i, j int) bool { return less(es.At(i), es.At(j)) })
	return es
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ValueAtQuantileSlice) MoveAndAppendTo(dest ValueAtQuantileSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es ValueAtQuantileSlice) RemoveIf(f func(ValueAtQuantile) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// ValueAtQuantile is a quantile value within a Summary data point.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewValueAtQuantile function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ValueAtQuantile struct {
	orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile
}

func newValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile) ValueAtQuantile {
	return ValueAtQuantile{orig: orig}
}

// NewValueAtQuantile creates a new empty ValueAtQuantile.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewValueAtQuantile() ValueAtQuantile {
	return newValueAtQuantile(&otlpmetrics.SummaryDataPoint_ValueAtQuantile{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms ValueAtQuantile) MoveTo(dest ValueAtQuantile) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
}

// Quantile returns the quantile associated with this ValueAtQuantile.
func (ms ValueAtQuantile) Quantile() float64 {
	return (*ms.orig).Quantile
}

// SetQuantile replaces the quantile associated with this ValueAtQuantile.
func (ms ValueAtQuantile) SetQuantile(v float64) {
	(*ms.orig).Quantile = v
}

// Value returns the value associated with this ValueAtQuantile.
func (ms ValueAtQuantile) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this ValueAtQuantile.
func (ms ValueAtQuantile) SetValue(v float64) {
	(*ms.orig).Value = v
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ValueAtQuantile) CopyTo(dest ValueAtQuantile) {
	dest.SetQuantile(ms.Quantile())
	dest.SetValue(ms.Value())
}

// ExemplarSlice logically represents a slice of Exemplar.
//
// This is a reference type. If passed by value and callee modifies it, the
// caller will see the modification.
//
// Must use NewExemplarSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ExemplarSlice struct {
	// orig points to the slice otlpmetrics.Exemplar field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like EnsureCapacity.
	orig *[]otlpmetrics.Exemplar
}

func newExemplarSlice(orig *[]otlpmetrics.Exemplar) ExemplarSlice {
	return ExemplarSlice{orig}
}

// NewExemplarSlice creates a ExemplarSlice with 0 elements.
// Can use "EnsureCapacity" to initialize with a given capacity.
func NewExemplarSlice() ExemplarSlice {
	orig := []otlpmetrics.Exemplar(nil)
	return ExemplarSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewExemplarSlice()".
func (es ExemplarSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
//
//	for i := 0; i < es.Len(); i++ {
//	    e := es.At(i)
//	    ... // Do something with the element
//	}
func (es ExemplarSlice) At(ix int) Exemplar {
	return newExemplar(&(*es.orig)[ix])
}

// CopyTo copies all elements from the current slice to the dest.
func (es ExemplarSlice) CopyTo(dest ExemplarSlice) {
	srcLen := es.Len()
	destCap := cap(*dest.orig)
	if srcLen <= destCap {
		(*dest.orig) = (*dest.orig)[:srcLen:destCap]
	} else {
		(*dest.orig) = make([]otlpmetrics.Exemplar, srcLen)
	}

	for i := range *es.orig {
		newExemplar(&(*es.orig)[i]).CopyTo(newExemplar(&(*dest.orig)[i]))
	}
}

// EnsureCapacity is an operation that ensures the slice has at least the specified capacity.
// 1. If the newCap <= cap then no change in capacity.
// 2. If the newCap > cap then the slice capacity will be expanded to equal newCap.
//
// Here is how a new ExemplarSlice can be initialized:
//
//	es := NewExemplarSlice()
//	es.EnsureCapacity(4)
//	for i := 0; i < 4; i++ {
//	    e := es.AppendEmpty()
//	    // Here should set all the values for e.
//	}
func (es ExemplarSlice) EnsureCapacity(newCap int) {
	oldCap := cap(*es.orig)
	if newCap <= oldCap {
		return
	}

	newOrig := make([]otlpmetrics.Exemplar, len(*es.orig), newCap)
	copy(newOrig, *es.orig)
	*es.orig = newOrig
}

// AppendEmpty will append to the end of the slice an empty Exemplar.
// It returns the newly added Exemplar.
func (es ExemplarSlice) AppendEmpty() Exemplar {
	*es.orig = append(*es.orig, otlpmetrics.Exemplar{})
	return es.At(es.Len() - 1)
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ExemplarSlice) MoveAndAppendTo(dest ExemplarSlice) {
	if *dest.orig == nil {
		// We can simply move the entire vector and avoid any allocations.
		*dest.orig = *es.orig
	} else {
		*dest.orig = append(*dest.orig, *es.orig...)
	}
	*es.orig = nil
}

// RemoveIf calls f sequentially for each element present in the slice.
// If f returns true, the element is removed from the slice.
func (es ExemplarSlice) RemoveIf(f func(Exemplar) bool) {
	newLen := 0
	for i := 0; i < len(*es.orig); i++ {
		if f(es.At(i)) {
			continue
		}
		if newLen == i {
			// Nothing to move, element is at the right place.
			newLen++
			continue
		}
		(*es.orig)[newLen] = (*es.orig)[i]
		newLen++
	}
	// TODO: Prevent memory leak by erasing truncated values.
	*es.orig = (*es.orig)[:newLen]
}

// Exemplar is a sample input double measurement.
//
// Exemplars also hold information about the environment when the measurement was recorded,
// for example the span and trace ID of the active span when the exemplar was recorded.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewExemplar function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Exemplar struct {
	orig *otlpmetrics.Exemplar
}

func newExemplar(orig *otlpmetrics.Exemplar) Exemplar {
	return Exemplar{orig: orig}
}

// NewExemplar creates a new empty Exemplar.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewExemplar() Exemplar {
	return newExemplar(&otlpmetrics.Exemplar{})
}

// MoveTo moves all properties from the current struct to dest
// resetting the current instance to its zero value
func (ms Exemplar) MoveTo(dest Exemplar) {
	*dest.orig = *ms.orig
	*ms.orig = otlpmetrics.Exemplar{}
}

// Timestamp returns the timestamp associated with this Exemplar.
func (ms Exemplar) Timestamp() Timestamp {
	return Timestamp((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this Exemplar.
func (ms Exemplar) SetTimestamp(v Timestamp) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// ValueType returns the type of the value for this Exemplar.
// Calling this function on zero-initialized Exemplar will cause a panic.
func (ms Exemplar) ValueType() ExemplarValueType {
	switch ms.orig.Value.(type) {
	case *otlpmetrics.Exemplar_AsDouble:
		return ExemplarValueTypeDouble
	case *otlpmetrics.Exemplar_AsInt:
		return ExemplarValueTypeInt
	}
	return ExemplarValueTypeNone
}

// DoubleVal returns the doubleval associated with this Exemplar.
func (ms Exemplar) DoubleVal() float64 {
	return (*ms.orig).GetAsDouble()
}

// SetDoubleVal replaces the doubleval associated with this Exemplar.
func (ms Exemplar) SetDoubleVal(v float64) {
	(*ms.orig).Value = &otlpmetrics.Exemplar_AsDouble{
		AsDouble: v,
	}
}

// IntVal returns the intval associated with this Exemplar.
func (ms Exemplar) IntVal() int64 {
	return (*ms.orig).GetAsInt()
}

// SetIntVal replaces the intval associated with this Exemplar.
func (ms Exemplar) SetIntVal(v int64) {
	(*ms.orig).Value = &otlpmetrics.Exemplar_AsInt{
		AsInt: v,
	}
}

// FilteredAttributes returns the FilteredAttributes associated with this Exemplar.
func (ms Exemplar) FilteredAttributes() Map {
	return newMap(&(*ms.orig).FilteredAttributes)
}

// TraceID returns the traceid associated with this Exemplar.
func (ms Exemplar) TraceID() TraceID {
	return TraceID{orig: ((*ms.orig).TraceId)}
}

// SetTraceID replaces the traceid associated with this Exemplar.
func (ms Exemplar) SetTraceID(v TraceID) {
	(*ms.orig).TraceId = v.orig
}

// SpanID returns the spanid associated with this Exemplar.
func (ms Exemplar) SpanID() SpanID {
	return SpanID{orig: ((*ms.orig).SpanId)}
}

// SetSpanID replaces the spanid associated with this Exemplar.
func (ms Exemplar) SetSpanID(v SpanID) {
	(*ms.orig).SpanId = v.orig
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Exemplar) CopyTo(dest Exemplar) {
	dest.SetTimestamp(ms.Timestamp())
	switch ms.ValueType() {
	case ExemplarValueTypeDouble:
		dest.SetDoubleVal(ms.DoubleVal())
	case ExemplarValueTypeInt:
		dest.SetIntVal(ms.IntVal())
	}

	ms.FilteredAttributes().CopyTo(dest.FilteredAttributes())
	dest.SetTraceID(ms.TraceID())
	dest.SetSpanID(ms.SpanID())
}
