// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "model/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run model/internal/cmd/pdatagen/main.go".

package pcommon

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNewImmutableByteSlice(t *testing.T) {
	tests := []struct {
		name string
		orig []byte
		want []byte
	}{
		{
			name: "nil",
			orig: nil,
			want: nil,
		},
		{
			name: "empty",
			orig: []byte{},
			want: nil,
		},
		{
			name: "copy",
			orig: []byte{1, 2, 3},
			want: []byte{1, 2, 3},
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			s := NewImmutableByteSlice(tt.orig)
			assert.Equal(t, tt.want, s.AsRaw())
			assert.Equal(t, len(s.getOrig()), s.Len())
			if len(tt.orig) > 0 {
				// verify that orig mutation doesn't have any effect
				tt.orig[0] = byte(0)
				assert.Equal(t, byte(1), s.At(0))
			}
		})
	}
}

func TestNewImmutableFloat64Slice(t *testing.T) {
	tests := []struct {
		name string
		orig []float64
		want []float64
	}{
		{
			name: "nil",
			orig: nil,
			want: nil,
		},
		{
			name: "empty",
			orig: []float64{},
			want: nil,
		},
		{
			name: "copy",
			orig: []float64{1, 2, 3},
			want: []float64{1, 2, 3},
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			s := NewImmutableFloat64Slice(tt.orig)
			assert.Equal(t, tt.want, s.AsRaw())
			assert.Equal(t, len(s.getOrig()), s.Len())
			if len(tt.orig) > 0 {
				// verify that orig mutation doesn't have any effect
				tt.orig[0] = float64(0)
				assert.Equal(t, float64(1), s.At(0))
			}
		})
	}
}

func TestNewImmutableUInt64Slice(t *testing.T) {
	tests := []struct {
		name string
		orig []uint64
		want []uint64
	}{
		{
			name: "nil",
			orig: nil,
			want: nil,
		},
		{
			name: "empty",
			orig: []uint64{},
			want: nil,
		},
		{
			name: "copy",
			orig: []uint64{1, 2, 3},
			want: []uint64{1, 2, 3},
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			s := NewImmutableUInt64Slice(tt.orig)
			assert.Equal(t, tt.want, s.AsRaw())
			assert.Equal(t, len(s.getOrig()), s.Len())
			if len(tt.orig) > 0 {
				// verify that orig mutation doesn't have any effect
				tt.orig[0] = uint64(0)
				assert.Equal(t, uint64(1), s.At(0))
			}
		})
	}
}
