27 Jan 2020

#### OpenShift v4.2 support with operator

Calico now supports the latest major release of OpenShift! Included in this
Calico release is an operator that installs and manages your Calico cluster on
OpenShift. For more information, see the OpenShift v4 [installation guide](https://docs.projectcalico.org/v3.12/getting-started/openshift/installation).

#### IPv6 service advertisement

If you are running an IPv6 or dual-stack cluster, Calico now supports advertising IPv6 service clusterIPs
over BGP in addition to IPv4 service IPs! To advertise your IPv6 services, simply add the IPv6 clusterIP cidrs
of your workloads to your default `BGPConfiguration`. For more information, see the [documentation for advertising service IPs](https://docs.projectcalico.org/v3.12/networking/advertise-service-ips).

 - Add IPv6 service advertisement support. [confd #310](https://github.com/projectcalico/confd/pull/310) (@neiljerram)

#### Autodetection of iptables backend

Previous versions of Calico required you to specify the host's iptables backend
(one of `NFT` or `Legacy`). With this release, Calico can now autodetect the
iptables variant on the host. This is useful in scenarios where you don't know
what the iptables backend might be such as in mixed deployments.

 - Added autodetection capability of iptables backend. [felix #2194](https://github.com/projectcalico/felix/pull/2194) (@tmjd)

#### Rule metadata

Calico now supports custom metadata attached to policy rules that allows you to aggregate packet and
byte statistics by that metadata. These rules annotations are rendered as comments on the iptables
rules corresponding to the policy rules, allowing you to use `iptables-save -c` to gather metrics. See the
[global network policy](https://docs.projectcalico.org/v3.12/reference/resources/globalnetworkpolicy#rulemetadata)
or [network policy](https://docs.projectcalico.org/v3.12/reference/resources/networkpolicy#rulemetadata) documentation
for more information.

 - Rule metadata annotations are written to iptables comments. [felix #2209](https://github.com/projectcalico/felix/pull/2209) (@spikecurtis)

#### Bug fixes

 - Fix a bug when checking the containerID during an IPAM upgrade from host-local to calico-ipam. [cni-plugin #824](https://github.com/projectcalico/cni-plugin/pull/824) (@sreis)
 - Fail fast & retry setting NetworkUnavailable to false. [node #387](https://github.com/projectcalico/node/pull/387) (@spikecurtis)
 - Wait for successful connect to datastore before configuring kubelet with CNI plugin. [cni-plugin #819](https://github.com/projectcalico/cni-plugin/pull/819) (@spikecurtis)
 - Fix Typha connnections limit to account for confd. [typha #387](https://github.com/projectcalico/typha/pull/348) (@rafaelvanoni)
 - Add nsswitch.conf to Typha for correct resolution of localhost. [typha #343](https://github.com/projectcalico/typha/pull/343) (@caseydavenport)
 - Update version of etcd client to fix failover for secure endpoints. [libcalico-go #1184](https://github.com/projectcalico/libcalico-go/pull/1184) (@caseydavenport)

#### Other changes

 - Support for SCTP ports. [felix #2192](https://github.com/projectcalico/felix/pull/2192) (@spikecurtis)
 - Update Application Layer Policy install instructions to work with Istio 1.4. [calico #3082](https://github.com/projectcalico/calico/pull/3082) (@spikecurtis)
 - Use iptables for IPv4 RPF check instead of sysctls. [felix #2189](https://github.com/projectcalico/felix/pull/2189) (@lmm)
 - Add projectcalico.org/name label for exact match on namespace and serviceaccount names. [libcalico-go #1191](https://github.com/projectcalico/libcalico-go/pull/1191) (@caseydavenport)
 - Application Layer Policy supports Istio in permissive mode. [app-policy #131](https://github.com/projectcalico/app-policy/pull/131) (@gianlucam76)
 - The "beta.kubernetes.io/os" label was deprecated and is replaced by "kubernetes.io/os". [calico #3064](https://github.com/projectcalico/calico/pull/3064) (@hackman)
 - Use kubernetes.io/os label selector instead of deprecated beta.kubernetes.io/os label. [calico #3095](https://github.com/projectcalico/calico/pull/3095) (@JonathanWilbur)
 - Add MTU configuration option to Canal config map. [calico #3062](https://github.com/projectcalico/calico/pull/3062) (@plnordquist)
