05 Mar 2020

#### New eBPF dataplane technology preview

The flagship feature of v3.13 is the tech preview of Calico's new eBPF dataplane mode.  While it's not ready for production (it's missing some key features and has had limited testing), it is a great preview of things to come for those ready to adopt newer kernel versions.

The eBPF dataplane:

- Scales to higher throughput.
- Uses less CPU per GBit.
- Has native support for Kubernetes services (without needing kube-proxy) that:
  - Reduces first packet latency for packets to services.
  - Preserves external client source IP addresses all the way to the pod.
  - Supports DSR (Direct Server Return) for more efficient service routing.
  - Uses less CPU than kube-proxy to keep the dataplane in sync.

If that's whetted your appetite and you'd like to hear more (and see some pretty performance graphs), head over to [the announcement blog](https://www.projectcalico.org/introducing-the-calico-ebpf-dataplane/).  Once you're ready to give it a spin, you'll want [the how-to guide](https://docs.projectcalico.org/master/getting-started/kubernetes/trying-ebpf).

#### Bug fixes

 - Fixes an issue where Felix / Typha unnecessarily perform full resyncs of NetworkPolicies [libcalico-go #1192](https://github.com/projectcalico/libcalico-go/pull/1192) (@spikecurtis)

#### Other changes

 - Add protocols section to calico/node nsswitch.conf [node #418](https://github.com/projectcalico/node/pull/418) (@leodotcloud)
 - Calico now auto-detects the IP Pool CIDR when running on kubeadm [node #417](https://github.com/projectcalico/node/pull/417) (@rafaelvanoni)
 - In calico.yaml, `CALICO_IPV4POOL_CIDR` has been commented out, but the default CIDR remains the same. To change the CIDR in the manifest, you must first uncomment that section. [calico #3211](https://github.com/projectcalico/calico/pull/3211) (@rafaelvanoni)
 - Improve Felix liveness reporting when handling large policies. [felix #2215](https://github.com/projectcalico/felix/pull/2215) (@fasaxc)
 - Improve IPAM garbage collection for etcd clusters. [kube-controllers #459](https://github.com/projectcalico/kube-controllers/pull/459) (@caseydavenport)
