//go:build !ignore_autogenerated
// +build !ignore_autogenerated

// Copyright (c) 2016-2021 Tigera, Inc. All rights reserved.

// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by openapi-gen. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package v1

import (
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeer":                  schema_libcalico_go_lib_apis_v1_BGPPeer(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeerList":              schema_libcalico_go_lib_apis_v1_BGPPeerList(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeerMetadata":          schema_libcalico_go_lib_apis_v1_BGPPeerMetadata(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeerSpec":              schema_libcalico_go_lib_apis_v1_BGPPeerSpec(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.CalicoAPIConfig":          schema_libcalico_go_lib_apis_v1_CalicoAPIConfig(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.CalicoAPIConfigMetadata":  schema_libcalico_go_lib_apis_v1_CalicoAPIConfigMetadata(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.CalicoAPIConfigSpec":      schema_libcalico_go_lib_apis_v1_CalicoAPIConfigSpec(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EndpointPort":             schema_libcalico_go_lib_apis_v1_EndpointPort(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EntityRule":               schema_libcalico_go_lib_apis_v1_EntityRule(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EtcdConfig":               schema_libcalico_go_lib_apis_v1_EtcdConfig(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpoint":             schema_libcalico_go_lib_apis_v1_HostEndpoint(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpointList":         schema_libcalico_go_lib_apis_v1_HostEndpointList(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpointMetadata":     schema_libcalico_go_lib_apis_v1_HostEndpointMetadata(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpointSpec":         schema_libcalico_go_lib_apis_v1_HostEndpointSpec(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ICMPFields":               schema_libcalico_go_lib_apis_v1_ICMPFields(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPIPConfiguration":        schema_libcalico_go_lib_apis_v1_IPIPConfiguration(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPNAT":                    schema_libcalico_go_lib_apis_v1_IPNAT(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPool":                   schema_libcalico_go_lib_apis_v1_IPPool(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPoolList":               schema_libcalico_go_lib_apis_v1_IPPoolList(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPoolMetadata":           schema_libcalico_go_lib_apis_v1_IPPoolMetadata(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPoolSpec":               schema_libcalico_go_lib_apis_v1_IPPoolSpec(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.KubeConfig":               schema_libcalico_go_lib_apis_v1_KubeConfig(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Node":                     schema_libcalico_go_lib_apis_v1_Node(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeBGPSpec":              schema_libcalico_go_lib_apis_v1_NodeBGPSpec(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeList":                 schema_libcalico_go_lib_apis_v1_NodeList(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeMetadata":             schema_libcalico_go_lib_apis_v1_NodeMetadata(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeSpec":                 schema_libcalico_go_lib_apis_v1_NodeSpec(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.OrchRef":                  schema_libcalico_go_lib_apis_v1_OrchRef(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Policy":                   schema_libcalico_go_lib_apis_v1_Policy(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.PolicyList":               schema_libcalico_go_lib_apis_v1_PolicyList(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.PolicyMetadata":           schema_libcalico_go_lib_apis_v1_PolicyMetadata(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.PolicySpec":               schema_libcalico_go_lib_apis_v1_PolicySpec(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Profile":                  schema_libcalico_go_lib_apis_v1_Profile(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ProfileList":              schema_libcalico_go_lib_apis_v1_ProfileList(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ProfileMetadata":          schema_libcalico_go_lib_apis_v1_ProfileMetadata(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ProfileSpec":              schema_libcalico_go_lib_apis_v1_ProfileSpec(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Rule":                     schema_libcalico_go_lib_apis_v1_Rule(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpoint":         schema_libcalico_go_lib_apis_v1_WorkloadEndpoint(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpointList":     schema_libcalico_go_lib_apis_v1_WorkloadEndpointList(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpointMetadata": schema_libcalico_go_lib_apis_v1_WorkloadEndpointMetadata(ref),
		"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpointSpec":     schema_libcalico_go_lib_apis_v1_WorkloadEndpointSpec(ref),
	}
}

func schema_libcalico_go_lib_apis_v1_BGPPeer(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BGPPeer contains information about a BGP peer resource that is a peer of a Calico compute node.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Metadata for a BGPPeer.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeerMetadata"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification for a BGPPeer.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeerSpec"),
						},
					},
				},
				Required: []string{"TypeMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeerMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeerSpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_BGPPeerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BGPPeerList contains a list of BGP Peer resources.  List types are returned from List() enumerations in the client interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeer"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMetadata", "items"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.BGPPeer", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_BGPPeerMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BGPPeerMetadata contains the metadata for a BGPPeer resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ObjectMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"),
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "The scope of the peer.  This may be global or node.  A global peer is a BGP device that peers with all Calico nodes.  A node peer is a BGP device that peers with the specified Calico node (specified by the node hostname).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"node": {
						SchemaProps: spec.SchemaProps{
							Description: "The node name identifying the Calico node instance that is peering with this peer. When modifying a BGP peer, the node must be specified when the scope is `node`, and must be omitted when the scope is `global`.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"peerIP": {
						SchemaProps: spec.SchemaProps{
							Description: "The IP address of the peer.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IP"),
						},
					},
				},
				Required: []string{"ObjectMetadata", "scope", "peerIP"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata", "github.com/projectcalico/calico/libcalico-go/lib/net.IP"},
	}
}

func schema_libcalico_go_lib_apis_v1_BGPPeerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BGPPeerSpec contains the specification for a BGPPeer resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"asNumber": {
						SchemaProps: spec.SchemaProps{
							Description: "The AS Number of the peer.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"asNumber"},
			},
		},
	}
}

func schema_libcalico_go_lib_apis_v1_CalicoAPIConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CalicoAPIConfig contains the connection information for a Calico CalicoAPIConfig resource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.CalicoAPIConfigMetadata"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.CalicoAPIConfigSpec"),
						},
					},
				},
				Required: []string{"TypeMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.CalicoAPIConfigMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.CalicoAPIConfigSpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_CalicoAPIConfigMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CalicoAPIConfigMetadata contains the metadata for a Calico CalicoAPIConfig resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ObjectMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"),
						},
					},
				},
				Required: []string{"ObjectMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_CalicoAPIConfigSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CalicoAPIConfigSpec contains the specification for a Calico CalicoAPIConfig resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"datastoreType": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"EtcdConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "Inline the etcd config fields",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EtcdConfig"),
						},
					},
					"KubeConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "Inline the k8s config fields.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.KubeConfig"),
						},
					},
				},
				Required: []string{"datastoreType", "EtcdConfig", "KubeConfig"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EtcdConfig", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.KubeConfig"},
	}
}

func schema_libcalico_go_lib_apis_v1_EndpointPort(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/api/pkg/lib/numorstring.Protocol"),
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Default: 0,
							Type:    []string{"integer"},
							Format:  "int32",
						},
					},
				},
				Required: []string{"name", "protocol", "port"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/api/pkg/lib/numorstring.Protocol"},
	}
}

func schema_libcalico_go_lib_apis_v1_EntityRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An EntityRule is a sub-component of a Rule comprising the match criteria specific to a particular entity (that is either the source or destination).\n\nA source EntityRule matches the source endpoint and originating traffic. A destination EntityRule matches the destination endpoint and terminating traffic.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"tag": {
						SchemaProps: spec.SchemaProps{
							Description: "Tag is an optional field that restricts the rule to only apply to traffic that originates from (or terminates at) endpoints that have profiles with the given tag in them.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"net": {
						SchemaProps: spec.SchemaProps{
							Description: "Net is an optional field that restricts the rule to only apply to traffic that originates from (or terminates at) IP addresses in the given subnet. Deprecated: superseded by the Nets field.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
						},
					},
					"nets": {
						SchemaProps: spec.SchemaProps{
							Description: "Nets is an optional field that restricts the rule to only apply to traffic that originates from (or terminates at) IP addresses in any of the given subnets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
									},
								},
							},
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is an optional field that contains a selector expression (see Policy for sample syntax).  Only traffic that originates from (terminates at) endpoints matching the selector will be matched.\n\nNote that: in addition to the negated version of the Selector (see NotSelector below), the selector expression syntax itself supports negation.  The two types of negation are subtly different. One negates the set of matched endpoints, the other negates the whole match:\n\n\tSelector = \"!has(my_label)\" matches packets that are from other Calico-controlled\n\tendpoints that do not have the label \"my_label\".\n\n\tNotSelector = \"has(my_label)\" matches packets that are not from Calico-controlled\n\tendpoints that do have the label \"my_label\".\n\nThe effect is that the latter will accept packets from non-Calico sources whereas the former is limited to packets from Calico-controlled endpoints.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "Ports is an optional field that restricts the rule to only apply to traffic that has a source (destination) port that matches one of these ranges/values. This value is a list of integers or strings that represent ranges of ports.\n\nSince only some protocols have ports, if any ports are specified it requires the Protocol match in the Rule to be set to \"tcp\" or \"udp\".",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/api/pkg/lib/numorstring.Port"),
									},
								},
							},
						},
					},
					"notTag": {
						SchemaProps: spec.SchemaProps{
							Description: "NotTag is the negated version of the Tag field.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"notNet": {
						SchemaProps: spec.SchemaProps{
							Description: "NotNet is an optional field that restricts the rule to only apply to traffic that does not originate from (or terminate at) an IP address in the given subnet. Deprecated: superseded by NotNets.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
						},
					},
					"notNets": {
						SchemaProps: spec.SchemaProps{
							Description: "NotNets is an optional field that restricts the rule to only apply to traffic that does not originate from (or terminate at) an IP address in any of the given subnets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
									},
								},
							},
						},
					},
					"notSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NotSelector is the negated version of the Selector field.  See Selector field for subtleties with negated selectors.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"notPorts": {
						SchemaProps: spec.SchemaProps{
							Description: "NotPorts is the negated version of the Ports field.\n\nSince only some protocols have ports, if any ports are specified it requires the Protocol match in the Rule to be set to \"tcp\" or \"udp\".",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/api/pkg/lib/numorstring.Port"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/api/pkg/lib/numorstring.Port", "github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"},
	}
}

func schema_libcalico_go_lib_apis_v1_EtcdConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"etcdScheme": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"etcdAuthority": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"etcdEndpoints": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"etcdDiscoverySrv": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"etcdUsername": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"etcdPassword": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"etcdKeyFile": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"etcdCertFile": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"etcdCACertFile": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"etcdScheme", "etcdAuthority", "etcdEndpoints", "etcdDiscoverySrv", "etcdUsername", "etcdPassword", "etcdKeyFile", "etcdCertFile", "etcdCACertFile"},
			},
		},
	}
}

func schema_libcalico_go_lib_apis_v1_HostEndpoint(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HostEndpoint contains information about a \"bare-metal\" interfaces attached to the host that is running Calico's agent, Felix. By default, Calico doesn't apply any policy to such interfaces.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpointMetadata"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpointSpec"),
						},
					},
				},
				Required: []string{"TypeMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpointMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpointSpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_HostEndpointList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HostEndpointList contains a list of Host Endpoint resources.  List types are returned from List() enumerations in the client interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpoint"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMetadata", "items"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.HostEndpoint", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_HostEndpointMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HostEndpointMetadata contains the Metadata for a HostEndpoint resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ObjectMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"),
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the endpoint.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"node": {
						SchemaProps: spec.SchemaProps{
							Description: "The node name identifying the Calico node instance.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "The labels applied to the host endpoint.  It is expected that many endpoints share the same labels. For example, they could be used to label all \"production\" workloads with \"deployment=prod\" so that security policy can be applied to production workloads.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"ObjectMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_HostEndpointSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HostEndpointSpec contains the specification for a HostEndpoint resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"interfaceName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the linux interface to apply policy to; for example \"eth0\". If \"InterfaceName\" is not present then at least one expected IP must be specified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expectedIPs": {
						SchemaProps: spec.SchemaProps{
							Description: "The expected IP addresses (IPv4 and IPv6) of the endpoint. If \"InterfaceName\" is not present, Calico will look for an interface matching any of the IPs in the list and apply policy to that.\n\nNote:\n\tWhen using the selector|tag match criteria in an ingress or egress security Policy\n\tor Profile, Calico converts the selector into a set of IP addresses. For host\n\tendpoints, the ExpectedIPs field is used for that purpose. (If only the interface\n\tname is specified, Calico does not learn the IPs of the interface for use in match\n\tcriteria.)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/projectcalico/calico/libcalico-go/lib/net.IP"),
									},
								},
							},
						},
					},
					"profiles": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of identifiers of security Profile objects that apply to this endpoint. Each profile is applied in the order that they appear in this list.  Profile rules are applied after the selector-based security policy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "Ports contains the endpoint's named ports, which may be referenced in security policy rules.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EndpointPort"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EndpointPort", "github.com/projectcalico/calico/libcalico-go/lib/net.IP"},
	}
}

func schema_libcalico_go_lib_apis_v1_ICMPFields(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ICMPFields defines structure for ICMP and NotICMP sub-struct for ICMP code and type",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Match on a specific ICMP type.  For example a value of 8 refers to ICMP Echo Request (i.e. pings).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"code": {
						SchemaProps: spec.SchemaProps{
							Description: "Match on a specific ICMP code.  If specified, the Type value must also be specified. This is a technical limitation imposed by the kernel's iptables firewall, which Calico uses to enforce the rule.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_libcalico_go_lib_apis_v1_IPIPConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "When enabled is true, ipip tunneling will be used to deliver packets to destinations within this pool.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "The IPIP mode.  This can be one of \"always\" or \"cross-subnet\".  A mode of \"always\" will also use IPIP tunneling for routing to destination IP addresses within this pool.  A mode of \"cross-subnet\" will only use IPIP tunneling when the destination node is on a different subnet to the originating node.  The default value (if not specified) is \"always\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_libcalico_go_lib_apis_v1_IPNAT(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IPNat contains a single NAT mapping for a WorkloadEndpoint resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"internalIP": {
						SchemaProps: spec.SchemaProps{
							Description: "The internal IP address which must be associated with the owning endpoint via the configured IPNetworks for the endpoint.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IP"),
						},
					},
					"externalIP": {
						SchemaProps: spec.SchemaProps{
							Description: "The external IP address.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IP"),
						},
					},
				},
				Required: []string{"internalIP", "externalIP"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/net.IP"},
	}
}

func schema_libcalico_go_lib_apis_v1_IPPool(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IPPool contains the details of a Calico IP pool resource. A pool resource is used by Calico in two ways:\n  - to provide a set of IP addresses from which Calico IPAM assigns addresses\n    for workloads.\n  - to provide configuration specific to IP address range, such as configuration\n    for the BGP daemon (e.g. when to use a GRE tunnel to encapsulate packets\n    between compute hosts).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPoolMetadata"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPoolSpec"),
						},
					},
				},
				Required: []string{"TypeMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPoolMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPoolSpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_IPPoolList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IPPoolList contains a list of IP pool resources.  List types are returned from List() enumerations in the client interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPool"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMetadata", "items"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPPool", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_IPPoolMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IPPoolMetadata contains the metadata for an IP pool resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ObjectMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"),
						},
					},
					"cidr": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
						},
					},
				},
				Required: []string{"ObjectMetadata", "cidr"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata", "github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"},
	}
}

func schema_libcalico_go_lib_apis_v1_IPPoolSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IPPoolSpec contains the specification for an IP pool resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ipip": {
						SchemaProps: spec.SchemaProps{
							Description: "Contains configuration for ipip tunneling for this pool. If not specified, then ipip tunneling is disabled for this pool.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPIPConfiguration"),
						},
					},
					"nat-outgoing": {
						SchemaProps: spec.SchemaProps{
							Description: "When nat-outgoing is true, packets sent from Calico networked containers in this pool to destinations outside of this pool will be masqueraded.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"disabled": {
						SchemaProps: spec.SchemaProps{
							Description: "When disabled is true, Calico IPAM will not assign addresses from this pool.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPIPConfiguration"},
	}
}

func schema_libcalico_go_lib_apis_v1_KubeConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kubeconfig": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"k8sAPIEndpoint": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"k8sKeyFile": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"k8sCertFile": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"k8sCAFile": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"k8sAPIToken": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"k8sInsecureSkipTLSVerify": {
						SchemaProps: spec.SchemaProps{
							Default: false,
							Type:    []string{"boolean"},
							Format:  "",
						},
					},
					"k8sDisableNodePoll": {
						SchemaProps: spec.SchemaProps{
							Default: false,
							Type:    []string{"boolean"},
							Format:  "",
						},
					},
				},
				Required: []string{"kubeconfig", "k8sAPIEndpoint", "k8sKeyFile", "k8sCertFile", "k8sCAFile", "k8sAPIToken", "k8sInsecureSkipTLSVerify", "k8sDisableNodePoll"},
			},
		},
	}
}

func schema_libcalico_go_lib_apis_v1_Node(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Node contains the details of a node resource which contains the configuration for a Calico node instance running on a compute host.\n\nIn addition to creating a Node resource through calicoctl or the Calico API, the Calico node instance must also be running on the specific host and should be provided the same Name as that configured on the Node resource.  Note that, by default, the Calico node instance uses the hostname of the compute host when it is not explicitly specified - in this case, the equivalent Node resource should be created using the same hostname as the Name of the Node resource.\n\nOperations on the Node resources is expected to be required when adding a new host into a Calico network, and when removing a host from a Calico network, and occasionally to modify certain configuration.  Care should be taken when operating on Node resources: deleting a Node resource will remove all Node specific data.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeMetadata"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeSpec"),
						},
					},
				},
				Required: []string{"TypeMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeSpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_NodeBGPSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeSpec contains the specification for a Calico Node resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"asNumber": {
						SchemaProps: spec.SchemaProps{
							Description: "The AS Number of the node.  If this is not specified, the global default value will be used.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"ipv4Address": {
						SchemaProps: spec.SchemaProps{
							Description: "IPv4Address is the IPv4 address and network of this node.  At least one of the IPv4 and IPv6 addresses should be specified.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
						},
					},
					"ipv6Address": {
						SchemaProps: spec.SchemaProps{
							Description: "IPv6Address is the IPv6 address and network of this node.  At least one of the IPv4 and IPv6 addresses should be specified.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"},
	}
}

func schema_libcalico_go_lib_apis_v1_NodeList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A NodeList contains a list of Node resources.  List types are returned from List() enumerations on the client interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Node"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMetadata", "items"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Node", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_NodeMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeMetadata contains the metadata for a Calico Node resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ObjectMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"),
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"ObjectMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_NodeSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeSpec contains the specification for a Calico Node resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"bgp": {
						SchemaProps: spec.SchemaProps{
							Description: "BGP configuration for this node.  If this omitted, the Calico node will be run in policy-only mode.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeBGPSpec"),
						},
					},
					"orchRefs": {
						SchemaProps: spec.SchemaProps{
							Description: "OrchRefs for this node.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.OrchRef"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.NodeBGPSpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.OrchRef"},
	}
}

func schema_libcalico_go_lib_apis_v1_OrchRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OrchRef is used to correlate a Calico node to its corresponding representation in a given orchestrator",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"nodeName": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeName represents the name for this node according to the orchestrator.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"orchestrator": {
						SchemaProps: spec.SchemaProps{
							Description: "Orchestrator represents the orchestrator using this node.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"orchestrator"},
			},
		},
	}
}

func schema_libcalico_go_lib_apis_v1_Policy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Policy contains information about a security Policy resource.  This contains a set of security rules to apply.  Security policies allow a selector-based security model which can override the security profiles directly referenced by an endpoint.\n\nEach policy must do one of the following:\n\n  - Match the packet and apply an \"allow\" action; this immediately accepts the packet, skipping\n    all further policies and profiles. This is not recommended in general, because it prevents\n    further policy from being executed.\n  - Match the packet and apply a \"deny\" action; this drops the packet immediately, skipping all\n    further policy and profiles.\n  - Fail to match the packet; in which case the packet proceeds to the next policy. If there\n    are no more policies then the packet is dropped.\n\nCalico implements the security policy for each endpoint individually and only the policies that have matching selectors are implemented. This ensures that the number of rules that actually need to be inserted into the kernel is proportional to the number of local endpoints rather than the total amount of policy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.PolicyMetadata"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.PolicySpec"),
						},
					},
				},
				Required: []string{"TypeMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.PolicyMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.PolicySpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_PolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PolicyList contains a list of selector-based security Policy resources.  List types are returned from List() enumerations on the client interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Policy"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMetadata", "items"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Policy", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_PolicyMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PolicyMetadata contains the metadata for a selector-based security Policy resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ObjectMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"),
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the selector-based security policy.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Arbitrary key-value information to be used by clients.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"ObjectMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_PolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PolicySpec contains the specification for a selector-based security Policy resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"order": {
						SchemaProps: spec.SchemaProps{
							Description: "Order is an optional field that specifies the order in which the policy is applied. Policies with higher \"order\" are applied after those with lower order.  If the order is omitted, it may be considered to be \"infinite\" - i.e. the policy will be applied last.  Policies with identical order will be applied in alphanumerical order based on the Policy \"Name\".",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"ingress": {
						SchemaProps: spec.SchemaProps{
							Description: "The ordered set of ingress rules.  Each rule contains a set of packet match criteria and a corresponding action to apply.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Rule"),
									},
								},
							},
						},
					},
					"egress": {
						SchemaProps: spec.SchemaProps{
							Description: "The ordered set of egress rules.  Each rule contains a set of packet match criteria and a corresponding action to apply.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Rule"),
									},
								},
							},
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "The selector is an expression used to pick out the endpoints that the policy should be applied to.\n\nSelector expressions follow this syntax:\n\n\tlabel == \"string_literal\"  ->  comparison, e.g. my_label == \"foo bar\"\n\tlabel != \"string_literal\"   ->  not equal; also matches if label is not present\n\tlabel in { \"a\", \"b\", \"c\", ... }  ->  true if the value of label X is one of \"a\", \"b\", \"c\"\n\tlabel not in { \"a\", \"b\", \"c\", ... }  ->  true if the value of label X is not one of \"a\", \"b\", \"c\"\n\thas(label_name)  -> True if that label is present\n\t! expr -> negation of expr\n\texpr && expr  -> Short-circuit and\n\texpr || expr  -> Short-circuit or\n\t( expr ) -> parens for grouping\n\tall() or the empty selector -> matches all endpoints.\n\nLabel names are allowed to contain alphanumerics, -, _ and /. String literals are more permissive but they do not support escape characters.\n\nExamples (with made-up labels):\n\n\ttype == \"webserver\" && deployment == \"prod\"\n\ttype in {\"frontend\", \"backend\"}\n\tdeployment != \"dev\"\n\t! has(label_name)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"doNotTrack": {
						SchemaProps: spec.SchemaProps{
							Description: "DoNotTrack indicates whether packets matched by the rules in this policy should go through the data plane's connection tracking, such as Linux conntrack.  If True, the rules in this policy are applied before any data plane connection tracking, and packets allowed by this policy are marked as not to be tracked.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"preDNAT": {
						SchemaProps: spec.SchemaProps{
							Description: "PreDNAT indicates to apply the rules in this policy before any DNAT.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"types": {
						SchemaProps: spec.SchemaProps{
							Description: "Types indicates whether this policy applies to ingress, or to egress, or to both.  When not explicitly specified (and so the value on creation is empty or nil), Calico defaults Types according to what IngressRules and EgressRules are present in the policy.  The default is:\n\n- [ PolicyTypeIngress ], if there are no EgressRules (including the case where there are\n  also no IngressRules)\n\n- [ PolicyTypeEgress ], if there are EgressRules but no IngressRules\n\n- [ PolicyTypeIngress, PolicyTypeEgress ], if there are both IngressRules and EgressRules.\n\nWhen the policy is read back again, Types will always be one of these values, never empty or nil.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"selector"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Rule"},
	}
}

func schema_libcalico_go_lib_apis_v1_Profile(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Profile contains the details a security profile resource.  A profile is set of security rules to apply on an endpoint.  An endpoint (either a host endpoint or an endpoint on a workload) can reference zero or more profiles.  The profile rules are applied directly to the endpoint *after* the selector-based security policy has been applied, and in the order the profiles are declared on the endpoint.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ProfileMetadata"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ProfileSpec"),
						},
					},
				},
				Required: []string{"TypeMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ProfileMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ProfileSpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_ProfileList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A ProfileList contains a list of security Profile resources.  List types are returned from List() enumerations on the client interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Profile"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMetadata", "items"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Profile", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_ProfileMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProfileMetadata contains the metadata for a security Profile resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ObjectMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"),
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the endpoint.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tags": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of tags that are applied to each endpoint that references this profile.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "The labels to apply to each endpoint that references this profile.  It is expected that many endpoints share the same labels. For example, they could be used to label all \"production\" workloads with \"deployment=prod\" so that security policy can be applied to production workloads.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"ObjectMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_ProfileSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProfileSpec contains the specification for a security Profile resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ingress": {
						SchemaProps: spec.SchemaProps{
							Description: "The ordered set of ingress rules.  Each rule contains a set of packet match criteria and a corresponding action to apply.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Rule"),
									},
								},
							},
						},
					},
					"egress": {
						SchemaProps: spec.SchemaProps{
							Description: "The ordered set of egress rules.  Each rule contains a set of packet match criteria and a corresponding action to apply.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Rule"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.Rule"},
	}
}

func schema_libcalico_go_lib_apis_v1_Rule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A Rule encapsulates a set of match criteria and an action.  Both selector-based security Policy and security Profiles reference rules - separated out as a list of rules for both ingress and egress packet matching.\n\nEach positive match criteria has a negated version, prefixed with \"Not\". All the match criteria within a rule must be satisfied for a packet to match. A single rule can contain the positive and negative version of a match and both must be satisfied for the rule to match.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"action": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"ipVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "IPVersion is an optional field that restricts the rule to only match a specific IP version.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "Protocol is an optional field that restricts the rule to only apply to traffic of a specific IP protocol. Required if any of the EntityRules contain Ports (because ports only apply to certain protocols).\n\nMust be one of these string values: \"tcp\", \"udp\", \"icmp\", \"icmpv6\", \"sctp\", \"udplite\" or an integer in the range 1-255.",
							Ref:         ref("github.com/projectcalico/api/pkg/lib/numorstring.Protocol"),
						},
					},
					"icmp": {
						SchemaProps: spec.SchemaProps{
							Description: "ICMP is an optional field that restricts the rule to apply to a specific type and code of ICMP traffic.  This should only be specified if the Protocol field is set to \"icmp\" or \"icmpv6\".",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ICMPFields"),
						},
					},
					"notProtocol": {
						SchemaProps: spec.SchemaProps{
							Description: "NotProtocol is the negated version of the Protocol field.",
							Ref:         ref("github.com/projectcalico/api/pkg/lib/numorstring.Protocol"),
						},
					},
					"notICMP": {
						SchemaProps: spec.SchemaProps{
							Description: "NotICMP is the negated version of the ICMP field.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ICMPFields"),
						},
					},
					"source": {
						SchemaProps: spec.SchemaProps{
							Description: "Source contains the match criteria that apply to source entity.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EntityRule"),
						},
					},
					"destination": {
						SchemaProps: spec.SchemaProps{
							Description: "Destination contains the match criteria that apply to destination entity.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EntityRule"),
						},
					},
				},
				Required: []string{"action"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/api/pkg/lib/numorstring.Protocol", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EntityRule", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.ICMPFields"},
	}
}

func schema_libcalico_go_lib_apis_v1_WorkloadEndpoint(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpointMetadata"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpointSpec"),
						},
					},
				},
				Required: []string{"TypeMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpointMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpointSpec", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_WorkloadEndpointList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkloadEndpointList contains a list of Workload Endpoint resources.  List types are returned from List() enumerations in the client interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpoint"),
									},
								},
							},
						},
					},
				},
				Required: []string{"TypeMetadata", "items"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.WorkloadEndpoint", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ListMetadata", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.TypeMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_WorkloadEndpointMetadata(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkloadEndpointMetadata contains the Metadata for a WorkloadEndpoint resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ObjectMetadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"),
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the endpoint.  This may be omitted on a create, in which case an endpoint ID will be automatically created, and the endpoint ID will be included in the response.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"workload": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the workload.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"orchestrator": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the orchestrator.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"node": {
						SchemaProps: spec.SchemaProps{
							Description: "The node name identifying the Calico node instance.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"activeInstanceID": {
						SchemaProps: spec.SchemaProps{
							Description: "ActiveInstanceID is an optional field that orchestrators may use to store additional information about the endpoint. The primary use case is to store a unique identifier for the active instance of a container. For example, with Calico CNI, a re-spawned container may use the same endpoint indexing (Node, Orchestrator, Workload, Endpoint) for the new container as for the old - the ActiveInstanceID is used to store an additional unique ID which the CNI plugin uses to determine whether the DEL operation needs to delete the Calico WorkloadEndpoint. This field is not an index field of the WorkloadEndpoint resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "The labels applied to the workload endpoint.  It is expected that many endpoints share the same labels. For example, they could be used to label all \"production\" workloads with \"deployment=prod\" so that security policy can be applied to production workloads.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"ObjectMetadata"},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1/unversioned.ObjectMetadata"},
	}
}

func schema_libcalico_go_lib_apis_v1_WorkloadEndpointSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkloadEndpointMetadata contains the specification for a WorkloadEndpoint resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ipNetworks": {
						SchemaProps: spec.SchemaProps{
							Description: "IPNetworks is a list of subnets allocated to this endpoint. IP packets will only be allowed to leave this interface if they come from an address in one of these subnets.\n\nCurrently only /32 for IPv4 and /128 for IPv6 networks are supported.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
									},
								},
							},
						},
					},
					"ipNATs": {
						SchemaProps: spec.SchemaProps{
							Description: "IPNATs is a list of 1:1 NAT mappings to apply to the endpoint. Inbound connections to the external IP will be forwarded to the internal IP. Connections initiated from the internal IP will not have their source address changed, except when an endpoint attempts to connect one of its own external IPs. Each internal IP must be associated with the same endpoint via the configured IPNetworks.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPNAT"),
									},
								},
							},
						},
					},
					"ipv4Gateway": {
						SchemaProps: spec.SchemaProps{
							Description: "IPv4Gateway is the gateway IPv4 address for traffic from the workload.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IP"),
						},
					},
					"ipv6Gateway": {
						SchemaProps: spec.SchemaProps{
							Description: "IPv6Gateway is the gateway IPv6 address for traffic from the workload.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.IP"),
						},
					},
					"profiles": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of security Profile resources that apply to this endpoint. Each profile is applied in the order that they appear in this list.  Profile rules are applied after the selector-based security policy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"interfaceName": {
						SchemaProps: spec.SchemaProps{
							Description: "InterfaceName the name of the Linux interface on the host: for example, tap80.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"mac": {
						SchemaProps: spec.SchemaProps{
							Description: "MAC is the MAC address of the endpoint interface.",
							Ref:         ref("github.com/projectcalico/calico/libcalico-go/lib/net.MAC"),
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "Ports contains the endpoint's named ports, which may be referenced in security policy rules.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EndpointPort"),
									},
								},
							},
						},
					},
					"allow_spoofed_source_prefixes": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowSpoofedSourcePrefixes is a list of CIDRs this workload endpoint is allowed to send traffic from, i.e. this allows the workload endpoint to spoof its IP address using addresses in these prefixes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/projectcalico/calico/libcalico-go/lib/net.IPNet"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/projectcalico/calico/libcalico-go/lib/apis/v1.EndpointPort", "github.com/projectcalico/calico/libcalico-go/lib/apis/v1.IPNAT", "github.com/projectcalico/calico/libcalico-go/lib/net.IP", "github.com/projectcalico/calico/libcalico-go/lib/net.IPNet", "github.com/projectcalico/calico/libcalico-go/lib/net.MAC"},
	}
}
