/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import [Ljava.awt.geom.Point2D;;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NodeInst
extends Geometric
implements Nodable {
    public static final Variable.Key NODE_NAME = ElectricObject.newKey("NODE_name");
    public static final Variable.Key TRACE = ElectricObject.newKey("trace");
    private static final int NEXPAND = 4;
    private static final int WIPED = 8;
    private static final int NSHORT = 16;
    private static final int HARDSELECTN = 32768;
    private static final int NVISIBLEINSIDE = 0x800000;
    private static final int NTECHBITS = 0x7E0000;
    private static final int NTECHBITSSH = 17;
    private static final int NILOCKED = 0x1000000;
    private NodeProto protoType;
    private NodeUsage nodeUsage;
    private int nodeIndex = -1;
    private int textbits = 0;
    private List portInsts = new ArrayList();
    private List connections = new ArrayList();
    private List exports = new ArrayList();
    private TextDescriptor protoDescriptor = TextDescriptor.getInstanceTextDescriptor(this);
    private Point2D center = new Point2D.Double();
    private double sX;
    private double sY;
    private int angle;
    private static AffineTransform rotateTranspose = new AffineTransform();
    private static AffineTransform mirrorXcoord = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private static AffineTransform mirrorYcoord = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);

    private NodeInst() {
    }

    public static NodeInst makeInstance(NodeProto protoType, Point2D center, double width, double height, int angle, Cell parent, String name) {
        NodeInst ni = NodeInst.newInstance(protoType, center, width, height, angle, parent, name);
        if (ni != null) {
            if (protoType instanceof Cell) {
                if (protoType.isWantExpanded()) {
                    ni.setExpanded();
                }
            } else {
                protoType.getTechnology().setDefaultOutline(ni);
            }
            CircuitChanges.inheritAttributes(ni, false);
        }
        return ni;
    }

    public static NodeInst makeDummyInstance(NodeProto np) {
        NodeInst ni = NodeInst.lowLevelAllocate();
        ni.lowLevelPopulate(np, new Point2D.Double(0.0, 0.0), np.getDefWidth(), np.getDefHeight(), 0, null);
        return ni;
    }

    public static NodeInst newInstance(NodeProto protoType, Point2D center, double width, double height, int angle, Cell parent, String name) {
        if (parent == null) {
            return null;
        }
        if (protoType instanceof Cell && Cell.isInstantiationRecursive((Cell)protoType, parent)) {
            System.out.println("Cannot create instance of " + protoType.describe() + " in cell " + parent.describe() + " because it is recursive");
            return null;
        }
        NodeInst ni = NodeInst.lowLevelAllocate();
        if (ni.lowLevelPopulate(protoType, center, width, height, angle, parent)) {
            return null;
        }
        if (name != null) {
            ni.setName(name);
        }
        if (ni.lowLevelLink()) {
            return null;
        }
        Undo.newObject(ni);
        return ni;
    }

    public void kill() {
        while (this.connections.size() > 0) {
            Connection con = (Connection)this.connections.get(this.connections.size() - 1);
            con.getArc().kill();
        }
        while (this.exports.size() > 0) {
            Export pp = (Export)this.exports.get(this.exports.size() - 1);
            pp.kill();
        }
        this.lowLevelUnlink();
        Undo.killObject(this);
    }

    public void modifyInstance(double dX, double dY, double dXSize, double dYSize, int dRot) {
        if ((dRot %= 3600) < 0) {
            dRot += 3600;
        }
        if (Undo.recordChange()) {
            Constraints.getCurrent().modifyNodeInst(this, dX, dY, dXSize, dYSize, dRot);
        } else {
            this.lowLevelModify(dX, dY, dXSize, dYSize, dRot);
            Iterator it = this.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                if (con.getPortInst().getNodeInst() != this) continue;
                Point2D oldLocation = con.getLocation();
                if (con.isHeadEnd()) {
                    con.getArc().modify(0.0, dX, dY, 0.0, 0.0);
                    continue;
                }
                con.getArc().modify(0.0, 0.0, 0.0, dX, dY);
            }
        }
        if (this.protoType instanceof PrimitiveNode && this.protoType == Generic.tech.cellCenterNode) {
            this.parent.adjustReferencePoint(this);
        }
    }

    public static void modifyInstances(NodeInst[] nis, double[] dXs, double[] dYs, double[] dXSizes, double[] dYSizes, int[] dRots) {
        int i;
        if (Undo.recordChange()) {
            Constraints.getCurrent().modifyNodeInsts(nis, dXs, dYs, dXSizes, dYSizes, dRots);
        } else {
            for (i = 0; i < nis.length; ++i) {
                nis[i].lowLevelModify(dXs[i], dYs[i], dXSizes[i], dYSizes[i], dRots[i]);
                Iterator it = nis[i].getConnections();
                while (it.hasNext()) {
                    Connection con = (Connection)it.next();
                    if (con.getPortInst().getNodeInst() != nis[i]) continue;
                    Point2D oldLocation = con.getLocation();
                    if (con.isHeadEnd()) {
                        con.getArc().modify(0.0, dXs[i], dYs[i], 0.0, 0.0);
                        continue;
                    }
                    con.getArc().modify(0.0, 0.0, 0.0, dXs[i], dYs[i]);
                }
            }
        }
        for (i = 0; i < nis.length; ++i) {
            if (!(nis[i].getProto() instanceof PrimitiveNode) || nis[i].getProto() != Generic.tech.cellCenterNode) continue;
            nis[i].getParent().adjustReferencePoint(nis[i]);
        }
    }

    public NodeInst replace(NodeProto np, boolean ignorePortNames, boolean allowMissingPorts) {
        PortInst opi;
        int index;
        NodeInst newNi;
        if (np instanceof Cell && Cell.isInstantiationRecursive((Cell)np, this.getParent())) {
            System.out.println("Cannot replace because it would be recursive");
            return null;
        }
        Point2D oldCenter = this.getAnchorCenter();
        double newXS = np.getDefWidth();
        double newYS = np.getDefHeight();
        if (np instanceof PrimitiveNode && this.getProto() instanceof PrimitiveNode) {
            SizeOffset oldSO = this.getProto().getProtoSizeOffset();
            SizeOffset newSO = np.getProtoSizeOffset();
            newXS = this.getXSize() - oldSO.getLowXOffset() - oldSO.getHighXOffset() + newSO.getLowXOffset() + newSO.getHighXOffset();
            newYS = this.getYSize() - oldSO.getLowYOffset() - oldSO.getHighYOffset() + newSO.getLowYOffset() + newSO.getHighYOffset();
        }
        if ((newNi = NodeInst.newInstance(np, oldCenter, newXS, newYS, this.getAngle(), this.getParent(), null)) == null) {
            return null;
        }
        if (np instanceof Cell) {
            if (this.getProto() instanceof Cell) {
                if (this.isExpanded()) {
                    newNi.setExpanded();
                } else {
                    newNi.clearExpanded();
                }
            } else if (np.isWantExpanded()) {
                newNi.setExpanded();
            } else {
                newNi.clearExpanded();
            }
        }
        PortAssociation[] oldAssoc = this.portAssociate(this, newNi, ignorePortNames);
        double arcDx = 0.0;
        double arcDy = 0.0;
        int arcCount = 0;
        Iterator it = this.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != con.getPortInst(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                if (allowMissingPorts) continue;
                System.out.println("No port on new node corresponds to old port: " + con.getPortInst().getPortProto().getName());
                newNi.kill();
                return null;
            }
            opi = oldAssoc[index].assn;
            ArcInst ai = con.getArc();
            if (!opi.getPortProto().connectsTo(ai.getProto())) {
                if (allowMissingPorts) continue;
                System.out.println(ai.describe() + " arc on old port " + con.getPortInst().getPortProto().getName() + " cannot connect to new port " + opi.getPortProto().getName());
                newNi.kill();
                return null;
            }
            Poly poly = opi.getPoly();
            if (!poly.isInside(con.getLocation())) {
                double xp = poly.getCenterX();
                double yp = poly.getCenterY();
                arcDx += xp - con.getLocation().getX();
                arcDy += yp - con.getLocation().getY();
            }
            ++arcCount;
        }
        it = this.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            for (index = 0; index < oldAssoc.length && oldAssoc[index].portInst != pp.getOriginalPort(); ++index) {
            }
            if (index >= oldAssoc.length || oldAssoc[index].assn == null) {
                System.out.println("No port on new node corresponds to old port: " + pp.getOriginalPort().getPortProto().getName());
                newNi.kill();
                return null;
            }
            opi = oldAssoc[index].assn;
            if (!pp.doesntConnect(opi.getPortProto().getBasePort())) continue;
            newNi.kill();
            return null;
        }
        ArrayList arcList = new ArrayList();
        Iterator it2 = this.getConnections();
        while (it2.hasNext()) {
            arcList.add(it2.next());
        }
        it2 = arcList.iterator();
        while (it2.hasNext()) {
            ArcInst newAi;
            int ang;
            int ii;
            int index2;
            Connection con = (Connection)it2.next();
            for (index2 = 0; index2 < oldAssoc.length && oldAssoc[index2].portInst != con.getPortInst(); ++index2) {
            }
            if (index2 >= oldAssoc.length || oldAssoc[index2].assn == null) {
                if (allowMissingPorts) continue;
                System.out.println("No port on new node corresponds to old port: " + con.getPortInst().getPortProto().getName());
                newNi.kill();
                return null;
            }
            PortInst opi2 = oldAssoc[index2].assn;
            PortInst[] newPortInst = new PortInst[2];
            Point2D.Double[] newPoint = new Point2D.Double[2];
            ArcInst ai = con.getArc();
            for (int i = 0; i < 2; ++i) {
                Connection oneCon = ai.getConnection(i);
                if (oneCon == con) {
                    newPortInst[i] = opi2;
                    if (newPortInst[i] == null) break;
                    newPoint[i] = new Point2D.Double(con.getLocation().getX(), con.getLocation().getY());
                    Poly poly = opi2.getPoly();
                    if (poly.isInside(newPoint[i])) continue;
                    ((Point2D)newPoint[i]).setLocation(poly.getCenterX(), poly.getCenterY());
                    continue;
                }
                newPortInst[i] = oneCon.getPortInst();
                newPoint[i] = oneCon.getLocation();
            }
            if (newPortInst[0] == null || newPortInst[1] == null) {
                if (!allowMissingPorts) {
                    System.out.println("Cannot re-connect " + ai.describe() + " arc");
                    continue;
                }
                ai.kill();
                continue;
            }
            boolean zigzag = false;
            if (ai.isFixedAngle() && (((Point2D)newPoint[0]).getX() != ((Point2D)newPoint[1]).getX() || ((Point2D)newPoint[0]).getY() != ((Point2D)newPoint[1]).getY()) && (ii = DBMath.figureAngle(newPoint[0], newPoint[1])) % 1800 != (ang = ai.getAngle()) % 1800) {
                zigzag = true;
            }
            if (zigzag) {
                double cX = ((Point2D)newPoint[0]).getX();
                double cY = ((Point2D)newPoint[1]).getY();
                PrimitiveNode pinNp = ((PrimitiveArc)ai.getProto()).findOverridablePinProto();
                double psx = ((NodeProto)pinNp).getDefWidth();
                double psy = ((NodeProto)pinNp).getDefHeight();
                NodeInst pinNi = NodeInst.newInstance(pinNp, new Point2D.Double(cX, cY), psx, psy, 0, this.getParent(), null);
                PortInst pinPi = pinNi.getOnlyPortInst();
                newAi = ArcInst.newInstance(ai.getProto(), ai.getWidth(), newPortInst[0], newPoint[0], pinPi, new Point2D.Double(cX, cY), null);
                if (newAi == null) {
                    return null;
                }
                newAi.lowLevelSetUserbits(ai.lowLevelGetUserbits());
                newAi.getHead().setNegated(ai.getHead().isNegated());
                ArcInst newAi2 = ArcInst.newInstance(ai.getProto(), ai.getWidth(), pinPi, new Point2D.Double(cX, cY), newPortInst[1], newPoint[1], null);
                if (newAi2 == null) {
                    return null;
                }
                newAi2.lowLevelSetUserbits(ai.lowLevelGetUserbits());
                newAi2.getTail().setNegated(ai.getTail().isNegated());
                if (newPortInst[1].getNodeInst() == this) {
                    ArcInst aiSwap = newAi;
                    newAi = newAi2;
                    newAi2 = aiSwap;
                }
            } else {
                newAi = ArcInst.newInstance(ai.getProto(), ai.getWidth(), newPortInst[0], newPoint[0], newPortInst[1], newPoint[1], null);
                if (newAi == null) {
                    newNi.kill();
                    return null;
                }
                newAi.lowLevelSetUserbits(ai.lowLevelGetUserbits());
                newAi.getHead().setNegated(ai.getHead().isNegated());
                newAi.getTail().setNegated(ai.getTail().isNegated());
            }
            newAi.copyVars(ai);
            ai.kill();
            newAi.setName(ai.getName());
        }
        ArrayList exportList = new ArrayList();
        Iterator it3 = this.getExports();
        while (it3.hasNext()) {
            exportList.add(it3.next());
        }
        it3 = exportList.iterator();
        while (it3.hasNext()) {
            int index3;
            Export pp = (Export)it3.next();
            for (index3 = 0; index3 < oldAssoc.length && oldAssoc[index3].portInst != pp.getOriginalPort(); ++index3) {
            }
            if (index3 >= oldAssoc.length || oldAssoc[index3].assn == null) continue;
            PortInst newPi = oldAssoc[index3].assn;
            pp.move(newPi);
        }
        newNi.copyVars(this);
        newNi.setNameTextDescriptor(this.getNameTextDescriptor());
        newNi.setProtoTextDescriptor(this.getProtoTextDescriptor());
        newNi.lowLevelSetUserbits(this.lowLevelGetUserbits());
        this.kill();
        newNi.setName(this.getName());
        return newNi;
    }

    public static NodeInst lowLevelAllocate() {
        NodeInst ni = new NodeInst();
        ni.parent = null;
        return ni;
    }

    public boolean lowLevelPopulate(NodeProto protoType, Point2D center, double width, double height, int angle, Cell parent) {
        if (this.getParent() != null && this.protoType != null) {
            System.out.println("NodeInst " + this + " of type " + this.protoType + " is populated again in " + this.getParent());
        }
        this.setParent(parent);
        this.protoType = protoType;
        Iterator it = protoType.getPorts();
        while (it.hasNext()) {
            PortProto pp = (PortProto)it.next();
            this.addPortInst(pp);
        }
        this.center.setLocation(center);
        this.sX = width;
        this.sY = height;
        this.angle = angle;
        this.redoGeometric();
        return false;
    }

    public boolean lowLevelLink() {
        if (!this.inDatabase()) {
            System.out.println("NodeInst can't be linked because it is not in database");
            return true;
        }
        if (!(this.isUsernamed() || this.getName() != null && this.parent.isUniqueName(this.name, this.getClass(), (ElectricObject)this) || !this.setNameKey(this.parent.getAutoname(this.getBasename())))) {
            return true;
        }
        if (this.checkAndRepair() > 0) {
            return true;
        }
        this.linkGeom(this.parent);
        this.nodeUsage = this.parent.addNode(this);
        return false;
    }

    public void lowLevelUnlink() {
        this.unLinkGeom(this.parent);
        this.parent.removeNode(this);
        this.nodeUsage = null;
    }

    public void lowLevelModify(double dX, double dY, double dXSize, double dYSize, int dRot) {
        this.unLinkGeom(this.parent);
        this.center.setLocation(DBMath.smooth(this.getAnchorCenterX() + dX), DBMath.smooth(this.getAnchorCenterY() + dY));
        this.sX = DBMath.smooth(this.sX + dXSize);
        this.sY = DBMath.smooth(this.sY + dYSize);
        this.angle = (this.angle + dRot) % 3600;
        this.redoGeometric();
        this.linkGeom(this.parent);
        this.parent.setDirty();
    }

    public boolean isIconOfParent() {
        NodeProto np = this.getProto();
        if (!(np instanceof Cell)) {
            return false;
        }
        return this.getParent().getCellGroup() == ((Cell)np).getCellGroup();
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public final int getNodeIndex() {
        return this.nodeIndex;
    }

    public boolean isLinked() {
        return this.nodeIndex >= 0;
    }

    public int getAngle() {
        return this.angle;
    }

    public Point2D getAnchorCenter() {
        return this.center;
    }

    public double getAnchorCenterX() {
        return this.center.getX();
    }

    public double getAnchorCenterY() {
        return this.center.getY();
    }

    public double getXSize() {
        return Math.abs(this.sX);
    }

    public double getYSize() {
        return Math.abs(this.sY);
    }

    public double getXSizeWithMirror() {
        return this.sX;
    }

    public double getYSizeWithMirror() {
        return this.sY;
    }

    public boolean isMirroredAboutXAxis() {
        return this.sY < 0.0;
    }

    public boolean isMirroredAboutYAxis() {
        return this.sX < 0.0;
    }

    public boolean isXMirrored() {
        return this.sX < 0.0;
    }

    public boolean isYMirrored() {
        return this.sY < 0.0;
    }

    public double[] getArcDegrees() {
        double[] returnValues = new double[2];
        returnValues[1] = 0.0;
        returnValues[0] = 0.0;
        if (!(this.protoType instanceof PrimitiveNode)) {
            return returnValues;
        }
        if (this.protoType != Artwork.tech.circleNode && this.protoType != Artwork.tech.thickCircleNode) {
            return returnValues;
        }
        Variable var = this.getVar(Artwork.ART_DEGREES);
        if (var != null) {
            Object addr = var.getObject();
            if (addr instanceof Integer) {
                Integer iAddr = (Integer)addr;
                returnValues[0] = 0.0;
                returnValues[1] = (double)iAddr.intValue() * Math.PI / 1800.0;
            } else if (addr instanceof Float[]) {
                Float[] fAddr = (Float[])addr;
                returnValues[0] = fAddr[0].doubleValue();
                returnValues[1] = fAddr[1].doubleValue();
            }
        }
        return returnValues;
    }

    public void setArcDegrees(double start, double curvature) {
        Float[] fAddr = new Float[]{new Float(start), new Float(curvature)};
        this.newVar(Artwork.ART_DEGREES, (Object)fAddr);
    }

    public SizeOffset getSizeOffset() {
        Technology tech = this.protoType.getTechnology();
        return tech.getNodeInstSizeOffset(this);
    }

    private void redoGeometric() {
        Point2D[] outline;
        double[] angles;
        if (this.sX == 0.0 && this.sY == 0.0) {
            this.visBounds.setRect(this.getAnchorCenterX(), this.getAnchorCenterY(), 0.0, 0.0);
            return;
        }
        if (this.protoType instanceof Cell) {
            Cell subCell = (Cell)this.protoType;
            Rectangle2D bounds = subCell.getBounds();
            Point2D.Double shift = new Point2D.Double(-bounds.getCenterX(), -bounds.getCenterY());
            AffineTransform trans = NodeInst.pureRotate(this.angle, this.sX < 0.0, this.sY < 0.0);
            trans.transform(shift, shift);
            double cX = this.center.getX();
            double cY = this.center.getY();
            Poly poly = new Poly(cX -= ((Point2D)shift).getX(), cY -= ((Point2D)shift).getY(), Math.abs(this.sX), Math.abs(this.sY));
            trans = NodeInst.rotateAbout(this.angle, cX, cY, this.sX, this.sY);
            poly.transform(trans);
            this.visBounds.setRect(poly.getBounds2D());
            return;
        }
        if (!(this.protoType != Artwork.tech.circleNode && this.protoType != Artwork.tech.thickCircleNode || (angles = this.getArcDegrees())[0] == 0.0 && angles[1] == 0.0)) {
            Point2D[] pointList = Artwork.fillEllipse(this.getAnchorCenter(), Math.abs(this.sX), Math.abs(this.sY), angles[0], angles[1]);
            Poly poly = new Poly(pointList);
            poly.setStyle(Poly.Type.OPENED);
            poly.transform(this.rotateOut());
            this.visBounds.setRect(poly.getBounds2D());
            return;
        }
        if (this.protoType.isWipeOn1or2() && this.getNumExports() == 0 && this.pinUseCount()) {
            this.visBounds.setRect(this.getAnchorCenterX(), this.getAnchorCenterY(), 0.0, 0.0);
            return;
        }
        if (this.protoType.isHoldsOutline() && (outline = this.getTrace()) != null) {
            Point2D[] pointList = new Point2D.Double[outline.length];
            for (int i = 0; i < outline.length; ++i) {
                pointList[i] = new Point2D.Double(this.getAnchorCenterX() + outline[i].getX(), this.getAnchorCenterY() + outline[i].getY());
            }
            Poly poly = new Poly(pointList);
            poly.setStyle(Poly.Type.OPENED);
            poly.transform(this.rotateOut());
            this.visBounds.setRect(poly.getBounds2D());
            return;
        }
        Poly poly = new Poly(this.center.getX(), this.center.getY(), this.sX, this.sY);
        AffineTransform trans = this.rotateOut();
        poly.transform(trans);
        this.visBounds.setRect(poly.getBounds2D());
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow wnd) {
        int totalText;
        int cellInstanceNameText = 0;
        if (this.protoType instanceof Cell && !this.isExpanded() && hardToSelect) {
            cellInstanceNameText = 1;
        }
        if (!User.isTextVisibilityOnInstance()) {
            cellInstanceNameText = 0;
        }
        int dispVars = this.numDisplayableVariables(false);
        int numExports = 0;
        int numExportVariables = 0;
        if (User.isTextVisibilityOnExport()) {
            numExports = this.getNumExports();
            Iterator it = this.getExports();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                numExportVariables += pp.numDisplayableVariables(false);
            }
        }
        if (this.protoType == Generic.tech.invisiblePinNode && !User.isTextVisibilityOnAnnotation()) {
            numExportVariables = 0;
            numExports = 0;
            dispVars = 0;
        }
        if (!User.isTextVisibilityOnNode()) {
            numExportVariables = 0;
            numExports = 0;
            dispVars = 0;
            cellInstanceNameText = 0;
        }
        if ((totalText = cellInstanceNameText + dispVars + numExports + numExportVariables) == 0) {
            return null;
        }
        Poly[] polys = new Poly[totalText];
        int start = 0;
        if (cellInstanceNameText != 0) {
            double cX = this.getTrueCenterX();
            double cY = this.getTrueCenterY();
            TextDescriptor td = this.getProtoTextDescriptor();
            double offX = td.getXOff();
            double offY = td.getYOff();
            TextDescriptor.Position pos = td.getPos();
            Poly.Type style = pos.getPolyType();
            Point2D[] pointList = new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
            polys[start] = new Poly(pointList);
            polys[start].setStyle(style);
            polys[start].setString(this.getProto().describe());
            polys[start].setTextDescriptor(td);
            ++start;
        }
        if (numExports > 0) {
            AffineTransform unTrans = this.rotateIn();
            Iterator it = this.getExports();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                polys[start] = pp.getNamePoly();
                polys[start].transform(unTrans);
                Poly poly = pp.getOriginalPort().getPoly();
                int numadded = pp.addDisplayableVariables(poly.getBounds2D(), polys, ++start, wnd, false);
                for (int i = 0; i < numadded; ++i) {
                    polys[start + i].setPort(pp);
                }
                start += numadded;
            }
        }
        if (dispVars > 0) {
            this.addDisplayableVariables(this.getBounds(), polys, start, wnd, false);
        }
        return polys;
    }

    public int numDisplayableVariables(boolean multipleStrings) {
        int numVarsOnNode = super.numDisplayableVariables(multipleStrings);
        Iterator it = this.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            numVarsOnNode += pi.numDisplayableVariables(multipleStrings);
        }
        return numVarsOnNode;
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow wnd, boolean multipleStrings) {
        int numAddedVariables = super.addDisplayableVariables(rect, polys, start, wnd, multipleStrings);
        Iterator it = this.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            int justAdded = pi.addDisplayableVariables(rect, polys, start + numAddedVariables, wnd, multipleStrings);
            for (int i = 0; i < justAdded; ++i) {
                polys[start + numAddedVariables + i].setPort(pi.getPortProto());
            }
            numAddedVariables += justAdded;
        }
        return numAddedVariables;
    }

    public AffineTransform transformOut() {
        AffineTransform xform = this.rotateOut();
        xform.concatenate(this.translateOut());
        return xform;
    }

    public AffineTransform translateIn() {
        Cell lowerCell = (Cell)this.protoType;
        double dx = this.getAnchorCenterX();
        double dy = this.getAnchorCenterY();
        AffineTransform transform = new AffineTransform();
        transform.translate(-dx, -dy);
        return transform;
    }

    public AffineTransform translateOut() {
        Cell lowerCell = (Cell)this.protoType;
        double dx = this.getAnchorCenterX();
        double dy = this.getAnchorCenterY();
        AffineTransform transform = new AffineTransform();
        transform.translate(dx, dy);
        return transform;
    }

    public AffineTransform translateOut(AffineTransform prevTransform) {
        AffineTransform transform = this.translateOut();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public static AffineTransform rotateAbout(int angle, double cX, double cY, double sX, double sY) {
        AffineTransform transform = new AffineTransform();
        if (sX < 0.0 || sY < 0.0) {
            rotateTranspose.setToRotation((double)angle * Math.PI / 1800.0);
            transform.setToTranslation(cX, cY);
            if (sX < 0.0) {
                transform.concatenate(mirrorXcoord);
            }
            if (sY < 0.0) {
                transform.concatenate(mirrorYcoord);
            }
            transform.concatenate(rotateTranspose);
            transform.translate(-cX, -cY);
        } else {
            transform.setToRotation((double)angle * Math.PI / 1800.0, cX, cY);
        }
        return transform;
    }

    public static AffineTransform pureRotate(int angle, boolean mirrorX, boolean mirrorY) {
        AffineTransform transform = new AffineTransform();
        transform.setToRotation((double)angle * Math.PI / 1800.0);
        if (mirrorX) {
            transform.preConcatenate(mirrorXcoord);
        }
        if (mirrorY) {
            transform.preConcatenate(mirrorYcoord);
        }
        return transform;
    }

    public AffineTransform pureRotateIn() {
        int numFlips = 0;
        if (this.sX < 0.0) {
            ++numFlips;
        }
        if (this.sY < 0.0) {
            ++numFlips;
        }
        int rotAngle = this.angle;
        if (numFlips != 1) {
            rotAngle = -rotAngle;
        }
        return NodeInst.pureRotate(rotAngle, this.sX < 0.0, this.sY < 0.0);
    }

    public AffineTransform rotateIn() {
        int numFlips = 0;
        if (this.sX < 0.0) {
            ++numFlips;
        }
        if (this.sY < 0.0) {
            ++numFlips;
        }
        int rotAngle = this.angle;
        if (numFlips != 1) {
            rotAngle = -rotAngle;
        }
        return NodeInst.rotateAbout(rotAngle, this.getAnchorCenterX(), this.getAnchorCenterY(), this.sX, this.sY);
    }

    public AffineTransform rotateOut() {
        return NodeInst.rotateAbout(this.angle, this.getAnchorCenterX(), this.getAnchorCenterY(), this.sX, this.sY);
    }

    public AffineTransform rotateOutAboutTrueCenter() {
        return NodeInst.rotateAbout(this.angle, this.getTrueCenterX(), this.getTrueCenterY(), this.sX, this.sY);
    }

    public AffineTransform rotateOut(AffineTransform prevTransform) {
        if (this.angle == 0 && this.sX >= 0.0 && this.sY >= 0.0) {
            return prevTransform;
        }
        AffineTransform transform = this.rotateOut();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public AffineTransform rotateOutAboutTrueCenter(AffineTransform prevTransform) {
        if (this.angle == 0 && this.sX >= 0.0 && this.sY >= 0.0) {
            return prevTransform;
        }
        AffineTransform transform = this.rotateOutAboutTrueCenter();
        AffineTransform returnTransform = new AffineTransform(prevTransform);
        returnTransform.concatenate(transform);
        return returnTransform;
    }

    public Poly getShapeOfPort(PortProto thePort) {
        return this.getShapeOfPort(thePort, null, false);
    }

    public Poly getShapeOfPort(PortProto thePort, Point2D selectPt, boolean compressPort) {
        NodeInst ni = this;
        PortProto pp = thePort;
        AffineTransform trans = ni.rotateOut();
        while (ni.getProto() instanceof Cell) {
            trans = ni.translateOut(trans);
            ni = ((Export)pp).getOriginalPort().getNodeInst();
            pp = ((Export)pp).getOriginalPort().getPortProto();
            trans = ni.rotateOut(trans);
        }
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        Technology tech = np.getTechnology();
        Poly poly = tech.getShapeOfPort(ni, (PrimitivePort)pp, selectPt);
        Rectangle2D box = poly.getBox();
        if (compressPort && box != null) {
            if (ni.getXSize() == np.getDefWidth()) {
                double x = poly.getCenterX();
                box = new Rectangle2D.Double(x, box.getMinY(), 0.0, box.getHeight());
            }
            if (ni.getYSize() == np.getDefHeight()) {
                double y = poly.getCenterY();
                box = new Rectangle2D.Double(box.getMinX(), y, box.getWidth(), 0.0);
            }
            poly = new Poly(box);
        }
        poly.transform(trans);
        return poly;
    }

    public Point2D[] getTrace() {
        Variable var = this.getVar(TRACE, Point2D;.class);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof Object[]) {
            return (Point2D[])obj;
        }
        return null;
    }

    public boolean traceWraps() {
        if (this.protoType == Artwork.tech.splineNode || this.protoType == Artwork.tech.openedPolygonNode || this.protoType == Artwork.tech.openedDottedPolygonNode || this.protoType == Artwork.tech.openedDashedPolygonNode || this.protoType == Artwork.tech.openedThickerPolygonNode) {
            return false;
        }
        return !this.isFET();
    }

    public Iterator getPortInsts() {
        return this.portInsts.iterator();
    }

    public int getNumPortInsts() {
        return this.portInsts.size();
    }

    public PortInst getPortInst(int portIndex) {
        return (PortInst)this.portInsts.get(portIndex);
    }

    public PortInst getOnlyPortInst() {
        int sz = this.portInsts.size();
        if (sz != 1) {
            System.out.println("NodeInst.getOnlyPortInst: Cell " + this.parent.describe() + ", node " + this.describe() + " doesn't have just one port, it has " + sz);
            return null;
        }
        return (PortInst)this.portInsts.get(0);
    }

    public PortInst findPortInst(String name) {
        PortProto pp = this.protoType.findPortProto(name);
        if (pp == null) {
            return null;
        }
        return (PortInst)this.portInsts.get(pp.getPortIndex());
    }

    public PortInst findClosestPortInst(Point2D w) {
        double bestDist = Double.MAX_VALUE;
        PortInst bestPi = null;
        for (int i = 0; i < this.portInsts.size(); ++i) {
            PortInst pi = (PortInst)this.portInsts.get(i);
            Poly piPoly = pi.getPoly();
            Point2D.Double piPt = new Point2D.Double(piPoly.getCenterX(), piPoly.getCenterY());
            double thisDist = piPt.distance(w);
            if (!(thisDist < bestDist)) continue;
            bestDist = thisDist;
            bestPi = pi;
        }
        return bestPi;
    }

    public PortInst findPortInstFromProto(PortProto pp) {
        return (PortInst)this.portInsts.get(pp.getPortIndex());
    }

    public void addPortInst(PortProto pp) {
        PortInst pi = PortInst.newInstance(pp, this);
        this.portInsts.add(pp.getPortIndex(), pi);
    }

    public void linkPortInst(PortInst pi) {
        this.portInsts.add(pi.getPortIndex(), pi);
    }

    public PortInst removePortInst(PortProto pp) {
        int i;
        PortInst pi = (PortInst)this.portInsts.get(pp.getPortIndex());
        for (i = this.connections.size() - 1; i >= 0; --i) {
            Connection con = (Connection)this.connections.get(i);
            if (con.getPortInst() != pi) continue;
            con.getArc().kill();
        }
        for (i = this.exports.size() - 1; i >= 0; --i) {
            Export export = (Export)this.exports.get(i);
            if (export.getOriginalPort() != pi) continue;
            export.kill();
        }
        this.portInsts.remove(pp.getPortIndex());
        return pi;
    }

    public Cell getProtoEquivalent() {
        if (!(this.protoType instanceof Cell)) {
            return null;
        }
        return ((Cell)this.protoType).getEquivalent();
    }

    public void addExport(Export e) {
        this.exports.add(e);
        this.redoGeometric();
    }

    public void removeExport(Export e) {
        if (!this.exports.contains(e)) {
            throw new RuntimeException("Tried to remove a non-existant export");
        }
        this.exports.remove(e);
        this.redoGeometric();
    }

    public Iterator getExports() {
        return this.exports.iterator();
    }

    public int getNumExports() {
        return this.exports.size();
    }

    private PortAssociation[] portAssociate(NodeInst ni1, NodeInst ni2, boolean ignorePortNames) {
        int total1 = ni1.getProto().getNumPorts();
        PortAssociation[] portInfo1 = new PortAssociation[total1];
        int k = 0;
        Iterator it1 = ni1.getPortInsts();
        while (it1.hasNext()) {
            PortInst pi1 = (PortInst)it1.next();
            portInfo1[k] = new PortAssociation();
            portInfo1[k].portInst = pi1;
            portInfo1[k].poly = pi1.getPoly();
            portInfo1[k].pos = new Point2D.Double(portInfo1[k].poly.getCenterX(), portInfo1[k].poly.getCenterY());
            portInfo1[k].assn = null;
            ++k;
        }
        int total2 = ni2.getProto().getNumPorts();
        PortAssociation[] portInfo2 = new PortAssociation[total2];
        k = 0;
        Iterator it2 = ni2.getPortInsts();
        while (it2.hasNext()) {
            PortInst pi2 = (PortInst)it2.next();
            portInfo2[k] = new PortAssociation();
            portInfo2[k].portInst = pi2;
            portInfo2[k].poly = pi2.getPoly();
            portInfo2[k].pos = new Point2D.Double(portInfo2[k].poly.getCenterX(), portInfo2[k].poly.getCenterY());
            portInfo2[k].assn = null;
            ++k;
        }
        if (!ignorePortNames) {
            for (int i1 = 0; i1 < total1; ++i1) {
                PortInst pi1 = portInfo1[i1].portInst;
                for (int i2 = 0; i2 < total2; ++i2) {
                    PortInst pi2 = portInfo2[i2].portInst;
                    if (portInfo2[i2].assn != null || !pi2.getPortProto().getName().equalsIgnoreCase(pi1.getPortProto().getName())) continue;
                    portInfo1[i1].assn = pi2;
                    portInfo2[i2].assn = pi1;
                }
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int i1 = 0; i1 < total1; ++i1) {
                PortInst pi1 = portInfo1[i1].portInst;
                if (portInfo1[i1].assn != null) continue;
                for (int i2 = 0; i2 < total2; ++i2) {
                    PortInst pi2 = portInfo2[i2].portInst;
                    if (portInfo2[i2].assn != null || portInfo2[i2].pos.getX() != portInfo1[i1].pos.getX() || portInfo2[i2].pos.getY() != portInfo1[i1].pos.getY() || pass == 0 && !portInfo1[i1].poly.polySame(portInfo2[i2].poly)) continue;
                    portInfo1[i1].assn = pi2;
                    portInfo2[i2].assn = pi1;
                }
            }
        }
        return portInfo1;
    }

    private boolean containsConnection(Connection c) {
        return this.connections.contains(c);
    }

    public void computeWipeState() {
        this.clearWiped();
        if (this.getProto().isArcsWipe()) {
            Iterator it = this.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                ArcInst ai = con.getArc();
                if (!ai.getProto().isWipable()) continue;
                this.setWiped();
                break;
            }
        }
    }

    public boolean pinUseCount() {
        if (this.connections.size() > 2) {
            return false;
        }
        if (this.exports.size() != 0) {
            return true;
        }
        return this.connections.size() != 0;
    }

    public boolean isInlinePin() {
        if (this.protoType.getFunction() != NodeProto.Function.PIN) {
            return false;
        }
        int j = 0;
        ArcInst[] reconAr = new ArcInst[2];
        Point2D.Double[] delta = new Point2D.Double[2];
        Iterator it = this.getConnections();
        while (it.hasNext()) {
            ArcInst ai;
            Connection con = (Connection)it.next();
            if (j >= 2) {
                j = 0;
                break;
            }
            reconAr[j] = ai = con.getArc();
            Connection thisCon = ai.getHead();
            Connection thatCon = ai.getTail();
            if (thatCon == con) {
                thisCon = ai.getTail();
                thatCon = ai.getHead();
            }
            delta[j] = new Point2D.Double(thatCon.getLocation().getX() - thisCon.getLocation().getX(), thatCon.getLocation().getY() - thisCon.getLocation().getY());
            ++j;
        }
        if (j != 2) {
            return false;
        }
        if (reconAr[0].getProto() != reconAr[1].getProto()) {
            return false;
        }
        if (reconAr[0].getWidth() != reconAr[1].getWidth()) {
            return false;
        }
        if (((Point2D)delta[0]).getX() != 0.0 || ((Point2D)delta[0]).getY() != 0.0 || ((Point2D)delta[1]).getX() != 0.0 || ((Point2D)delta[1]).getY() != 0.0) {
            Point2D.Double zero = new Point2D.Double(0.0, 0.0);
            if (!(((Point2D)delta[0]).getX() == 0.0 && ((Point2D)delta[0]).getY() == 0.0 || ((Point2D)delta[1]).getX() == 0.0 && ((Point2D)delta[1]).getY() == 0.0 || DBMath.figureAngle(zero, delta[0]) == DBMath.figureAngle(delta[1], zero))) {
                return false;
            }
        }
        if (reconAr[0].getVar(ArcInst.ARC_RADIUS) != null) {
            return false;
        }
        if (reconAr[1].getVar(ArcInst.ARC_RADIUS) != null) {
            return false;
        }
        Name name0 = reconAr[0].getNameKey();
        Name name1 = reconAr[1].getNameKey();
        return name0 == null || name1 == null || name0.isTempname() || name1.isTempname();
    }

    public PortProto connectsTo(ArcProto arc) {
        return this.protoType.connectsTo(arc);
    }

    public void addConnection(Connection c) {
        this.connections.add(c);
        NodeInst ni = c.getPortInst().getNodeInst();
        ni.computeWipeState();
        this.redoGeometric();
    }

    public void removeConnection(Connection c) {
        this.connections.remove(c);
        NodeInst ni = c.getPortInst().getNodeInst();
        ni.computeWipeState();
        this.redoGeometric();
    }

    public Iterator getConnections() {
        return this.connections.iterator();
    }

    public int getNumConnections() {
        return this.connections.size();
    }

    public TextDescriptor getProtoTextDescriptor() {
        return this.protoDescriptor;
    }

    public void setProtoTextDescriptor(TextDescriptor descriptor) {
        this.protoDescriptor.copy(descriptor);
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        return key == NODE_NAME;
    }

    public boolean isInvisiblePinWithText() {
        if (this.getProto() != Generic.tech.invisiblePinNode) {
            return false;
        }
        if (this.getNumExports() != 0) {
            return true;
        }
        return this.numDisplayableVariables(false) != 0;
    }

    public Point2D invisiblePinWithOffsetText(boolean repair) {
        TextDescriptor td;
        Poly.Type style;
        Technology tech;
        Poly[] polyList;
        if (this.protoType.getFunction() != NodeProto.Function.PIN) {
            return null;
        }
        if (this.getNumConnections() != 0) {
            return null;
        }
        if (this.protoType != Generic.tech.invisiblePinNode && (polyList = (tech = this.protoType.getTechnology()).getShapeOfNode(this)).length > 0 && !(style = polyList[0].getStyle()).isText()) {
            return null;
        }
        Iterator it = this.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            td = pp.getTextDescriptor();
            if (td.getXOff() == 0.0 && td.getYOff() == 0.0) continue;
            Point2D.Double retVal = new Point2D.Double(this.getAnchorCenterX() + td.getXOff(), this.getAnchorCenterY() + td.getYOff());
            if (repair) {
                td.setOff(0.0, 0.0);
            }
            return retVal;
        }
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            td = var.getTextDescriptor();
            if (!var.isDisplay() || td.getXOff() == 0.0 && td.getYOff() == 0.0) continue;
            Point2D.Double retVal = new Point2D.Double(this.getAnchorCenterX() + td.getXOff(), this.getAnchorCenterY() + td.getYOff());
            if (repair) {
                td.setOff(0.0, 0.0);
            }
            return retVal;
        }
        return null;
    }

    public String describe() {
        String description = this.protoType.describe();
        String name = this.getName();
        if (name != null) {
            description = description + "[" + name + "]";
        }
        return description;
    }

    public String toString() {
        return "NodeInst " + this.protoType.getName();
    }

    public NodeProto getProto() {
        return this.protoType;
    }

    public int getNumActualProtos() {
        return 1;
    }

    public NodeProto getActualProto(int i) {
        return i == 0 ? this.protoType : null;
    }

    public boolean contains(NodeInst ni, int arrayIndex) {
        return ni == this && arrayIndex == 0;
    }

    public NodeProto.Function getFunction() {
        if (this.protoType instanceof Cell) {
            return NodeProto.Function.UNKNOWN;
        }
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getPrimitiveFunction(this);
    }

    public boolean isPrimitiveTransistor() {
        NodeProto.Function func = this.protoType.getFunction();
        return func == NodeProto.Function.TRANS || func == NodeProto.Function.TRANS4 || func == NodeProto.Function.TRANMOS || func == NodeProto.Function.TRAPMOS;
    }

    public boolean isFET() {
        NodeProto.Function fun = this.getFunction();
        return fun == NodeProto.Function.TRANMOS || fun == NodeProto.Function.TRA4NMOS || fun == NodeProto.Function.TRAPMOS || fun == NodeProto.Function.TRA4PMOS || fun == NodeProto.Function.TRADMOS || fun == NodeProto.Function.TRA4DMOS || fun == NodeProto.Function.TRADMES || fun == NodeProto.Function.TRA4DMES || fun == NodeProto.Function.TRAEMES || fun == NodeProto.Function.TRA4EMES;
    }

    public Dimension2D getTransistorSize(VarContext context) {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorSize(this, context);
    }

    public PortInst getTransistorGatePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorGatePort(this);
    }

    public PortInst getTransistorSourcePort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorSourcePort(this);
    }

    public PortInst getTransistorBiasPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorBiasPort(this);
    }

    public PortInst getTransistorDrainPort() {
        PrimitiveNode np = (PrimitiveNode)this.protoType;
        return np.getTechnology().getTransistorDrainPort(this);
    }

    public int checkAndRepair() {
        int errorCount = 0;
        if (this.protoType instanceof Cell) {
            Rectangle2D bounds = ((Cell)this.protoType).getBounds();
            if (bounds.getWidth() != this.getXSize() || bounds.getHeight() != this.getYSize()) {
                System.out.println("Cell " + this.parent.describe() + ", node " + this.describe() + " is " + this.getXSize() + "x" + this.getYSize() + ", but prototype is " + bounds.getWidth() + " x " + bounds.getHeight() + " ****REPAIRED****");
                this.sX = bounds.getWidth() * (double)(this.isMirroredAboutYAxis() ? -1 : 1);
                this.sY = bounds.getHeight() * (double)(this.isMirroredAboutXAxis() ? -1 : 1);
                ++errorCount;
            }
        } else {
            Point2D[] points = this.getTrace();
            if (points != null) {
                double lY;
                double lX;
                double hX = lX = points[0].getX();
                double hY = lY = points[0].getY();
                for (int i = 1; i < points.length; ++i) {
                    if (points[i].getX() < lX) {
                        lX = points[i].getX();
                    }
                    if (points[i].getX() > hX) {
                        hX = points[i].getX();
                    }
                    if (points[i].getY() < lY) {
                        lY = points[i].getY();
                    }
                    if (!(points[i].getY() > hY)) continue;
                    hY = points[i].getY();
                }
                if (hX - lX != this.getXSize() || hY - lY != this.getYSize()) {
                    System.out.println("Cell " + this.parent.describe() + ", node " + this.describe() + " is " + this.getXSize() + "x" + this.getYSize() + " but has outline of size " + (hX - lX) + "x" + (hY - lY) + " (REPAIRED)");
                    this.sX = (hX - lX) * this.getXSize() / this.getXSizeWithMirror();
                    this.sY = (hY - lY) * this.getYSize() / this.getYSizeWithMirror();
                }
            }
        }
        if (this.portInsts.size() != this.protoType.getNumPorts()) {
            System.out.println("Cell " + this.parent.describe() + ", node " + this.describe() + " has number of PortInsts " + this.portInsts.size() + " , but prototype " + this.protoType + " has " + this.protoType.getNumPorts() + " ports");
            return 1;
        }
        int i = 0;
        Iterator it = this.protoType.getPorts();
        while (it.hasNext()) {
            PortProto pp = (PortProto)it.next();
            PortInst pi = (PortInst)this.portInsts.get(i);
            if (pp.getPortIndex() != i || pi.getPortProto() != pp) {
                System.out.println("Cell " + this.parent.describe() + ", node " + this.describe() + " has mismatches between PortInsts and PortProtos (" + pp.getName() + ")");
                ++errorCount;
            }
            ++i;
        }
        return errorCount;
    }

    public Name getBasename() {
        return this.protoType instanceof Cell ? ((Cell)this.protoType).getBasename() : this.getFunction().getBasename();
    }

    public NodeUsage getNodeUsage() {
        return this.nodeUsage;
    }

    public void setExpanded() {
        this.userBits |= 4;
    }

    public void clearExpanded() {
        this.userBits &= 0xFFFFFFFB;
    }

    public boolean isExpanded() {
        return (this.userBits & 4) != 0;
    }

    public void setWiped() {
        this.userBits |= 8;
    }

    public void clearWiped() {
        this.userBits &= 0xFFFFFFF7;
    }

    public boolean isWiped() {
        return (this.userBits & 8) != 0;
    }

    public void setShortened() {
        this.userBits |= 0x10;
    }

    public void clearShortened() {
        this.userBits &= 0xFFFFFFEF;
    }

    public boolean isShortened() {
        return (this.userBits & 0x10) != 0;
    }

    public void setHardSelect() {
        this.userBits |= 0x8000;
    }

    public void clearHardSelect() {
        this.userBits &= 0xFFFF7FFF;
    }

    public boolean isHardSelect() {
        return (this.userBits & 0x8000) != 0;
    }

    public void setVisInside() {
        this.userBits |= 0x800000;
    }

    public void clearVisInside() {
        this.userBits &= 0xFF7FFFFF;
    }

    public boolean isVisInside() {
        return (this.userBits & 0x800000) != 0;
    }

    public void setLocked() {
        this.userBits |= 0x1000000;
    }

    public void clearLocked() {
        this.userBits &= 0xFEFFFFFF;
    }

    public boolean isLocked() {
        return (this.userBits & 0x1000000) != 0;
    }

    public void setTechSpecific(int value) {
        this.userBits = this.userBits & 0xFF81FFFF | value << 17;
    }

    public int getTechSpecific() {
        return (this.userBits & 0x7E0000) >> 17;
    }

    public Rectangle2D findEssentialBounds() {
        NodeProto np = this.getProto();
        if (!(np instanceof Cell)) {
            return null;
        }
        Rectangle2D eb = ((Cell)np).findEssentialBounds();
        if (eb == null) {
            return null;
        }
        AffineTransform xForm = this.translateOut();
        Point2D ll = new Point2D.Double(eb.getMinX(), eb.getMinY());
        ll = xForm.transform(ll, null);
        Point2D ur = new Point2D.Double(eb.getMaxX(), eb.getMaxY());
        ur = xForm.transform(ur, null);
        double minX = Math.min(ll.getX(), ur.getX());
        double minY = Math.min(ll.getY(), ur.getY());
        double maxX = Math.max(ll.getX(), ur.getX());
        double maxY = Math.max(ll.getY(), ur.getY());
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly[] noPolyList;
        NodeProto.Function noFunc;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeInst no = (NodeInst)obj;
        if (this.getFunction() != no.getFunction()) {
            if (buffer != null) {
                buffer.append("Functions are not the same for " + this.getName() + " and " + no.getName() + "\n");
            }
            return false;
        }
        NodeProto noProtoType = no.getProto();
        NodeProto protoType = this.getProto();
        if (protoType.getClass() != noProtoType.getClass()) {
            if (buffer != null) {
                buffer.append("Not the same node prototypes for " + this.getName() + " and " + no.getName() + "\n");
            }
            return false;
        }
        if (!this.rotateOut().equals(no.rotateOut())) {
            if (buffer != null) {
                buffer.append("Not the same rotation for " + this.getName() + " and " + no.getName() + "\n");
            }
            return false;
        }
        if (protoType instanceof Cell) {
            return noProtoType instanceof Cell;
        }
        PrimitiveNode np = (PrimitiveNode)protoType;
        PrimitiveNode noNp = (PrimitiveNode)noProtoType;
        NodeProto.Function function = np.getTechnology().getPrimitiveFunction(this);
        if (function != (noFunc = noNp.getTechnology().getPrimitiveFunction(no))) {
            if (buffer != null) {
                buffer.append("Not the same node prototypes for " + this.getName() + " and " + no.getName() + ":" + function.getName() + " v/s " + noFunc.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = np.getTechnology().getShapeOfNode(this);
        if (polyList.length != (noPolyList = noNp.getTechnology().getShapeOfNode(no)).length) {
            if (buffer != null) {
                buffer.append("Not same number of geometries in " + this.getName() + " and " + no.getName() + "\n");
            }
            return false;
        }
        ArrayList<Poly> noCheckAgain = new ArrayList<Poly>();
        for (int i = 0; i < polyList.length; ++i) {
            boolean found = false;
            for (int j = 0; j < noPolyList.length; ++j) {
                if (noCheckAgain.contains(noPolyList[j]) || !polyList[i].compare(noPolyList[j], buffer)) continue;
                found = true;
                noCheckAgain.add(noPolyList[j]);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding geometry in " + this.getName() + " found in " + no.getName() + "\n");
            }
            return false;
        }
        return true;
    }

    private static class PortAssociation {
        PortInst portInst;
        Poly poly;
        Point2D pos;
        PortInst assn;

        private PortAssociation() {
        }
    }
}

