/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.ncc.NccEngine;
import com.sun.electric.tool.ncc.NccOptions;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StdCellParams {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private double nmosWellHeight = 70.0;
    private double pmosWellHeight = 70.0;
    private double gndY = -21.0;
    private double vddY = 21.0;
    private double gndWidth = 10.0;
    private double vddWidth = 10.0;
    private double trackPitch = 7.0;
    private double trackWidth = 4.0;
    private double metalSpace = 3.0;
    private double enableGateStrengthRatio = 0.1;
    private boolean separateWellTies = false;
    private double maxWellTieRadius = 300.0;
    private String pmosWellTieName = "vnw";
    private String nmosWellTieName = "vsb";
    private double nmosWellTieY;
    private double pmosWellTieY;
    private double minGateWid = 3.0;
    private double diffContWid = 5.0;
    private double maxMosWidth = 45.0;
    private double sizeErr = 0.1;
    private static final double selectOverhangsDiffCont = 4.5;
    private static final double selectSpace = 2.0;
    private static final double m1OverhangsDiffCont = 2.0;
    private static final double m1Space = 3.0;
    private static final double selectOverhangsDiff = 2.0;
    private ArrayList nmosTracks = new ArrayList();
    private ArrayList pmosTracks = new ArrayList();
    private int botNmosTrack;
    private int topNmosTrack;
    private int botPmosTrack;
    private int topPmosTrack;
    private Library schemLib = null;
    private Library layoutLib = null;
    private boolean doubleStrapGate = false;
    private boolean exhaustivePlace = true;
    private int nbPlacerPerms = 40000;
    private boolean simpleName = false;
    private String vddExportName = "vdd";
    private String gndExportName = "gnd";
    private PortProto.Characteristic vddExportRole = PortProto.Characteristic.PWR;
    private PortProto.Characteristic gndExportRole = PortProto.Characteristic.GND;
    public static final SelectSrcDrn EVEN = new SelectSrcDrn(){

        public boolean connectThisOne(int mosNdx, int srcDrnNdx) {
            return srcDrnNdx % 2 == 0;
        }
    };
    public static final SelectSrcDrn ODD = new SelectSrcDrn(){

        public boolean connectThisOne(int mosNdx, int srcDrnNdx) {
            return srcDrnNdx % 2 == 1;
        }
    };

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private void init(Library lib) {
        this.layoutLib = lib;
        this.init();
    }

    private void init() {
        TrackBlockages blockages = new TrackBlockages(this.metalSpace);
        blockages.addBlockage(11.0, 4.0);
        blockages.addBlockage(-11.0, 4.0);
        blockages.addBlockage(this.vddY, this.vddWidth);
        blockages.addBlockage(this.gndY, this.gndWidth);
        this.generateTracks(blockages);
        this.nmosWellTieY = this.gndY;
        this.pmosWellTieY = this.vddY;
        if (this.separateWellTies) {
            this.nmosWellTieY = this.getTrackY(-(this.nbNmosTracks() - 1));
            blockages.addBlockage(this.nmosWellTieY, this.trackWidth);
            this.pmosWellTieY = this.getTrackY(this.nbPmosTracks() - 1);
            blockages.addBlockage(this.pmosWellTieY, this.trackWidth);
            this.generateTracks(blockages);
        }
    }

    private void generateTracks(TrackBlockages blockages) {
        double y;
        this.nmosTracks.clear();
        this.pmosTracks.clear();
        for (y = this.trackPitch / 2.0; y < this.pmosWellHeight; y += this.trackPitch) {
            if (blockages.isBlocked(y, this.trackWidth)) continue;
            this.pmosTracks.add(new Double(y));
        }
        for (y = -this.trackPitch / 2.0; y > -this.nmosWellHeight; y -= this.trackPitch) {
            if (blockages.isBlocked(y, this.trackWidth)) continue;
            this.nmosTracks.add(new Double(y));
        }
    }

    private double quantizeMantissa(double mantissa) {
        double loApprox;
        double szRatio = (1.0 + this.sizeErr) / (1.0 - this.sizeErr);
        double logBaseSzRatio = Math.log(mantissa) / Math.log(szRatio);
        double floorN = Math.floor(logBaseSzRatio);
        double ceilN = Math.ceil(logBaseSzRatio);
        double hiApprox = Math.pow(szRatio, ceilN);
        return hiApprox - mantissa < mantissa - (loApprox = Math.pow(szRatio, floorN)) ? hiApprox : loApprox;
    }

    private int calcNbGroups(double maxAvailWid, double totWid, int groupSz) {
        int nbGroups = (int)Math.ceil(totWid / maxAvailWid / (double)groupSz);
        if (groupSz % 2 == 0) {
            return nbGroups;
        }
        if (nbGroups % 2 == 0) {
            return nbGroups;
        }
        int roundupGroups = nbGroups + 1;
        double wid = totWid / (double)groupSz / (double)roundupGroups;
        if (wid >= this.diffContWid) {
            nbGroups = roundupGroups;
        }
        return nbGroups;
    }

    private void fillDiffNotch(PortInst prevPort, PortInst thisPort, FoldedMos mos) {
        double diffWid = mos.getPhysWidth();
        Cell f = mos.getSrcDrn(0).getNodeInst().getParent();
        PrimitiveNode diffCont = mos instanceof FoldedPmos ? Tech.pdm1 : Tech.ndm1;
        PrimitiveArc diffArc = mos instanceof FoldedPmos ? Tech.pdiff : Tech.ndiff;
        PrimitiveNode diffNode = mos instanceof FoldedPmos ? Tech.pdNode : Tech.ndNode;
        double prevX = prevPort.getBounds().getCenterX();
        double thisX = thisPort.getBounds().getCenterX();
        double dist = thisX - prevX;
        if (dist == 0.0 || dist >= 11.0) {
            return;
        }
        double mosY = mos.getMosCenterY();
        NodeInst dFill = LayoutLib.newNodeInst(diffNode, thisX - dist / 2.0, mosY, dist, diffWid, 0.0, f);
        double contY = thisPort.getBounds().getCenterY();
        LayoutLib.newArcInst(diffArc, Double.POSITIVE_INFINITY, thisPort, thisX, contY, dFill.getOnlyPortInst(), dFill.getOnlyPortInst().getBounds().getCenterX(), contY);
        this.addSelAroundDiff(dFill);
        if (dist < 7.0) {
            double m1Wid = mos.getDiffContWidth() - 1.0;
            NodeInst mFill = LayoutLib.newNodeInst(Tech.m1Node, thisX - dist / 2.0, contY, dist, m1Wid, 0.0, f);
            LayoutLib.newArcInst(Tech.m1, Double.POSITIVE_INFINITY, thisPort, mFill.getOnlyPortInst());
        }
    }

    private static FoldedMos getRightMos(Object a) {
        if (a instanceof FoldedMos) {
            return (FoldedMos)a;
        }
        StdCellParams.error(!(a instanceof FoldedMos[]), "not FoldedMos or FoldedMos[]");
        FoldedMos[] moss = (FoldedMos[])a;
        return moss[moss.length - 1];
    }

    private static String trkMsg(Object key, Cell schem) {
        return "Track assignment for export: " + key + " in Cell: " + schem.getName() + ".\n    ";
    }

    public void setDoubleStrapGate(boolean val) {
        this.doubleStrapGate = val;
    }

    public void setExhaustivePlace(boolean val) {
        this.exhaustivePlace = val;
    }

    public void setNbPlacerPerms(int i) {
        this.nbPlacerPerms = i;
    }

    public void setNmosWellHeight(double h) {
        this.nmosWellHeight = h;
        this.init();
    }

    public void setPmosWellHeight(double h) {
        this.pmosWellHeight = h;
        this.init();
    }

    public void setMaxMosWidth(double wid) {
        this.maxMosWidth = wid;
    }

    public void enableNCC(String libName) {
        this.schemLib = Library.findLibrary(libName);
        StdCellParams.error(this.schemLib == null, "Please open the PurpleFour Library");
    }

    public void setVddExportName(String vddNm) {
        this.vddExportName = vddNm;
    }

    public String getVddExportName() {
        return this.vddExportName;
    }

    public void setGndExportName(String gndNm) {
        this.gndExportName = gndNm;
    }

    public String getGndExportName() {
        return this.gndExportName;
    }

    public void setVddExportRole(PortProto.Characteristic vddRole) {
        this.vddExportRole = vddRole;
    }

    public PortProto.Characteristic getVddExportRole() {
        return this.vddExportRole;
    }

    public void setGndExportRole(PortProto.Characteristic gndRole) {
        this.gndExportRole = gndRole;
    }

    public PortProto.Characteristic getGndExportRole() {
        return this.gndExportRole;
    }

    public StdCellParams(Library lib) {
        this.init(lib);
    }

    public double getNmosWellHeight() {
        return this.nmosWellHeight;
    }

    public double getPmosWellHeight() {
        return this.pmosWellHeight;
    }

    public boolean getDoubleStrapGate() {
        return this.doubleStrapGate;
    }

    public boolean getExhaustivePlace() {
        return this.exhaustivePlace;
    }

    public int getNbPlacerPerms() {
        return this.nbPlacerPerms;
    }

    public double getCellBot() {
        return -this.nmosWellHeight;
    }

    public double getCellTop() {
        return this.pmosWellHeight;
    }

    public double getGndY() {
        return this.gndY;
    }

    public void setGndY(double y) {
        this.gndY = y;
        this.init();
    }

    public double getVddY() {
        return this.vddY;
    }

    public void setVddY(double y) {
        this.vddY = y;
        this.init();
    }

    public double getGndWidth() {
        return this.gndWidth;
    }

    public double getVddWidth() {
        return this.vddWidth;
    }

    public double getTrackY(int i) {
        StdCellParams.error(i == 0, "StdCellParams.getTrackY: 0 is an illegal track index");
        return i > 0 ? ((Double)this.pmosTracks.get(i - 1)).doubleValue() : ((Double)this.nmosTracks.get(-i - 1)).doubleValue();
    }

    public double getPhysTrackY(int i) {
        StdCellParams.error(i == 0, "StdCellParams.getPhysTrackY: 0 is illegal track index");
        return i > 0 ? this.trackPitch / 2.0 + (double)(i - 1) * this.trackPitch : -this.trackPitch / 2.0 + (double)(i + 1) * this.trackPitch;
    }

    public double getTrackPitch() {
        return this.trackPitch;
    }

    public int nbNmosTracks() {
        return this.nmosTracks.size();
    }

    public int nbPmosTracks() {
        return this.pmosTracks.size();
    }

    public boolean getSeparateWellTies() {
        return this.separateWellTies;
    }

    public void setSeparateWellTies(boolean b) {
        this.separateWellTies = b;
        this.init();
    }

    public double getNmosWellTieY() {
        return this.nmosWellTieY;
    }

    public double getPmosWellTieY() {
        return this.pmosWellTieY;
    }

    public double getNmosWellTieWidth() {
        return this.separateWellTies ? this.trackWidth : this.gndWidth;
    }

    public double getPmosWellTieWidth() {
        return this.separateWellTies ? this.trackWidth : this.vddWidth;
    }

    public String getNmosWellTieName() {
        return this.separateWellTies ? "vsb" : this.gndExportName;
    }

    public String getPmosWellTieName() {
        return this.separateWellTies ? "vnw" : this.vddExportName;
    }

    public PortProto.Characteristic getNmosWellTieRole() {
        return this.separateWellTies ? PortProto.Characteristic.IN : this.gndExportRole;
    }

    public PortProto.Characteristic getPmosWellTieRole() {
        return this.separateWellTies ? PortProto.Characteristic.IN : this.vddExportRole;
    }

    public void setSimpleName(boolean b) {
        this.simpleName = b;
    }

    public boolean getSimpleName() {
        return this.simpleName;
    }

    public double getWellTiePitch() {
        double tieToPwellTop = 0.0 - this.getNmosWellTieY();
        double tieToPwellBot = this.getNmosWellTieY() - -this.nmosWellHeight;
        double tieToPwellTopBot = Math.max(tieToPwellTop, tieToPwellBot);
        double nmosWellTieDistance = Math.sqrt(Math.pow(this.maxWellTieRadius, 2.0) - Math.pow(tieToPwellTopBot, 2.0));
        double tieToNwellTop = this.pmosWellHeight - this.getPmosWellTieY();
        double tieToNwellBot = this.getPmosWellTieY() - 0.0;
        double tieToNwellTopBot = Math.max(tieToNwellTop, tieToNwellBot);
        double pmosWellTieDistance = Math.sqrt(Math.pow(this.maxWellTieRadius, 2.0) - Math.pow(tieToNwellTopBot, 2.0));
        double tiePitch = 2.0 * Math.min(nmosWellTieDistance, pmosWellTieDistance);
        return (int)tiePitch / 2;
    }

    public double getEnableGateStrengthRatio() {
        return this.enableGateStrengthRatio;
    }

    public double roundGateWidth(double w) {
        return Math.rint(w * 2.0) / 2.0;
    }

    public double roundSize(double s) {
        if (s == 0.0) {
            return s;
        }
        double q = this.quantizeSize(s);
        double e = (s - q) / s;
        double qe = Math.rint(e * 100000.0) / 100000.0;
        return q;
    }

    public void setSizeQuantizationError(double err) {
        StdCellParams.error(err >= 1.0, "quantization error must be less than 1.0");
        StdCellParams.error(err < 0.0, "quantization error must be positive");
        this.sizeErr = err;
    }

    public double quantizeSize(double desiredSize) {
        double exponent = Math.floor(Math.log(desiredSize) / Math.log(10.0));
        double mantissa = desiredSize / Math.pow(10.0, exponent);
        double quantMant = this.sizeErr != 0.0 ? this.quantizeMantissa(mantissa) : mantissa;
        double roundMant = Math.rint(quantMant * 100.0) / 100.0;
        return Math.pow(10.0, exponent) * roundMant;
    }

    public String parameterizedName(String nm) {
        if (!this.vddExportName.equals("vdd")) {
            nm = nm + "_pwr";
        }
        if (this.simpleName) {
            return nm;
        }
        return nm + "_NH" + this.nmosWellHeight + "_PH" + this.pmosWellHeight + "_MW" + this.maxMosWidth + "_VY" + this.vddY + "_GY" + this.gndY;
    }

    public String sizedName(String nm, double sz) {
        String num = "" + (sz + 1000.0);
        num = num.substring(1);
        return this.parameterizedName(nm) + "_X" + num + "{lay}";
    }

    private NodeInst addNmosWell(double loX, double hiX, double y, Cell cell) {
        NodeInst well = LayoutLib.newNodeInst(Tech.pwell, (loX + hiX) / 2.0, y - this.nmosWellHeight / 2.0, hiX - loX, this.nmosWellHeight, 0.0, cell);
        well.setHardSelect();
        return well;
    }

    private NodeInst addPmosWell(double loX, double hiX, double y, Cell cell) {
        NodeInst well = LayoutLib.newNodeInst(Tech.nwell, (loX + hiX) / 2.0, y + this.pmosWellHeight / 2.0, hiX - loX, this.pmosWellHeight, 0.0, cell);
        well.setHardSelect();
        return well;
    }

    public NodeInst addNmosWell(double loX, double hiX, Cell cell) {
        return this.addNmosWell(loX, hiX, 0.0, cell);
    }

    public NodeInst addPmosWell(double loX, double hiX, Cell cell) {
        return this.addPmosWell(loX, hiX, 0.0, cell);
    }

    public void addWellsForRow(ArrayList row, double minX, double maxX, Cell cell) {
        NodeInst last;
        double rowMaxX;
        NodeInst first = (NodeInst)row.get(row.size() - 1);
        double rowMinX = first.getBounds().getMinX();
        if (rowMinX < minX) {
            this.addPmosWell(minX, rowMinX, first.getAnchorCenterY(), cell);
            this.addNmosWell(minX, rowMinX, first.getAnchorCenterY(), cell);
        }
        if ((rowMaxX = (last = (NodeInst)row.get(row.size() - 1)).getBounds().getMaxX()) < maxX) {
            this.addPmosWell(rowMaxX, maxX, first.getAnchorCenterY(), cell);
            this.addNmosWell(rowMaxX, maxX, first.getAnchorCenterY(), cell);
        }
    }

    public void addPstackEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(Tech.essentialBounds, loX, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, hiX, this.pmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public void addNstackEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(Tech.essentialBounds, loX, -this.nmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, hiX, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public void addEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(Tech.essentialBounds, loX, -this.nmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, hiX, this.pmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public double checkMinStrength(double specified, double minAllowable, String gateNm) {
        if (specified < minAllowable) {
            System.out.println("Can't make: " + gateNm + " this small: X=" + specified + ", Using X=" + minAllowable + " instead");
        }
        return Math.max(specified, minAllowable);
    }

    public FoldsAndWidth calcFoldsAndWidth(double spaceAvailWid, double totWid, int groupSz) {
        if (totWid == 0.0) {
            return null;
        }
        double maxAvailWid = Math.min(spaceAvailWid, this.maxMosWidth);
        int nbGroups = this.calcNbGroups(maxAvailWid, totWid, groupSz);
        double gateWid = this.roundGateWidth(totWid / (double)groupSz / (double)nbGroups);
        if (gateWid > maxAvailWid) {
            nbGroups = this.calcNbGroups(maxAvailWid - 0.5, totWid, groupSz);
            gateWid = this.roundGateWidth(totWid / (double)groupSz / (double)nbGroups);
        }
        double physWid = Math.max(this.diffContWid, gateWid);
        if (gateWid < this.minGateWid) {
            return null;
        }
        return new FoldsAndWidth(nbGroups * groupSz, gateWid, physWid);
    }

    public void fillDiffNotches(FoldedMos[] moss) {
        StdCellParams.error(moss.length == 0, "fillDiffNotches: no transistors?");
        FoldedMos mos = moss[0];
        for (int i = 1; i < moss.length; ++i) {
            PortInst thisPort = moss[i].getSrcDrn(0);
            PortInst prevPort = moss[i - 1].getSrcDrn(moss[i - 1].nbSrcDrns() - 1);
            this.fillDiffNotch(prevPort, thisPort, mos);
        }
    }

    public void wireVddGnd(FoldedMos[] moss, SelectSrcDrn select, Cell p) {
        String exportNm;
        FoldedMos mos = moss[0];
        PortInst leftDiff = mos.getSrcDrn(0);
        Cell f = leftDiff.getNodeInst().getParent();
        double busWid = mos instanceof FoldedPmos ? this.vddWidth : this.gndWidth;
        double busY = mos instanceof FoldedPmos ? this.vddY : this.gndY;
        TrackRouterH net = new TrackRouterH(Tech.m2, busWid, busY, p);
        String string = exportNm = mos instanceof FoldedPmos ? this.vddExportName : this.gndExportName;
        if (f.findPortProto(exportNm) == null) {
            double x = leftDiff.getBounds().getCenterX();
            NodeInst pinProt = LayoutLib.newNodeInst(Tech.m2pin, x, busY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, f);
            PortInst pin = pinProt.getOnlyPortInst();
            Export e = Export.newInstance(f, pin, exportNm);
            PortProto.Characteristic role = mos instanceof FoldedPmos ? this.vddExportRole : this.gndExportRole;
            e.setCharacteristic(role);
            LayoutLib.newArcInst(Tech.m2, busWid, pin, pin);
            net.connect(pin);
        }
        double diffY = leftDiff.getBounds().getCenterY();
        double notchLoY = Math.min(busY - busWid / 2.0, diffY);
        double notchHiY = Math.max(busY + busWid / 2.0, diffY);
        PortInst lastDiff = null;
        for (int i = 0; i < moss.length; ++i) {
            for (int j = 0; j < moss[i].nbSrcDrns(); ++j) {
                if (!select.connectThisOne(i, j)) continue;
                PortInst thisDiff = moss[i].getSrcDrn(j);
                net.connect(thisDiff);
                if (lastDiff != null) {
                    double rightX;
                    double leftX = lastDiff.getBounds().getCenterX();
                    StdCellParams.error(leftX > (rightX = thisDiff.getBounds().getCenterX()), "wireVddGnd: trans not sorted left to right");
                    double deltaX = rightX - leftX;
                    if (deltaX > 0.0 && deltaX < 7.0) {
                        double dY = Math.ceil(notchHiY - notchLoY);
                        NodeInst patchNode = LayoutLib.newNodeInst(Tech.m1Node, (leftX + rightX) / 2.0, notchLoY + dY / 2.0, deltaX, dY, 0.0, f);
                        PortInst patch = patchNode.getOnlyPortInst();
                        LayoutLib.newArcInst(Tech.m1, Double.POSITIVE_INFINITY, patch, thisDiff);
                    }
                }
                lastDiff = thisDiff;
            }
        }
    }

    public void wireVddGnd(FoldedMos mos, SelectSrcDrn select, Cell p) {
        this.wireVddGnd(new FoldedMos[]{mos}, select, p);
    }

    public boolean nccEnabled() {
        return this.schemLib != null;
    }

    public void doNCC(Cell layout, String schemNm) {
        if (this.schemLib == null) {
            return;
        }
        Cell schem = this.schemLib.findNodeProto(schemNm);
        StdCellParams.error(schem == null, "can't find schematic: " + schemNm);
        NccOptions options = new NccOptions();
        options.verbose = false;
        boolean match = NccEngine.compare(schem, null, layout, null, null, options);
        StdCellParams.error(!match, "layout not topologically identical to schematic!");
    }

    public static double getSize(NodeInst iconInst, VarContext context) {
        Variable var = iconInst.getVar("ATTR_X");
        if (var == null) {
            var = iconInst.getVar("ATTR_S");
        }
        if (var == null) {
            var = iconInst.getVar("ATTR_SP");
        }
        if (var == null) {
            var = iconInst.getVar("ATTR_SN");
        }
        if (var == null) {
            System.out.println("can't find size, using 40");
            return 40.0;
        }
        Object val = context.evalVar(var);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        StdCellParams.error(true, "an Icon's size isn't a numeric value");
        return 0.0;
    }

    public Cell findPart(String partNm, double sz) {
        return this.findPart(this.sizedName(partNm, sz));
    }

    public Cell findPart(String partNm) {
        return this.layoutLib.findNodeProto(partNm);
    }

    public Cell newPart(String partNm, double sz) {
        return this.newPart(this.sizedName(partNm, sz));
    }

    public Cell newPart(String partNm) {
        StdCellParams.error(this.findPart(partNm) != null, "Cell already exists: " + partNm);
        Cell p = Cell.newInstance(this.layoutLib, partNm);
        return p;
    }

    public static double getRightDiffX(FoldedMos m) {
        return m.getSrcDrn(m.nbSrcDrns() - 1).getBounds().getCenterX();
    }

    public static double getRightDiffX(FoldedMos[] moss) {
        return StdCellParams.getRightDiffX(StdCellParams.getRightMos(moss));
    }

    public static double getRightDiffX(Object a, Object b) {
        FoldedMos ra = StdCellParams.getRightMos(a);
        FoldedMos rb = StdCellParams.getRightMos(b);
        return Math.max(StdCellParams.getRightDiffX(ra), StdCellParams.getRightDiffX(rb));
    }

    public static void addEssentialBoundsFromChildren(Cell cell) {
        double loY = Double.MAX_VALUE;
        double loX = Double.MAX_VALUE;
        double hiY = Double.MIN_VALUE;
        double hiX = Double.MIN_VALUE;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            Rectangle2D b = ((NodeInst)it.next()).getBounds();
            loX = Math.min(loX, b.getMinX());
            loY = Math.min(loY, b.getMinY());
            hiX = Math.max(hiX, b.getMaxX());
            hiY = Math.max(hiY, b.getMaxY());
        }
        LayoutLib.newNodeInst(Tech.essentialBounds, loX, loY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, hiX, hiY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public HashMap getSchemTrackAssign(Cell schem) {
        HashMap<String, Variable> schAsgn = new HashMap<String, Variable>();
        Iterator it = schem.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            Variable val = e.getVar("ATTR_track");
            String key = e.getName();
            if (val == null) continue;
            schAsgn.put(key, val);
        }
        this.validateTrackAssign(schAsgn, schem);
        return schAsgn;
    }

    public void validateTrackAssign(HashMap asgn, Cell s) {
        HashMap trkToExp = new HashMap();
        Iterator it = asgn.keySet().iterator();
        while (it.hasNext()) {
            Object k = it.next();
            Object v = asgn.get(k);
            StdCellParams.error(!(k instanceof String), "Track assignment key not String: " + k);
            StdCellParams.error(!(v instanceof Integer), StdCellParams.trkMsg(k, s) + "Value not Integer: " + v);
            int track = (Integer)v;
            StdCellParams.error(track == 0, StdCellParams.trkMsg(k, s) + "Track must be <=-1 or >=1, 0 is illegal");
            Object oldK = trkToExp.get(v);
            if (oldK != null) {
                System.out.println(StdCellParams.trkMsg(k, s) + "Track: " + v + " is shared by export: " + oldK);
            }
            trkToExp.put(v, k);
        }
    }

    public void addSelAroundDiff(NodeInst diffNode) {
        NodeProto prot = diffNode.getProto();
        StdCellParams.error(prot != Tech.pdNode && prot != Tech.ndNode, "addSelectAroundDiff: only works with MOSIS CMOS diff nodes");
        PrimitiveNode sel = prot == Tech.pdNode ? Tech.pselNode : Tech.nselNode;
        Rectangle2D r = diffNode.getBounds();
        double w = r.getWidth() + 4.0;
        double h = r.getHeight() + 4.0;
        Cell f = diffNode.getParent();
        LayoutLib.newNodeInst(sel, r.getCenterX(), r.getCenterY(), w, h, 0.0, f);
    }

    public static interface SelectSrcDrn {
        public boolean connectThisOne(int var1, int var2);
    }

    private static class TrackBlockages {
        private ArrayList blockages = new ArrayList();
        private double space;

        TrackBlockages(double space) {
            this.space = space;
        }

        void addBlockage(double center, double width) {
            this.blockages.add(new Blockage(center, width));
        }

        boolean isBlocked(double center, double width) {
            double top = center + width / 2.0 + this.space;
            double bot = center + width / 2.0 - this.space;
            for (int i = 0; i < this.blockages.size(); ++i) {
                Blockage b = (Blockage)this.blockages.get(i);
                if (!(b.bot < top) || !(b.top > bot)) continue;
                return true;
            }
            return false;
        }

        private static class Blockage {
            double bot;
            double top;

            Blockage(double center, double width) {
                this.bot = center - width / 2.0;
                this.top = center + width / 2.0;
            }
        }
    }
}

