/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.tool.ncc.basic.Messenger;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class Part
extends NetObject {
    protected static final int RESISTOR = 0;
    protected static final int TRANSISTOR = 1;
    protected static final int SUBCIRCUIT = 2;
    protected static final int TYPE_FIELD_WIDTH = 4;
    protected Wire[] pins;

    protected Part(String name, Wire[] pins) {
        super(name);
        this.pins = pins;
        for (int i = 0; i < pins.length; ++i) {
            pins[i].add(this);
        }
    }

    public Iterator getConnected() {
        return Arrays.asList(this.pins).iterator();
    }

    public NetObject.Type getNetObjType() {
        return NetObject.Type.PART;
    }

    public abstract String valueString();

    public int numPins() {
        return this.pins.length;
    }

    public abstract int[] getTermCoefs();

    public abstract boolean parallelMerge(Part var1);

    public abstract Integer hashCodeForParallelMerge();

    public boolean disconnect(Wire w) {
        boolean found = false;
        for (int i = 0; i < this.pins.length; ++i) {
            Wire ww = this.pins[i];
            if (ww != w) continue;
            this.pins[i] = null;
            found = true;
        }
        return found;
    }

    public void deleteMe() {
        for (int i = 0; i < this.pins.length; ++i) {
            Wire w = this.pins[i];
            w.disconnect(this);
        }
        Circuit parent = this.getParent();
        parent.remove(this);
    }

    public int numDistinctWires() {
        HashSet<Wire> wires = new HashSet<Wire>();
        for (int i = 0; i < this.pins.length; ++i) {
            wires.add(this.pins[i]);
        }
        return wires.size();
    }

    public abstract String typeString();

    public abstract int typeCode();

    public String nameString() {
        return this.typeString() + " " + this.getName();
    }

    public int numPinsConnected(Wire w) {
        int numConnected = 0;
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            ++numConnected;
        }
        return numConnected;
    }

    public abstract boolean touchesAtGate(Wire var1);

    protected abstract boolean isThisGate(int var1);

    public abstract Set getPinTypes();

    public abstract String connectionString(Wire var1);

    public Integer computeHashCode() {
        int sum = 0;
        int[] codes = this.getTermCoefs();
        for (int i = 0; i < this.pins.length; ++i) {
            Wire w = this.pins[i];
            sum += w.getCode() * codes[i];
        }
        return new Integer(sum);
    }

    public int getHashFor(Wire w) {
        int sum = 0;
        int[] codes = this.getTermCoefs();
        for (int i = 0; i < this.pins.length; ++i) {
            Wire x = this.pins[i];
            Part.error(x == null, "null wire?");
            if (x != w) continue;
            sum += codes[i] * this.getCode();
        }
        return sum;
    }

    public void checkMe(Circuit parent) {
        Part.error(parent != this.getParent(), "wrong parent");
        for (int i = 0; i < this.pins.length; ++i) {
            Wire w = this.pins[i];
            Part.error(w == null, "Wire is null");
            Part.error(!w.touches(this), "Wire not connected to Part");
        }
    }

    public int getNumWiresConnected() {
        HashSet<Wire> wires = new HashSet<Wire>();
        for (int i = 0; i < this.pins.length; ++i) {
            wires.add(this.pins[i]);
        }
        return wires.size();
    }

    public void printMe(int maxCon, Messenger messenger) {
        String n = this.nameString();
        String s = this.valueString();
        String c = this.connectionString(maxCon);
        messenger.println(n + " " + s + " " + c);
    }
}

