/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AutoStitch {
    static ArcProto preferredArc;
    static InteractiveRouter router;

    public static void autoStitch(boolean highlighted, boolean forced) {
        ArrayList nodesToStitch = new ArrayList();
        if (highlighted) {
            List highs = Highlight.getHighlighted(true, false);
            Iterator it = highs.iterator();
            while (it.hasNext()) {
                nodesToStitch.add(it.next());
            }
        } else {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return;
            }
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (ni.isIconOfParent()) continue;
                nodesToStitch.add(ni);
            }
        }
        if (nodesToStitch.size() > 0) {
            AutoStitchJob autoStitchJob = new AutoStitchJob(nodesToStitch, forced);
        }
    }

    static {
        router = new SimpleWirer();
    }

    private static class AutoStitchJob
    extends Job {
        List nodesToStitch;
        FlagSet nodeMark;
        boolean forced;
        List allRoutes;

        protected AutoStitchJob(List nodesToStitch, boolean forced) {
            super("Auto-Stitch", Routing.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.nodesToStitch = nodesToStitch;
            this.forced = forced;
            this.allRoutes = new ArrayList();
            this.startJob();
        }

        public boolean doIt() {
            PrimitiveArc ap;
            Iterator aIt;
            Technology tech;
            ArcProto curAp;
            FlagSet cellMark = NodeProto.getFlagSet(1);
            this.nodeMark = NodeInst.getFlagSet(1);
            cellMark.clearOnAllCells();
            int count = 0;
            Iterator it = this.nodesToStitch.iterator();
            while (it.hasNext()) {
                NodeInst nodeToStitch = (NodeInst)it.next();
                Cell parent = nodeToStitch.getParent();
                if (parent.isBit(cellMark)) continue;
                parent.setBit(cellMark);
                Iterator nIt = parent.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = (NodeInst)nIt.next();
                    ni.clearBit(this.nodeMark);
                    int total = ni.getProto().getNumPorts();
                    double[] bbArray = new double[total * 4];
                    ni.setTempObj(bbArray);
                    int i = 0;
                    Iterator pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto pp = (PortProto)pIt.next();
                        AffineTransform trans = ni.rotateOut();
                        NodeInst rNi = ni;
                        PortProto rPp = pp;
                        while (rNi.getProto() instanceof Cell) {
                            AffineTransform temp = rNi.translateOut();
                            temp.preConcatenate(trans);
                            PortInst subPi = ((Export)rPp).getOriginalPort();
                            rPp = subPi.getPortProto();
                            rNi = subPi.getNodeInst();
                            trans = rNi.rotateOut();
                            trans.preConcatenate(temp);
                        }
                        Rectangle2D.Double bounds = new Rectangle2D.Double(rNi.getAnchorCenterX() - rNi.getXSize() / 2.0, rNi.getAnchorCenterY() - rNi.getYSize() / 2.0, rNi.getXSize(), rNi.getYSize());
                        DBMath.transformRect(bounds, trans);
                        bbArray[i++] = bounds.getMinX();
                        bbArray[i++] = bounds.getMaxX();
                        bbArray[i++] = bounds.getMinY();
                        bbArray[i++] = bounds.getMaxY();
                    }
                }
            }
            it = this.nodesToStitch.iterator();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.setBit(this.nodeMark);
            }
            preferredArc = null;
            String preferredName = Routing.getPreferredRoutingArc();
            if (preferredName.length() > 0) {
                preferredArc = ArcProto.findArcProto(preferredName);
            }
            if (preferredArc == null && (curAp = User.tool.getCurrentArcProto()) != null) {
                preferredArc = curAp;
            }
            Iterator it2 = Technology.getTechnologies();
            while (it2.hasNext()) {
                tech = (Technology)it2.next();
                aIt = tech.getArcs();
                while (aIt.hasNext()) {
                    ap = (PrimitiveArc)aIt.next();
                    ap.setTempObj(null);
                }
            }
            it2 = this.nodesToStitch.iterator();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                if (ni.getParent().isAllLocked()) continue;
                count += this.checkStitching(ni);
            }
            if (count != 0) {
                System.out.println("AUTO ROUTING: added " + count + " wires");
            } else if (this.forced) {
                System.out.println("No arcs added");
            }
            it2 = Technology.getTechnologies();
            while (it2.hasNext()) {
                tech = (Technology)it2.next();
                aIt = tech.getArcs();
                while (aIt.hasNext()) {
                    ap = (PrimitiveArc)aIt.next();
                    ap.setTempObj(null);
                }
            }
            it2 = Library.getLibraries();
            while (it2.hasNext()) {
                Library lib = (Library)it2.next();
                Iterator cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = (Cell)cIt.next();
                    if (!cell.isBit(cellMark)) continue;
                    Iterator nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst ni = (NodeInst)nIt.next();
                        ni.setTempObj(null);
                    }
                }
            }
            cellMark.freeFlagSet();
            this.nodeMark.freeFlagSet();
            it2 = this.allRoutes.iterator();
            while (it2.hasNext()) {
                Route route = (Route)it2.next();
                RouteElement re = (RouteElement)route.get(0);
                Cell c = re.getCell();
                Router.createRouteNoJob(route, c, false);
            }
            return true;
        }

        private int checkStitching(NodeInst ni) {
            Cell cell = ni.getParent();
            Netlist netlist = cell.getUserNetlist();
            double[] boundArray = (double[])ni.getTempObj();
            ArrayList<Geometric> nodesInArea = new ArrayList<Geometric>();
            Iterator it = cell.searchIterator(ni.getBounds());
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof NodeInst)) continue;
                nodesInArea.add(geom);
            }
            int count = 0;
            Iterator it2 = nodesInArea.iterator();
            block1: while (it2.hasNext()) {
                NodeInst oNi = (NodeInst)it2.next();
                if (oNi.isBit(this.nodeMark) && oNi.getNodeIndex() <= ni.getNodeIndex()) continue;
                Rectangle2D oBounds = oNi.getBounds();
                if (ni.getProto() instanceof Cell) {
                    int bbp = 0;
                    Iterator pIt = ni.getProto().getPorts();
                    block2: while (pIt.hasNext()) {
                        PortProto pp = (PortProto)pIt.next();
                        if (boundArray != null) {
                            double lX = boundArray[bbp++];
                            double hX = boundArray[bbp++];
                            double lY = boundArray[bbp++];
                            double hY = boundArray[bbp++];
                            if (lX > oBounds.getMaxX() || hX < oBounds.getMinX() || lY > oBounds.getMaxY() || hY < oBounds.getMinY()) continue;
                        }
                        boolean found = false;
                        Iterator cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Connection con = (Connection)cIt.next();
                            PortInst pi = con.getPortInst();
                            if (pi.getPortProto() != pp || con.getArc().getHead().getPortInst().getNodeInst() != oNi && con.getArc().getTail().getPortInst().getNodeInst() != oNi) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        AffineTransform trans = ni.rotateOut();
                        NodeInst rNi = ni;
                        PortProto rPp = pp;
                        while (rNi.getProto() instanceof Cell) {
                            AffineTransform temp = rNi.translateOut();
                            temp.preConcatenate(trans);
                            Export e = (Export)rPp;
                            rNi = e.getOriginalPort().getNodeInst();
                            rPp = e.getOriginalPort().getPortProto();
                            trans = rNi.rotateOut();
                            trans.preConcatenate(temp);
                        }
                        ArcProto[] connections = pp.getBasePort().getConnections();
                        for (int i = 0; i < connections.length; ++i) {
                            AutoStitchJob.findSmallestLayer(connections[i]);
                        }
                        boolean usePortPoly = false;
                        Technology tech = rNi.getProto().getTechnology();
                        Poly[] nodePolys = tech.getShapeOfNode(rNi, null, true, true);
                        int tot = nodePolys.length;
                        if (tot == 0 || rNi.getProto() == Generic.tech.simProbeNode) {
                            usePortPoly = true;
                            tot = 1;
                        }
                        Netlist subNetlist = rNi.getParent().getUserNetlist();
                        for (int j = 0; j < tot; ++j) {
                            Layer layer = null;
                            Poly poly = null;
                            if (usePortPoly) {
                                poly = ni.getShapeOfPort(pp);
                                layer = poly.getLayer();
                            } else {
                                poly = nodePolys[j];
                                if (poly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, poly.getPort())) continue;
                                poly.transform(trans);
                                layer = poly.getLayer();
                                if (layer != null) {
                                    layer = layer.getNonPseudoLayer();
                                }
                            }
                            boolean connected = false;
                            for (int pass = 0; pass < 2; ++pass) {
                                for (int i = 0; i < connections.length; ++i) {
                                    ArcProto ap = connections[i];
                                    if (pass != 0 ? ap == preferredArc || ap.getTechnology() != rNi.getProto().getTechnology() : ap != preferredArc) continue;
                                    if (!usePortPoly && !tech.sameLayer((Layer)ap.getTempObj(), layer) || !(connected = this.testPoly(ni, pp, ap, poly, oNi, netlist))) continue;
                                    ++count;
                                    break;
                                }
                                if (connected) break;
                            }
                            if (connected) continue block2;
                        }
                    }
                    continue;
                }
                AffineTransform trans = ni.rotateOut();
                double oX = oNi.getAnchorCenterX();
                double oY = oNi.getAnchorCenterY();
                boolean usePortPoly = false;
                Technology tech = ni.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, null, true, true);
                int tot = polys.length;
                if (tot == 0 || ni.getProto() == Generic.tech.simProbeNode) {
                    usePortPoly = true;
                    tot = 1;
                }
                for (int j = 0; j < tot; ++j) {
                    double dist;
                    double y;
                    Iterator pIt;
                    double bestDist;
                    PortProto bestPp;
                    PortProto rPp = null;
                    Poly polyPtr = null;
                    if (usePortPoly) {
                        bestPp = null;
                        bestDist = 0.0;
                        pIt = ni.getProto().getPorts();
                        while (pIt.hasNext()) {
                            PortProto tPp = (PortProto)pIt.next();
                            Poly portPoly = ni.getShapeOfPort(tPp);
                            double x = portPoly.getCenterX();
                            y = portPoly.getCenterY();
                            dist = Math.abs(x - oX) + Math.abs(y - oY);
                            if (bestPp == null) {
                                bestDist = dist;
                            }
                            if (dist > bestDist) continue;
                            bestPp = rPp;
                            bestDist = dist;
                        }
                        if (bestPp == null) continue;
                        rPp = bestPp;
                        polyPtr = ni.getShapeOfPort(rPp);
                    } else {
                        polyPtr = polys[j];
                        if (polyPtr.getPort() == null) continue;
                        bestPp = null;
                        bestDist = 0.0;
                        pIt = ni.getProto().getPorts();
                        while (pIt.hasNext()) {
                            PortProto tPp = (PortProto)pIt.next();
                            if (!netlist.portsConnected(ni, tPp, polyPtr.getPort())) continue;
                            Poly portPoly = ni.getShapeOfPort(tPp);
                            double x = portPoly.getCenterX();
                            y = portPoly.getCenterY();
                            dist = Math.abs(x - oX) + Math.abs(y - oY);
                            if (bestPp == null) {
                                bestDist = dist;
                            }
                            if (dist > bestDist) continue;
                            bestPp = tPp;
                            bestDist = dist;
                        }
                        if (bestPp == null) continue;
                        rPp = bestPp;
                        polyPtr.transform(trans);
                    }
                    Layer layer = polyPtr.getLayer();
                    if (layer != null) {
                        layer = layer.getNonPseudoLayer();
                    }
                    boolean found = false;
                    Iterator cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = (Connection)cIt.next();
                        PortInst pi = con.getPortInst();
                        if (!netlist.portsConnected(ni, rPp, pi.getPortProto()) || con.getArc().getHead().getPortInst().getNodeInst() != oNi && con.getArc().getTail().getPortInst().getNodeInst() != oNi) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    boolean connected = false;
                    ArcProto[] connections = rPp.getBasePort().getConnections();
                    for (int pass = 0; pass < 2; ++pass) {
                        for (int i = 0; i < connections.length; ++i) {
                            ArcProto ap = connections[i];
                            if (pass != 0 ? ap == preferredArc : ap != preferredArc) continue;
                            if (ap.getTechnology() != ni.getProto().getTechnology()) break;
                            AutoStitchJob.findSmallestLayer(ap);
                            if (!usePortPoly) {
                                Layer oLayer = (Layer)ap.getTempObj();
                                if (!ap.getTechnology().sameLayer(oLayer, layer)) continue;
                            }
                            if (!(connected = this.testPoly(ni, rPp, ap, polyPtr, oNi, netlist))) continue;
                            ++count;
                            break;
                        }
                        if (connected) break;
                    }
                    if (connected) continue block1;
                }
            }
            return count;
        }

        private boolean testPoly(NodeInst ni, PortProto pp, ArcProto ap, Poly poly, NodeInst oNi, Netlist netlist) {
            PortInst pi = ni.findPortInstFromProto(pp);
            JNetwork net = netlist.getNetwork(pi);
            if (oNi.getProto() instanceof Cell) {
                double[] boundArray = (double[])oNi.getTempObj();
                int bbp = 0;
                Rectangle2D bounds = poly.getBounds2D();
                Iterator it = oNi.getProto().getPorts();
                while (it.hasNext()) {
                    PortProto mPp = (PortProto)it.next();
                    if (boundArray != null) {
                        double lX = boundArray[bbp++];
                        double hX = boundArray[bbp++];
                        double lY = boundArray[bbp++];
                        double hY = boundArray[bbp++];
                        if (lX > bounds.getMaxX() || hX < bounds.getMinX() || lY > bounds.getMaxY() || hY < bounds.getMinY()) continue;
                    }
                    if (!mPp.getBasePort().connectsTo(ap)) continue;
                    JNetwork oNet = netlist.getNetwork(oNi.findPortInstFromProto(mPp));
                    if (net != null && oNet == net) continue;
                    AffineTransform trans = oNi.rotateOut();
                    NodeInst rNi = oNi;
                    PortProto rPp = mPp;
                    while (rNi.getProto() instanceof Cell) {
                        AffineTransform temp = rNi.translateOut();
                        temp.preConcatenate(trans);
                        Export e = (Export)rPp;
                        rNi = e.getOriginalPort().getNodeInst();
                        rPp = e.getOriginalPort().getPortProto();
                        trans = rNi.rotateOut();
                        trans.preConcatenate(temp);
                    }
                    Technology tech = rNi.getProto().getTechnology();
                    Poly[] polys = tech.getShapeOfNode(rNi, null, true, true);
                    int tot = polys.length;
                    if (tot == 0) {
                        Poly oPoly = oNi.getShapeOfPort(mPp);
                        if (!this.comparePoly(oNi, mPp, oPoly, ni, pp, poly, ap, netlist)) continue;
                        return true;
                    }
                    Netlist subNetlist = rNi.getParent().getUserNetlist();
                    for (int j = 0; j < tot; ++j) {
                        Poly oPoly = polys[j];
                        if (oPoly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, oPoly.getPort())) continue;
                        if (ni.getProto() != Generic.tech.simProbeNode) {
                            Layer oLayer = oPoly.getLayer();
                            if (oLayer != null) {
                                oLayer = oLayer.getNonPseudoLayer();
                            }
                            if (!tech.sameLayer(oLayer, (Layer)ap.getTempObj())) continue;
                        }
                        oPoly.transform(trans);
                        if (!this.comparePoly(oNi, mPp, oPoly, ni, pp, poly, ap, netlist)) continue;
                        return true;
                    }
                }
            } else {
                AffineTransform trans = oNi.rotateOut();
                double ox = poly.getCenterX();
                double oy = poly.getCenterY();
                Technology tech = oNi.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfNode(oNi, null, true, true);
                int tot = polys.length;
                if (tot == 0) {
                    Poly oPoly;
                    PortProto rPp;
                    PortProto bestPp = null;
                    double bestDist = 0.0;
                    Iterator pIt = oNi.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto rPp2 = (PortProto)pIt.next();
                        Poly portPoly = oNi.getShapeOfPort(rPp2);
                        double dist = Math.abs(portPoly.getCenterX() - ox) + Math.abs(portPoly.getCenterY() - oy);
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = rPp2;
                        bestDist = dist;
                    }
                    if (bestPp != null && (rPp = bestPp).getBasePort().connectsTo(ap) && this.comparePoly(oNi, rPp, oPoly = oNi.getShapeOfPort(rPp), ni, pp, poly, ap, netlist)) {
                        return true;
                    }
                } else {
                    for (int j = 0; j < tot; ++j) {
                        PortProto rPp;
                        Poly oPoly = polys[j];
                        if (oPoly.getPort() == null) continue;
                        Layer oLayer = oPoly.getLayer();
                        if (oLayer != null) {
                            oLayer = oLayer.getNonPseudoLayer();
                        }
                        if (!tech.sameLayer((Layer)ap.getTempObj(), oLayer)) continue;
                        PortInst oPi = oNi.findPortInstFromProto(oPoly.getPort());
                        JNetwork oNet = netlist.getNetwork(oPi);
                        if (net != null && oNet == net) continue;
                        PortProto bestPp = null;
                        double bestDist = 0.0;
                        Iterator pIt = oNi.getProto().getPorts();
                        while (pIt.hasNext()) {
                            PortProto rPp3 = (PortProto)pIt.next();
                            if (!netlist.portsConnected(oNi, rPp3, oPoly.getPort())) continue;
                            Poly portPoly = oNi.getShapeOfPort(rPp3);
                            double dist = Math.abs(ox - portPoly.getCenterX()) + Math.abs(oy - portPoly.getCenterY());
                            if (bestPp == null) {
                                bestDist = dist;
                            }
                            if (dist > bestDist) continue;
                            bestPp = rPp3;
                            bestDist = dist;
                        }
                        if (bestPp == null || !(rPp = bestPp).getBasePort().connectsTo(ap)) continue;
                        oPoly.transform(trans);
                        if (!this.comparePoly(oNi, rPp, oPoly, ni, pp, poly, ap, netlist)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean comparePoly(NodeInst oNi, PortProto opp, Poly oPoly, NodeInst ni, PortProto pp, Poly poly, ArcProto ap, Netlist netlist) {
            Point2D.Double tPortCenter;
            double tDist;
            PortProto tPp;
            Rectangle2D polyBounds = poly.getBounds2D();
            Rectangle2D oPolyBounds = oPoly.getBounds2D();
            if (polyBounds.getMinX() > oPolyBounds.getMaxX() || oPolyBounds.getMinX() > polyBounds.getMaxX() || polyBounds.getMinY() > oPolyBounds.getMaxY() || oPolyBounds.getMinY() > polyBounds.getMaxY()) {
                return false;
            }
            Poly portPoly = ni.getShapeOfPort(pp);
            Point2D.Double portCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
            portPoly = oNi.getShapeOfPort(opp);
            Point2D.Double oPortCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
            double dist = portCenter.distance(oPortCenter);
            Iterator it = oNi.getProto().getPorts();
            while (it.hasNext()) {
                tPp = (PortProto)it.next();
                if (tPp == opp || !netlist.portsConnected(oNi, tPp, opp) || (tDist = portCenter.distance(tPortCenter = new Point2D.Double((portPoly = oNi.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
                dist = tDist;
                opp = tPp;
                oPortCenter.setLocation(tPortCenter);
            }
            it = ni.getProto().getPorts();
            while (it.hasNext()) {
                tPp = (PortProto)it.next();
                if (tPp == pp || !netlist.portsConnected(ni, tPp, pp) || (tDist = oPortCenter.distance(tPortCenter = new Point2D.Double((portPoly = ni.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
                dist = tDist;
                pp = tPp;
                portCenter.setLocation(tPortCenter);
            }
            double x = (((Point2D)oPortCenter).getX() + ((Point2D)portCenter).getX()) / 2.0;
            double y = (((Point2D)oPortCenter).getY() + ((Point2D)portCenter).getY()) / 2.0;
            PortInst pi = ni.findPortInstFromProto(pp);
            PortInst opi = oNi.findPortInstFromProto(opp);
            Route route = router.planRoute(ni.getParent(), pi, opi, (Point2D)new Point2D.Double(x, y));
            if (route.size() == 0) {
                return false;
            }
            this.allRoutes.add(route);
            return true;
        }

        public static void findSmallestLayer(ArcProto ap) {
            if (ap.getTempObj() != null) {
                return;
            }
            ArcInst ai = ArcInst.makeDummyInstance((PrimitiveArc)ap, 100.0);
            boolean bestFound = false;
            double bestArea = 0.0;
            Technology tech = ap.getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            int tot = polys.length;
            for (int i = 0; i < tot; ++i) {
                Poly poly = polys[i];
                double area = Math.abs(poly.getArea());
                if (bestFound && area >= bestArea) continue;
                bestArea = area;
                bestFound = true;
                ap.setTempObj(poly.getLayer());
            }
        }
    }
}

