/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PixelDrawing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class LayerVisibility
extends EDialog {
    private JList layerList;
    private DefaultListModel layerListModel;
    private HashMap visibility;
    private HashMap highlighted;
    private List layersInList;
    private boolean initialTextOnNode;
    private boolean initialTextOnArc;
    private boolean initialTextOnPort;
    private boolean initialTextOnExport;
    private boolean initialTextOnAnnotation;
    private boolean initialTextOnInstance;
    private boolean initialTextOnCell;
    private boolean showHighlighted;
    private static final Class view3DClass = Resources.get3DMainClass();
    private static Method setVisibilityMethod = null;
    private JButton allInvisible;
    private JButton allVisible;
    private JCheckBox annotationText;
    private JButton apply;
    private JCheckBox arcText;
    private JButton cancel;
    private JCheckBox cellText;
    private JCheckBox exportText;
    private JCheckBox instanceNames;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JScrollPane layerPane;
    private JButton makeInvisible;
    private JButton makeVisible;
    private JCheckBox nodeText;
    private JButton ok;
    private JCheckBox portText;
    private JComboBox technology;
    private JButton toggleHighlight;
    private JButton unhighlightAll;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    public LayerVisibility(Frame parent, boolean modal) {
        super(parent, modal);
        Layer layer;
        Iterator lIt;
        Technology tech;
        this.initComponents();
        this.initialTextOnNode = User.isTextVisibilityOnNode();
        this.nodeText.setSelected(this.initialTextOnNode);
        this.initialTextOnArc = User.isTextVisibilityOnArc();
        this.arcText.setSelected(this.initialTextOnArc);
        this.initialTextOnPort = User.isTextVisibilityOnPort();
        this.portText.setSelected(this.initialTextOnPort);
        this.initialTextOnExport = User.isTextVisibilityOnExport();
        this.exportText.setSelected(this.initialTextOnExport);
        this.initialTextOnAnnotation = User.isTextVisibilityOnAnnotation();
        this.annotationText.setSelected(this.initialTextOnAnnotation);
        this.initialTextOnInstance = User.isTextVisibilityOnInstance();
        this.instanceNames.setSelected(this.initialTextOnInstance);
        this.initialTextOnCell = User.isTextVisibilityOnCell();
        this.cellText.setSelected(this.initialTextOnCell);
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(2);
        this.layerPane.setViewportView(this.layerList);
        this.layerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                LayerVisibility.this.apply(e);
            }
        });
        boolean noDimming = true;
        Iterator it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = (Layer)lIt.next();
                if (!layer.isDimmed()) continue;
                noDimming = false;
            }
        }
        this.visibility = new HashMap();
        this.highlighted = new HashMap();
        it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = (Layer)lIt.next();
                if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
                this.visibility.put(layer, new Boolean(layer.isVisible()));
                if (noDimming) {
                    this.highlighted.put(layer, new Boolean(false));
                    continue;
                }
                this.highlighted.put(layer, new Boolean(!layer.isDimmed()));
            }
        }
        it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            this.technology.addItem(tech.getTechName());
        }
        this.technology.setSelectedItem(Technology.getCurrent().getTechName());
        this.showLayersForTechnology();
        this.finishInitialization();
    }

    private void showLayersForTechnology() {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        this.layerListModel.clear();
        this.layersInList = new ArrayList();
        Iterator it = tech.getLayersSortedByHeight().iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
            this.layersInList.add(layer);
            this.layerListModel.addElement(this.lineName(layer));
        }
        this.layerList.setSelectedIndex(0);
    }

    private String lineName(Layer layer) {
        StringBuffer layerName = new StringBuffer();
        Boolean layerVisible = (Boolean)this.visibility.get(layer);
        if (layerVisible.booleanValue()) {
            layerName.append("\u2713 ");
        } else {
            layerName.append("  ");
        }
        if ((layer.getFunctionExtras() & 0x1000) != 0) {
            layerName.append(" (for pins)");
        }
        Boolean layerHighlighted = (Boolean)this.highlighted.get(layer);
        layerName.append(layer.getName());
        if (layerHighlighted.booleanValue()) {
            layerName.append(" (HIGHLIGHTED)");
        }
        return layerName.toString();
    }

    private void apply(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int[] indices = this.layerList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                int line;
                this.setVisibility(line, !this.isLineChecked(line = indices[i]));
            }
        }
    }

    private void clearAllHighlight() {
        for (int i = 0; i < this.layerListModel.size(); ++i) {
            this.changeHighlighted(i, 0);
        }
    }

    private void toggleHighlight() {
        int[] indices = this.layerList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            int line = indices[i];
            this.changeHighlighted(line, 1);
        }
    }

    private void setAllVisibility(boolean on) {
        for (int i = 0; i < this.layerListModel.size(); ++i) {
            this.setVisibility(i, on);
        }
    }

    private void setVisibility(boolean on) {
        int[] indices = this.layerList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            int line = indices[i];
            this.setVisibility(line, on);
        }
    }

    private boolean isLineChecked(int i) {
        String s = (String)this.layerListModel.get(i);
        return s.charAt(0) != ' ';
    }

    private void setVisibility(int i, boolean on) {
        Layer layer;
        String name = (String)this.layerListModel.get(i);
        if (name != null) {
            name = name.substring(2);
        }
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        if ((layer = tech.findLayer(name)) == null) {
            System.out.println("Can't find " + name);
            return;
        }
        this.visibility.put(layer, new Boolean(on));
        this.layerListModel.set(i, this.lineName(layer));
    }

    private void changeHighlighted(int i, int how) {
        Layer layer;
        String name = (String)this.layerListModel.get(i);
        if (name != null) {
            name = name.substring(2);
        }
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        if ((layer = tech.findLayer(name)) == null) {
            System.out.println("Can't find " + name);
            return;
        }
        boolean newState = false;
        if (how == 1) {
            newState = (Boolean)this.highlighted.get(layer) == false;
        }
        this.highlighted.put(layer, new Boolean(newState));
        this.layerListModel.set(i, this.lineName(layer));
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void termDialog() {
        boolean currentTextOnCell;
        boolean currentTextOnInstance;
        boolean currentTextOnAnnotation;
        boolean currentTextOnExport;
        boolean currentTextOnPort;
        boolean currentTextOnArc;
        Layer layer;
        Iterator lIt;
        Technology tech;
        boolean anyHighlighted = false;
        Iterator it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = (Layer)lIt.next();
                Boolean layerHighlighted = (Boolean)this.highlighted.get(layer.getNonPseudoLayer());
                if (layerHighlighted == null || !layerHighlighted.booleanValue()) continue;
                anyHighlighted = true;
            }
        }
        it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Boolean layerHighlighted;
                layer = (Layer)lIt.next();
                Boolean layerVis = (Boolean)this.visibility.get(layer.getNonPseudoLayer());
                if (layerVis != null && layer.isVisible() != layerVis.booleanValue()) {
                    layer.setVisible(layerVis);
                    Object obj3D = layer.getGraphics().get3DAppearance();
                    if (obj3D != null) {
                        try {
                            if (setVisibilityMethod == null) {
                                setVisibilityMethod = view3DClass.getDeclaredMethod("set3DVisibility", class$java$lang$Object == null ? LayerVisibility.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Boolean == null ? LayerVisibility.class$("java.lang.Boolean") : class$java$lang$Boolean);
                            }
                            setVisibilityMethod.invoke((Object)view3DClass, obj3D, layerVis);
                        }
                        catch (Exception e) {
                            System.out.println("Cannot call 3D plugin method set3DVisibility: " + e.getMessage());
                        }
                    }
                }
                if ((layerHighlighted = (Boolean)this.highlighted.get(layer.getNonPseudoLayer())) == null) continue;
                boolean newState = false;
                if (anyHighlighted && !layerHighlighted.booleanValue()) {
                    newState = true;
                }
                if (newState == layer.isDimmed()) continue;
                layer.setDimmed(newState);
            }
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            Iterator nIt = tech.getNodes();
            while (nIt.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)nIt.next();
                Technology.NodeLayer[] layers = np.getLayers();
                boolean invisible = true;
                for (int i = 0; i < layers.length; ++i) {
                    Technology.NodeLayer lay = layers[i];
                    if (!lay.getLayer().isVisible()) continue;
                    invisible = false;
                    break;
                }
                np.setNodeInvisible(invisible);
            }
            Iterator aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ArcProto ap = (ArcProto)aIt.next();
                PrimitiveArc pAp = (PrimitiveArc)ap;
                Technology.ArcLayer[] layers = pAp.getLayers();
                boolean invisible = true;
                for (int i = 0; i < layers.length; ++i) {
                    Technology.ArcLayer lay = layers[i];
                    if (!lay.getLayer().isVisible()) continue;
                    invisible = false;
                    break;
                }
                ap.setArcInvisible(invisible);
            }
        }
        boolean currentTextOnNode = this.nodeText.isSelected();
        if (currentTextOnNode != this.initialTextOnNode) {
            this.initialTextOnNode = currentTextOnNode;
            User.setTextVisibilityOnNode(this.initialTextOnNode);
        }
        if ((currentTextOnArc = this.arcText.isSelected()) != this.initialTextOnArc) {
            this.initialTextOnArc = currentTextOnArc;
            User.setTextVisibilityOnArc(this.initialTextOnArc);
        }
        if ((currentTextOnPort = this.portText.isSelected()) != this.initialTextOnPort) {
            this.initialTextOnPort = currentTextOnPort;
            User.setTextVisibilityOnPort(this.initialTextOnPort);
        }
        if ((currentTextOnExport = this.exportText.isSelected()) != this.initialTextOnExport) {
            this.initialTextOnExport = currentTextOnExport;
            User.setTextVisibilityOnExport(this.initialTextOnExport);
        }
        if ((currentTextOnAnnotation = this.annotationText.isSelected()) != this.initialTextOnAnnotation) {
            this.initialTextOnAnnotation = currentTextOnAnnotation;
            User.setTextVisibilityOnAnnotation(this.initialTextOnAnnotation);
        }
        if ((currentTextOnInstance = this.instanceNames.isSelected()) != this.initialTextOnInstance) {
            this.initialTextOnInstance = currentTextOnInstance;
            User.setTextVisibilityOnInstance(this.initialTextOnInstance);
        }
        if ((currentTextOnCell = this.cellText.isSelected()) != this.initialTextOnCell) {
            this.initialTextOnCell = currentTextOnCell;
            User.setTextVisibilityOnCell(this.initialTextOnCell);
        }
        PixelDrawing.clearSubCellCache();
        EditWindow.repaintAllContents();
    }

    private void initComponents() {
        this.apply = new JButton();
        this.ok = new JButton();
        this.layerPane = new JScrollPane();
        this.technology = new JComboBox();
        this.jLabel1 = new JLabel();
        this.nodeText = new JCheckBox();
        this.arcText = new JCheckBox();
        this.portText = new JCheckBox();
        this.exportText = new JCheckBox();
        this.annotationText = new JCheckBox();
        this.instanceNames = new JCheckBox();
        this.cellText = new JCheckBox();
        this.allVisible = new JButton();
        this.allInvisible = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cancel = new JButton();
        this.makeVisible = new JButton();
        this.makeInvisible = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.toggleHighlight = new JButton();
        this.unhighlightAll = new JButton();
        this.jSeparator3 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Layer Visibility");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LayerVisibility.this.closeDialog(evt);
            }
        });
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.apply(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.layerPane.setMinimumSize(new Dimension(100, 300));
        this.layerPane.setPreferredSize(new Dimension(100, 300));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.layerPane, gridBagConstraints);
        this.technology.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.technologyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.technology, gridBagConstraints);
        this.jLabel1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.nodeText.setText("Node text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.nodeText, gridBagConstraints);
        this.arcText.setText("Arc text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.arcText, gridBagConstraints);
        this.portText.setText("Port text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.portText, gridBagConstraints);
        this.exportText.setText("Export text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.exportText, gridBagConstraints);
        this.annotationText.setText("Annotation text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.annotationText, gridBagConstraints);
        this.instanceNames.setText("Instance names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.instanceNames, gridBagConstraints);
        this.cellText.setText("Cell text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.cellText, gridBagConstraints);
        this.allVisible.setText("All Visible");
        this.allVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.allVisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.allVisible, gridBagConstraints);
        this.allInvisible.setText("All Invisible");
        this.allInvisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.allInvisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.allInvisible, gridBagConstraints);
        this.jLabel3.setText("Cheked layers are visibile; double-click to toggle.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Text visibility options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.makeVisible.setText("Make Visible");
        this.makeVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.makeVisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.getContentPane().add((Component)this.makeVisible, gridBagConstraints);
        this.makeInvisible.setText("Make Invisible");
        this.makeInvisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.makeInvisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        this.getContentPane().add((Component)this.makeInvisible, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.toggleHighlight.setText("Toggle Highlight");
        this.toggleHighlight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.toggleHighlightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        this.getContentPane().add((Component)this.toggleHighlight, gridBagConstraints);
        this.unhighlightAll.setText("Unhighlight All");
        this.unhighlightAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerVisibility.this.unhighlightAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.unhighlightAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.pack();
    }

    private void toggleHighlightActionPerformed(ActionEvent evt) {
        this.toggleHighlight();
    }

    private void unhighlightAllActionPerformed(ActionEvent evt) {
        this.clearAllHighlight();
    }

    private void makeInvisibleActionPerformed(ActionEvent evt) {
        this.setVisibility(false);
    }

    private void makeVisibleActionPerformed(ActionEvent evt) {
        this.setVisibility(true);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void allVisibleActionPerformed(ActionEvent evt) {
        this.setAllVisibility(true);
    }

    private void allInvisibleActionPerformed(ActionEvent evt) {
        this.setAllVisibility(false);
    }

    private void technologyActionPerformed(ActionEvent evt) {
        this.showLayersForTechnology();
    }

    private void apply(ActionEvent evt) {
        this.termDialog();
    }

    private void ok(ActionEvent evt) {
        this.termDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

