/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.URL;

public class SmartSpiceOut
extends Simulate {
    SmartSpiceOut() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        if (this.openBinaryInput(fileURL)) {
            return null;
        }
        SmartSpiceOut.startProgressDialog("SmartSpice output", fileURL.getFile());
        Stimuli sd = this.readRawSmartSpiceFile(cell);
        SmartSpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private Stimuli readRawSmartSpiceFile(Cell cell) throws IOException {
        String line;
        boolean first = true;
        int signalCount = -1;
        AnalogSignal[] allSignals = null;
        int rowCount = -1;
        Stimuli sd = null;
        block0: while ((line = this.getLineFromBinary()) != null) {
            int j;
            int i;
            int colonPos;
            if (first) {
                first = false;
                if (line.length() >= 20 && line.substring(16, 20).equals("9007")) {
                    System.out.println("This is an HSPICE file, not a SMARTSPICE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return null;
                }
            }
            if ((colonPos = line.indexOf(58)) < 0) continue;
            String keyWord = line.substring(0, colonPos);
            String restOfLine = line.substring(colonPos + 1).trim();
            if (keyWord.equals("No. Variables")) {
                signalCount = TextUtils.atoi(restOfLine) - 1;
                continue;
            }
            if (keyWord.equals("No. Points")) {
                rowCount = TextUtils.atoi(restOfLine);
                continue;
            }
            if (keyWord.equals("Variables")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return null;
                }
                sd = new Stimuli();
                sd.setCell(cell);
                allSignals = new AnalogSignal[signalCount];
                for (i = 0; i <= signalCount; ++i) {
                    int nameEnd;
                    int nameStart;
                    int indexOnLine;
                    if (i != 0) {
                        restOfLine = this.getLineFromBinary();
                        if (restOfLine == null) continue block0;
                        restOfLine = restOfLine.trim();
                    }
                    if ((indexOnLine = TextUtils.atoi(restOfLine)) != i) {
                        System.out.println("Warning: Variable " + i + " has number " + indexOnLine);
                    }
                    for (nameStart = 0; nameStart < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameStart)); ++nameStart) {
                    }
                    while (nameStart < restOfLine.length() && Character.isWhitespace(restOfLine.charAt(nameStart))) {
                        ++nameStart;
                    }
                    for (nameEnd = nameStart; nameEnd < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameEnd)); ++nameEnd) {
                    }
                    String name = restOfLine.substring(nameStart, nameEnd);
                    if (name.startsWith("v(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    }
                    if (i == 0) {
                        if (name.equals("time")) continue;
                        System.out.println("Warning: the first variable should be time, is '" + name + "'");
                        continue;
                    }
                    AnalogSignal as = new AnalogSignal(sd);
                    int lastDotPos = name.lastIndexOf(46);
                    if (lastDotPos >= 0) {
                        as.setSignalContext(name.substring(0, lastDotPos));
                        as.setSignalName(name.substring(lastDotPos + 1));
                    } else {
                        as.setSignalName(name);
                    }
                    allSignals[i - 1] = as;
                }
                continue;
            }
            if (keyWord.equals("Values")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return null;
                }
                if (rowCount < 0) {
                    System.out.println("Missing point count in file");
                    return null;
                }
                sd.buildCommonTime(rowCount);
                for (i = 0; i < signalCount; ++i) {
                    allSignals[i].buildValues(rowCount);
                }
                double[] timeValues = new double[rowCount];
                for (j = 0; j < rowCount && (line = this.getLineFromBinary()) != null; ++j) {
                    int spacePos;
                    if (TextUtils.atoi(line) != j) {
                        System.out.println("Warning: data point " + j + " has number " + TextUtils.atoi(line));
                    }
                    if ((spacePos = line.indexOf(32)) >= 0) {
                        line = line.substring(spacePos + 1);
                    }
                    double time = TextUtils.atof(line.trim());
                    sd.setCommonTime(j, time);
                    for (int i2 = 0; i2 < signalCount && (line = this.getLineFromBinary()) != null; ++i2) {
                        double value = TextUtils.atof(line.trim());
                        allSignals[i2].setValue(j, value);
                    }
                }
            }
            if (!keyWord.equals("Binary")) continue;
            if (signalCount < 0) {
                System.out.println("Missing variable count in file");
                return null;
            }
            if (rowCount < 0) {
                System.out.println("Missing point count in file");
                return null;
            }
            sd.buildCommonTime(rowCount);
            for (int i3 = 0; i3 < signalCount; ++i3) {
                allSignals[i3].buildValues(rowCount);
            }
            double[] timeValues = new double[rowCount];
            for (j = 0; j < rowCount; ++j) {
                double time = this.dataInputStream.readDouble();
                sd.setCommonTime(j, time);
                for (int i4 = 0; i4 < signalCount; ++i4) {
                    double value = this.dataInputStream.readDouble();
                    allSignals[i4].setValue(j, value);
                }
            }
        }
        return sd;
    }
}

