/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LibToTech {
    private static final int HASDRCMINWID = 1;
    private static final int HASDRCMINWIDR = 2;
    private static final int HASCOLORMAP = 4;
    private static final int HASARCWID = 8;
    private static final int HASCIF = 16;
    private static final int HASDXF = 32;
    private static final int HASGDS = 64;
    private static final int HASGRAB = 128;
    private static final int HASSPIRES = 256;
    private static final int HASSPICAP = 512;
    private static final int HASSPIECAP = 1024;
    private static final int HAS3DINFO = 2048;
    private static final int HASCONDRC = 4096;
    private static final int HASCONDRCR = 8192;
    private static final int HASUNCONDRC = 16384;
    private static final int HASUNCONDRCR = 32768;
    private static final int HASCONDRCW = 65536;
    private static final int HASCONDRCWR = 131072;
    private static final int HASUNCONDRCW = 262144;
    private static final int HASUNCONDRCWR = 524288;
    private static final int HASCONDRCM = 0x100000;
    private static final int HASCONDRCMR = 0x200000;
    private static final int HASUNCONDRCM = 0x400000;
    private static final int HASUNCONDRCMR = 0x800000;
    private static final int HASEDGEDRC = 0x1000000;
    private static final int HASEDGEDRCR = 0x2000000;
    private static final int HASMINNODE = 0x4000000;
    private static final int HASMINNODER = 0x8000000;
    private static final int HASPRINTCOL = 0x10000000;
    private static final int TOEDGELEFT = 1;
    private static final int TOEDGERIGHT = 2;
    private static final int TOEDGETOP = 4;
    private static final int TOEDGEBOT = 8;
    private static final int FROMCENTX = 16;
    private static final int FROMCENTY = 32;
    private static final int RATIOCENTX = 64;
    private static final int RATIOCENTY = 128;

    public static void makeTechFromLib() {
        GenerateTechnology dialog = new GenerateTechnology();
        dialog.initComponents();
        dialog.setVisible(true);
    }

    private static void makeTech(String newName, String renameName, boolean alsoJava) {
        String fileName;
        int i;
        Library lib = Library.getCurrent();
        String newTechName = newName;
        boolean modified = false;
        while (Technology.findTechnology(newTechName) != null) {
            newTechName = newTechName + "X";
            modified = true;
        }
        if (modified) {
            System.out.println("Warning: already a technology called " + newName + ".  Naming this " + newTechName);
        }
        Library[] dependentLibs = Info.getDependentLibraries(lib);
        Cell np = null;
        for (int i2 = dependentLibs.length - 1; i2 >= 0 && (np = dependentLibs[i2].findNodeProto("factors")) == null; --i2) {
        }
        if (np == null) {
            System.out.println("Cell with general information, called 'factors', is missing");
            return;
        }
        GeneralInfo gi = GeneralInfo.parseCell(np);
        LayerInfo[] lList = LibToTech.extractLayers(dependentLibs);
        if (lList == null) {
            return;
        }
        ArcInfo[] aList = LibToTech.extractArcs(dependentLibs, lList);
        if (aList == null) {
            return;
        }
        NodeInfo[] nList = LibToTech.extractNodes(dependentLibs, lList, aList);
        if (nList == null) {
            return;
        }
        SoftTech tech = new SoftTech(newTechName);
        tech.setTheScale(gi.scale);
        tech.setTechDesc(gi.description);
        tech.setMinResistance(gi.minRes);
        tech.setMinCapacitance(gi.minCap);
        tech.setGateLengthSubtraction(gi.gateShrinkage);
        tech.setGateIncluded(gi.includeGateInResistance);
        tech.setGroundNetIncluded(gi.includeGround);
        if (gi.transparentColors != null) {
            tech.setTransparentColors(gi.transparentColors);
        }
        for (i = 0; i < lList.length; ++i) {
            Layer lay = Layer.newInstance(tech, lList[i].name, lList[i].desc);
            lay.setFunction(lList[i].fun, lList[i].funExtra);
            lay.setCIFLayer(lList[i].cif);
            lay.setGDSLayer(lList[i].gds);
            lay.setResistance(lList[i].spiRes);
            lay.setCapacitance(lList[i].spiCap);
            lay.setEdgeCapacitance(lList[i].spiECap);
            lay.setDistance(lList[i].height3d);
            lay.setThickness(lList[i].thick3d);
            lList[i].generated = lay;
        }
        for (i = 0; i < aList.length; ++i) {
            ArcInfo.LayerDetails[] ad = aList[i].arcDetails;
            Technology.ArcLayer[] arcLayers = new Technology.ArcLayer[ad.length];
            for (int j = 0; j < ad.length; ++j) {
                arcLayers[j] = new Technology.ArcLayer(ad[j].layer.generated, ad[j].width, ad[j].style);
            }
            ArcProto newArc = ArcProto.newInstance(tech, aList[i].name, aList[i].maxWidth, arcLayers);
            newArc.setFunction(aList[i].func);
            newArc.setFactoryFixedAngle(aList[i].fixAng);
            if (aList[i].wipes) {
                newArc.setWipable();
            } else {
                newArc.clearWipable();
            }
            newArc.setFactoryAngleIncrement(aList[i].angInc);
            newArc.setExtended(!aList[i].noExtend);
            newArc.setWidthOffset(aList[i].widthOffset);
            ERC.getERCTool().setAntennaRatio(newArc, aList[i].antennaRatio);
            aList[i].generated = newArc;
        }
        for (i = 0; i < nList.length; ++i) {
            PrimitiveNode prim;
            NodeInfo.LayerDetails[] nd = nList[i].nodeLayers;
            Technology.NodeLayer[] nodeLayers = new Technology.NodeLayer[nd.length];
            for (int j = 0; j < nd.length; ++j) {
                LayerInfo li = nd[j].layer;
                Layer lay = li.generated;
                Technology.TechPoint[] points = nd[j].values;
                nodeLayers[j] = nList[i].specialType == 1 ? new Technology.NodeLayer(lay, nd[j].portIndex, nd[j].style, nd[j].representation, points, nd[j].lWidth, nd[j].rWidth, nd[j].extendB, nd[j].extendT) : new Technology.NodeLayer(lay, nd[j].portIndex, nd[j].style, nd[j].representation, points);
            }
            nList[i].generated = prim = PrimitiveNode.newInstance(nList[i].name, tech, nList[i].xSize, nList[i].ySize, nList[i].so, nodeLayers);
            prim.setFunction(nList[i].func);
            if (nList[i].wipes) {
                prim.setWipeOn1or2();
            }
            if (nList[i].square) {
                prim.setSquare();
            }
            if (nList[i].lockable) {
                prim.setLockedPrim();
            }
            switch (nList[i].specialType) {
                case 1: {
                    prim.setHoldsOutline();
                    prim.setCanShrink();
                    prim.setSpecialValues(nList[i].specialValues);
                    prim.setSpecialType(nList[i].specialType);
                    break;
                }
                case 3: {
                    prim.setSpecialValues(nList[i].specialValues);
                    prim.setSpecialType(nList[i].specialType);
                    break;
                }
                case 2: {
                    prim.setHoldsOutline();
                    prim.setSpecialType(nList[i].specialType);
                }
            }
            if (nList[i].func == PrimitiveNode.Function.NODE) {
                prim.setHoldsOutline();
            } else if (nList[i].func == PrimitiveNode.Function.PIN && !prim.isWipeOn1or2()) {
                prim.setArcsWipe();
                prim.setArcsShrink();
            }
            int numPorts = nList[i].nodePortDetails.length;
            PrimitivePort[] portList = new PrimitivePort[numPorts];
            for (int j = 0; j < numPorts; ++j) {
                NodeInfo.PortDetails portDetail = nList[i].nodePortDetails[j];
                int numConns = portDetail.connections.length;
                ArcProto[] cons = new ArcProto[numConns];
                for (int k = 0; k < numConns; ++k) {
                    cons[k] = portDetail.connections[k].generated;
                }
                portList[j] = PrimitivePort.newInstance(tech, prim, cons, portDetail.name, portDetail.angle, portDetail.range, portDetail.netIndex, PortCharacteristic.UNKNOWN, portDetail.values[0].getX(), portDetail.values[0].getY(), portDetail.values[1].getX(), portDetail.values[1].getY());
            }
            prim.addPrimitivePorts(portList);
        }
        block16: for (i = 0; i < lList.length; ++i) {
            if ((lList[i].funExtra & 0x1000) != 0) continue;
            for (int j = 0; j < nList.length; ++j) {
                if (nList[j].func != PrimitiveNode.Function.NODE) continue;
                NodeInfo.LayerDetails nld = nList[j].nodeLayers[0];
                if (nld.layer != lList[i]) continue;
                lList[i].generated.setPureLayerNode(nList[j].generated);
                continue block16;
            }
        }
        Generic.tech.makeUnivList();
        LibToTech.checkAndWarn(lList, aList, nList);
        if (alsoJava && (fileName = OpenFile.chooseOutputFile(FileType.JAVA, "File for Technology's Java Code", newTechName + ".java")) != null) {
            Object fileOutputStream = null;
            try {
                PrintStream buffWriter = new PrintStream(new FileOutputStream(fileName));
                LibToTech.dumpLayersToJava(buffWriter, newTechName, lList, gi);
                LibToTech.dumpArcsToJava(buffWriter, newTechName, aList, gi);
                LibToTech.dumpNodesToJava(buffWriter, newTechName, nList, lList, gi);
                buffWriter.println("}");
                buffWriter.close();
                System.out.println("Wrote " + fileName);
            }
            catch (IOException e) {
                System.out.println("Error creating " + fileName);
            }
        }
        System.out.println("Technology " + tech.getTechName() + " built.");
        WindowFrame.updateTechnologyLists();
    }

    private static void checkAndWarn(LayerInfo[] lList, ArcInfo[] aList, NodeInfo[] nList) {
        NodeInfo nIn;
        int j;
        boolean found;
        int i;
        for (i = 0; i < lList.length; ++i) {
            if ((lList[i].funExtra & 0x1000) != 0) continue;
            found = false;
            for (j = 0; j < nList.length; ++j) {
                nIn = nList[j];
                if (nIn.func != PrimitiveNode.Function.NODE || nIn.nodeLayers[0].layer != lList[i]) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("Warning: Layer " + lList[i].name + " has no associated pure-layer node");
        }
        for (i = 0; i < aList.length; ++i) {
            found = false;
            for (j = 0; j < nList.length; ++j) {
                nIn = nList[j];
                if (nIn.func != PrimitiveNode.Function.PIN) continue;
                for (int k = 0; k < nIn.nodePortDetails.length; ++k) {
                    ArcInfo[] connections = nIn.nodePortDetails[k].connections;
                    for (int l = 0; l < connections.length; ++l) {
                        if (connections[l] != aList[i]) continue;
                        boolean allPseudo = true;
                        for (int m = 0; m < nIn.nodeLayers.length; ++m) {
                            LayerInfo lin = nIn.nodeLayers[m].layer;
                            if ((lin.funExtra & 0x1000) != 0) continue;
                            allPseudo = false;
                            break;
                        }
                        if (!allPseudo) {
                            System.out.println("Warning: Pin " + nIn.name + " is not composed of pseudo-layers");
                        }
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (found) break;
            }
            if (found) continue;
            System.out.println("Warning: Arc " + aList[i].name + " has no associated pin node");
        }
    }

    private static LayerInfo[] extractLayers(Library[] dependentLibs) {
        Cell[] layerCells = Info.findCellSequence(dependentLibs, "layer-", Info.LAYERSEQUENCE_KEY);
        if (layerCells.length <= 0) {
            System.out.println("No layers found");
            return null;
        }
        LayerInfo[] lis = new LayerInfo[layerCells.length];
        for (int i = 0; i < layerCells.length; ++i) {
            lis[i] = LayerInfo.parseCell(layerCells[i]);
            if (lis[i] != null) continue;
        }
        return lis;
    }

    private static ArcInfo[] extractArcs(Library[] dependentLibs, LayerInfo[] lList) {
        Cell[] arcCells = Info.findCellSequence(dependentLibs, "arc-", Info.ARCSEQUENCE_KEY);
        if (arcCells.length <= 0) {
            System.out.println("No arcs found");
            return null;
        }
        ArcInfo[] allArcs = new ArcInfo[arcCells.length];
        for (int i = 0; i < arcCells.length; ++i) {
            Cell np = arcCells[i];
            allArcs[i] = ArcInfo.parseCell(np);
            Example neList = Example.getExamples(np, false);
            if (neList == null) {
                return null;
            }
            if (neList.nextExample != null) {
                LibToTech.pointOutError(null, np);
                System.out.println("Can only be one example of " + np + " but more were found");
                return null;
            }
            double maxWid = -1.0;
            double hWid = -1.0;
            int count = 0;
            Iterator it = neList.samples.iterator();
            while (it.hasNext()) {
                Sample ns = (Sample)it.next();
                double wid = Math.min(ns.node.getXSize(), ns.node.getYSize());
                if (wid > maxWid) {
                    maxWid = wid;
                }
                if (ns.layer == null) {
                    hWid = wid;
                    continue;
                }
                ++count;
            }
            allArcs[i].widthOffset = maxWid - hWid;
            allArcs[i].maxWidth = maxWid;
            if (hWid < 0.0) {
                LibToTech.pointOutError(null, np);
                System.out.println("No highlight layer found in " + np);
                return null;
            }
            allArcs[i].arcDetails = new ArcInfo.LayerDetails[count];
            int layerIndex = 0;
            for (int k = 0; k < 2; ++k) {
                Iterator it2 = neList.samples.iterator();
                while (it2.hasNext()) {
                    Sample ns = (Sample)it2.next();
                    if (ns.layer == null) continue;
                    String sampleLayer = ns.layer.getName().substring(6);
                    LayerInfo li = null;
                    for (int j = 0; j < lList.length; ++j) {
                        if (!sampleLayer.equals(lList[j].name)) continue;
                        li = lList[j];
                        break;
                    }
                    if (li == null) {
                        System.out.println("Cannot find layer " + sampleLayer + ", used in " + np);
                        return null;
                    }
                    if (k == 0 ? li.desc.getTransparentLayer() == 0 : li.desc.getTransparentLayer() != 0) continue;
                    allArcs[i].arcDetails[layerIndex] = new ArcInfo.LayerDetails();
                    allArcs[i].arcDetails[layerIndex].layer = li;
                    Poly.Type style = Poly.Type.CLOSED;
                    if (ns.node.getProto() == Artwork.tech.filledBoxNode) {
                        style = Poly.Type.FILLED;
                    }
                    allArcs[i].arcDetails[layerIndex].style = style;
                    double wid = Math.min(ns.node.getXSize(), ns.node.getYSize());
                    allArcs[i].arcDetails[layerIndex].width = maxWid - wid;
                    ++layerIndex;
                }
            }
        }
        return allArcs;
    }

    private static NodeInfo[] extractNodes(Library[] dependentLibs, LayerInfo[] lList, ArcInfo[] aList) {
        Cell[] nodeCells = Info.findCellSequence(dependentLibs, "node-", Info.NODESEQUENCE_KEY);
        if (nodeCells.length <= 0) {
            System.out.println("No nodes found");
            return null;
        }
        NodeInfo[] nList = new NodeInfo[nodeCells.length];
        int nodeIndex = 0;
        for (int pass = 0; pass < 3; ++pass) {
            for (int m = 0; m < nodeCells.length; ++m) {
                Cell np = nodeCells[m];
                NodeInfo nIn = NodeInfo.parseCell(np);
                Netlist netList = np.acquireUserNetlist();
                if (netList == null) {
                    System.out.println("Sorry, a deadlock technology generation (network information unavailable).  Please try again");
                    return null;
                }
                if (pass == 0 && nIn.func != PrimitiveNode.Function.PIN || pass == 1 && (nIn.func == PrimitiveNode.Function.PIN || nIn.func == PrimitiveNode.Function.NODE) || pass == 2 && nIn.func != PrimitiveNode.Function.NODE) continue;
                if (nIn.func == PrimitiveNode.Function.NODE) {
                    if (nIn.serp) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Pure layer " + nIn.name + " can not be serpentine");
                        return null;
                    }
                    nIn.specialType = 2;
                }
                nList[nodeIndex] = nIn;
                nIn.name = np.getName().substring(5);
                Example neList = Example.getExamples(np, true);
                if (neList == null) {
                    System.out.println("Cannot analyze " + np);
                    return null;
                }
                nIn.xSize = neList.hx - neList.lx;
                nIn.ySize = neList.hy - neList.ly;
                if (LibToTech.associateExamples(neList, np)) {
                    System.out.println("Cannot match different examples in " + np);
                    return null;
                }
                nIn.nodeLayers = LibToTech.makePrimitiveNodeLayers(neList, np, lList);
                if (nIn.nodeLayers == null) {
                    System.out.println("Cannot derive stretching rules for " + np);
                    return null;
                }
                for (int i = 0; i < nIn.nodeLayers.length; ++i) {
                    NodeInfo.LayerDetails nld = nIn.nodeLayers[i];
                    if (!nld.multiCut) continue;
                    nIn.specialType = 3;
                    nIn.specialValues = new double[6];
                    nIn.specialValues[0] = nIn.nodeLayers[i].multiXS;
                    nIn.specialValues[1] = nIn.nodeLayers[i].multiYS;
                    nIn.specialValues[2] = nIn.nodeLayers[i].multiIndent;
                    nIn.specialValues[3] = nIn.nodeLayers[i].multiIndent;
                    nIn.specialValues[4] = nIn.nodeLayers[i].multiSep;
                    nIn.specialValues[5] = nIn.nodeLayers[i].multiSep;
                    NodeInfo.LayerDetails nldLast = nIn.nodeLayers[nIn.nodeLayers.length - 1];
                    NodeInfo.LayerDetails nldMC = nIn.nodeLayers[i];
                    nIn.nodeLayers[i] = nldLast;
                    nIn.nodeLayers[nIn.nodeLayers.length - 1] = nldMC;
                    break;
                }
                int portCount = 0;
                Iterator it = neList.samples.iterator();
                while (it.hasNext()) {
                    Sample ns = (Sample)it.next();
                    if (ns.layer != Generic.tech.portNode) continue;
                    ++portCount;
                }
                if (portCount == 0) {
                    LibToTech.pointOutError(null, np);
                    System.out.println("No ports found in " + np);
                    return null;
                }
                nIn.nodePortDetails = new NodeInfo.PortDetails[portCount];
                int pol1Port = -1;
                int pol2Port = -1;
                int dif1Port = -1;
                int dif2Port = -1;
                int i = 0;
                Iterator it2 = neList.samples.iterator();
                while (it2.hasNext()) {
                    Sample ns = (Sample)it2.next();
                    if (ns.layer != Generic.tech.portNode) continue;
                    nIn.nodePortDetails[i] = new NodeInfo.PortDetails();
                    nIn.nodePortDetails[i].connections = new ArcInfo[0];
                    Variable var = ns.node.getVar(Info.CONNECTION_KEY);
                    if (var != null) {
                        Cell[] arcCells = (Cell[])var.getObject();
                        ArcInfo[] connections = new ArcInfo[arcCells.length];
                        nIn.nodePortDetails[i].connections = connections;
                        boolean portChecked = false;
                        for (int j = 0; j < arcCells.length; ++j) {
                            Cell arcCell = arcCells[j];
                            connections[j] = null;
                            if (arcCell != null) {
                                String cellName = arcCell.getName().substring(4);
                                for (int k = 0; k < aList.length; ++k) {
                                    if (!aList[k].name.equalsIgnoreCase(cellName)) continue;
                                    connections[j] = aList[k];
                                    break;
                                }
                            }
                            if (connections[j] == null) {
                                LibToTech.pointOutError(ns.node, ns.node.getParent());
                                System.out.println("Invalid connection list on port in " + np);
                                return null;
                            }
                            if (portChecked) continue;
                            if (connections[j].func.isPoly()) {
                                if (pol1Port < 0) {
                                    pol1Port = i;
                                    portChecked = true;
                                    continue;
                                }
                                if (pol2Port >= 0) continue;
                                pol2Port = i;
                                portChecked = true;
                                continue;
                            }
                            if (!connections[j].func.isDiffusion()) continue;
                            if (dif1Port < 0) {
                                dif1Port = i;
                                portChecked = true;
                                continue;
                            }
                            if (dif2Port >= 0) continue;
                            dif2Port = i;
                            portChecked = true;
                        }
                    }
                    if (nIn.nodePortDetails[i].connections == null) {
                        return null;
                    }
                    String portName = Info.getPortName(ns.node);
                    if (portName == null) {
                        LibToTech.pointOutError(ns.node, np);
                        System.out.println("Cell " + np.describe(true) + ": port does not have a name");
                        return null;
                    }
                    for (int c = 0; c < portName.length(); ++c) {
                        char str = portName.charAt(c);
                        if (str > ' ' && str < '\u007f') continue;
                        LibToTech.pointOutError(ns.node, np);
                        System.out.println("Invalid port name '" + portName + "' in " + np);
                        return null;
                    }
                    nIn.nodePortDetails[i].name = portName;
                    nIn.nodePortDetails[i].angle = 0;
                    Variable varAngle = ns.node.getVar(Info.PORTANGLE_KEY);
                    if (varAngle != null) {
                        nIn.nodePortDetails[i].angle = (Integer)varAngle.getObject();
                    }
                    nIn.nodePortDetails[i].range = 180;
                    Variable varRange = ns.node.getVar(Info.PORTRANGE_KEY);
                    if (varRange != null) {
                        nIn.nodePortDetails[i].range = (Integer)varRange.getObject();
                    }
                    nIn.nodePortDetails[i].netIndex = i;
                    if (ns.node.getNumConnections() != 0) {
                        Sample oNs;
                        ArcInst ai1 = ((Connection)ns.node.getConnections().next()).getArc();
                        Network net1 = netList.getNetwork(ai1, 0);
                        int j = 0;
                        Iterator oIt = neList.samples.iterator();
                        while (oIt.hasNext() && (oNs = (Sample)oIt.next()) != ns) {
                            ArcInst ai2;
                            Network net2;
                            if (oNs.layer != Generic.tech.portNode) continue;
                            if (oNs.node.getNumConnections() != 0 && net1 == (net2 = netList.getNetwork(ai2 = ((Connection)oNs.node.getConnections().next()).getArc(), 0))) {
                                nIn.nodePortDetails[i].netIndex = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    nIn.nodePortDetails[i].values = ns.values;
                    ++i;
                }
                if (nIn.func == PrimitiveNode.Function.TRANMOS || nIn.func == PrimitiveNode.Function.TRADMOS || nIn.func == PrimitiveNode.Function.TRAPMOS || nIn.func == PrimitiveNode.Function.TRADMES || nIn.func == PrimitiveNode.Function.TRAEMES) {
                    NodeInfo.PortDetails formerPortB;
                    NodeInfo.PortDetails formerPortA;
                    if (pol1Port < 0 || pol2Port < 0 || dif1Port < 0 || dif2Port < 0) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Need 2 gate and 2 active ports on field-effect transistor " + np.describe(true));
                        return null;
                    }
                    if (pol1Port != 0) {
                        if (pol2Port == 0) {
                            formerPortA = nIn.nodePortDetails[pol1Port];
                            formerPortB = nIn.nodePortDetails[pol2Port];
                            int swap = pol1Port;
                            pol1Port = pol2Port;
                            pol2Port = swap;
                            nIn.nodePortDetails[pol1Port] = formerPortA;
                            nIn.nodePortDetails[pol2Port] = formerPortB;
                        } else if (dif1Port == 0) {
                            formerPortA = nIn.nodePortDetails[pol1Port];
                            formerPortB = nIn.nodePortDetails[dif1Port];
                            int swap = pol1Port;
                            pol1Port = dif1Port;
                            dif1Port = swap;
                            nIn.nodePortDetails[pol1Port] = formerPortA;
                            nIn.nodePortDetails[dif1Port] = formerPortB;
                        } else if (dif2Port == 0) {
                            formerPortA = nIn.nodePortDetails[pol1Port];
                            formerPortB = nIn.nodePortDetails[dif2Port];
                            int swap = pol1Port;
                            pol1Port = dif2Port;
                            dif2Port = swap;
                            nIn.nodePortDetails[pol1Port] = formerPortA;
                            nIn.nodePortDetails[dif2Port] = formerPortB;
                        }
                    }
                    if (pol2Port != 2) {
                        if (dif1Port == 2) {
                            formerPortA = nIn.nodePortDetails[pol2Port];
                            formerPortB = nIn.nodePortDetails[dif1Port];
                            int swap = pol2Port;
                            pol2Port = dif1Port;
                            dif1Port = swap;
                            nIn.nodePortDetails[pol2Port] = formerPortA;
                            nIn.nodePortDetails[dif1Port] = formerPortB;
                        } else if (dif2Port == 2) {
                            formerPortA = nIn.nodePortDetails[pol2Port];
                            formerPortB = nIn.nodePortDetails[dif2Port];
                            int swap = pol2Port;
                            pol2Port = dif2Port;
                            dif2Port = swap;
                            nIn.nodePortDetails[pol2Port] = formerPortA;
                            nIn.nodePortDetails[dif2Port] = formerPortB;
                        }
                    }
                    if (dif1Port != 1) {
                        formerPortA = nIn.nodePortDetails[dif1Port];
                        formerPortB = nIn.nodePortDetails[dif2Port];
                        int swap = dif1Port;
                        dif1Port = dif2Port;
                        dif2Port = swap;
                        nIn.nodePortDetails[dif1Port] = formerPortA;
                        nIn.nodePortDetails[dif2Port] = formerPortB;
                    }
                    double x1Pos = (nIn.nodePortDetails[dif1Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() + nIn.nodePortDetails[dif1Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif1Port].values[1].getX().getAdder()) / 2.0;
                    double x2Pos = (nIn.nodePortDetails[dif2Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif2Port].values[0].getX().getAdder() + nIn.nodePortDetails[dif2Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[dif2Port].values[1].getX().getAdder()) / 2.0;
                    double y1Pos = (nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() + nIn.nodePortDetails[dif1Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif1Port].values[1].getY().getAdder()) / 2.0;
                    double y2Pos = (nIn.nodePortDetails[dif2Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif2Port].values[0].getY().getAdder() + nIn.nodePortDetails[dif2Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[dif2Port].values[1].getY().getAdder()) / 2.0;
                    if (Math.abs(x1Pos - x2Pos) > Math.abs(y1Pos - y2Pos)) {
                        if (x1Pos < x2Pos) {
                            NodeInfo.PortDetails formerPortA2 = nIn.nodePortDetails[dif1Port];
                            NodeInfo.PortDetails formerPortB2 = nIn.nodePortDetails[dif2Port];
                            nIn.nodePortDetails[dif1Port] = formerPortA2;
                            nIn.nodePortDetails[dif2Port] = formerPortB2;
                        }
                    } else if (y1Pos < y2Pos) {
                        NodeInfo.PortDetails formerPortA3 = nIn.nodePortDetails[dif1Port];
                        NodeInfo.PortDetails formerPortB3 = nIn.nodePortDetails[dif2Port];
                        nIn.nodePortDetails[dif1Port] = formerPortA3;
                        nIn.nodePortDetails[dif2Port] = formerPortB3;
                    }
                    x1Pos = (nIn.nodePortDetails[pol1Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol1Port].values[0].getX().getAdder() + nIn.nodePortDetails[pol1Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol1Port].values[1].getX().getAdder()) / 2.0;
                    x2Pos = (nIn.nodePortDetails[pol2Port].values[0].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol2Port].values[0].getX().getAdder() + nIn.nodePortDetails[pol2Port].values[1].getX().getMultiplier() * nIn.xSize + nIn.nodePortDetails[pol2Port].values[1].getX().getAdder()) / 2.0;
                    y1Pos = (nIn.nodePortDetails[pol1Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol1Port].values[0].getY().getAdder() + nIn.nodePortDetails[pol1Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol1Port].values[1].getY().getAdder()) / 2.0;
                    y2Pos = (nIn.nodePortDetails[pol2Port].values[0].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol2Port].values[0].getY().getAdder() + nIn.nodePortDetails[pol2Port].values[1].getY().getMultiplier() * nIn.ySize + nIn.nodePortDetails[pol2Port].values[1].getY().getAdder()) / 2.0;
                    if (Math.abs(x1Pos - x2Pos) > Math.abs(y1Pos - y2Pos)) {
                        if (x1Pos > x2Pos) {
                            NodeInfo.PortDetails formerPortA4 = nIn.nodePortDetails[pol1Port];
                            NodeInfo.PortDetails formerPortB4 = nIn.nodePortDetails[pol2Port];
                            nIn.nodePortDetails[pol1Port] = formerPortA4;
                            nIn.nodePortDetails[pol2Port] = formerPortB4;
                        }
                    } else if (y1Pos > y2Pos) {
                        NodeInfo.PortDetails formerPortA5 = nIn.nodePortDetails[pol1Port];
                        NodeInfo.PortDetails formerPortB5 = nIn.nodePortDetails[pol2Port];
                        nIn.nodePortDetails[pol1Port] = formerPortA5;
                        nIn.nodePortDetails[pol2Port] = formerPortB5;
                    }
                }
                int layerCount = 0;
                Iterator it3 = neList.samples.iterator();
                while (it3.hasNext()) {
                    Sample ns = (Sample)it3.next();
                    if (ns.values == null || ns.layer == Generic.tech.portNode || ns.layer == Generic.tech.cellCenterNode || ns.layer == null) continue;
                    ++layerCount;
                }
                if (nIn.serp) {
                    int k;
                    nIn.specialType = 1;
                    int polIndex = -1;
                    int difIndex = -1;
                    for (k = 0; k < nIn.nodeLayers.length; ++k) {
                        int funExtraNew;
                        int funExtraOld;
                        NodeInfo.LayerDetails nld = nIn.nodeLayers[k];
                        if (nld.layer.fun.isPoly()) {
                            polIndex = k;
                            continue;
                        }
                        if (!nld.layer.fun.isDiff() || difIndex >= 0 && ((funExtraOld = nIn.nodeLayers[difIndex].layer.funExtra) == (funExtraNew = nld.layer.funExtra) || (funExtraOld & 0xFFFFFF3F) == 0)) continue;
                        difIndex = k;
                    }
                    if (difIndex < 0 || polIndex < 0) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("No diffusion and polysilicon layers in transistor " + np);
                        return null;
                    }
                    nIn.specialValues = new double[6];
                    nIn.specialValues[0] = layerCount + 1;
                    if (nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() > nIn.nodePortDetails[dif1Port].values[0].getY().getAdder()) {
                        nIn.specialValues[3] = nIn.ySize * nIn.nodeLayers[polIndex].values[1].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getY().getAdder());
                        nIn.specialValues[1] = nIn.xSize * nIn.nodePortDetails[dif1Port].values[0].getX().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[difIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getX().getAdder());
                        nIn.specialValues[2] = nIn.ySize * nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[1].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getY().getAdder());
                        nIn.specialValues[4] = nIn.ySize * nIn.nodePortDetails[pol1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[pol1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[polIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getY().getAdder());
                        nIn.specialValues[5] = nIn.xSize * nIn.nodeLayers[difIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getX().getAdder() - (nIn.xSize * nIn.nodePortDetails[pol1Port].values[1].getX().getMultiplier() + nIn.nodePortDetails[pol1Port].values[1].getX().getAdder());
                    } else {
                        nIn.specialValues[3] = nIn.xSize * nIn.nodeLayers[polIndex].values[1].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[1].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder());
                        nIn.specialValues[1] = nIn.ySize * nIn.nodePortDetails[dif1Port].values[0].getY().getMultiplier() + nIn.nodePortDetails[dif1Port].values[0].getY().getAdder() - (nIn.ySize * nIn.nodeLayers[difIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getY().getAdder());
                        nIn.specialValues[2] = nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder() - (nIn.xSize * nIn.nodePortDetails[dif1Port].values[1].getX().getMultiplier() + nIn.nodePortDetails[dif1Port].values[1].getX().getAdder());
                        nIn.specialValues[4] = nIn.xSize * nIn.nodePortDetails[pol1Port].values[0].getX().getMultiplier() + nIn.nodePortDetails[pol1Port].values[0].getX().getAdder() - (nIn.xSize * nIn.nodeLayers[polIndex].values[0].getX().getMultiplier() + nIn.nodeLayers[polIndex].values[0].getX().getAdder());
                        nIn.specialValues[5] = nIn.ySize * nIn.nodeLayers[difIndex].values[0].getY().getMultiplier() + nIn.nodeLayers[difIndex].values[0].getY().getAdder() - (nIn.ySize * nIn.nodePortDetails[pol1Port].values[1].getY().getMultiplier() + nIn.nodePortDetails[pol1Port].values[1].getY().getAdder());
                    }
                    for (k = 0; k < nIn.nodeLayers.length; ++k) {
                        NodeInfo.LayerDetails nld = nIn.nodeLayers[k];
                        Sample ns = nld.ns;
                        Rectangle2D nodeBounds = ns.node.getBounds();
                        Sample polNs = nIn.nodeLayers[polIndex].ns;
                        Rectangle2D polNodeBounds = polNs.node.getBounds();
                        Sample difNs = nIn.nodeLayers[difIndex].ns;
                        Rectangle2D difNodeBounds = difNs.node.getBounds();
                        if (polNodeBounds.getWidth() > polNodeBounds.getHeight()) {
                            nld.lWidth = nodeBounds.getMaxY() - (ns.parent.ly + ns.parent.hy) / 2.0;
                            nld.rWidth = (ns.parent.ly + ns.parent.hy) / 2.0 - nodeBounds.getMinY();
                            nld.extendT = difNodeBounds.getMinX() - nodeBounds.getMinX();
                        } else {
                            nld.lWidth = nodeBounds.getMaxX() - (ns.parent.lx + ns.parent.hx) / 2.0;
                            nld.rWidth = (ns.parent.lx + ns.parent.hx) / 2.0 - nodeBounds.getMinX();
                            nld.extendT = difNodeBounds.getMinY() - nodeBounds.getMinY();
                        }
                        nld.extendB = nld.extendT;
                    }
                }
                double lX = 0.0;
                double hX = 0.0;
                double lY = 0.0;
                double hY = 0.0;
                boolean found = false;
                Iterator it4 = neList.samples.iterator();
                while (it4.hasNext()) {
                    Sample ns = (Sample)it4.next();
                    if (ns.layer != null) continue;
                    found = true;
                    if (ns.values != null) {
                        boolean err = false;
                        if (ns.values[0].getX().getMultiplier() == -0.5) {
                            lX = ns.values[0].getX().getAdder();
                        } else if (ns.values[0].getX().getMultiplier() == 0.5) {
                            lX = nIn.xSize + ns.values[0].getX().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns.values[0].getY().getMultiplier() == -0.5) {
                            lY = ns.values[0].getY().getAdder();
                        } else if (ns.values[0].getY().getMultiplier() == 0.5) {
                            lY = nIn.ySize + ns.values[0].getY().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns.values[1].getX().getMultiplier() == 0.5) {
                            hX = -ns.values[1].getX().getAdder();
                        } else if (ns.values[1].getX().getMultiplier() == -0.5) {
                            hX = nIn.xSize - ns.values[1].getX().getAdder();
                        } else {
                            err = true;
                        }
                        if (ns.values[1].getY().getMultiplier() == 0.5) {
                            hY = -ns.values[1].getY().getAdder();
                        } else if (ns.values[1].getY().getMultiplier() == -0.5) {
                            hY = nIn.ySize - ns.values[1].getY().getAdder();
                        } else {
                            err = true;
                        }
                        if (!err) continue;
                        LibToTech.pointOutError(ns.node, ns.node.getParent());
                        System.out.println("Highlighting cannot scale from center in " + np);
                        return null;
                    }
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("No rule found for highlight in " + np);
                    return null;
                }
                if (!found) {
                    LibToTech.pointOutError(null, np);
                    System.out.println("No highlight found in " + np);
                    return null;
                }
                if (lX != 0.0 || hX != 0.0 || lY != 0.0 || hY != 0.0) {
                    nList[nodeIndex].so = new SizeOffset(lX, hX, lY, hY);
                }
                ++nodeIndex;
            }
        }
        return nList;
    }

    private static boolean associateExamples(Example neList, Cell np) {
        if (neList.nextExample == null) {
            return false;
        }
        Example ne = neList.nextExample;
        while (ne != null) {
            Sample nsList;
            Sample ns;
            Iterator it = ne.samples.iterator();
            while (it.hasNext()) {
                ns = (Sample)it.next();
                ns.assoc = null;
            }
            it = ne.samples.iterator();
            while (it.hasNext()) {
                Sample thisSample;
                Sample nsList2;
                Iterator oIt;
                ns = (Sample)it.next();
                if (ns.assoc != null) continue;
                if (ns.layer == Generic.tech.cellCenterNode) {
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Grab point should only be in main example of " + np);
                    return true;
                }
                int total = 0;
                Sample nsFound = null;
                Iterator oIt2 = neList.samples.iterator();
                while (oIt2.hasNext()) {
                    Sample nsList3 = (Sample)oIt2.next();
                    if (nsList3.layer != ns.layer) continue;
                    ++total;
                    nsFound = nsList3;
                }
                if (total == 0) {
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Layer " + LibToTech.getSampleName(ns.layer) + " not found in main example of " + np);
                    return true;
                }
                if (total == 1) {
                    ns.assoc = nsFound;
                    continue;
                }
                if (ns.layer == Generic.tech.portNode) {
                    String name = Info.getPortName(ns.node);
                    if (name == null) {
                        LibToTech.pointOutError(ns.node, ns.node.getParent());
                        System.out.println("Cell " + np.describe(true) + ": port does not have a name");
                        return true;
                    }
                    boolean found = false;
                    oIt = neList.samples.iterator();
                    while (oIt.hasNext()) {
                        nsList2 = (Sample)oIt.next();
                        if (nsList2.layer != Generic.tech.portNode) continue;
                        String otherName = Info.getPortName(nsList2.node);
                        if (otherName == null) {
                            LibToTech.pointOutError(nsList2.node, nsList2.node.getParent());
                            System.out.println("Cell " + np.describe(true) + ": port does not have a name");
                            return true;
                        }
                        if (!name.equalsIgnoreCase(otherName)) continue;
                        ns.assoc = nsList2;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LibToTech.pointOutError(null, np);
                    System.out.println("Could not find port " + name + " in all examples of " + np);
                    return true;
                }
                int i = 0;
                Iterator oIt3 = ne.samples.iterator();
                while (oIt3.hasNext()) {
                    Sample nsList4 = (Sample)oIt3.next();
                    if (nsList4.layer != ns.layer) continue;
                    ++i;
                }
                if (total != i) {
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Layer " + LibToTech.getSampleName(ns.layer) + " found " + total + " times in main example, " + i + " in other");
                    System.out.println("Make the counts consistent");
                    return true;
                }
                ArrayList<Sample> mainList = new ArrayList<Sample>();
                i = 0;
                oIt = neList.samples.iterator();
                while (oIt.hasNext()) {
                    nsList2 = (Sample)oIt.next();
                    if (nsList2.layer != ns.layer) continue;
                    mainList.add(nsList2);
                }
                ArrayList<Sample> thisList = new ArrayList<Sample>();
                i = 0;
                Iterator oIt4 = ne.samples.iterator();
                while (oIt4.hasNext()) {
                    Sample nsList5 = (Sample)oIt4.next();
                    if (nsList5.layer != ns.layer) continue;
                    thisList.add(nsList5);
                }
                Collections.sort(mainList, new SampleCoordAscending());
                Collections.sort(thisList, new SampleCoordAscending());
                for (i = 1; i < total; ++i) {
                    thisSample = (Sample)thisList.get(i);
                    Sample lastSample = (Sample)thisList.get(i - 1);
                    Sample thisMainSample = (Sample)mainList.get(i);
                    Sample lastMainSample = (Sample)mainList.get(i - 1);
                    if (thisSample.xPos == lastSample.xPos && thisSample.yPos == lastSample.yPos && thisSample.node.getProto() == lastSample.node.getProto() || thisMainSample.xPos == lastMainSample.xPos && thisMainSample.yPos == lastMainSample.yPos && thisMainSample.node.getProto() == lastMainSample.node.getProto()) break;
                }
                if (i >= total) {
                    for (i = 0; i < total; ++i) {
                        thisSample = (Sample)thisList.get(i);
                        thisSample.assoc = (Sample)mainList.get(i);
                    }
                    continue;
                }
                thisSample = (Sample)thisList.get(i);
                LibToTech.pointOutError(thisSample.node, thisSample.node.getParent());
                System.out.println("Sample " + LibToTech.getSampleName(thisSample.layer) + " is unassociated in " + np);
                return true;
            }
            Iterator oIt = neList.samples.iterator();
            while (oIt.hasNext()) {
                nsList = (Sample)oIt.next();
                nsList.assoc = null;
            }
            oIt = ne.samples.iterator();
            while (oIt.hasNext()) {
                ns.assoc.assoc = ns = (Sample)oIt.next();
            }
            oIt = neList.samples.iterator();
            while (oIt.hasNext()) {
                nsList = (Sample)oIt.next();
                if (nsList.assoc != null || nsList.layer == Generic.tech.cellCenterNode) continue;
                LibToTech.pointOutError(nsList.node, nsList.node.getParent());
                System.out.println("Layer " + LibToTech.getSampleName(nsList.layer) + " found in main example, but not others in " + np);
                return true;
            }
            ne = ne.nextExample;
        }
        return false;
    }

    static void pointOutError(NodeInst ni, Cell cell) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (!(wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)wf.getContent();
        wf.setCellWindow(cell);
        if (ni != null) {
            Highlighter highligher = wnd.getHighlighter();
            highligher.clear();
            highligher.addElectricObject(ni, cell);
            highligher.finished();
        }
    }

    private static Poly.Type getStyle(NodeInst ni) {
        Variable var;
        Poly.Type sty = null;
        if (ni.getProto() == Artwork.tech.filledBoxNode) {
            sty = Poly.Type.FILLED;
        } else if (ni.getProto() == Artwork.tech.boxNode) {
            sty = Poly.Type.CLOSED;
        } else if (ni.getProto() == Artwork.tech.crossedBoxNode) {
            sty = Poly.Type.CROSSED;
        } else if (ni.getProto() == Artwork.tech.filledPolygonNode) {
            sty = Poly.Type.FILLED;
        } else if (ni.getProto() == Artwork.tech.closedPolygonNode) {
            sty = Poly.Type.CLOSED;
        } else if (ni.getProto() == Artwork.tech.openedPolygonNode) {
            sty = Poly.Type.OPENED;
        } else if (ni.getProto() == Artwork.tech.openedDottedPolygonNode) {
            sty = Poly.Type.OPENEDT1;
        } else if (ni.getProto() == Artwork.tech.openedDashedPolygonNode) {
            sty = Poly.Type.OPENEDT2;
        } else if (ni.getProto() == Artwork.tech.openedThickerPolygonNode) {
            sty = Poly.Type.OPENEDT3;
        } else if (ni.getProto() == Artwork.tech.filledCircleNode) {
            sty = Poly.Type.DISC;
        } else if (ni.getProto() == Artwork.tech.circleNode) {
            sty = Poly.Type.CIRCLE;
            double[] angles = ni.getArcDegrees();
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                sty = Poly.Type.CIRCLEARC;
            }
        } else if (ni.getProto() == Artwork.tech.thickCircleNode) {
            sty = Poly.Type.THICKCIRCLE;
            double[] angles = ni.getArcDegrees();
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                sty = Poly.Type.THICKCIRCLEARC;
            }
        } else if (ni.getProto() == Generic.tech.invisiblePinNode && (var = ni.getVar(Artwork.ART_MESSAGE)) != null) {
            TextDescriptor.Position pos = var.getTextDescriptor().getPos();
            if (pos == TextDescriptor.Position.BOXED) {
                sty = Poly.Type.TEXTBOX;
            } else if (pos == TextDescriptor.Position.CENT) {
                sty = Poly.Type.TEXTCENT;
            } else if (pos == TextDescriptor.Position.UP) {
                sty = Poly.Type.TEXTBOT;
            } else if (pos == TextDescriptor.Position.DOWN) {
                sty = Poly.Type.TEXTTOP;
            } else if (pos == TextDescriptor.Position.LEFT) {
                sty = Poly.Type.TEXTRIGHT;
            } else if (pos == TextDescriptor.Position.RIGHT) {
                sty = Poly.Type.TEXTLEFT;
            } else if (pos == TextDescriptor.Position.UPLEFT) {
                sty = Poly.Type.TEXTBOTRIGHT;
            } else if (pos == TextDescriptor.Position.UPRIGHT) {
                sty = Poly.Type.TEXTBOTLEFT;
            } else if (pos == TextDescriptor.Position.DOWNLEFT) {
                sty = Poly.Type.TEXTTOPRIGHT;
            } else if (pos == TextDescriptor.Position.DOWNRIGHT) {
                sty = Poly.Type.TEXTTOPLEFT;
            }
        }
        if (sty == null) {
            System.out.println("Cannot determine style to use for " + ni.getProto() + " node in " + ni.getParent());
        }
        return sty;
    }

    private static NodeInfo.LayerDetails[] makeNodeScaledUniformly(Example neList, NodeProto np, LayerInfo[] lis) {
        int count = 0;
        Iterator it = neList.samples.iterator();
        while (it.hasNext()) {
            Sample ns = (Sample)it.next();
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            ++count;
        }
        NodeInfo.LayerDetails[] nodeLayers = new NodeInfo.LayerDetails[count];
        count = 0;
        Iterator it2 = neList.samples.iterator();
        while (it2.hasNext()) {
            Sample ns = (Sample)it2.next();
            Rectangle2D nodeBounds = LibToTech.getBoundingBox(ns.node);
            AffineTransform trans = ns.node.rotateOut();
            Point2D[] pointList = null;
            int[] pointFactor = null;
            Point2D[] points = null;
            Object var = null;
            if (ns.node.getProto() == Artwork.tech.filledPolygonNode || ns.node.getProto() == Artwork.tech.closedPolygonNode || ns.node.getProto() == Artwork.tech.openedPolygonNode || ns.node.getProto() == Artwork.tech.openedDottedPolygonNode || ns.node.getProto() == Artwork.tech.openedDashedPolygonNode || ns.node.getProto() == Artwork.tech.openedThickerPolygonNode) {
                points = ns.node.getTrace();
            }
            if (points != null) {
                pointList = new Point2D[points.length];
                pointFactor = new int[points.length];
                for (int i = 0; i < points.length; ++i) {
                    pointList[i] = new Point2D.Double(nodeBounds.getCenterX() + points[i].getX(), nodeBounds.getCenterY() + points[i].getY());
                    trans.transform(pointList[i], pointList[i]);
                    pointFactor[i] = 192;
                }
            } else {
                double[] angles = null;
                if ((ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode) && (angles = ns.node.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                    angles = null;
                }
                if (angles != null) {
                    pointList = new Point2D[3];
                    pointFactor = new int[3];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    double dist = nodeBounds.getMaxX() - nodeBounds.getCenterX();
                    pointList[1] = new Point2D.Double(nodeBounds.getCenterX() + dist * Math.cos(angles[0]), nodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                    trans.transform(pointList[1], pointList[1]);
                    pointFactor[0] = 48;
                    pointFactor[1] = 192;
                    pointFactor[2] = 192;
                } else if (ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode || ns.node.getProto() == Artwork.tech.filledCircleNode) {
                    pointList = new Point2D[2];
                    pointFactor = new int[2];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getCenterY());
                    pointFactor[0] = 48;
                    pointFactor[1] = 34;
                } else {
                    pointList = new Point2D[2];
                    pointFactor = new int[2];
                    pointList[0] = new Point2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getMaxY());
                    pointFactor[0] = 9;
                    pointFactor[1] = 6;
                }
            }
            Technology.TechPoint[] newRule = LibToTech.stretchPoints(pointList, pointFactor, ns, np, neList);
            if (newRule == null) {
                System.out.println("Error creating stretch point in " + np);
                return null;
            }
            ns.msg = Info.getValueOnNode(ns.node);
            if (ns.msg != null && ns.msg.length() == 0) {
                ns.msg = null;
            }
            ns.values = newRule;
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            LayerInfo layer = null;
            String desiredLayer = ns.layer.getName().substring(6);
            for (int i = 0; i < lis.length; ++i) {
                if (!desiredLayer.equals(lis[i].name)) continue;
                layer = lis[i];
                break;
            }
            if (layer == null) {
                System.out.println("Cannot find layer " + desiredLayer);
                return null;
            }
            nodeLayers[count] = new NodeInfo.LayerDetails();
            nodeLayers[count].layer = layer;
            nodeLayers[count].ns = ns;
            nodeLayers[count].style = LibToTech.getStyle(ns.node);
            nodeLayers[count].representation = 0;
            if (ns.values.length == 2 && (nodeLayers[count].style == Poly.Type.CROSSED || nodeLayers[count].style == Poly.Type.FILLED || nodeLayers[count].style == Poly.Type.CLOSED)) {
                nodeLayers[count].representation = 1;
                Variable var2 = ns.node.getVar(Info.MINSIZEBOX_KEY);
                if (var2 != null) {
                    nodeLayers[count].representation = 2;
                }
            }
            nodeLayers[count].values = ns.values;
            ++count;
        }
        return nodeLayers;
    }

    private static NodeInfo.LayerDetails[] makePrimitiveNodeLayers(Example neList, Cell np, LayerInfo[] lis) {
        if (neList.nextExample == null) {
            return LibToTech.makeNodeScaledUniformly(neList, np, lis);
        }
        int count = 0;
        Iterator it = neList.samples.iterator();
        while (it.hasNext()) {
            Sample ns = (Sample)it.next();
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            ++count;
        }
        NodeInfo.LayerDetails[] nodeLayers = new NodeInfo.LayerDetails[count];
        count = 0;
        Iterator it2 = neList.samples.iterator();
        while (it2.hasNext()) {
            Technology.TechPoint[] newRule;
            Sample ns = (Sample)it2.next();
            if (ns.layer == Generic.tech.cellCenterNode) continue;
            AffineTransform trans = ns.node.rotateOut();
            Rectangle2D nodeBounds = LibToTech.getBoundingBox(ns.node);
            LayerInfo giLayer = null;
            if (ns.layer != null && ns.layer != Generic.tech.portNode) {
                String desiredLayer = ns.layer.getName().substring(6);
                for (int i = 0; i < lis.length; ++i) {
                    if (!desiredLayer.equals(lis[i].name)) continue;
                    giLayer = lis[i];
                    break;
                }
                if (giLayer == null) {
                    System.out.println("Cannot find layer " + desiredLayer);
                    return null;
                }
            }
            neList.studySample = ns;
            NodeInfo.LayerDetails multiRule = null;
            Example ne = neList.nextExample;
            while (ne != null) {
                int total = 0;
                Iterator oIt = ne.samples.iterator();
                while (oIt.hasNext()) {
                    Sample nso = (Sample)oIt.next();
                    if (nso.assoc != ns) continue;
                    ne.studySample = nso;
                    ++total;
                }
                if (total == 0) {
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Still unassociated sample in " + np + " (shouldn't happen)");
                    return null;
                }
                if (total > 1) {
                    if (ns.layer == null || ns.layer == Generic.tech.portNode) {
                        LibToTech.pointOutError(ns.node, ns.node.getParent());
                        System.out.println("Only contact layers may be iterated in examples of " + np);
                        return null;
                    }
                    multiRule = LibToTech.getMultiCutRule(ns, neList, np);
                    if (multiRule != null) break;
                }
                ne = ne.nextExample;
            }
            if (multiRule != null) {
                multiRule.layer = giLayer;
                nodeLayers[count] = multiRule;
                ++count;
                continue;
            }
            Point2D[] pointList = null;
            int[] pointFactor = null;
            Point2D[] points = null;
            if (ns.node.getProto() == Artwork.tech.filledPolygonNode || ns.node.getProto() == Artwork.tech.closedPolygonNode || ns.node.getProto() == Artwork.tech.openedPolygonNode || ns.node.getProto() == Artwork.tech.openedDottedPolygonNode || ns.node.getProto() == Artwork.tech.openedDashedPolygonNode || ns.node.getProto() == Artwork.tech.openedThickerPolygonNode) {
                points = ns.node.getTrace();
            }
            int trueCount = 0;
            int minFactor = 0;
            if (points != null) {
                pointList = new Point2D[points.length];
                pointFactor = new int[points.length];
                for (int i = 0; i < points.length; ++i) {
                    pointList[i] = new Point2D.Double(nodeBounds.getCenterX() + points[i].getX(), nodeBounds.getCenterY() + points[i].getY());
                    trans.transform(pointList[i], pointList[i]);
                }
                trueCount = points.length;
            } else {
                Variable var2;
                double[] angles = null;
                if ((ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode) && (angles = ns.node.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                    angles = null;
                }
                if (angles == null && (var2 = ns.node.getVar(Info.MINSIZEBOX_KEY)) != null) {
                    minFactor = 2;
                }
                if (angles != null) {
                    pointList = new Point2D[3];
                    pointFactor = new int[3];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    double dist = nodeBounds.getMaxX() - nodeBounds.getCenterX();
                    pointList[1] = new Point2D.Double(nodeBounds.getCenterX() + dist * Math.cos(angles[0]), nodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                    trans.transform(pointList[1], pointList[1]);
                    trueCount = 3;
                } else if (ns.node.getProto() == Artwork.tech.circleNode || ns.node.getProto() == Artwork.tech.thickCircleNode || ns.node.getProto() == Artwork.tech.filledCircleNode) {
                    pointList = new Point2D[2 + minFactor];
                    pointFactor = new int[2 + minFactor];
                    pointList[0] = new Point2D.Double(nodeBounds.getCenterX(), nodeBounds.getCenterY());
                    pointList[0] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getCenterY());
                    trueCount = 2;
                } else {
                    pointList = new Point2D[2 + minFactor];
                    pointFactor = new int[2 + minFactor];
                    pointList[0] = new Point2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY());
                    pointList[1] = new Point2D.Double(nodeBounds.getMaxX(), nodeBounds.getMaxY());
                    trueCount = 2;
                }
                if (minFactor > 1) {
                    pointList[2] = new Point2D.Double(pointList[0].getX(), pointList[0].getY());
                    pointList[3] = new Point2D.Double(pointList[1].getX(), pointList[1].getY());
                }
            }
            double[] pointLeftDist = new double[pointFactor.length];
            double[] pointRightDist = new double[pointFactor.length];
            double[] pointBottomDist = new double[pointFactor.length];
            double[] pointTopDist = new double[pointFactor.length];
            double[] centerXDist = new double[pointFactor.length];
            double[] centerYDist = new double[pointFactor.length];
            double[] pointXRatio = new double[pointFactor.length];
            double[] pointYRatio = new double[pointFactor.length];
            for (int i = 0; i < pointFactor.length; ++i) {
                pointLeftDist[i] = pointList[i].getX() - neList.lx;
                pointRightDist[i] = neList.hx - pointList[i].getX();
                pointBottomDist[i] = pointList[i].getY() - neList.ly;
                pointTopDist[i] = neList.hy - pointList[i].getY();
                centerXDist[i] = pointList[i].getX() - (neList.lx + neList.hx) / 2.0;
                centerYDist[i] = pointList[i].getY() - (neList.ly + neList.hy) / 2.0;
                pointXRatio[i] = neList.hx == neList.lx ? 0.0 : (pointList[i].getX() - (neList.lx + neList.hx) / 2.0) / (neList.hx - neList.lx);
                pointYRatio[i] = neList.hy == neList.ly ? 0.0 : (pointList[i].getY() - (neList.ly + neList.hy) / 2.0) / (neList.hy - neList.ly);
                pointFactor[i] = i < trueCount ? 255 : 48;
            }
            Point2D[] pointCoords = new Point2D[pointFactor.length];
            Example ne2 = neList.nextExample;
            while (ne2 != null) {
                NodeInst ni = ne2.studySample.node;
                AffineTransform oTrans = ni.rotateOut();
                Rectangle2D oNodeBounds = LibToTech.getBoundingBox(ni);
                Point2D[] oPoints = null;
                if (ni.getProto() == Artwork.tech.filledPolygonNode || ni.getProto() == Artwork.tech.closedPolygonNode || ni.getProto() == Artwork.tech.openedPolygonNode || ni.getProto() == Artwork.tech.openedDottedPolygonNode || ni.getProto() == Artwork.tech.openedDashedPolygonNode || ni.getProto() == Artwork.tech.openedThickerPolygonNode) {
                    oPoints = ni.getTrace();
                }
                int newCount = 2;
                if (oPoints != null) {
                    newCount = oPoints.length;
                    int numPoints = Math.min(trueCount, newCount);
                    int bestOffset = 0;
                    double bestDist = Double.MAX_VALUE;
                    for (int offset = 0; offset < numPoints; ++offset) {
                        double dist = 0.0;
                        for (int i = 0; i < numPoints; ++i) {
                            double dX = points[i].getX() - oPoints[(i + offset) % numPoints].getX();
                            double dY = points[i].getY() - oPoints[(i + offset) % numPoints].getY();
                            dist += Math.sqrt(dX * dX + dY * dY);
                        }
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                        bestOffset = offset;
                    }
                    for (int i = 0; i < numPoints; ++i) {
                        pointCoords[i] = new Point2D.Double(oNodeBounds.getCenterX() + oPoints[(i + bestOffset) % numPoints].getX(), oNodeBounds.getCenterY() + oPoints[(i + bestOffset) % numPoints].getY());
                        oTrans.transform(pointCoords[i], pointCoords[i]);
                    }
                } else {
                    double[] angles = null;
                    if ((ni.getProto() == Artwork.tech.circleNode || ni.getProto() == Artwork.tech.thickCircleNode) && (angles = ni.getArcDegrees())[0] == 0.0 && angles[1] == 0.0) {
                        angles = null;
                    }
                    if (angles != null) {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getCenterX(), oNodeBounds.getCenterY());
                        double dist = oNodeBounds.getMaxX() - oNodeBounds.getCenterX();
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getCenterX() + dist * Math.cos(angles[0]), oNodeBounds.getCenterY() + dist * Math.sin(angles[0]));
                        oTrans.transform(pointCoords[1], pointCoords[1]);
                    } else if (ni.getProto() == Artwork.tech.circleNode || ni.getProto() == Artwork.tech.thickCircleNode || ni.getProto() == Artwork.tech.filledCircleNode) {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getCenterX(), oNodeBounds.getCenterY());
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getMaxX(), oNodeBounds.getCenterY());
                    } else {
                        pointCoords[0] = new Point2D.Double(oNodeBounds.getMinX(), oNodeBounds.getMinY());
                        pointCoords[1] = new Point2D.Double(oNodeBounds.getMaxX(), oNodeBounds.getMaxY());
                    }
                }
                if (newCount != trueCount) {
                    LibToTech.pointOutError(ni, ni.getParent());
                    System.out.println("Main example of " + LibToTech.getSampleName(ne2.studySample.layer) + " has " + trueCount + " points but this has " + newCount + " in " + np);
                    return null;
                }
                for (int i = 0; i < trueCount; ++i) {
                    if (!DBMath.areEquals(pointLeftDist[i], pointCoords[i].getX() - ne2.lx)) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFFE;
                    }
                    if (!DBMath.areEquals(pointRightDist[i], ne2.hx - pointCoords[i].getX())) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFFD;
                    }
                    if (!DBMath.areEquals(pointBottomDist[i], pointCoords[i].getY() - ne2.ly)) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFF7;
                    }
                    if (!DBMath.areEquals(pointTopDist[i], ne2.hy - pointCoords[i].getY())) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFFB;
                    }
                    if (!DBMath.areEquals(centerXDist[i], pointCoords[i].getX() - (ne2.lx + ne2.hx) / 2.0)) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFEF;
                    }
                    if (!DBMath.areEquals(centerYDist[i], pointCoords[i].getY() - (ne2.ly + ne2.hy) / 2.0)) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFDF;
                    }
                    double r = 0.0;
                    if (ne2.hx != ne2.lx) {
                        r = (pointCoords[i].getX() - (ne2.lx + ne2.hx) / 2.0) / (ne2.hx - ne2.lx);
                    }
                    if (!DBMath.areEquals(r, pointXRatio[i])) {
                        int n = i;
                        pointFactor[n] = pointFactor[n] & 0xFFFFFFBF;
                    }
                    if (DBMath.areEquals(r = ne2.hy == ne2.ly ? 0.0 : (pointCoords[i].getY() - (ne2.ly + ne2.hy) / 2.0) / (ne2.hy - ne2.ly), pointYRatio[i])) continue;
                    int n = i;
                    pointFactor[n] = pointFactor[n] & 0xFFFFFF7F;
                }
                if (ns.layer == Generic.tech.portNode) {
                    Variable var = ns.node.getVar(Info.PORTANGLE_KEY);
                    Variable var2 = ni.getVar(Info.PORTANGLE_KEY);
                    if (var == null && var2 != null) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Warning: moving port angle to main example of " + np);
                        ns.node.newVar(Info.PORTANGLE_KEY, var2.getObject());
                    }
                    var = ns.node.getVar(Info.PORTRANGE_KEY);
                    var2 = ni.getVar(Info.PORTRANGE_KEY);
                    if (var == null && var2 != null) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Warning: moving port range to main example of " + np);
                        ns.node.newVar(Info.PORTRANGE_KEY, var2.getObject());
                    }
                    var = ns.node.getVar(Info.CONNECTION_KEY);
                    var2 = ni.getVar(Info.CONNECTION_KEY);
                    if (var == null && var2 != null) {
                        LibToTech.pointOutError(null, np);
                        System.out.println("Warning: moving port connections to main example of " + np);
                        ns.node.newVar(Info.CONNECTION_KEY, var2.getObject());
                    }
                }
                ne2 = ne2.nextExample;
            }
            if (ns.layer == null) {
                for (int i = 0; i < trueCount; ++i) {
                    if ((pointFactor[i] & 3) != 0 && (pointFactor[i] & 0xC) != 0) continue;
                    LibToTech.pointOutError(ns.node, ns.node.getParent());
                    System.out.println("Highlight must be constant distance from edge in " + np);
                    return null;
                }
            }
            if ((newRule = LibToTech.stretchPoints(pointList, pointFactor, ns, np, neList)) == null) {
                return null;
            }
            ns.msg = Info.getValueOnNode(ns.node);
            if (ns.msg != null && ns.msg.length() == 0) {
                ns.msg = null;
            }
            ns.values = newRule;
            if (ns.layer == null || ns.layer == Generic.tech.portNode) continue;
            nodeLayers[count] = new NodeInfo.LayerDetails();
            nodeLayers[count].layer = giLayer;
            nodeLayers[count].ns = ns;
            nodeLayers[count].style = LibToTech.getStyle(ns.node);
            nodeLayers[count].representation = 0;
            if (ns.values.length == 2 && (nodeLayers[count].style == Poly.Type.CROSSED || nodeLayers[count].style == Poly.Type.FILLED || nodeLayers[count].style == Poly.Type.CLOSED)) {
                nodeLayers[count].representation = 1;
                if (minFactor != 0) {
                    nodeLayers[count].representation = 2;
                }
            }
            nodeLayers[count].values = ns.values;
            ++count;
        }
        if (count != nodeLayers.length) {
            System.out.println("Generated only " + count + " of " + nodeLayers.length + " layers for " + np);
        }
        return nodeLayers;
    }

    private static Rectangle2D getBoundingBox(NodeInst ni) {
        Rectangle2D bounds = ni.getBounds();
        if (ni.getProto() == Generic.tech.portNode) {
            double portShrink = 2.0;
            bounds.setRect(bounds.getMinX() + portShrink, bounds.getMinY() + portShrink, bounds.getWidth() - portShrink * 2.0, bounds.getHeight() - portShrink * 2.0);
        }
        bounds.setRect(DBMath.round(bounds.getMinX()), DBMath.round(bounds.getMinY()), DBMath.round(bounds.getWidth()), DBMath.round(bounds.getHeight()));
        return bounds;
    }

    private static Technology.TechPoint[] stretchPoints(Point2D[] pts, int[] factor, Sample ns, NodeProto np, Example neList) {
        Technology.TechPoint[] newRule = new Technology.TechPoint[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            EdgeH horiz = null;
            if ((factor[i] & 1) != 0) {
                horiz = EdgeH.fromLeft(pts[i].getX() - neList.lx);
            } else if ((factor[i] & 2) != 0) {
                horiz = EdgeH.fromRight(neList.hx - pts[i].getX());
            } else if ((factor[i] & 0x10) != 0) {
                horiz = EdgeH.fromCenter(pts[i].getX() - (neList.lx + neList.hx) / 2.0);
            } else if ((factor[i] & 0x40) != 0) {
                horiz = neList.hx == neList.lx ? EdgeH.makeCenter() : new EdgeH((pts[i].getX() - (neList.lx + neList.hx) / 2.0) / (neList.hx - neList.lx), 0.0);
            } else {
                LibToTech.pointOutError(ns.node, ns.node.getParent());
                System.out.println("Cannot determine X stretching rule for layer " + LibToTech.getSampleName(ns.layer) + " in " + np);
                return null;
            }
            EdgeV vert = null;
            if ((factor[i] & 8) != 0) {
                vert = EdgeV.fromBottom(pts[i].getY() - neList.ly);
            } else if ((factor[i] & 4) != 0) {
                vert = EdgeV.fromTop(neList.hy - pts[i].getY());
            } else if ((factor[i] & 0x20) != 0) {
                vert = EdgeV.fromCenter(pts[i].getY() - (neList.ly + neList.hy) / 2.0);
            } else if ((factor[i] & 0x80) != 0) {
                vert = neList.hy == neList.ly ? EdgeV.makeCenter() : new EdgeV((pts[i].getY() - (neList.ly + neList.hy) / 2.0) / (neList.hy - neList.ly), 0.0);
            } else {
                LibToTech.pointOutError(ns.node, ns.node.getParent());
                System.out.println("Cannot determine Y stretching rule for layer " + LibToTech.getSampleName(ns.layer) + " in " + np);
                return null;
            }
            newRule[i] = new Technology.TechPoint(horiz, vert);
        }
        return newRule;
    }

    private static Sample needHighlightLayer(Example neList, Cell np) {
        Iterator it = neList.samples.iterator();
        while (it.hasNext()) {
            Sample ns = (Sample)it.next();
            if (ns.layer != null) continue;
            return ns;
        }
        LibToTech.pointOutError(null, np);
        System.out.println("No highlight layer on contact " + np.describe(true));
        return null;
    }

    private static NodeInfo.LayerDetails getMultiCutRule(Sample ns, Example neList, Cell np) {
        Sample hs = LibToTech.needHighlightLayer(neList, np);
        if (hs == null) {
            return null;
        }
        Rectangle2D highlightBounds = hs.node.getBounds();
        Rectangle2D nodeBounds = ns.node.getBounds();
        double multiXS = nodeBounds.getWidth();
        double multiYS = nodeBounds.getHeight();
        double multiIndent = nodeBounds.getMinX() - highlightBounds.getMinX();
        if (highlightBounds.getMaxX() - nodeBounds.getMaxX() != multiIndent || nodeBounds.getMinY() - highlightBounds.getMinY() != multiIndent || highlightBounds.getMaxY() - nodeBounds.getMaxY() != multiIndent) {
            LibToTech.pointOutError(ns.node, ns.node.getParent());
            System.out.println("Multiple contact cuts must be indented uniformly in " + np);
            return null;
        }
        double xSep = -1.0;
        double ySep = -1.0;
        Example ne = neList.nextExample;
        while (ne != null) {
            double sepY;
            double sepX;
            Rectangle2D lastNodeBounds;
            Rectangle2D thisNodeBounds;
            int i;
            int total = 0;
            Iterator it = ne.samples.iterator();
            while (it.hasNext()) {
                Sample nso = (Sample)it.next();
                if (nso.assoc != ns) continue;
                Rectangle2D oNodeBounds = nso.node.getBounds();
                if (multiXS != oNodeBounds.getWidth() || multiYS != oNodeBounds.getHeight()) {
                    LibToTech.pointOutError(nso.node, nso.node.getParent());
                    System.out.println("Multiple contact cuts must not differ in size in " + np);
                    return null;
                }
                ++total;
            }
            Sample[] nsList = new Sample[total];
            int fill = 0;
            Iterator it2 = ne.samples.iterator();
            while (it2.hasNext()) {
                Sample nso = (Sample)it2.next();
                if (nso.assoc != ns) continue;
                nsList[fill++] = nso;
            }
            for (i = 1; i < total; ++i) {
                thisNodeBounds = nsList[i].node.getBounds();
                lastNodeBounds = nsList[i - 1].node.getBounds();
                sepX = Math.abs(lastNodeBounds.getCenterX() - thisNodeBounds.getCenterX());
                sepY = Math.abs(lastNodeBounds.getCenterY() - thisNodeBounds.getCenterY());
                if (sepX < multiXS && sepY < multiYS) {
                    LibToTech.pointOutError(nsList[i].node, nsList[i].node.getParent());
                    System.out.println("Multiple contact cuts must not overlap in " + np);
                    return null;
                }
                if (sepX >= multiXS) {
                    if (xSep < 0.0) {
                        xSep = sepX;
                    } else if (xSep > sepX) {
                        xSep = sepX;
                    }
                }
                if (!(sepY >= multiYS)) continue;
                if (ySep < 0.0) {
                    ySep = sepY;
                    continue;
                }
                if (!(ySep > sepY)) continue;
                ySep = sepY;
            }
            for (i = 1; i < total; ++i) {
                thisNodeBounds = nsList[i].node.getBounds();
                lastNodeBounds = nsList[i - 1].node.getBounds();
                sepX = Math.abs(lastNodeBounds.getCenterX() - thisNodeBounds.getCenterX());
                sepY = Math.abs(lastNodeBounds.getCenterY() - thisNodeBounds.getCenterY());
                if (sepX / xSep * xSep != sepX) {
                    LibToTech.pointOutError(nsList[i].node, nsList[i].node.getParent());
                    System.out.println("Multiple contact cut X spacing must be uniform in " + np);
                    return null;
                }
                if (sepY / ySep * ySep == sepY) continue;
                LibToTech.pointOutError(nsList[i].node, nsList[i].node.getParent());
                System.out.println("Multiple contact cut Y spacing must be uniform in " + np);
                return null;
            }
            ne = ne.nextExample;
        }
        double multiSep = xSep - multiXS;
        if (multiSep != ySep - multiYS) {
            LibToTech.pointOutError(null, np);
            System.out.println("Multiple contact cut X and Y spacing must be the same in " + np);
            return null;
        }
        ns.values = new Technology.TechPoint[2];
        ns.values[0] = new Technology.TechPoint(EdgeH.fromLeft(1.0), EdgeV.fromBottom(1.0));
        ns.values[1] = new Technology.TechPoint(EdgeH.fromLeft(3.0), EdgeV.fromBottom(3.0));
        NodeInfo.LayerDetails multiDetails = new NodeInfo.LayerDetails();
        multiDetails.style = LibToTech.getStyle(ns.node);
        multiDetails.representation = 0;
        if (multiDetails.style == Poly.Type.CROSSED || multiDetails.style == Poly.Type.FILLED || multiDetails.style == Poly.Type.CLOSED) {
            multiDetails.representation = 1;
            Variable var2 = ns.node.getVar(Info.MINSIZEBOX_KEY);
            if (var2 != null) {
                multiDetails.representation = 2;
            }
        }
        multiDetails.values = ns.values;
        multiDetails.ns = ns;
        multiDetails.multiCut = true;
        multiDetails.multiXS = multiXS;
        multiDetails.multiYS = multiYS;
        multiDetails.multiIndent = multiIndent;
        multiDetails.multiSep = multiSep;
        return multiDetails;
    }

    private static void dumpLayersToJava(PrintStream buffWriter, String techName, LayerInfo[] lList, GeneralInfo gi) {
        int j;
        int i;
        buffWriter.println("// BE SURE TO INCLUDE THIS TECHNOLOGY IN Technology.initAllTechnologies()");
        buffWriter.println();
        buffWriter.println("/* -*- tab-width: 4 -*-");
        buffWriter.println(" *");
        buffWriter.println(" * Electric(tm) VLSI Design System");
        buffWriter.println(" *");
        buffWriter.println(" * File: " + techName + ".java");
        buffWriter.println(" * " + techName + " technology description");
        buffWriter.println(" * Generated automatically from a library");
        buffWriter.println(" *");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        buffWriter.println(" * Copyright (c) " + cal.get(1) + " Sun Microsystems and Static Free Software");
        buffWriter.println(" *");
        buffWriter.println(" * Electric(tm) is free software; you can redistribute it and/or modify");
        buffWriter.println(" * it under the terms of the GNU General Public License as published by");
        buffWriter.println(" * the Free Software Foundation; either version 2 of the License, or");
        buffWriter.println(" * (at your option) any later version.");
        buffWriter.println(" *");
        buffWriter.println(" * Electric(tm) is distributed in the hope that it will be useful,");
        buffWriter.println(" * but WITHOUT ANY WARRANTY; without even the implied warranty of");
        buffWriter.println(" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
        buffWriter.println(" * GNU General Public License for more details.");
        buffWriter.println(" *");
        buffWriter.println(" * You should have received a copy of the GNU General Public License");
        buffWriter.println(" * along with Electric(tm); see the file COPYING.  If not, write to");
        buffWriter.println(" * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,");
        buffWriter.println(" * Boston, Mass 02111-1307, USA.");
        buffWriter.println(" */");
        buffWriter.println("package com.sun.electric.technology.technologies;");
        buffWriter.println();
        buffWriter.println("import com.sun.electric.database.geometry.EGraphics;");
        buffWriter.println("import com.sun.electric.database.geometry.Poly;");
        buffWriter.println("import com.sun.electric.database.prototype.PortCharacteristic;");
        buffWriter.println("import com.sun.electric.database.prototype.PortProto;");
        buffWriter.println("import com.sun.electric.database.prototype.NodeProto;");
        buffWriter.println("import com.sun.electric.technology.ArcProto;");
        buffWriter.println("import com.sun.electric.technology.DRCRules;");
        buffWriter.println("import com.sun.electric.technology.EdgeH;");
        buffWriter.println("import com.sun.electric.technology.EdgeV;");
        buffWriter.println("import com.sun.electric.technology.Layer;");
        buffWriter.println("import com.sun.electric.technology.PrimitiveNode;");
        buffWriter.println("import com.sun.electric.technology.PrimitivePort;");
        buffWriter.println("import com.sun.electric.technology.SizeOffset;");
        buffWriter.println("import com.sun.electric.technology.Technology;");
        buffWriter.println("import com.sun.electric.technology.technologies.utils.MOSRules;");
        buffWriter.println("import com.sun.electric.tool.erc.ERC;");
        buffWriter.println();
        buffWriter.println("import java.awt.Color;");
        buffWriter.println();
        buffWriter.println("/**");
        buffWriter.println(" * This is the " + gi.description + " Technology.");
        buffWriter.println(" */");
        buffWriter.println("public class " + techName + " extends Technology");
        buffWriter.println("{");
        buffWriter.println("\t/** the " + gi.description + " Technology object. */\tpublic static final " + techName + " tech = new " + techName + "();");
        buffWriter.println();
        buffWriter.println("\tprivate " + techName + "()");
        buffWriter.println("\t{");
        buffWriter.println("\t\tsuper(\"" + techName + "\");");
        buffWriter.println("\t\tsetTechDesc(\"" + gi.description + "\");");
        buffWriter.println("\t\tsetFactoryScale(" + TextUtils.formatDouble(gi.scale) + ", true);   // in nanometers: really " + gi.scale / 1000.0 + " microns");
        buffWriter.println("\t\tsetMinResistance(" + gi.minRes + ");");
        buffWriter.println("\t\tsetMinCapacitance(" + gi.minCap + ");");
        buffWriter.println("\t\tsetGateLengthSubtraction(" + gi.gateShrinkage + ");");
        buffWriter.println("\t\tsetGateIncluded(" + gi.includeGateInResistance + ");");
        buffWriter.println("\t\tsetGroundNetIncluded(" + gi.includeGround + ");");
        buffWriter.println("\t\tsetNoNegatedArcs();");
        buffWriter.println("\t\tsetStaticTechnology();");
        if (gi.transparentColors != null && gi.transparentColors.length > 0) {
            buffWriter.println("\t\tsetFactoryTransparentLayers(new Color []");
            buffWriter.println("\t\t{");
            for (i = 0; i < gi.transparentColors.length; ++i) {
                Color col = gi.transparentColors[i];
                buffWriter.print("\t\t\tnew Color(" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + ")");
                if (i + 1 < gi.transparentColors.length) {
                    buffWriter.print(",");
                }
                buffWriter.println();
            }
            buffWriter.println("\t\t});");
        }
        buffWriter.println();
        buffWriter.println("\t\t//**************************************** LAYERS ****************************************");
        for (i = 0; i < lList.length; ++i) {
            int j2;
            lList[i].javaName = LibToTech.makeJavaName(lList[i].name);
            buffWriter.print("\t\t/** " + lList[i].name + " layer */");
            buffWriter.println("\t\tLayer " + lList[i].javaName + "_lay = Layer.newInstance(this, \"" + lList[i].name + "\",");
            buffWriter.print("\t\t\tnew EGraphics(");
            if (lList[i].desc.isPatternedOnDisplay()) {
                if (lList[i].desc.isOutlinedOnDisplay()) {
                    buffWriter.print("EGraphics.OUTLINEPAT");
                } else {
                    buffWriter.print("EGraphics.PATTERNED");
                }
            } else {
                buffWriter.print("EGraphics.SOLID");
            }
            buffWriter.print(", ");
            if (lList[i].desc.isPatternedOnPrinter()) {
                if (lList[i].desc.isOutlinedOnPrinter()) {
                    buffWriter.print("EGraphics.OUTLINEPAT");
                } else {
                    buffWriter.print("EGraphics.PATTERNED");
                }
            } else {
                buffWriter.print("EGraphics.SOLID");
            }
            String transparent = "0";
            if (lList[i].desc.getTransparentLayer() > 0) {
                transparent = "EGraphics.TRANSPARENT_" + lList[i].desc.getTransparentLayer();
            }
            int red = lList[i].desc.getColor().getRed();
            int green = lList[i].desc.getColor().getGreen();
            int blue = lList[i].desc.getColor().getBlue();
            if (red < 0 || red > 255) {
                red = 0;
            }
            if (green < 0 || green > 255) {
                green = 0;
            }
            if (blue < 0 || blue > 255) {
                blue = 0;
            }
            buffWriter.println(", " + transparent + ", " + red + "," + green + "," + blue + ", 0.8,true,");
            boolean hasPattern = false;
            int[] pattern = lList[i].desc.getPattern();
            for (j2 = 0; j2 < 16; ++j2) {
                if (pattern[j2] == 0) continue;
                hasPattern = true;
            }
            if (hasPattern) {
                for (j2 = 0; j2 < 16; ++j2) {
                    buffWriter.print("\t\t\t");
                    if (j2 == 0) {
                        buffWriter.print("new int[] { ");
                    } else {
                        buffWriter.print("\t\t\t");
                    }
                    String hexValue = Integer.toHexString(pattern[j2] & 0xFFFF);
                    while (hexValue.length() < 4) {
                        hexValue = "0" + hexValue;
                    }
                    buffWriter.print("0x" + hexValue);
                    if (j2 == 15) {
                        buffWriter.print("}));");
                    } else {
                        buffWriter.print(",   ");
                    }
                    buffWriter.print("// ");
                    for (int k = 0; k < 16; ++k) {
                        if ((pattern[j2] & 1 << 15 - k) != 0) {
                            buffWriter.print("X");
                            continue;
                        }
                        buffWriter.print(" ");
                    }
                    buffWriter.println();
                }
                buffWriter.println();
                continue;
            }
            buffWriter.println("\t\t\tnew int[] {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}));");
        }
        buffWriter.println();
        buffWriter.println("\t\t// The layer functions");
        for (i = 0; i < lList.length; ++i) {
            Layer.Function fun = lList[i].fun;
            int funExtra = lList[i].funExtra;
            String infstr = lList[i].javaName + "_lay.setFunction(Layer.Function.";
            if (fun.isDiff() && (funExtra & 0x40) != 0) {
                infstr = infstr + "DIFFP";
                funExtra &= 0xFFFFFFBF;
            } else if (fun.isDiff() && (funExtra & 0x80) != 0) {
                infstr = infstr + "DIFFN";
                funExtra &= 0xFFFFFF7F;
            } else if (fun == Layer.Function.WELL && (funExtra & 0x40) != 0) {
                infstr = infstr + "WELLP";
                funExtra &= 0xFFFFFFBF;
            } else if (fun == Layer.Function.WELL && (funExtra & 0x80) != 0) {
                infstr = infstr + "WELLN";
                funExtra &= 0xFFFFFF7F;
            } else if (fun == Layer.Function.IMPLANT && (funExtra & 0x40) != 0) {
                infstr = infstr + "IMPLANTP";
                funExtra &= 0xFFFFFFBF;
            } else if (fun == Layer.Function.IMPLANT && (funExtra & 0x80) != 0) {
                infstr = infstr + "IMPLANTN";
                funExtra &= 0xFFFFFF7F;
            } else if (fun.isPoly() && (funExtra & 0x400000) != 0) {
                infstr = infstr + "GATE";
                funExtra &= 0xFFBFFFFF;
            } else {
                infstr = infstr + fun.getConstantName();
            }
            boolean extraFunction = false;
            int[] extras = Layer.Function.getFunctionExtras();
            for (int j3 = 0; j3 < extras.length; ++j3) {
                if ((funExtra & extras[j3]) == 0) continue;
                infstr = extraFunction ? infstr + "|" : infstr + ", ";
                infstr = infstr + "Layer.Function.";
                infstr = infstr + Layer.Function.getExtraConstantName(extras[j3]);
                extraFunction = true;
            }
            infstr = infstr + ");";
            buffWriter.println("\t\t" + infstr + "\t\t// " + lList[i].name);
        }
        for (j = 0; j < lList.length; ++j) {
            if (lList[j].cif.length() <= 0) continue;
            buffWriter.println("\n\t\t// The CIF names");
            for (int i2 = 0; i2 < lList.length; ++i2) {
                buffWriter.println("\t\t" + lList[i2].javaName + "_lay.setFactoryCIFLayer(\"" + lList[i2].cif + "\");\t\t// " + lList[i2].name);
            }
            break;
        }
        for (j = 0; j < lList.length; ++j) {
            if (lList[j].gds.length() <= 0) continue;
            buffWriter.println("\n\t\t// The GDS names");
            for (int i3 = 0; i3 < lList.length; ++i3) {
                buffWriter.println("\t\t" + lList[i3].javaName + "_lay.setFactoryGDSLayer(\"" + lList[i3].gds + "\");\t\t// " + lList[i3].name);
            }
            break;
        }
        for (j = 0; j < lList.length; ++j) {
            if (lList[j].thick3d == 0.0 && lList[j].height3d == 0.0) continue;
            buffWriter.println("\n\t\t// The layer height");
            for (int i4 = 0; i4 < lList.length; ++i4) {
                buffWriter.println("\t\t" + lList[i4].javaName + "_lay.setFactory3DInfo(" + TextUtils.formatDouble(lList[i4].thick3d) + ", " + TextUtils.formatDouble(lList[i4].height3d) + ");\t\t// " + lList[i4].name);
            }
            break;
        }
        for (j = 0; j < lList.length; ++j) {
            if (lList[j].spiRes == 0.0 && lList[j].spiCap == 0.0 && lList[j].spiECap == 0.0) continue;
            buffWriter.println("\n\t\t// The SPICE information");
            for (int i5 = 0; i5 < lList.length; ++i5) {
                buffWriter.println("\t\t" + lList[i5].javaName + "_lay.setFactoryParasitics(" + TextUtils.formatDouble(lList[i5].spiRes) + ", " + TextUtils.formatDouble(lList[i5].spiCap) + ", " + TextUtils.formatDouble(lList[i5].spiECap) + ");\t\t// " + lList[i5].name);
            }
            break;
        }
    }

    private static void dumpArcsToJava(PrintStream buffWriter, String techName, ArcInfo[] aList, GeneralInfo gi) {
        buffWriter.println();
        buffWriter.println("\t\t//******************** ARCS ********************");
        for (int i = 0; i < aList.length; ++i) {
            aList[i].javaName = LibToTech.makeJavaName(aList[i].name);
            buffWriter.println("\n\t\t/** " + aList[i].name + " arc */");
            buffWriter.println("\t\tArcProto " + aList[i].javaName + "_arc = ArcProto.newInstance(this, \"" + aList[i].name + "\", " + TextUtils.formatDouble(aList[i].maxWidth) + ", new Technology.ArcLayer []");
            buffWriter.println("\t\t{");
            for (int k = 0; k < aList[i].arcDetails.length; ++k) {
                buffWriter.print("\t\t\tnew Technology.ArcLayer(" + aList[i].arcDetails[k].layer.javaName + "_lay, ");
                buffWriter.print(TextUtils.formatDouble(aList[i].arcDetails[k].width) + ",");
                if (aList[i].arcDetails[k].style == Poly.Type.FILLED) {
                    buffWriter.print(" Poly.Type.FILLED)");
                } else {
                    buffWriter.print(" Poly.Type.CLOSED)");
                }
                if (k + 1 < aList[i].arcDetails.length) {
                    buffWriter.print(",");
                }
                buffWriter.println();
            }
            buffWriter.println("\t\t});");
            buffWriter.println("\t\t" + aList[i].javaName + "_arc.setFunction(ArcProto.Function." + aList[i].func.getConstantName() + ");");
            if (aList[i].wipes) {
                buffWriter.println("\t\t" + aList[i].javaName + "_arc.setWipable();");
            }
            buffWriter.println("\t\t" + aList[i].javaName + "_arc.setWidthOffset(" + TextUtils.formatDouble(aList[i].widthOffset) + ");");
            if (aList[i].fixAng) {
                buffWriter.println("\t\t" + aList[i].javaName + "_arc.setFactoryFixedAngle(true);");
            }
            if (aList[i].noExtend) {
                buffWriter.println("\t\t" + aList[i].javaName + "_arc.setFactoryExtended(false);");
            }
            buffWriter.println("\t\t" + aList[i].javaName + "_arc.setFactoryAngleIncrement(" + aList[i].angInc + ");");
            buffWriter.println("\t\tERC.getERCTool().setAntennaRatio(" + aList[i].javaName + "_arc, " + TextUtils.formatDouble(aList[i].antennaRatio) + ");");
        }
    }

    private static String makeabbrev(String pt, boolean upper) {
        StringBuffer infstr = new StringBuffer();
        int i = 0;
        while (i < pt.length()) {
            char chr = pt.charAt(i);
            if (Character.isLetterOrDigit(chr)) {
                if (upper) {
                    infstr.append(Character.toUpperCase(chr));
                } else {
                    infstr.append(Character.toLowerCase(chr));
                }
                while (Character.isLetterOrDigit(chr) && ++i < pt.length()) {
                    chr = pt.charAt(i);
                }
            }
            while (!Character.isLetterOrDigit(chr) && ++i < pt.length()) {
                chr = pt.charAt(i);
            }
        }
        return infstr.toString();
    }

    private static void dumpNodesToJava(PrintStream buffWriter, String techName, NodeInfo[] nList, LayerInfo[] lList, GeneralInfo gi) {
        String ab;
        int i;
        HashSet<String> abbrevs = new HashSet<String>();
        for (i = 0; i < nList.length; ++i) {
            ab = LibToTech.makeabbrev(nList[i].name, false);
            while (abbrevs.contains(ab)) {
                int l = ab.length() - 1;
                char last = ab.charAt(l);
                if (last >= '0' && last <= '8') {
                    ab = ab.substring(0, l) + (last + '\u0001');
                    continue;
                }
                ab = ab + "0";
            }
            abbrevs.add(ab);
            nList[i].abbrev = ab;
        }
        buffWriter.println();
        buffWriter.println("\t\t//******************** NODES ********************");
        block12: for (i = 0; i < nList.length; ++i) {
            ab = nList[i].abbrev;
            buffWriter.println();
            buffWriter.println("\t\t/** " + nList[i].name + " */");
            buffWriter.print("\t\tPrimitiveNode " + ab + "_node = PrimitiveNode.newInstance(\"" + nList[i].name + "\", this, " + TextUtils.formatDouble(nList[i].xSize) + ", " + TextUtils.formatDouble(nList[i].ySize) + ", ");
            if (nList[i].so == null) {
                buffWriter.println("null,");
            } else {
                buffWriter.println("new SizeOffset(" + TextUtils.formatDouble(nList[i].so.getLowXOffset()) + ", " + TextUtils.formatDouble(nList[i].so.getHighXOffset()) + ", " + TextUtils.formatDouble(nList[i].so.getLowYOffset()) + ", " + TextUtils.formatDouble(nList[i].so.getHighYOffset()) + "),");
            }
            buffWriter.println("\t\t\tnew Technology.NodeLayer []");
            buffWriter.println("\t\t\t{");
            int tot = nList[i].nodeLayers.length;
            for (int j = 0; j < tot; ++j) {
                int portNum = nList[i].nodeLayers[j].portIndex;
                buffWriter.print("\t\t\t\tnew Technology.NodeLayer(" + nList[i].nodeLayers[j].layer.javaName + "_lay, " + portNum + ", Poly.Type." + nList[i].nodeLayers[j].style.getConstantName() + ",");
                switch (nList[i].nodeLayers[j].representation) {
                    case 1: {
                        buffWriter.print(" Technology.NodeLayer.BOX,");
                        break;
                    }
                    case 2: {
                        buffWriter.print(" Technology.NodeLayer.MINBOX,");
                        break;
                    }
                    case 0: {
                        buffWriter.print(" Technology.NodeLayer.POINTS,");
                        break;
                    }
                    default: {
                        buffWriter.print(" Technology.NodeLayer.????,");
                    }
                }
                buffWriter.println(" new Technology.TechPoint [] {");
                int totLayers = nList[i].nodeLayers[j].values.length;
                for (int k = 0; k < totLayers; ++k) {
                    Technology.TechPoint tp = nList[i].nodeLayers[j].values[k];
                    buffWriter.print("\t\t\t\t\tnew Technology.TechPoint(" + LibToTech.getEdgeLabel(tp, false) + ", " + LibToTech.getEdgeLabel(tp, true) + ")");
                    if (k < totLayers - 1) {
                        buffWriter.println(",");
                        continue;
                    }
                    buffWriter.print("}");
                }
                if (nList[i].specialType == 1) {
                    buffWriter.print(", " + nList[i].nodeLayers[j].lWidth + ", " + nList[i].nodeLayers[j].rWidth + ", " + nList[i].nodeLayers[j].extendB + ", " + nList[i].nodeLayers[j].extendT);
                }
                buffWriter.print(")");
                if (j + 1 < tot) {
                    buffWriter.print(",");
                }
                buffWriter.println();
            }
            buffWriter.println("\t\t\t});");
            buffWriter.println("\t\t" + ab + "_node.addPrimitivePorts(new PrimitivePort[]");
            buffWriter.println("\t\t\t{");
            int numPorts = nList[i].nodePortDetails.length;
            for (int j = 0; j < numPorts; ++j) {
                NodeInfo.PortDetails portDetail = nList[i].nodePortDetails[j];
                buffWriter.print("\t\t\t\tPrimitivePort.newInstance(this, " + ab + "_node, new ArcProto [] {");
                ArcInfo[] conns = portDetail.connections;
                for (int l = 0; l < conns.length; ++l) {
                    buffWriter.print(conns[l].javaName + "_arc");
                    if (l + 1 >= conns.length) continue;
                    buffWriter.print(", ");
                }
                buffWriter.println("}, \"" + portDetail.name + "\", " + portDetail.angle + "," + portDetail.range + ", " + portDetail.netIndex + ", PortCharacteristic.UNKNOWN,");
                buffWriter.print("\t\t\t\t\t" + LibToTech.getEdgeLabel(portDetail.values[0], false) + ", " + LibToTech.getEdgeLabel(portDetail.values[0], true) + ", " + LibToTech.getEdgeLabel(portDetail.values[1], false) + ", " + LibToTech.getEdgeLabel(portDetail.values[1], true) + ")");
                if (j + 1 < numPorts) {
                    buffWriter.print(",");
                }
                buffWriter.println();
            }
            buffWriter.println("\t\t\t});");
            PrimitiveNode.Function fun = nList[i].func;
            buffWriter.println("\t\t" + ab + "_node.setFunction(PrimitiveNode.Function." + fun.getConstantName() + ");");
            if (nList[i].wipes) {
                buffWriter.println("\t\t" + ab + "_node.setWipeOn1or2();");
            }
            if (nList[i].square) {
                buffWriter.println("\t\t" + ab + "_node.setSquare();");
            }
            if (nList[i].lockable) {
                buffWriter.println("\t\t" + ab + "_node.setLockedPrim();");
            }
            if (fun == PrimitiveNode.Function.PIN) {
                buffWriter.println("\t\t" + ab + "_node.setArcsWipe();");
                buffWriter.println("\t\t" + ab + "_node.setArcsShrink();");
            }
            if (nList[i].specialType == 0) continue;
            switch (nList[i].specialType) {
                case 1: {
                    buffWriter.println("\t\t" + ab + "_node.setHoldsOutline();");
                    buffWriter.println("\t\t" + ab + "_node.setCanShrink();");
                    buffWriter.println("\t\t" + ab + "_node.setSpecialType(PrimitiveNode.SERPTRANS);");
                    buffWriter.println("\t\t" + ab + "_node.setSpecialValues(new double [] {" + nList[i].specialValues[0] + ", " + nList[i].specialValues[1] + ", " + nList[i].specialValues[2] + ", " + nList[i].specialValues[3] + ", " + nList[i].specialValues[4] + ", " + nList[i].specialValues[5] + "});");
                    continue block12;
                }
                case 2: {
                    buffWriter.println("\t\t" + ab + "_node.setHoldsOutline();");
                    buffWriter.println("\t\t" + ab + "_node.setSpecialType(PrimitiveNode.POLYGONAL);");
                    continue block12;
                }
                case 3: {
                    buffWriter.println("\t\t" + ab + "_node.setSpecialType(PrimitiveNode.MULTICUT);");
                    buffWriter.println("\t\t" + ab + "_node.setSpecialValues(new double [] {" + nList[i].specialValues[0] + ", " + nList[i].specialValues[1] + ", " + nList[i].specialValues[2] + ", " + nList[i].specialValues[3] + ", " + nList[i].specialValues[4] + ", " + nList[i].specialValues[5] + "});");
                }
            }
        }
        buffWriter.println();
        buffWriter.println("\t\t// The pure layer nodes");
        block17: for (i = 0; i < lList.length; ++i) {
            if ((lList[i].funExtra & 0x1000) != 0) continue;
            for (int j = 0; j < nList.length; ++j) {
                if (nList[j].func != PrimitiveNode.Function.NODE) continue;
                NodeInfo.LayerDetails nld = nList[j].nodeLayers[0];
                if (nld.layer != lList[i]) continue;
                buffWriter.println("\t\t" + lList[i].javaName + "_lay.setPureLayerNode(" + nList[j].abbrev + "_node);\t\t// " + lList[i].name);
                continue block17;
            }
        }
        buffWriter.println("\t};");
    }

    private static String makeJavaName(String string) {
        StringBuffer infstr = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char chr = string.charAt(i);
            if (i == 0) {
                chr = !Character.isJavaIdentifierStart(chr) ? (char)'_' : (char)Character.toLowerCase(chr);
            } else if (!Character.isJavaIdentifierPart(chr)) {
                chr = '_';
            }
            infstr.append(chr);
        }
        return infstr.toString();
    }

    private static String getEdgeLabel(Technology.TechPoint pt, boolean yAxis) {
        double mul;
        double add;
        if (yAxis) {
            add = pt.getY().getAdder();
            mul = pt.getY().getMultiplier();
        } else {
            add = pt.getX().getAdder();
            mul = pt.getX().getMultiplier();
        }
        StringBuffer infstr = new StringBuffer();
        if (mul == 0.0) {
            if (yAxis) {
                infstr.append("EdgeV.");
            } else {
                infstr.append("EdgeH.");
            }
            if (add == 0.0) {
                infstr.append("makeCenter()");
            } else {
                infstr.append("fromCenter(" + TextUtils.formatDouble(add) + ")");
            }
            return infstr.toString();
        }
        if (mul == 0.5 || mul == -0.5) {
            if (yAxis) {
                infstr.append("EdgeV.");
            } else {
                infstr.append("EdgeH.");
            }
            double amt = Math.abs(add);
            if (!yAxis) {
                if (mul < 0.0) {
                    if (add == 0.0) {
                        infstr.append("makeLeftEdge()");
                    } else {
                        infstr.append("fromLeft(" + TextUtils.formatDouble(amt) + ")");
                    }
                } else if (add == 0.0) {
                    infstr.append("makeRightEdge()");
                } else {
                    infstr.append("fromRight(" + TextUtils.formatDouble(amt) + ")");
                }
            } else if (mul < 0.0) {
                if (add == 0.0) {
                    infstr.append("makeBottomEdge()");
                } else {
                    infstr.append("fromBottom(" + TextUtils.formatDouble(amt) + ")");
                }
            } else if (add == 0.0) {
                infstr.append("makeTopEdge()");
            } else {
                infstr.append("fromTop(" + TextUtils.formatDouble(amt) + ")");
            }
            return infstr.toString();
        }
        if (!yAxis) {
            infstr.append("new EdgeH(" + TextUtils.formatDouble(mul) + ", " + TextUtils.formatDouble(add) + ")");
        } else {
            infstr.append("new EdgeV(" + TextUtils.formatDouble(mul) + ", " + TextUtils.formatDouble(add) + ")");
        }
        return infstr.toString();
    }

    private static String getSampleName(NodeProto layerCell) {
        if (layerCell == Generic.tech.portNode) {
            return "PORT";
        }
        if (layerCell == Generic.tech.cellCenterNode) {
            return "GRAB";
        }
        if (layerCell == null) {
            return "HIGHLIGHT";
        }
        return layerCell.getName().substring(6);
    }

    private static class SampleCoordAscending
    implements Comparator {
        private SampleCoordAscending() {
        }

        public int compare(Object o1, Object o2) {
            Sample s1 = (Sample)o1;
            Sample s2 = (Sample)o2;
            if (s1.xPos != s2.xPos) {
                return (int)(s1.xPos - s2.xPos);
            }
            if (s1.yPos != s2.yPos) {
                return (int)(s1.yPos - s2.yPos);
            }
            return s1.node.getName().compareTo(s2.node.getName());
        }
    }

    private static class GenerateTechnology
    extends EDialog {
        private JLabel lab2;
        private JLabel lab3;
        private JTextField renameName;
        private JTextField newName;
        private JCheckBox alsoJava;

        private GenerateTechnology() {
            super((Frame)null, true);
        }

        private void ok() {
            this.exit(true);
        }

        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            if (goodButton) {
                LibToTech.makeTech(this.newName.getText(), this.renameName.getText(), this.alsoJava.isSelected());
            }
            this.dispose();
        }

        private void nameChanged() {
            String techName = this.newName.getText();
            if (Technology.findTechnology(techName) != null) {
                this.lab2.setEnabled(true);
                this.lab3.setEnabled(true);
                this.renameName.setEnabled(true);
                this.renameName.setEditable(true);
            } else {
                this.lab2.setEnabled(false);
                this.lab3.setEnabled(false);
                this.renameName.setEnabled(false);
                this.renameName.setEditable(false);
            }
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Convert Library to Technology");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    GenerateTechnology.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Creating new technology:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.newName = new JTextField(Library.getCurrent().getName());
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.newName, gbc);
            TechNameDocumentListener myDocumentListener = new TechNameDocumentListener(this);
            this.newName.getDocument().addDocumentListener(myDocumentListener);
            this.lab2 = new JLabel("Already a technology with this name");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.lab2, gbc);
            this.lab3 = new JLabel("Rename existing technology to:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.lab3, gbc);
            this.renameName = new JTextField();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.renameName, gbc);
            this.alsoJava = new JCheckBox("Also write Java code");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.alsoJava, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GenerateTechnology.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GenerateTechnology.this.exit(true);
                }
            });
            this.pack();
        }

        private static class TechNameDocumentListener
        implements DocumentListener {
            GenerateTechnology dialog;

            TechNameDocumentListener(GenerateTechnology dialog) {
                this.dialog = dialog;
            }

            public void changedUpdate(DocumentEvent e) {
                this.dialog.nameChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                this.dialog.nameChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                this.dialog.nameChanged();
            }
        }
    }

    private static class SoftTech
    extends Technology {
        private SoftTech(String name) {
            super(name);
            this.setNoNegatedArcs();
        }

        private void setTheScale(double scale) {
            this.setFactoryScale(scale, true);
        }

        private void setTransparentColors(Color[] colors) {
            this.setFactoryTransparentLayers(colors);
        }
    }
}

