/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LibToTech;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import java.awt.Color;
import java.util.Iterator;

public class GeneralInfo
extends Info {
    String description;
    double scale;
    double minRes;
    double minCap;
    double gateShrinkage;
    boolean includeGateInResistance;
    boolean includeGround;
    Color[] transparentColors;
    static Info.SpecialTextDescr[] genTextTable = new Info.SpecialTextDescr[]{new Info.SpecialTextDescr(0.0, 3.0, 14), new Info.SpecialTextDescr(0.0, 0.0, 15), new Info.SpecialTextDescr(0.0, -3.0, 38), new Info.SpecialTextDescr(0.0, -6.0, 39), new Info.SpecialTextDescr(0.0, -9.0, 42), new Info.SpecialTextDescr(0.0, -12.0, 43), new Info.SpecialTextDescr(0.0, -15.0, 44), new Info.SpecialTextDescr(0.0, -18.0, 45)};

    void generate(Cell np) {
        GeneralInfo.loadTableEntry(genTextTable, 14, new Double(this.scale));
        GeneralInfo.loadTableEntry(genTextTable, 15, this.description);
        GeneralInfo.loadTableEntry(genTextTable, 38, new Double(this.minRes));
        GeneralInfo.loadTableEntry(genTextTable, 39, new Double(this.minCap));
        GeneralInfo.loadTableEntry(genTextTable, 42, new Double(this.gateShrinkage));
        GeneralInfo.loadTableEntry(genTextTable, 43, new Boolean(this.includeGateInResistance));
        GeneralInfo.loadTableEntry(genTextTable, 44, new Boolean(this.includeGround));
        GeneralInfo.loadTableEntry(genTextTable, 45, this.transparentColors);
        GeneralInfo.createSpecialText(np, genTextTable);
    }

    static GeneralInfo parseCell(Cell np) {
        GeneralInfo gi = new GeneralInfo();
        Iterator it = np.getNodes();
        block11: while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            int opt = Manipulate.getOptionOnNode(ni);
            String str = GeneralInfo.getValueOnNode(ni);
            switch (opt) {
                case 14: {
                    gi.scale = TextUtils.atof(str);
                    break;
                }
                case 15: {
                    gi.description = str;
                    break;
                }
                case 38: {
                    gi.minRes = TextUtils.atof(str);
                    break;
                }
                case 39: {
                    gi.minCap = TextUtils.atof(str);
                    break;
                }
                case 42: {
                    gi.gateShrinkage = TextUtils.atof(str);
                    break;
                }
                case 43: {
                    gi.includeGateInResistance = str.equalsIgnoreCase("yes");
                    break;
                }
                case 44: {
                    gi.includeGround = str.equalsIgnoreCase("yes");
                    break;
                }
                case 45: {
                    Color[] colors;
                    Variable var = ni.getVar(TRANSLAYER_KEY);
                    if (var == null || (colors = GeneralInfo.getTransparentColors((String)var.getObject())) == null) continue block11;
                    gi.transparentColors = colors;
                    break;
                }
                case 26: {
                    break;
                }
                default: {
                    LibToTech.pointOutError(ni, np);
                    System.out.println("Unknown object in miscellaneous-information cell (" + ni + ")");
                }
            }
        }
        return gi;
    }

    static Color[] getTransparentColors(String str) {
        String[] colorNames = str.split("/");
        Color[] colors = new Color[colorNames.length];
        for (int i = 0; i < colorNames.length; ++i) {
            String colorName = colorNames[i].trim();
            String[] rgb = colorName.split(",");
            if (rgb.length != 3) {
                return null;
            }
            int r = TextUtils.atoi(rgb[0]);
            int g = TextUtils.atoi(rgb[1]);
            int b = TextUtils.atoi(rgb[2]);
            colors[i] = new Color(r, g, b);
        }
        return colors;
    }

    static String makeTransparentColorsLine(Color[] trans) {
        String str = "The Transparent Colors: ";
        for (int j = 0; j < trans.length; ++j) {
            if (j != 0) {
                str = str + " /";
            }
            str = str + " " + trans[j].getRed() + "," + trans[j].getGreen() + "," + trans[j].getBlue();
        }
        return str;
    }
}

