/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.hierarchy.Cell;

public final class CellUsage {
    public static final CellUsage[] NULL_ARRAY = new CellUsage[0];
    public final CellId parentId;
    public final CellId protoId;
    public final int indexInParent;

    CellUsage(CellId parentId, CellId protoId, int indexInParent) {
        this.parentId = parentId;
        this.protoId = protoId;
        this.indexInParent = indexInParent;
    }

    public Cell getProto() {
        return Cell.inCurrentThread(this.protoId);
    }

    public Cell getParent() {
        return Cell.inCurrentThread(this.parentId);
    }

    public String toString() {
        return "CellUsage of " + this.protoId + " in " + this.parentId;
    }

    void check() {
        assert (this == this.parentId.getUsageIn(this.indexInParent));
        assert (this == this.parentId.getUsageIn(this.protoId, false));
        int count = 0;
        int protoNumOf = this.protoId.numUsagesOf();
        for (int i = 0; i < protoNumOf; ++i) {
            CellUsage u = this.protoId.getUsageOf(i);
            if (u.parentId != this.parentId) continue;
            assert (u == this);
            ++count;
        }
        assert (count == 1);
    }
}

