/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric;

import com.sun.electric.Main;
import com.sun.electric.tool.Regression;
import com.sun.electric.tool.user.User;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public final class Launcher {
    private static final boolean enableAssertions = true;

    private Launcher() {
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String str = args[i];
            if (!str.equals("-NOMINMEM") && !str.equals("-help") && !str.equals("-version") && !str.equals("-v")) continue;
            Main.main(args);
            return;
        }
        String program = "java";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            program = javaHome + File.separator + "bin" + File.separator + program;
        }
        if (args.length >= 1 && args[0].equals("-regression")) {
            Launcher.invokeRegression(args, program);
            return;
        }
        try {
            if (program != null) {
                Launcher.invokeElectric(args, program);
            } else {
                Main.main(args);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Main.main(args);
        }
    }

    private static void invokeElectric(String[] args, String program) {
        Runtime runtime = Runtime.getRuntime();
        long maxMem = runtime.maxMemory() / 1000000L;
        long maxPermWanted = User.getPermSpace();
        int maxMemWanted = User.getMemorySize();
        if ((long)maxMemWanted <= maxMem && maxPermWanted == 0L) {
            ClassLoader.getSystemClassLoader().setDefaultAssertionStatus(true);
            Main.main(args);
            return;
        }
        URL electric = Launcher.class.getResource("Main.class");
        if (electric.getProtocol().equals("jar")) {
            String file = electric.getFile();
            file = file.replaceAll("file:", "");
            file = file.replaceAll("!.*", "");
        }
        String command = program;
        command = command + " -cp " + System.getProperty("java.class.path", ".");
        command = command + " -ss2m";
        command = command + " -ea";
        command = command + " -mx" + maxMemWanted + "m ";
        if (maxPermWanted > 0L) {
            command = command + " -XX:MaxPermSize=" + maxPermWanted + "m ";
        }
        command = command + "com.sun.electric.Main";
        if ((long)maxMemWanted > maxMem) {
            System.out.println("Current Java memory limit of " + maxMem + "MEG is too small, rerunning Electric with a memory limit of " + maxMemWanted + "MEG");
        }
        if (maxPermWanted > 0L) {
            System.out.println("Setting maximum permanent space (2nd GC) to " + maxPermWanted + "MEG");
        }
        for (int i = 0; i < args.length; ++i) {
            command = command + " " + args[i];
        }
        try {
            runtime.exec(command);
            System.exit(0);
        }
        catch (IOException e) {
            Main.main(args);
        }
    }

    private static void invokeRegression(String[] args, String program) {
        String jarfile = "electric.jar";
        URL electric = Launcher.class.getResource("Main.class");
        if (electric.getProtocol().equals("jar")) {
            String file = electric.getFile();
            file = file.replaceAll("file:", "");
            jarfile = file = file.replaceAll("!.*", "");
        }
        String script = args[1];
        String command = program;
        command = command + " -ea";
        for (int i = 2; i < args.length; ++i) {
            command = command + " " + args[i];
        }
        command = command + " -jar " + jarfile + " -batch";
        System.out.println("exec: " + command);
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        Regression.runScript(script);
    }
}

