/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.technology.Layer;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolySweepMerge
extends GeometryHandler {
    public PolySweepMerge() {
    }

    public PolySweepMerge(int initialSize) {
        super(initialSize);
    }

    public void setMode(int mode) {
    }

    @Override
    public void add(Layer key, Object element) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(key);
        if (container == null) {
            container = new PolySweepContainer(true);
            this.layers.put(key, container);
        }
        container.add(element);
    }

    @Override
    public void subtract(Object key, Object element) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(key);
        if (container == null) {
            return;
        }
        container.subtract(element);
    }

    @Override
    public void subtractAll(HashMap<Layer, List<PolyBase>> map) {
        for (Map.Entry<Layer, List<PolyBase>> e : map.entrySet()) {
            PolySweepContainer container = (PolySweepContainer)this.layers.get(e.getKey());
            if (container == null) continue;
            for (PolyBase p : e.getValue()) {
                container.subtract(p);
            }
        }
    }

    @Override
    public void addAll(GeometryHandler subMerge, AffineTransform tTrans) {
        PolySweepMerge other = (PolySweepMerge)subMerge;
        ArrayList<Area> list = new ArrayList<Area>();
        for (Map.Entry e : other.layers.entrySet()) {
            Layer layer = (Layer)e.getKey();
            PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
            PolySweepContainer otherContainer = (PolySweepContainer)e.getValue();
            if (container == null) {
                container = new PolySweepContainer(false);
                this.layers.put(layer, container);
                container.areas = new ArrayList(otherContainer.areas.size());
            }
            ArrayList<Area> otherAreas = new ArrayList<Area>(otherContainer.areas.size());
            for (Area area : otherContainer.areas) {
                otherAreas.add((Area)area.clone());
            }
            Collections.sort(otherAreas, areaSort);
            Collections.sort(container.areas, areaSort);
            for (Area area : otherAreas) {
                Area thisArea;
                Rectangle2D thisRect;
                if (tTrans != null) {
                    area.transform(tTrans);
                }
                Rectangle2D rect = area.getBounds2D();
                double areaMinX = rect.getMinX();
                double areaMaxX = rect.getMaxX();
                list.clear();
                Iterator i$ = container.areas.iterator();
                while (i$.hasNext() && !(areaMaxX < (thisRect = (thisArea = (Area)i$.next()).getBounds2D()).getMinX())) {
                    if (!(areaMinX <= thisRect.getMaxX())) continue;
                    list.add(thisArea);
                    area.add(thisArea);
                }
                container.areas.removeAll(list);
                container.areas.add(area);
            }
            otherAreas = null;
        }
    }

    @Override
    public void postProcess(boolean merge) {
        if (merge) {
            this.mergeProcess();
        } else {
            this.disjointProcess();
        }
    }

    private void disjointProcess() {
        for (Object obj : this.layers.values()) {
            PolySweepContainer container = (PolySweepContainer)obj;
            if (container == null) continue;
            Collections.sort(container.areas, areaSort);
            double maxXSweep = -1.7976931348623157E308;
            Area areaXTmp = null;
            ArrayList<Area> twoFrontierAreas = new ArrayList<Area>();
            ArrayList<Area> tmp = new ArrayList<Area>();
            for (Area geomArea : container.areas) {
                Rectangle2D rectX = geomArea.getBounds2D();
                double minX = rectX.getX();
                double maxX = rectX.getMaxX();
                if (minX > maxXSweep) {
                    if (areaXTmp != null) {
                        PolySweepMerge.sweepYFrontier(twoFrontierAreas, tmp, false);
                        areaXTmp = null;
                    }
                    tmp.clear();
                }
                tmp.add(geomArea);
                if (areaXTmp == null) {
                    areaXTmp = geomArea;
                }
                if (!(maxX > maxXSweep)) continue;
                maxXSweep = maxX;
            }
            PolySweepMerge.sweepYFrontier(twoFrontierAreas, tmp, false);
            container.areas = twoFrontierAreas;
        }
    }

    private void mergeProcess() {
        for (Object obj : this.layers.values()) {
            PolySweepContainer container = (PolySweepContainer)obj;
            if (container == null) continue;
            Collections.sort(container.areas, areaSort);
            double maxXSweep = -1.7976931348623157E308;
            Area areaXTmp = null;
            ArrayList<Area> areas = new ArrayList<Area>();
            for (Area geom : container.areas) {
                Rectangle2D rectX = geom.getBounds2D();
                double minX = rectX.getX();
                double maxX = rectX.getMaxX();
                if (minX > maxXSweep && areaXTmp != null) {
                    if (!areas.contains(areaXTmp)) {
                        areas.add(areaXTmp);
                    }
                    areaXTmp = null;
                }
                if (areaXTmp == null) {
                    areaXTmp = geom;
                    areas.add(areaXTmp);
                } else {
                    areaXTmp.add(geom);
                }
                if (!(maxX > maxXSweep)) continue;
                maxXSweep = maxX;
            }
            if (areaXTmp != null && !areas.contains(areaXTmp)) {
                areas.add(areaXTmp);
            }
            container.areas = areas;
        }
    }

    private static void sweepYFrontier(List<Area> twoFrontierAreas, List<Area> tmp, boolean merge) {
        if (merge) {
            return;
        }
        Collections.sort(tmp, areaSort);
        double maxYSweep = -1.7976931348623157E308;
        Area areaYTmp = null;
        for (Area area : tmp) {
            Rectangle2D rectY = area.getBounds2D();
            double minY = rectY.getY();
            double maxY = rectY.getMaxY();
            if (minY > maxYSweep) {
                if (areaYTmp != null && !twoFrontierAreas.contains(areaYTmp)) {
                    twoFrontierAreas.add(areaYTmp);
                }
                areaYTmp = null;
            }
            if (areaYTmp == null) {
                if (!merge) {
                    areaYTmp = (Area)area.clone();
                    twoFrontierAreas.add(area);
                } else {
                    areaYTmp = area;
                    twoFrontierAreas.add(areaYTmp);
                }
            } else if (merge) {
                areaYTmp.add(area);
            } else {
                Area clone = (Area)area.clone();
                clone.intersect(areaYTmp);
                if (!clone.isEmpty()) {
                    area.subtract(areaYTmp);
                }
                if (!area.isEmpty()) {
                    twoFrontierAreas.add(area);
                    areaYTmp.add(area);
                }
            }
            if (!(maxY > maxYSweep)) continue;
            maxYSweep = maxY;
        }
        if (areaYTmp != null && merge && !twoFrontierAreas.contains(areaYTmp)) {
            twoFrontierAreas.add(areaYTmp);
        }
    }

    @Override
    public Collection<PolyBase> getObjects(Object layer, boolean modified, boolean simple) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
        if (container == null) {
            return null;
        }
        ArrayList<PolyBase> list = new ArrayList<PolyBase>();
        for (Area area : container.areas) {
            PolyBase.getPointsInArea(area, (Layer)layer, simple, false, list);
        }
        return list;
    }

    @Override
    public Collection<PolyBase.PolyBaseTree> getTreeObjects(Object layer) {
        PolySweepContainer container = (PolySweepContainer)this.layers.get(layer);
        if (container == null) {
            return null;
        }
        ArrayList<PolyBase.PolyBaseTree> list = new ArrayList<PolyBase.PolyBaseTree>();
        for (Area area : container.areas) {
            list.addAll(PolyBase.getPolyTrees(area, (Layer)layer));
        }
        return list;
    }

    private static class PolySweepContainer {
        private List<Area> areas = null;

        public PolySweepContainer(boolean createPolyList) {
            this.areas = createPolyList ? new ArrayList() : null;
        }

        public void add(Object value) {
            Area a = null;
            if (value instanceof Shape) {
                a = new Area((Shape)value);
            } else {
                System.out.println("Error: invalid class for addition in PolySweepMerge");
            }
            this.areas.add(a);
        }

        public void subtract(Object element) {
            Area elem = null;
            if (element instanceof Shape) {
                elem = new Area((Shape)element);
            } else {
                System.out.println("Error: invalid class for subtraction in PolySweepMerge");
            }
            for (Area a : this.areas) {
                a.subtract(elem);
            }
        }
    }
}

