/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcProto
implements Comparable<ArcProto> {
    private static HashMap<ArcProto, Pref> defaultExtendPrefs = new HashMap();
    private static HashMap<ArcProto, Pref> defaultAnglePrefs = new HashMap();
    private static HashMap<ArcProto, Pref> defaultRigidPrefs = new HashMap();
    private static HashMap<ArcProto, Pref> defaultFixedAnglePrefs = new HashMap();
    private static HashMap<ArcProto, Pref> defaultSlidablePrefs = new HashMap();
    private static HashMap<ArcProto, Pref> defaultExtendedPrefs = new HashMap();
    private static HashMap<ArcProto, Pref> defaultDirectionalPrefs = new HashMap();
    protected final String protoName;
    protected final Technology tech;
    private int gridFullExtend;
    private double lambdaBaseExtend;
    private int gridBaseExtend;
    private int minLayerGridExtend;
    private int maxLayerGridExtend;
    private int userBits;
    final Function function;
    final Technology.ArcLayer[] layers;
    final String fullName;
    final int primArcIndex;
    private static final int CANWIPE = 64;
    private static final int CANCURVE = 128;
    private static final int ARCSPECIAL = 0x200000;
    private static final int AEDGESELECT = 0x400000;
    private static final int AINVISIBLE = 0x800000;
    private static final int ANOTUSED = Integer.MIN_VALUE;
    private static final int SKIPSIZEINPALETTE = 256;
    HashMap<ArcProto, Pref> arcPinPrefs = new HashMap();

    ArcProto(Technology tech, String protoName, long gridFullExtend, long gridBaseExtend, long gridExtendOverMin, Function function, Technology.ArcLayer[] layers, int primArcIndex) {
        assert (-268435455L < gridFullExtend && gridFullExtend < 0xFFFFFFFL);
        assert (-268435455L < gridBaseExtend && gridBaseExtend < 0xFFFFFFFL);
        assert (-268435455L < gridExtendOverMin && gridExtendOverMin < 0xFFFFFFFL);
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("ArcProto name " + protoName + " is not safe to write into JELIB");
        }
        this.protoName = protoName;
        this.fullName = tech.getTechName() + ":" + protoName;
        this.tech = tech;
        this.userBits = 0;
        this.function = function;
        this.layers = (Technology.ArcLayer[])layers.clone();
        this.primArcIndex = primArcIndex;
        this.gridFullExtend = (int)gridFullExtend;
        this.gridBaseExtend = (int)gridBaseExtend;
        this.lambdaBaseExtend = DBMath.gridToLambda(gridBaseExtend);
        this.computeLayerGridExtendRange();
        this.getArcProtoExtendPref(DBMath.gridToLambda(gridExtendOverMin));
    }

    public String getName() {
        return this.protoName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    private Pref getArcProtoExtendPref(double factory) {
        Pref pref = defaultExtendPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultExtendFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            defaultExtendPrefs.put(this, pref);
        }
        return pref;
    }

    public boolean setDefaultLambdaBaseWidth(double lambdaWidth) {
        long gridExtendOverMin = DBMath.lambdaToGrid(0.5 * lambdaWidth) - (long)this.gridBaseExtend;
        if (gridExtendOverMin <= -268435455L || gridExtendOverMin >= 0xFFFFFFFL) {
            System.out.println("ArcProto " + this.tech.getTechName() + ":" + this.protoName + " has invalid default base width " + lambdaWidth);
            return false;
        }
        return this.getArcProtoExtendPref(0.0).setDouble(DBMath.gridToLambda(gridExtendOverMin));
    }

    public void setExtends(int gridBaseExtend, int gridFullExtend) {
        this.gridBaseExtend = gridBaseExtend;
        this.gridFullExtend = gridFullExtend;
        this.lambdaBaseExtend = DBMath.gridToLambda(gridBaseExtend);
        this.computeLayerGridExtendRange();
    }

    public double getDefaultLambdaFullWidth() {
        return DBMath.gridToLambda(this.getDefaultGridFullWidth());
    }

    public long getDefaultGridFullWidth() {
        return 2L * (this.getDefaultGridExtendOverMin() + (long)this.gridFullExtend);
    }

    public double getDefaultLambdaBaseWidth() {
        return DBMath.gridToLambda(this.getDefaultGridBaseWidth());
    }

    public long getDefaultGridBaseWidth() {
        return 2L * (this.getDefaultGridExtendOverMin() + (long)this.gridBaseExtend);
    }

    public double getDefaultLambdaExtendOverMin() {
        return DBMath.gridToLambda(this.getDefaultGridExtendOverMin());
    }

    public long getDefaultGridExtendOverMin() {
        return DBMath.lambdaToGrid(this.getArcProtoExtendPref(0.0).getDouble());
    }

    public int getGridFullExtend() {
        return this.gridFullExtend;
    }

    public double getLambdaBaseExtend() {
        return this.lambdaBaseExtend;
    }

    public int getGridBaseExtend() {
        return this.gridBaseExtend;
    }

    public double getLambdaWidthOffset() {
        return DBMath.gridToLambda(this.getGridWidthOffset());
    }

    public int getGridWidthOffset() {
        return 2 * (this.gridFullExtend - this.gridBaseExtend);
    }

    public int getMinLayerGridExtend() {
        return this.minLayerGridExtend;
    }

    public int getMaxLayerGridExtend() {
        return this.maxLayerGridExtend;
    }

    private Pref getArcProtoBitPref(String what, HashMap<ArcProto, Pref> map, boolean factory) {
        Pref pref = map.get(this);
        if (pref == null) {
            pref = Pref.makeBooleanPref("Default" + what + "For" + this.protoName + "IN" + this.tech.getTechName(), User.getUserTool().prefs, factory);
            map.put(this, pref);
        }
        return pref;
    }

    public void setFactoryRigid(boolean rigid) {
        this.getArcProtoBitPref("Rigid", defaultRigidPrefs, rigid);
    }

    public void setRigid(boolean rigid) {
        this.getArcProtoBitPref("Rigid", defaultRigidPrefs, false).setBoolean(rigid);
    }

    public boolean isRigid() {
        return this.getArcProtoBitPref("Rigid", defaultRigidPrefs, false).getBoolean();
    }

    public void setFactoryFixedAngle(boolean fixed) {
        this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, fixed);
    }

    public void setFixedAngle(boolean fixed) {
        this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, true).setBoolean(fixed);
    }

    public boolean isFixedAngle() {
        return this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, true).getBoolean();
    }

    public void setFactorySlidable(boolean slidable) {
        this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, slidable);
    }

    public void setSlidable(boolean slidable) {
        this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, true).setBoolean(slidable);
    }

    public boolean isSlidable() {
        return this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, true).getBoolean();
    }

    public void setFactoryExtended(boolean extended) {
        this.getArcProtoBitPref("Extended", defaultExtendedPrefs, extended);
    }

    public void setExtended(boolean extended) {
        this.getArcProtoBitPref("Extended", defaultExtendedPrefs, true).setBoolean(extended);
    }

    public boolean isExtended() {
        return this.getArcProtoBitPref("Extended", defaultExtendedPrefs, true).getBoolean();
    }

    public void setDirectional(boolean directional) {
        this.getArcProtoBitPref("Directional", defaultDirectionalPrefs, false).setBoolean(directional);
    }

    public boolean isDirectional() {
        return this.getArcProtoBitPref("Directional", defaultDirectionalPrefs, false).getBoolean();
    }

    public void setNotUsed(boolean set) {
        this.userBits = set ? (this.userBits |= Integer.MIN_VALUE) : (this.userBits &= Integer.MAX_VALUE);
    }

    public boolean isNotUsed() {
        return (this.userBits & Integer.MIN_VALUE) != 0;
    }

    public void setArcInvisible(boolean invisible) {
        this.userBits = invisible ? (this.userBits |= 0x800000) : (this.userBits &= 0xFF7FFFFF);
    }

    public boolean isArcInvisible() {
        return (this.userBits & 0x800000) != 0;
    }

    public void setSkipSizeInPalette() {
        this.userBits |= 0x100;
    }

    public boolean isSkipSizeInPalette() {
        return (this.userBits & 0x100) != 0;
    }

    public void setWipable() {
        this.userBits |= 0x40;
    }

    public void clearWipable() {
        this.userBits &= 0xFFFFFFBF;
    }

    public boolean isWipable() {
        return (this.userBits & 0x40) != 0;
    }

    public void setCurvable() {
        this.userBits |= 0x80;
    }

    public void clearCurvable() {
        this.userBits &= 0xFFFFFF7F;
    }

    public boolean isCurvable() {
        return (this.userBits & 0x80) != 0;
    }

    public void setEdgeSelect() {
        this.userBits |= 0x400000;
    }

    public void clearEdgeSelect() {
        this.userBits &= 0xFFBFFFFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x400000) != 0;
    }

    public void setSpecialArc() {
        this.userBits |= 0x200000;
    }

    public boolean isSpecialArc() {
        return (this.userBits & 0x200000) != 0;
    }

    public int getDefaultConstraints() {
        int flags = ImmutableArcInst.DEFAULT_FLAGS;
        flags = ImmutableArcInst.RIGID.set(flags, this.isRigid());
        flags = ImmutableArcInst.FIXED_ANGLE.set(flags, this.isFixedAngle());
        flags = ImmutableArcInst.SLIDABLE.set(flags, this.isSlidable());
        flags = ImmutableArcInst.HEAD_EXTENDED.set(flags, this.isExtended());
        flags = ImmutableArcInst.TAIL_EXTENDED.set(flags, this.isExtended());
        flags = ImmutableArcInst.HEAD_ARROWED.set(flags, this.isDirectional());
        flags = ImmutableArcInst.BODY_ARROWED.set(flags, this.isDirectional());
        return flags;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFactoryAngleIncrement(int angle) {
        Pref pref = Pref.makeIntPref("DefaultAngleFor" + this.protoName + "IN" + this.tech.getTechName(), User.getUserTool().prefs, angle);
        defaultAnglePrefs.put(this, pref);
    }

    public void setAngleIncrement(int angle) {
        Pref pref = defaultAnglePrefs.get(this);
        if (pref == null) {
            return;
        }
        pref.setInt(angle);
    }

    public int getAngleIncrement() {
        Pref pref = defaultAnglePrefs.get(this);
        if (pref == null) {
            return 90;
        }
        return pref.getInt();
    }

    private Pref getArcPinPref() {
        Pref pref = this.arcPinPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeStringPref("PinFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), "");
            this.arcPinPrefs.put(this, pref);
        }
        return pref;
    }

    public void setPinProto(PrimitiveNode np) {
        Pref pref = this.getArcPinPref();
        pref.setString(np.getName());
    }

    public PrimitiveNode findOverridablePinProto() {
        PrimitiveNode np;
        Pref pref = this.getArcPinPref();
        String primName = pref.getString();
        if (primName != null && primName.length() > 0 && (np = this.tech.findNodeProto(primName)) != null) {
            return np;
        }
        return this.findPinProto();
    }

    public PrimitiveNode findPinProto() {
        Iterator<PrimitiveNode> it = this.tech.getNodes();
        while (it.hasNext()) {
            PrimitivePort pp;
            PrimitiveNode pn = it.next();
            if (!pn.isPin() || !(pp = (PrimitivePort)pn.getPorts().next()).connectsTo(this)) continue;
            return pn;
        }
        return null;
    }

    public PrimitiveNode makeWipablePin(String pinName, String portName) {
        double sizeOffset = DBMath.gridToLambda(this.getGridFullExtend() - this.getGridBaseExtend());
        double defSize = 2.0 * DBMath.gridToLambda(this.getGridFullExtend());
        return this.makeWipablePin(pinName, portName, sizeOffset, defSize, new ArcProto[0]);
    }

    public PrimitiveNode makeWipablePin(String pinName, String portName, double sizeOffset, double defSize, ArcProto ... extraArcs) {
        double refSize = DBMath.round(defSize * 0.5);
        Technology.NodeLayer[] nodeLayers = new Technology.NodeLayer[this.getNumArcLayers()];
        for (int i = 0; i < this.getNumArcLayers(); ++i) {
            nodeLayers[i] = new Technology.NodeLayer(this.getLayer(i).getPseudoLayer(), 0, Poly.Type.CROSSED, 1, Technology.TechPoint.makeIndented(refSize - this.getLayerLambdaExtend(i)));
        }
        SizeOffset so = null;
        if (sizeOffset != 0.0) {
            so = new SizeOffset(sizeOffset, sizeOffset, sizeOffset, sizeOffset);
        }
        PrimitiveNode pin = PrimitiveNode.newInstance(pinName, this.tech, 2.0 * refSize, 2.0 * refSize, so, nodeLayers);
        ArcProto[] connections = new ArcProto[1 + extraArcs.length];
        connections[0] = this;
        System.arraycopy(extraArcs, 0, connections, 1, extraArcs.length);
        pin.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this.tech, pin, connections, portName, 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(0.5 * defSize), EdgeV.fromBottom(0.5 * defSize), EdgeH.fromRight(0.5 * defSize), EdgeV.fromTop(0.5 * defSize))});
        pin.setFunction(PrimitiveNode.Function.PIN);
        pin.setArcsWipe();
        pin.setArcsShrink();
        return pin;
    }

    public static ArcProto findArcProto(String line) {
        String withoutPrefix;
        Technology tech = Technology.getCurrent();
        int colon = line.indexOf(58);
        if (colon == -1) {
            withoutPrefix = line;
        } else {
            String prefix = line.substring(0, colon);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
            }
            withoutPrefix = line.substring(colon + 1);
        }
        ArcProto ap = tech.findArcProto(withoutPrefix);
        if (ap != null) {
            return ap;
        }
        return null;
    }

    public int getNumArcLayers() {
        return this.layers.length;
    }

    public Layer getLayer(int arcLayerIndex) {
        return this.layers[arcLayerIndex].getLayer();
    }

    public double getLayerLambdaExtend(int arcLayerIndex) {
        return DBMath.gridToLambda(this.getLayerGridExtend(arcLayerIndex));
    }

    public int getLayerGridExtend(int arcLayerIndex) {
        return this.gridFullExtend - (this.layers[arcLayerIndex].getGridOffset() >>> 1);
    }

    public Poly.Type getLayerStyle(int arcLayerIndex) {
        return this.layers[arcLayerIndex].getStyle();
    }

    public double getLayerLambdaExtend(Layer layer) {
        return this.getLayerLambdaExtend(this.indexOf(layer));
    }

    public long getLayerGridExtend(Layer layer) {
        return this.getLayerGridExtend(this.indexOf(layer));
    }

    public Poly.Type getLayerStyle(Layer layer) {
        return this.getLayerStyle(this.indexOf(layer));
    }

    Technology.ArcLayer getArcLayer(int i) {
        return this.layers[i];
    }

    public Iterator<Layer> getLayerIterator() {
        return new LayerIterator(this.layers);
    }

    public int indexOf(Layer layer) {
        for (int arcLayerIndex = 0; arcLayerIndex < this.layers.length; ++arcLayerIndex) {
            if (this.layers[arcLayerIndex].getLayer() != layer) continue;
            return arcLayerIndex;
        }
        return -1;
    }

    protected void setArcLayerSurroundLayer(Layer outerLayer, Layer innerLayer, double surround) {
        int inLayerIndex = this.indexOf(innerLayer);
        if (inLayerIndex < 0) {
            System.out.println("Internal error in " + this.tech.getTechDesc() + " surround computation. Arc layer '" + innerLayer.getName() + "' is not valid in '" + this.getName() + "'");
            return;
        }
        int i = this.indexOf(outerLayer);
        if (i < 0) {
            System.out.println("Internal error in " + this.tech.getTechDesc() + " surround computation. Arc layer '" + outerLayer.getName() + "' is not valid in '" + this.getName() + "'");
            return;
        }
        long indent = (long)this.layers[inLayerIndex].getGridOffset() - DBMath.lambdaToGrid(surround) * 2L;
        this.layers[i] = this.layers[i].withGridOffset(indent);
        this.computeLayerGridExtendRange();
    }

    void computeLayerGridExtendRange() {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.layers.length; ++i) {
            Technology.ArcLayer primLayer = this.layers[i];
            assert (this.indexOf(primLayer.getLayer()) == i);
            min = Math.min(min, (long)this.getLayerGridExtend(i));
            max = Math.max(max, (long)this.getLayerGridExtend(i));
        }
        assert (-268435455L < min);
        assert (max < 0xFFFFFFFL && min <= max);
        this.minLayerGridExtend = (int)min;
        this.maxLayerGridExtend = (int)max;
    }

    public void getZValues(double[] array) {
        for (int j = 0; j < this.layers.length; ++j) {
            Layer layer = this.layers[j].getLayer();
            double distance = layer.getDistance();
            double thickness = layer.getThickness();
            double z = distance + thickness;
            array[0] = array[0] > distance ? distance : array[0];
            array[1] = array[1] < z ? z : array[1];
        }
    }

    public Poly[] getShapeOfDummyArc(double lambdaLength) {
        long l2 = DBMath.lambdaToGrid(lambdaLength / 2.0);
        Poly[] polys = new Poly[this.layers.length];
        for (int i = 0; i < this.layers.length; ++i) {
            Point2D[] points;
            long gridWidth = 2L * (this.getDefaultGridExtendOverMin() + (long)this.getLayerGridExtend(i));
            Poly.Type style = this.getLayerStyle(i);
            if (gridWidth == 0L) {
                points = new Point2D.Double[]{new Point2D.Double(-l2, 0.0), new Point2D.Double(l2, 0.0)};
                if (style == Poly.Type.FILLED) {
                    style = Poly.Type.OPENED;
                }
            } else {
                long w2 = gridWidth / 2L;
                assert (w2 > 0L);
                points = new Point2D.Double[]{new Point2D.Double(-l2 - w2, w2), new Point2D.Double(-l2 - w2, -w2), new Point2D.Double(l2 + w2, -w2), new Point2D.Double(l2 + w2, w2)};
                if (style.isOpened()) {
                    points = new Point2D.Double[]{points[0], points[1], points[2], points[3], (Point2D.Double)points[0].clone()};
                }
            }
            Poly poly = new Poly(points);
            poly.gridToLambda();
            poly.setStyle(style);
            poly.setLayer(this.getLayer(i));
            polys[i] = poly;
        }
        return polys;
    }

    public String describe() {
        String description = "";
        Technology tech = this.getTechnology();
        if (Technology.getCurrent() != tech) {
            description = description + tech.getTechName() + ":";
        }
        description = description + this.protoName;
        return description;
    }

    @Override
    public int compareTo(ArcProto that) {
        int cmp;
        if (this.tech != that.tech && (cmp = this.tech.compareTo(that.tech)) != 0) {
            return cmp;
        }
        return this.primArcIndex - that.primArcIndex;
    }

    public String toString() {
        return "arc " + this.describe();
    }

    void dump(PrintWriter out) {
        out.println("ArcProto " + this.getName() + " " + (Object)((Object)this.getFunction()));
        out.println("\tisWipable=" + this.isWipable());
        out.println("\tisCurvable=" + this.isCurvable());
        out.println("\tisSpecialArc=" + this.isSpecialArc());
        out.println("\tisEdgeSelect=" + this.isEdgeSelect());
        out.println("\tisNotUsed=" + this.isNotUsed());
        out.println("\tisSkipSizeInPalette=" + this.isSkipSizeInPalette());
        Technology.printlnPref(out, 1, defaultExtendPrefs.get(this));
        out.println("\tbaseExtend=" + this.getLambdaBaseExtend());
        out.println("\tdefaultLambdaBaseWidth=" + this.getDefaultLambdaBaseWidth());
        Technology.printlnPref(out, 1, defaultAnglePrefs.get(this));
        Technology.printlnPref(out, 1, defaultRigidPrefs.get(this));
        Technology.printlnPref(out, 1, defaultFixedAnglePrefs.get(this));
        Technology.printlnPref(out, 1, defaultExtendedPrefs.get(this));
        Technology.printlnPref(out, 1, defaultDirectionalPrefs.get(this));
        for (int arcLayerIndex = 0; arcLayerIndex < this.getNumArcLayers(); ++arcLayerIndex) {
            out.println("\t\tarcLayer layer=" + this.getLayer(arcLayerIndex).getName() + " style=" + this.getLayerStyle(arcLayerIndex).name() + " extend=" + this.getLayerLambdaExtend(arcLayerIndex));
        }
    }

    void check() {
        for (Technology.ArcLayer primLayer : this.layers) {
            long gridExtend = this.getLayerGridExtend(primLayer.getLayer());
            assert ((long)this.minLayerGridExtend <= gridExtend && gridExtend <= (long)this.maxLayerGridExtend);
        }
        assert (0 <= this.gridBaseExtend && this.gridBaseExtend <= this.gridFullExtend && this.gridBaseExtend <= this.maxLayerGridExtend);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerIterator
    implements Iterator<Layer> {
        Technology.ArcLayer[] array;
        int pos;

        public LayerIterator(Technology.ArcLayer[] a) {
            this.array = a;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public Layer next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Function
    extends Enum<Function> {
        public static final /* enum */ Function UNKNOWN = new Function("unknown", 0, 0);
        public static final /* enum */ Function METAL1 = new Function("metal-1", 1, 0);
        public static final /* enum */ Function METAL2 = new Function("metal-2", 2, 0);
        public static final /* enum */ Function METAL3 = new Function("metal-3", 3, 0);
        public static final /* enum */ Function METAL4 = new Function("metal-4", 4, 0);
        public static final /* enum */ Function METAL5 = new Function("metal-5", 5, 0);
        public static final /* enum */ Function METAL6 = new Function("metal-6", 6, 0);
        public static final /* enum */ Function METAL7 = new Function("metal-7", 7, 0);
        public static final /* enum */ Function METAL8 = new Function("metal-8", 8, 0);
        public static final /* enum */ Function METAL9 = new Function("metal-9", 9, 0);
        public static final /* enum */ Function METAL10 = new Function("metal-10", 10, 0);
        public static final /* enum */ Function METAL11 = new Function("metal-11", 11, 0);
        public static final /* enum */ Function METAL12 = new Function("metal-12", 12, 0);
        public static final /* enum */ Function POLY1 = new Function("polysilicon-1", 0, 1);
        public static final /* enum */ Function POLY2 = new Function("polysilicon-2", 0, 2);
        public static final /* enum */ Function POLY3 = new Function("polysilicon-3", 0, 3);
        public static final /* enum */ Function DIFF = new Function("diffusion", 0, 0);
        public static final /* enum */ Function DIFFP = new Function("p-diffusion", 0, 0);
        public static final /* enum */ Function DIFFN = new Function("n-diffusion", 0, 0);
        public static final /* enum */ Function DIFFS = new Function("substrate-diffusion", 0, 0);
        public static final /* enum */ Function DIFFW = new Function("well-diffusion", 0, 0);
        public static final /* enum */ Function BUS = new Function("bus", 0, 0);
        public static final /* enum */ Function UNROUTED = new Function("unrouted", 0, 0);
        public static final /* enum */ Function NONELEC = new Function("nonelectrical", 0, 0);
        private final String printName;
        private final int level;
        private final boolean isMetal;
        private final boolean isPoly;
        private final boolean isDiffusion;
        private static final Function[] metalLayers;
        private static final Function[] polyLayers;
        private static final /* synthetic */ Function[] $VALUES;

        public static final Function[] values() {
            return (Function[])$VALUES.clone();
        }

        public static Function valueOf(String name) {
            return Enum.valueOf(Function.class, name);
        }

        private Function(String printName, int metalLevel, int polyLevel) {
            this.printName = printName;
            this.isMetal = metalLevel != 0;
            this.isPoly = polyLevel != 0;
            this.isDiffusion = this.name().startsWith("DIFF");
            this.level = this.isMetal ? metalLevel : (this.isPoly ? polyLevel : 0);
        }

        public String toString() {
            return this.printName;
        }

        public String getConstantName() {
            return this.name();
        }

        public static List<Function> getFunctions() {
            return Arrays.asList(Function.class.getEnumConstants());
        }

        public int getLevel() {
            return this.level;
        }

        public static Function getMetal(int level) {
            return level < metalLayers.length ? metalLayers[level] : null;
        }

        public static Function getPoly(int level) {
            return level < polyLayers.length ? polyLayers[level] : null;
        }

        public boolean isMetal() {
            return this.isMetal;
        }

        public boolean isPoly() {
            return this.isPoly;
        }

        public boolean isDiffusion() {
            return this.isDiffusion;
        }

        private static Function[] initMetalLayers(Function[] allFunctions) {
            int maxLevel = -1;
            for (Function fun : Function.getFunctions()) {
                if (!fun.isMetal()) continue;
                maxLevel = Math.max(maxLevel, fun.level);
            }
            Function[] layers = new Function[maxLevel + 1];
            for (Function fun : Function.getFunctions()) {
                if (!fun.isMetal()) continue;
                assert (layers[fun.level] == null);
                layers[fun.level] = fun;
            }
            return layers;
        }

        private static Function[] initPolyLayers(Function[] allFunctions) {
            int maxLevel = -1;
            for (Function fun : Function.getFunctions()) {
                if (!fun.isPoly()) continue;
                maxLevel = Math.max(maxLevel, fun.level);
            }
            Function[] layers = new Function[maxLevel + 1];
            for (Function fun : Function.getFunctions()) {
                if (!fun.isPoly()) continue;
                assert (layers[fun.level] == null);
                layers[fun.level] = fun;
            }
            return layers;
        }

        static {
            $VALUES = new Function[]{UNKNOWN, METAL1, METAL2, METAL3, METAL4, METAL5, METAL6, METAL7, METAL8, METAL9, METAL10, METAL11, METAL12, POLY1, POLY2, POLY3, DIFF, DIFFP, DIFFN, DIFFS, DIFFW, BUS, UNROUTED, NONELEC};
            metalLayers = Function.initMetalLayers((Function[])Function.class.getEnumConstants());
            polyLayers = Function.initPolyLayers((Function[])Function.class.getEnumConstants());
        }
    }
}

