/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.ncc.Pie;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EditKeyBindings;
import com.sun.electric.tool.user.dialogs.options.AntennaRulesTab;
import com.sun.electric.tool.user.dialogs.options.CDLTab;
import com.sun.electric.tool.user.dialogs.options.CIFTab;
import com.sun.electric.tool.user.dialogs.options.CVSTab;
import com.sun.electric.tool.user.dialogs.options.CellModelTab;
import com.sun.electric.tool.user.dialogs.options.CompactionTab;
import com.sun.electric.tool.user.dialogs.options.ComponentMenuTab;
import com.sun.electric.tool.user.dialogs.options.CoverageTab;
import com.sun.electric.tool.user.dialogs.options.DEFTab;
import com.sun.electric.tool.user.dialogs.options.DRCTab;
import com.sun.electric.tool.user.dialogs.options.DXFTab;
import com.sun.electric.tool.user.dialogs.options.DaisTab;
import com.sun.electric.tool.user.dialogs.options.DesignRulesTab;
import com.sun.electric.tool.user.dialogs.options.DisplayControlTab;
import com.sun.electric.tool.user.dialogs.options.EDIFTab;
import com.sun.electric.tool.user.dialogs.options.FastHenryTab;
import com.sun.electric.tool.user.dialogs.options.FrameTab;
import com.sun.electric.tool.user.dialogs.options.GDSTab;
import com.sun.electric.tool.user.dialogs.options.GeneralTab;
import com.sun.electric.tool.user.dialogs.options.GridAndAlignmentTab;
import com.sun.electric.tool.user.dialogs.options.IconTab;
import com.sun.electric.tool.user.dialogs.options.LayersTab;
import com.sun.electric.tool.user.dialogs.options.LibraryTab;
import com.sun.electric.tool.user.dialogs.options.NCCTab;
import com.sun.electric.tool.user.dialogs.options.NetworkTab;
import com.sun.electric.tool.user.dialogs.options.NewArcsTab;
import com.sun.electric.tool.user.dialogs.options.NewNodesTab;
import com.sun.electric.tool.user.dialogs.options.ParasiticTab;
import com.sun.electric.tool.user.dialogs.options.PortsAndExportsTab;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.dialogs.options.PrintingTab;
import com.sun.electric.tool.user.dialogs.options.ProjectManagementTab;
import com.sun.electric.tool.user.dialogs.options.RoutingTab;
import com.sun.electric.tool.user.dialogs.options.SUETab;
import com.sun.electric.tool.user.dialogs.options.SelectionTab;
import com.sun.electric.tool.user.dialogs.options.SiliconCompilerTab;
import com.sun.electric.tool.user.dialogs.options.SimulatorsTab;
import com.sun.electric.tool.user.dialogs.options.SkillTab;
import com.sun.electric.tool.user.dialogs.options.SmartTextTab;
import com.sun.electric.tool.user.dialogs.options.SpiceTab;
import com.sun.electric.tool.user.dialogs.options.SunRouterTab;
import com.sun.electric.tool.user.dialogs.options.TechnologyTab;
import com.sun.electric.tool.user.dialogs.options.TextTab;
import com.sun.electric.tool.user.dialogs.options.ThreeDTab;
import com.sun.electric.tool.user.dialogs.options.UnitsTab;
import com.sun.electric.tool.user.dialogs.options.WellCheckTab;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PreferencesFrame
extends EDialog {
    private JSplitPane splitPane;
    private JTree optionTree;
    JButton cancel;
    JButton ok;
    List<PreferencePanel> optionPanes = new ArrayList<PreferencePanel>();
    private static String currentTabName = "General";
    private static String currentSectionName = "General ";
    private DefaultMutableTreeNode currentDMTN;

    public static void preferencesCommand() {
        PreferencesFrame dialog = new PreferencesFrame(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    public PreferencesFrame(Frame parent) {
        super(parent, true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Preferences");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PreferencesFrame.this.closeDialog(evt);
            }
        });
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Preferences");
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.optionTree = new JTree(treeModel);
        TreeHandler handler = new TreeHandler(this);
        this.optionTree.addMouseListener(handler);
        this.optionTree.addTreeExpansionListener(handler);
        DefaultMutableTreeNode generalSet = new DefaultMutableTreeNode("General ");
        rootNode.add(generalSet);
        this.addTreeNode(new GeneralTab(parent, true), generalSet);
        this.addTreeNode(new SelectionTab(parent, true), generalSet);
        TopLevel top = TopLevel.getCurrentJFrame();
        if (top != null && top.getEMenuBar() != null) {
            this.addTreeNode(new EditKeyBindings(top.getEMenuBar(), parent, true), generalSet);
        }
        this.addTreeNode(new ComponentMenuTab(parent, true), generalSet);
        this.addTreeNode(new NewNodesTab(parent, true), generalSet);
        this.addTreeNode(new NewArcsTab(parent, true), generalSet);
        this.addTreeNode(new ProjectManagementTab(parent, true), generalSet);
        this.addTreeNode(new CVSTab(parent, true), generalSet);
        this.addTreeNode(new PrintingTab(parent, true), generalSet);
        if (Job.getDebug()) {
            try {
                Class<?> testTab = Class.forName("com.sun.electric.plugins.tests.TestTab");
                Constructor<?> tab = testTab.getDeclaredConstructor(Frame.class, Boolean.class);
                this.addTreeNode((PreferencePanel)tab.newInstance(parent, new Boolean(true)), generalSet);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        DefaultMutableTreeNode displaySet = new DefaultMutableTreeNode("Display ");
        rootNode.add(displaySet);
        this.addTreeNode(new DisplayControlTab(parent, true), displaySet);
        this.addTreeNode(new LayersTab(parent, true), displaySet);
        this.addTreeNode(new TextTab(parent, true), displaySet);
        this.addTreeNode(new SmartTextTab(parent, true), displaySet);
        this.addTreeNode(new GridAndAlignmentTab(parent, true), displaySet);
        this.addTreeNode(new PortsAndExportsTab(parent, true), displaySet);
        this.addTreeNode(new FrameTab(parent, true), displaySet);
        this.addTreeNode(ThreeDTab.create3DTab(parent, true), displaySet);
        DefaultMutableTreeNode ioSet = new DefaultMutableTreeNode("I/O ");
        rootNode.add(ioSet);
        this.addTreeNode(new CIFTab(parent, true), ioSet);
        this.addTreeNode(new GDSTab(parent, true), ioSet);
        this.addTreeNode(new EDIFTab(parent, true), ioSet);
        this.addTreeNode(new DEFTab(parent, true), ioSet);
        this.addTreeNode(new CDLTab(parent, true), ioSet);
        this.addTreeNode(new DXFTab(parent, true), ioSet);
        this.addTreeNode(new SUETab(parent, true), ioSet);
        if (IOTool.hasDais()) {
            this.addTreeNode(new DaisTab(parent, true), ioSet);
        }
        if (IOTool.hasSkill()) {
            this.addTreeNode(new SkillTab(parent, true), ioSet);
        }
        this.addTreeNode(new LibraryTab(parent, true), ioSet);
        DefaultMutableTreeNode toolSet = new DefaultMutableTreeNode("Tools ");
        rootNode.add(toolSet);
        this.addTreeNode(new AntennaRulesTab(parent, true), toolSet);
        this.addTreeNode(new CompactionTab(parent, true), toolSet);
        this.addTreeNode(new CoverageTab(parent, true), toolSet);
        this.addTreeNode(new DRCTab(parent, true), toolSet);
        this.addTreeNode(new FastHenryTab(parent, true), toolSet);
        this.addTreeNode(new NCCTab(parent, true), toolSet);
        if (Pie.hasPie()) {
            try {
                Class<?> pTab = Class.forName("com.sun.electric.plugins.pie.ui.PIETab");
                Constructor<?> tab = pTab.getDeclaredConstructor(Frame.class, Boolean.TYPE);
                this.addTreeNode((PreferencePanel)tab.newInstance(parent, new Boolean(true)), toolSet);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.addTreeNode(new NetworkTab(parent, true), toolSet);
        this.addTreeNode(new ParasiticTab(parent, true), toolSet);
        this.addTreeNode(new RoutingTab(parent, true), toolSet);
        this.addTreeNode(new SiliconCompilerTab(parent, true), toolSet);
        this.addTreeNode(new SimulatorsTab(parent, true), toolSet);
        this.addTreeNode(new SpiceTab(parent, true), toolSet);
        this.addTreeNode(new CellModelTab(parent, true, CellModelPrefs.spiceModelPrefs), toolSet);
        if (Routing.hasSunRouter()) {
            this.addTreeNode(new SunRouterTab(parent, true), toolSet);
        }
        this.addTreeNode(new CellModelTab(parent, true, CellModelPrefs.verilogModelPrefs), toolSet);
        this.addTreeNode(new WellCheckTab(parent, true), toolSet);
        DefaultMutableTreeNode techSet = new DefaultMutableTreeNode("Technology ");
        rootNode.add(techSet);
        this.addTreeNode(new TechnologyTab(parent, true), techSet);
        this.addTreeNode(new DesignRulesTab(parent, true), techSet);
        this.addTreeNode(new UnitsTab(parent, true), techSet);
        this.addTreeNode(new IconTab(parent, true), techSet);
        TreePath topPath = this.optionTree.getPathForRow(0);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getPathForRow(1);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getNextMatch(currentSectionName, 0, null);
        this.optionTree.expandPath(topPath);
        this.openSelectedPath(rootNode);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        JScrollPane scrolledTree = new JScrollPane(this.optionTree);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        leftPanel.add((Component)scrolledTree, gbc);
        JButton save = new JButton("Export");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.exportActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)save, gbc);
        JButton restore = new JButton("Import");
        restore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.importActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)restore, gbc);
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.helpActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)help, gbc);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.cancelActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.cancel, gbc);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.okActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.ok, gbc);
        this.getRootPane().setDefaultButton(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.splitPane = new JSplitPane(1);
        this.loadOptionPanel();
        this.splitPane.setLeftComponent(leftPanel);
        PreferencesFrame.recursivelyHighlight(this.optionTree, rootNode, this.currentDMTN, this.optionTree.getPathForRow(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane, gbc);
        this.pack();
        this.finishInitialization();
    }

    private void addTreeNode(PreferencePanel panel, DefaultMutableTreeNode theSet) {
        this.optionPanes.add(panel);
        String sectionName = (String)theSet.getUserObject();
        String name = panel.getName();
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(name);
        theSet.add(dmtn);
        if (sectionName.equals(currentSectionName) && name.equals(currentTabName)) {
            this.currentDMTN = dmtn;
        }
    }

    private boolean openSelectedPath(DefaultMutableTreeNode rootNode) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            Object o = node.getUserObject();
            if (o.toString().equals(currentTabName)) {
                this.optionTree.scrollPathToVisible(new TreePath(node.getPath()));
                return true;
            }
            if (!this.openSelectedPath(node)) continue;
            return true;
        }
        return false;
    }

    private void cancelActionPerformed() {
        this.closeDialog(null);
    }

    private void okActionPerformed() {
        new OKUpdate(this);
    }

    private void helpActionPerformed() {
        ManualViewer.showPreferenceHelp(currentSectionName.trim() + "/" + currentTabName);
        this.closeDialog(null);
    }

    private void exportActionPerformed() {
        Job.getUserInterface().exportPrefs();
    }

    private void importActionPerformed() {
        Job.getUserInterface().importPrefs();
        TopLevel top = TopLevel.getCurrentJFrame();
        top.getEMenuBar().restoreSavedBindings(false);
        Technology.cacheTransparentLayerColors();
        this.closeDialog(null);
        EditWindow.repaintAllContents();
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.loadComponentMenuForTechnology();
        }
    }

    private void loadOptionPanel() {
        for (PreferencePanel ti : this.optionPanes) {
            if (!ti.getName().equals(currentTabName)) continue;
            if (!ti.isInited()) {
                ti.init();
                ti.setInited();
            }
            this.splitPane.setRightComponent(ti.getPanel());
            return;
        }
    }

    protected void escapePressed() {
        this.cancelActionPerformed();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TreeHandler
    implements MouseListener,
    TreeExpansionListener {
        private PreferencesFrame dialog;

        TreeHandler(PreferencesFrame dialog) {
            this.dialog = dialog;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            TreePath currentPath = this.dialog.optionTree.getPathForLocation(e.getX(), e.getY());
            if (currentPath == null) {
                return;
            }
            this.dialog.optionTree.setSelectionPath(currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
            currentTabName = (String)node.getUserObject();
            this.dialog.optionTree.expandPath(currentPath);
            if (currentTabName.endsWith(" ")) {
                currentSectionName = currentTabName;
            } else {
                this.dialog.loadOptionPanel();
            }
            this.dialog.pack();
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            this.dialog.pack();
        }

        public void treeExpanded(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            if (tp.getPathCount() == 2) {
                TreePath topPath = this.dialog.optionTree.getPathForRow(0);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)topPath.getLastPathComponent();
                int numChildren = node.getChildCount();
                for (int i = 0; i < numChildren; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    TreePath descentPath = topPath.pathByAddingChild(child);
                    if (descentPath.getLastPathComponent().equals(tp.getLastPathComponent())) {
                        DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)descentPath.getLastPathComponent();
                        currentSectionName = (String)subNode.getUserObject();
                        continue;
                    }
                    this.dialog.optionTree.collapsePath(descentPath);
                }
            }
            this.dialog.pack();
        }
    }

    private static class OKUpdate
    extends Job {
        private transient PreferencesFrame dialog;
        private Pref.PrefChangeBatch changeBatch;

        private OKUpdate(PreferencesFrame dialog) {
            super("Update Preferences", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            Pref.gatherPrefChanges();
            for (PreferencePanel ti : dialog.optionPanes) {
                if (!ti.isInited()) continue;
                ti.term();
            }
            this.changeBatch = Pref.getPrefChanges();
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Pref.implementPrefChanges(this.changeBatch);
            return true;
        }

        public void terminateOK() {
            this.dialog.closeDialog(null);
        }
    }
}

