/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.ArchSim;
import com.sun.electric.tool.io.output.CIF;
import com.sun.electric.tool.io.output.DELIB;
import com.sun.electric.tool.io.output.DXF;
import com.sun.electric.tool.io.output.ECAD;
import com.sun.electric.tool.io.output.EDIF;
import com.sun.electric.tool.io.output.ELIB;
import com.sun.electric.tool.io.output.Eagle;
import com.sun.electric.tool.io.output.FastHenry;
import com.sun.electric.tool.io.output.GDS;
import com.sun.electric.tool.io.output.HPGL;
import com.sun.electric.tool.io.output.IRSIM;
import com.sun.electric.tool.io.output.JELIB;
import com.sun.electric.tool.io.output.L;
import com.sun.electric.tool.io.output.LEF;
import com.sun.electric.tool.io.output.MOSSIM;
import com.sun.electric.tool.io.output.Maxwell;
import com.sun.electric.tool.io.output.PAL;
import com.sun.electric.tool.io.output.Pads;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.io.output.ReadableDump;
import com.sun.electric.tool.io.output.Silos;
import com.sun.electric.tool.io.output.Sim;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Tegas;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.user.User;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output {
    protected String filePath;
    protected PrintWriter printWriter;
    protected StringWriter stringWriter;
    protected DataOutputStream dataOutputStream;
    protected boolean quiet;
    private int lineCharCount = 0;
    private int maxWidth = 80;
    private boolean strictWidthLimit = false;
    private String continuationString = "";

    public static void exportCellCommand(Cell cell, VarContext context, String filePath, FileType type, List<PolyBase> override) {
        new OutputCellInfo(cell, context, filePath, type, override);
    }

    protected boolean writeCell(Cell cell, VarContext context) {
        return true;
    }

    public static boolean writePanicSnapshot(Snapshot panicSnapshot, File panicDir, boolean oldRevision) {
        FileType type = FileType.JELIB;
        HashMap<LibId, URL> libFiles = new HashMap<LibId, URL>();
        TreeMap<String, LibId> sortedLibs = new TreeMap<String, LibId>(TextUtils.STRING_NUMBER_ORDER);
        for (LibraryBackup libBackup : panicSnapshot.libBackups) {
            if (libBackup == null || (libBackup.d.flags & 0x80) != 0) continue;
            LibId libId = libBackup.d.libId;
            String libName = libBackup.d.libId.libName;
            URL libURL = libBackup.d.libFile;
            File newLibFile = null;
            if (libURL == null || libURL.getPath() == null) {
                newLibFile = new File(panicDir.getAbsolutePath(), libName + "." + type.getExtensions()[0]);
            } else {
                File libFile = new File(libURL.getPath());
                String fileName = libFile.getName();
                if (fileName == null) {
                    fileName = libName + "." + type.getExtensions()[0];
                }
                newLibFile = new File(panicDir.getAbsolutePath(), fileName);
            }
            URL newLibURL = TextUtils.makeURLToFile(newLibFile.getAbsolutePath());
            libFiles.put(libId, newLibURL);
            sortedLibs.put(libName, libId);
        }
        boolean error = false;
        if (oldRevision) {
            IdMapper idMapper = IdMapper.consolidateExportIds(panicSnapshot);
            panicSnapshot = panicSnapshot.withRenamedIds(idMapper, null, null);
        }
        for (LibId libId : sortedLibs.values()) {
            System.out.print(".");
            System.out.flush();
            JELIB jelib = new JELIB();
            URL libURL = (URL)libFiles.get(libId);
            String properOutputName = TextUtils.getFilePath(libURL) + TextUtils.getFileNameWithoutExtension(libURL) + ".jelib";
            if (!jelib.openTextOutputStream(properOutputName) && !jelib.writeLib(panicSnapshot, libId, libFiles, oldRevision) && !jelib.closeTextOutputStream()) continue;
            System.out.println("Error saving " + panicSnapshot.getLib((LibId)libId).d.libId.libName);
            error = true;
        }
        System.out.println(" Libraries saved");
        return error;
    }

    public static boolean saveJelib(String newName, Library lib) {
        HashMap<LibId, URL> libFiles = new HashMap<LibId, URL>();
        URL libURL = lib.getLibFile();
        if (newName != null) {
            libURL = TextUtils.makeURLToFile(newName);
            libFiles.put(lib.getId(), libURL);
        }
        boolean error = false;
        JELIB jelib = new JELIB();
        String properOutputName = TextUtils.getFilePath(libURL) + TextUtils.getFileNameWithoutExtension(libURL) + ".jelib";
        if (jelib.openTextOutputStream(properOutputName) || jelib.writeLib(lib.getDatabase().backupUnsafe(), lib.getId(), libFiles, false) || jelib.closeTextOutputStream()) {
            System.out.println("Error saving " + lib.getName());
            error = true;
        }
        return error;
    }

    public static boolean writeLibrary(Library lib, FileType type, boolean compatibleWith6, boolean quiet, boolean delibHeaderOnly) {
        String properOutputName;
        LibId libId;
        Snapshot snapshot;
        block39: {
            File newFile;
            int backupScheme;
            String properOutputNameWithoutExtension;
            block40: {
                Iterator<Listener> it = Tool.getListeners();
                while (it.hasNext()) {
                    Listener listener = it.next();
                    listener.writeLibrary(lib);
                }
                snapshot = lib.getDatabase().backup();
                libId = lib.getId();
                URL libFile = lib.getLibFile();
                if (libFile == null) {
                    libFile = TextUtils.makeURLToFile(lib.getName());
                }
                properOutputName = properOutputNameWithoutExtension = TextUtils.getFilePath(libFile) + TextUtils.getFileNameWithoutExtension(libFile);
                if (type == FileType.ELIB) {
                    properOutputName = properOutputName + ".elib";
                }
                if (type == FileType.JELIB) {
                    properOutputName = properOutputName + ".jelib";
                }
                if (type == FileType.DELIB) {
                    properOutputName = properOutputName + ".delib";
                }
                if (type == FileType.READABLEDUMP) {
                    properOutputName = properOutputName + ".txt";
                }
                if (type != FileType.ELIB && type != FileType.JELIB && type != FileType.DELIB) break block39;
                backupScheme = IOTool.getBackupRedundancy();
                if (backupScheme != 1) break block40;
                File newFile2 = new File(properOutputName);
                if (!newFile2.exists()) break block39;
                String backupFileName = properOutputName + "~";
                File oldFile = new File(backupFileName);
                boolean canRename = true;
                if (oldFile.exists() && !oldFile.delete()) {
                    System.out.println("Unable to delete former library file " + oldFile);
                    canRename = false;
                }
                if (canRename && !newFile2.renameTo(oldFile)) {
                    System.out.println("Unable to rename " + newFile2 + " to " + oldFile);
                }
                break block39;
            }
            if (backupScheme == 2 && (newFile = new File(properOutputName)).exists()) {
                long modified = newFile.lastModified();
                Date modifiedDate = new Date(modified);
                SimpleDateFormat sdf = new SimpleDateFormat("-yyyy-MM-dd");
                for (int i = 0; i < 1000; ++i) {
                    File oldFile;
                    String backupFileName = properOutputNameWithoutExtension + sdf.format(modifiedDate);
                    if (i != 0) {
                        backupFileName = backupFileName + "--" + i;
                    }
                    if ((oldFile = new File(backupFileName = backupFileName + "." + type.getExtensions()[0])).exists()) continue;
                    if (newFile.renameTo(oldFile)) break;
                    System.out.println("Unable to rename " + newFile + " to " + oldFile);
                    break;
                }
            }
        }
        if (type == FileType.ELIB || type == FileType.JELIB) {
            if (type == FileType.ELIB) {
                ELIB elib = new ELIB();
                elib.quiet = quiet;
                if (compatibleWith6) {
                    elib.write6Compatible();
                }
                if (elib.openBinaryOutputStream(properOutputName)) {
                    return true;
                }
                if (CVS.isEnabled()) {
                    CVSLibrary.savingLibrary(lib);
                }
                if (elib.writeLib(snapshot, libId)) {
                    return true;
                }
                if (elib.closeBinaryOutputStream()) {
                    return true;
                }
                if (CVS.isEnabled()) {
                    CVSLibrary.savedLibrary(lib);
                }
            } else {
                JELIB jelib = new JELIB();
                jelib.quiet = quiet;
                if (jelib.openTextOutputStream(properOutputName)) {
                    return true;
                }
                if (CVS.isEnabled()) {
                    CVSLibrary.savingLibrary(lib);
                }
                if (jelib.writeLib(snapshot, libId, null, false)) {
                    return true;
                }
                if (jelib.closeTextOutputStream()) {
                    return true;
                }
                if (CVS.isEnabled()) {
                    CVSLibrary.savedLibrary(lib);
                }
            }
        } else if (type == FileType.READABLEDUMP) {
            ReadableDump readableDump = new ReadableDump();
            readableDump.quiet = quiet;
            if (readableDump.openTextOutputStream(properOutputName)) {
                return true;
            }
            if (readableDump.writeLib(snapshot, libId)) {
                return true;
            }
            if (readableDump.closeTextOutputStream()) {
                return true;
            }
        } else if (type == FileType.DELIB) {
            DELIB delib = new DELIB(delibHeaderOnly);
            delib.quiet = quiet;
            if (delib.openTextOutputStream(properOutputName)) {
                return true;
            }
            if (CVS.isEnabled() && !delibHeaderOnly) {
                CVSLibrary.savingLibrary(lib);
            }
            if (delib.writeLib(snapshot, libId, lib.getDelibCellFiles())) {
                return true;
            }
            if (delib.closeTextOutputStream()) {
                return true;
            }
            if (CVS.isEnabled() && !delibHeaderOnly) {
                CVSLibrary.savedLibrary(lib, delib.getDeletedCellFiles(), delib.getWrittenCellFiles());
            }
        } else {
            System.out.println("Unknown export type: " + type);
            return true;
        }
        lib.setFromDisk();
        if (!quiet) {
            System.out.println(properOutputName + " written");
        }
        lib.setVersion(Version.getVersion());
        lib.clearChanged();
        Constraints.getCurrent().writeLibrary(lib);
        return false;
    }

    public static void writeCell(Cell cell, VarContext context, String filePath, FileType type, List<PolyBase> override) {
        if (type == FileType.ARCHSIM) {
            ArchSim.writeArchSimFile(cell, filePath);
        } else if (type == FileType.CDL) {
            Spice.writeSpiceFile(cell, context, filePath, true);
        } else if (type == FileType.CIF) {
            CIF.writeCIFFile(cell, context, filePath);
        } else if (type == FileType.COSMOS) {
            Sim.writeSimFile(cell, context, filePath, type);
        } else if (type == FileType.DXF) {
            DXF.writeDXFFile(cell, filePath);
        } else if (type == FileType.EAGLE) {
            Eagle.writeEagleFile(cell, context, filePath);
        } else if (type == FileType.ECAD) {
            ECAD.writeECADFile(cell, context, filePath);
        } else if (type == FileType.EDIF) {
            EDIF.writeEDIFFile(cell, context, filePath);
        } else if (type == FileType.ESIM || type == FileType.RSIM) {
            Sim.writeSimFile(cell, context, filePath, type);
        } else if (type == FileType.FASTHENRY) {
            FastHenry.writeFastHenryFile(cell, context, filePath);
        } else if (type == FileType.HPGL) {
            HPGL.writeHPGLFile(cell, context, filePath);
        } else if (type == FileType.GDS) {
            GDS.writeGDSFile(cell, context, filePath);
        } else if (type == FileType.IRSIM) {
            Technology layoutTech = Schematics.getDefaultSchematicTechnology();
            IRSIM.writeIRSIMFile(cell, context, layoutTech, filePath);
        } else if (type == FileType.L) {
            L.writeLFile(cell, filePath);
        } else if (type == FileType.LEF) {
            LEF.writeLEFFile(cell, context, filePath);
        } else if (type == FileType.MAXWELL) {
            Maxwell.writeMaxwellFile(cell, context, filePath);
        } else if (type == FileType.MOSSIM) {
            MOSSIM.writeMOSSIMFile(cell, context, filePath);
        } else if (type == FileType.PADS) {
            Pads.writePadsFile(cell, context, filePath);
        } else if (type == FileType.PAL) {
            PAL.writePALFile(cell, context, filePath);
        } else if (type == FileType.POSTSCRIPT || type == FileType.EPS) {
            PostScript.writePostScriptFile(cell, filePath, override);
        } else if (type == FileType.SILOS) {
            Silos.writeSilosFile(cell, context, filePath);
        } else if (type == FileType.SKILL) {
            IOTool.writeSkill(cell, filePath, false);
        } else if (type == FileType.SKILLEXPORTSONLY) {
            IOTool.writeSkill(cell, filePath, true);
        } else if (type == FileType.SPICE) {
            Spice.writeSpiceFile(cell, context, filePath, false);
        } else if (type == FileType.TEGAS) {
            Tegas.writeTegasFile(cell, context, filePath);
        } else if (type == FileType.VERILOG) {
            Verilog.writeVerilogFile(cell, context, filePath);
        }
    }

    String diskName(ElectricObject owner, Variable var) {
        String portName = null;
        if (owner instanceof PortInst) {
            PortInst pi = (PortInst)owner;
            portName = pi.getPortProto().getName();
        }
        return this.diskName(portName, var);
    }

    String diskName(String portName, Variable var) {
        if (portName == null) {
            return var.getKey().getName();
        }
        StringBuffer sb = new StringBuffer("ATTRP_");
        for (int i = 0; i < portName.length(); ++i) {
            char ch = portName.charAt(i);
            if (ch == '\\' || ch == '_') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append('_');
        sb.append(var.getKey().getName());
        return sb.toString();
    }

    protected boolean openBinaryOutputStream(String filePath) {
        FileOutputStream fileOutputStream;
        this.filePath = filePath;
        try {
            fileOutputStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not write file " + filePath);
            System.out.println("Reason: " + e.getMessage());
            return true;
        }
        BufferedOutputStream bufStrm = new BufferedOutputStream(fileOutputStream);
        this.dataOutputStream = new DataOutputStream(bufStrm);
        return false;
    }

    protected boolean closeBinaryOutputStream() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing " + this.filePath);
            return true;
        }
        return false;
    }

    protected boolean openTextOutputStream(String filePath) {
        this.filePath = filePath;
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath + ": " + e.getMessage());
            return true;
        }
        return false;
    }

    protected boolean closeTextOutputStream() {
        this.printWriter.close();
        return false;
    }

    protected void openStringsOutputStream() {
        this.stringWriter = new StringWriter();
    }

    protected List<String> closeStringsOutputStream() {
        StringBuffer sb = this.stringWriter.getBuffer();
        String[] lines = sb.toString().split("\n");
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            strings.add(lines[i]);
        }
        return strings;
    }

    protected void emitCopyright(String prefix, String postfix) {
        if (!IOTool.isUseCopyrightMessage()) {
            return;
        }
        String str = IOTool.getCopyrightMessage();
        int start = 0;
        while (start < str.length()) {
            int endPos = str.indexOf(10, start);
            if (endPos < 0) {
                endPos = str.length();
            }
            String oneLine = str.substring(start, endPos);
            this.writeChunk(prefix + oneLine + postfix + "\n");
            start = endPos + 1;
        }
    }

    protected void setOutputWidth(int width, boolean strict) {
        this.maxWidth = width;
        this.strictWidthLimit = strict;
    }

    protected void setContinuationString(String str) {
        this.continuationString = str;
    }

    private void writeChunk(String str) {
        int len = str.length();
        if (len <= 0) {
            return;
        }
        if (this.printWriter != null) {
            this.printWriter.print(str);
        } else if (this.stringWriter != null) {
            this.stringWriter.write(str);
        }
        this.lineCharCount += len;
        if (str.charAt(len - 1) == '\n') {
            this.lineCharCount = 0;
        }
    }

    protected void writeWidthLimited(String str) {
        int len;
        while ((len = str.length()) > 0) {
            int i = str.indexOf(10);
            i = i < 0 ? len : ++i;
            if (this.lineCharCount + i < this.maxWidth) {
                String chunk = str;
                if (i < len) {
                    chunk = str.substring(0, i);
                }
                this.writeChunk(chunk);
                if ((str = str.substring(i)).length() != 0) continue;
                break;
            }
            String exact = str.substring(0, this.maxWidth - this.lineCharCount);
            int splitPos = exact.lastIndexOf(32);
            if (splitPos < 0) {
                int semiPos;
                int closePos;
                int openPos;
                int commaPos = exact.lastIndexOf(44);
                if (commaPos > splitPos) {
                    splitPos = commaPos;
                }
                if ((openPos = exact.lastIndexOf(40)) > splitPos) {
                    splitPos = openPos;
                }
                if ((closePos = exact.lastIndexOf(41)) > splitPos) {
                    splitPos = closePos;
                }
                if ((semiPos = exact.lastIndexOf(59)) > splitPos) {
                    splitPos = semiPos;
                }
                if (splitPos < 0) {
                    splitPos = exact.length() - 1;
                    if (!this.strictWidthLimit) {
                        splitPos = str.length() - 1;
                        int spacePos = str.indexOf(32);
                        if (spacePos >= 0 && spacePos < splitPos) {
                            splitPos = spacePos;
                        }
                        if ((commaPos = str.indexOf(44)) >= 0 && commaPos < splitPos) {
                            splitPos = commaPos;
                        }
                        if ((openPos = str.indexOf(40)) >= 0 && openPos < splitPos) {
                            splitPos = openPos;
                        }
                        if ((closePos = str.indexOf(41)) >= 0 && closePos < splitPos) {
                            splitPos = closePos;
                        }
                        if ((semiPos = str.indexOf(59)) >= 0 && semiPos < splitPos) {
                            splitPos = semiPos;
                        }
                    }
                }
            }
            while (splitPos + 1 < str.length() && str.charAt(splitPos + 1) == '\n') {
                ++splitPos;
            }
            exact = str.substring(0, splitPos + 1);
            this.writeChunk(exact);
            if (!exact.endsWith("\n")) {
                this.writeChunk("\n");
                if (this.continuationString.length() > 0) {
                    this.writeChunk(this.continuationString);
                }
            }
            str = str.substring(exact.length());
        }
    }

    public static Rectangle2D getAreaToPrint(Cell cell, boolean reduce, EditWindow_ wnd) {
        ERectangle cb = cell.getBounds();
        Rectangle2D bounds = new Rectangle2D.Double(cb.getMinX(), cb.getMinY(), cb.getWidth(), cb.getHeight());
        if (wnd != null) {
            bounds = wnd.getBoundsInWindow();
        }
        if (reduce) {
            double wid = bounds.getWidth() * 0.75;
            double hei = bounds.getHeight() * 0.75;
            bounds.setRect(bounds.getCenterX(), bounds.getCenterY(), wid, hei);
        }
        if (IOTool.getPlotArea() != 0) {
            if (wnd == null) {
                System.out.println("No current window: printing entire cell");
            } else if (IOTool.getPlotArea() == 2) {
                bounds = wnd.getDisplayedBounds();
            } else {
                Rectangle2D hBounds = wnd.getHighlightedArea();
                if (hBounds == null || hBounds.getWidth() == 0.0 || hBounds.getHeight() == 0.0) {
                    System.out.println("Warning: no highlighted area; printing entire cell");
                } else {
                    bounds = hBounds;
                }
            }
        }
        return bounds;
    }

    public static class WriteJELIB
    extends Job {
        private Library lib;
        private String newName;
        private IdMapper idMapper;

        public WriteJELIB(Library lib, String newName) {
            super("Write " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            boolean error = false;
            try {
                if (this.newName != null) {
                    URL libURL = TextUtils.makeURLToFile(this.newName);
                    this.lib.setLibFile(libURL);
                    this.idMapper = this.lib.setName(TextUtils.getFileNameWithoutExtension(libURL));
                    if (this.idMapper != null) {
                        this.lib = EDatabase.serverDatabase().getLib(this.idMapper.get(this.lib.getId()));
                    }
                }
                this.fieldVariableChanged("idMapper");
                error = Output.writeLibrary(this.lib, FileType.JELIB, false, false, false);
            }
            catch (Exception e) {
                throw new JobException("Exception caught when saving library: " + e.getMessage());
            }
            return !error;
        }

        public void terminateOK() {
            User.fixStaleCellReferences(this.idMapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OutputCellInfo
    extends Job {
        private Cell cell;
        private VarContext context;
        private String filePath;
        private FileType type;
        private List<PolyBase> override;

        public OutputCellInfo(Cell cell, VarContext context, String filePath, FileType type, List<PolyBase> override) {
            super("Export " + cell + " (" + type + ")", IOTool.getIOTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.context = context;
            this.filePath = filePath;
            this.type = type;
            this.override = override;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Output.writeCell(this.cell, this.context, this.filePath, this.type, this.override);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NetNamesSort
    implements Comparator<NetNames> {
        NetNamesSort() {
        }

        @Override
        public int compare(NetNames nn1, NetNames nn2) {
            String name1 = nn1.netName;
            String name2 = nn2.netName;
            return name1.compareToIgnoreCase(name2);
        }
    }

    static class NetNames {
        String nodeName;
        String netName;
        String portName;

        NetNames() {
        }
    }
}

