/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class HighlightLine
extends Highlight2 {
    protected Point2D start;
    protected Point2D end;
    protected Point2D center;
    protected boolean thickLine;

    HighlightLine(Cell c, Point2D s, Point2D e, Point2D cen, boolean thick) {
        super(c);
        this.start = s;
        this.end = e;
        this.center = cen;
        this.thickLine = thick;
    }

    public void showInternalHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, boolean setConnected) {
        Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.start.getX(), this.start.getY()), new Point2D.Double(this.end.getX(), this.end.getY())};
        HighlightLine.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, this.thickLine);
    }

    Rectangle2D getHighlightedArea(EditWindow wnd) {
        double cX = Math.min(this.start.getX(), this.end.getX());
        double cY = Math.min(this.start.getY(), this.end.getY());
        double sX = Math.abs(this.start.getX() - this.end.getX());
        double sY = Math.abs(this.start.getY() - this.end.getY());
        return new Rectangle2D.Double(cX, cY, sX, sY);
    }

    public String getInfo() {
        String description = "Line from (" + this.start.getX() + "," + this.start.getY() + ") to (" + this.end.getX() + "," + this.end.getY() + ")";
        return description;
    }
}

