/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogAnalysis;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.ComplexWaveform;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.Waveform;
import com.sun.electric.tool.simulation.WaveformImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSpiceOut
extends Simulate {
    private static final boolean DEBUGCONDITIONS = false;
    private boolean isTRACDCBinary;
    private boolean isTRACDCBinarySwapped;
    private String fileBase;
    private String trExtension;
    private String swExtension;
    private String icExtension;
    private String acExtension;
    private String mtExtension;
    private String paExtension;
    private int binaryTRACDCSize;
    private int binaryTRACDCPosition;
    private boolean eofReached;
    private byte[] binaryTRACDCBuffer;

    HSpiceOut() {
    }

    @Override
    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        Stimuli sd = new Stimuli();
        sd.setCell(cell);
        this.fileBase = fileURL.getFile();
        this.trExtension = "tr0";
        this.swExtension = "sw0";
        this.icExtension = "ic0";
        this.acExtension = "ac0";
        this.mtExtension = "mt0";
        this.paExtension = "pa0";
        int dotPos = this.fileBase.lastIndexOf(46);
        if (dotPos > 0) {
            String extension = this.fileBase.substring(dotPos + 1);
            this.fileBase = this.fileBase.substring(0, dotPos);
            if (extension.startsWith("tr") || extension.startsWith("sw") || extension.startsWith("ic") || extension.startsWith("ac") || extension.startsWith("mt") || extension.startsWith("pa")) {
                this.trExtension = "tr" + extension.substring(2);
                this.swExtension = "sw" + extension.substring(2);
                this.icExtension = "ic" + extension.substring(2);
                this.acExtension = "ac" + extension.substring(2);
                this.mtExtension = "mt" + extension.substring(2);
                this.paExtension = "pa" + extension.substring(2);
            }
        }
        List<PALine> paList = this.readPAFile(fileURL);
        this.addTRData(sd, paList, fileURL);
        this.addDCData(sd, paList, fileURL);
        this.addACData(sd, paList, fileURL);
        this.addMeasurementData(sd, fileURL);
        return sd;
    }

    private void addMeasurementData(Stimuli sd, URL fileURL) throws IOException {
        String nextLine;
        URL mtURL = null;
        try {
            mtURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.mtExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (mtURL == null) {
            return;
        }
        if (!TextUtils.URLExists(mtURL)) {
            return;
        }
        if (this.openTextInput(mtURL)) {
            return;
        }
        System.out.println("Reading HSpice measurements '" + mtURL.getFile() + "'");
        AnalogAnalysis an = new AnalogAnalysis(sd, AnalogAnalysis.ANALYSIS_MEAS, false);
        ArrayList<String> measurementNames = new ArrayList<String>();
        HashMap measurementData = new HashMap();
        String lastLine = null;
        while ((nextLine = lastLine) != null || (nextLine = this.lineReader.readLine()) != null) {
            List mData;
            String mName;
            int i;
            if (nextLine.startsWith("$") || nextLine.startsWith(".")) continue;
            String[] keywords = this.breakMTLine(nextLine, false);
            if (keywords.length == 0) break;
            if (measurementNames.size() == 0) {
                int i2;
                for (i2 = 0; i2 < keywords.length; ++i2) {
                    measurementNames.add(keywords[i2]);
                }
                while ((lastLine = this.lineReader.readLine()) != null) {
                    keywords = this.breakMTLine(lastLine, true);
                    if (keywords.length == 0) {
                        lastLine = null;
                        break;
                    }
                    if (TextUtils.isANumber(keywords[0])) break;
                    for (i2 = 0; i2 < keywords.length; ++i2) {
                        if (keywords[i2].length() <= 0) continue;
                        measurementNames.add(keywords[i2]);
                    }
                }
                for (String mName2 : measurementNames) {
                    measurementData.put(mName2, new ArrayList());
                }
                continue;
            }
            int index = 0;
            for (i = 0; i < keywords.length; ++i) {
                if (keywords[i].length() == 0) continue;
                mName = (String)measurementNames.get(index++);
                mData = (List)measurementData.get(mName);
                mData.add(new Double(TextUtils.atof(keywords[i])));
            }
            while (index < measurementNames.size() && (lastLine = this.lineReader.readLine()) != null && (keywords = this.breakMTLine(lastLine, true)).length != 0) {
                for (i = 0; i < keywords.length; ++i) {
                    if (keywords[i].length() == 0) continue;
                    mName = (String)measurementNames.get(index++);
                    mData = (List)measurementData.get(mName);
                    mData.add(new Double(TextUtils.atof(keywords[i])));
                }
            }
            lastLine = null;
        }
        List argMeas = (List)measurementData.get(measurementNames.get(0));
        an.buildCommonTime(argMeas.size());
        for (int i = 0; i < argMeas.size(); ++i) {
            an.setCommonTime(i, (Double)argMeas.get(i));
        }
        ArrayList<AnalogSignal> measData = new ArrayList<AnalogSignal>();
        for (String mName : measurementNames) {
            List mData = (List)measurementData.get(mName);
            double[] values = new double[mData.size()];
            for (int i = 0; i < mData.size(); ++i) {
                values[i] = (Double)mData.get(i);
            }
            if (mName.equals("alter#")) {
                mName = "alter";
            }
            AnalogSignal as = an.addSignal(mName, null, values);
            measData.add(as);
        }
        this.closeInput();
    }

    private String[] breakMTLine(String line, boolean continuation) {
        ArrayList<String> strings = new ArrayList<String>();
        int i = 1;
        while (line.length() > i + 1) {
            int end = i + 17;
            if (end > line.length()) {
                end = line.length();
            }
            while (end < line.length() && line.charAt(end - 1) != ' ') {
                ++end;
            }
            String part = line.substring(i, end).trim();
            if (part.length() > 0) {
                strings.add(part.trim());
            }
            i = end;
        }
        int actualSize = strings.size();
        String[] retVal = new String[actualSize];
        for (int i2 = 0; i2 < actualSize; ++i2) {
            retVal[i2] = (String)strings.get(i2);
        }
        return retVal;
    }

    private void addTRData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        URL swURL = null;
        try {
            swURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.trExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (swURL == null) {
            return;
        }
        if (!TextUtils.URLExists(swURL)) {
            return;
        }
        this.readTRDCACFile(sd, swURL, paList, Analysis.ANALYSIS_TRANS);
    }

    private void addDCData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        URL swURL = null;
        try {
            swURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.swExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (swURL != null && TextUtils.URLExists(swURL)) {
            this.readTRDCACFile(sd, swURL, paList, Analysis.ANALYSIS_DC);
            return;
        }
        URL icURL = null;
        try {
            icURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.icExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (icURL != null && TextUtils.URLExists(icURL)) {
            System.out.println("WARNING: Cannot read old DC format file (." + this.icExtension + ")...must provide new format (." + this.swExtension + "): " + this.fileBase + "." + this.icExtension);
            return;
        }
    }

    private void addACData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        URL acURL = null;
        try {
            acURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.acExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (acURL == null) {
            return;
        }
        if (!TextUtils.URLExists(acURL)) {
            return;
        }
        this.readTRDCACFile(sd, acURL, paList, Analysis.ANALYSIS_AC);
    }

    private List<PALine> readPAFile(URL fileURL) throws IOException {
        String nextLine;
        URL paURL = null;
        try {
            paURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.paExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (paURL == null) {
            return null;
        }
        if (!TextUtils.URLExists(paURL)) {
            return null;
        }
        if (this.openTextInput(paURL)) {
            return null;
        }
        ArrayList<PALine> paList = new ArrayList<PALine>();
        while ((nextLine = this.lineReader.readLine()) != null) {
            String trimLine = nextLine.trim();
            int spacePos = trimLine.indexOf(32);
            if (spacePos <= 0) continue;
            PALine pl = new PALine();
            pl.number = TextUtils.atoi(trimLine, 0, 10);
            pl.string = HSpiceOut.removeLeadingX(trimLine.substring(spacePos + 1).trim());
            paList.add(pl);
        }
        this.closeInput();
        return paList;
    }

    private void readTRDCACFile(Stimuli sd, URL fileURL, List<PALine> paList, Analysis.AnalysisType analysisType) throws IOException {
        int i;
        int l;
        int j;
        int k;
        int j2;
        if (this.openBinaryInput(fileURL)) {
            return;
        }
        this.eofReached = false;
        this.resetBinaryTRACDCReader();
        SweepAnalysis an = new SweepAnalysis(sd, analysisType);
        HSpiceOut.startProgressDialog("HSpice " + analysisType.toString() + " analysis", fileURL.getFile());
        System.out.println("Reading HSpice " + analysisType.toString() + " analysis '" + fileURL.getFile() + "'");
        int nodcnt = this.getHSpiceInt();
        int numnoi = this.getHSpiceInt();
        int cndcnt = this.getHSpiceInt();
        StringBuffer line = new StringBuffer();
        for (int j3 = 0; j3 < 4; ++j3) {
            line.append((char)this.getByteFromFile());
        }
        int multiplier = TextUtils.atoi(line.toString(), 0, 10);
        int numSignals = numnoi + (nodcnt += multiplier * 10000) - 1;
        if (numSignals <= 0) {
            System.out.println("Error reading " + fileURL.getFile());
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        int version = this.getHSpiceInt();
        if (version != 9007 && version != 9601) {
            System.out.println("Warning: may not be able to read HSpice files of type " + version);
        }
        line = new StringBuffer();
        for (j2 = 0; j2 < 76; ++j2) {
            k = this.getByteFromFile();
            line.append((char)k);
            if (this.isTRACDCBinary || k != 10) continue;
            --j2;
        }
        line = new StringBuffer();
        for (j2 = 0; j2 < 16; ++j2) {
            line.append((char)this.getByteFromFile());
        }
        line = new StringBuffer();
        for (j2 = 0; j2 < 72; ++j2) {
            k = this.getByteFromFile();
            line.append((char)k);
            if (this.isTRACDCBinary || k != 10) continue;
            --j2;
        }
        int sweepcnt = this.getHSpiceInt();
        if (cndcnt == 0) {
            sweepcnt = 0;
        }
        line = new StringBuffer();
        for (int j4 = 0; j4 < 76; ++j4) {
            int k2 = this.getByteFromFile();
            line.append((char)k2);
            if (this.isTRACDCBinary || k2 != 10) continue;
            --j4;
        }
        String[] signalNames = new String[numSignals];
        int[] signalTypes = new int[numSignals];
        for (int k3 = 0; k3 <= numSignals; ++k3) {
            line = new StringBuffer();
            for (j = 0; j < 8; ++j) {
                int l2 = this.getByteFromFile();
                line.append((char)l2);
                if (this.isTRACDCBinary || l2 != 10) continue;
                --j;
            }
            if (k3 == 0) continue;
            int l3 = k3 - nodcnt;
            if (k3 < nodcnt) {
                l3 = k3 + numnoi - 1;
            }
            String lineStr = line.toString().trim();
            signalTypes[l3] = TextUtils.atoi(lineStr, 0, 10);
        }
        boolean paMissingWarned = false;
        for (int k4 = 0; k4 <= numSignals; ++k4) {
            line = new StringBuffer();
            while (true) {
                int l4;
                if ((l4 = this.getByteFromFile()) == 10) {
                    continue;
                }
                if (l4 == 32) {
                    if (line.length() == 0) {
                        while ((l4 = this.getByteFromFile()) == 32) {
                        }
                    }
                    break;
                }
                line.append((char)l4);
                if (version == 9007 && line.length() >= 16) break;
            }
            int j5 = line.length();
            l = (j5 + 16) / 16 * 16 - 1;
            if (version == 9007) {
                l = (j5 + 15) / 16 * 16 - 1;
            }
            while (j5 < l) {
                i = this.getByteFromFile();
                if (!this.isTRACDCBinary && i == 10) {
                    --j5;
                }
                ++j5;
            }
            if (k4 == 0) continue;
            int startPos = 0;
            int openPos = line.indexOf("(");
            if (openPos >= 0) {
                startPos = openPos + 1;
            }
            for (j5 = startPos; j5 < line.length() && line.charAt(j5) != ':' && TextUtils.isDigit(line.charAt(j5)); ++j5) {
            }
            if (j5 < line.length() && line.charAt(j5) == ':') {
                l = TextUtils.atoi(line.toString().substring(startPos), 0, 10);
                PALine foundPALine = null;
                if (paList == null) {
                    if (!paMissingWarned) {
                        System.out.println("Warning: there should be a ." + this.paExtension + " file with extra signal names");
                    }
                    paMissingWarned = true;
                } else {
                    for (PALine paLine : paList) {
                        if (paLine.number != l) continue;
                        foundPALine = paLine;
                        break;
                    }
                }
                if (foundPALine != null) {
                    StringBuffer newSB = new StringBuffer();
                    newSB.append(line.substring(0, startPos));
                    newSB.append(foundPALine.string);
                    newSB.append(line.substring(j5 + 1));
                    line = newSB;
                }
            } else if (line.indexOf(".") >= 0) {
                String fixedLine = HSpiceOut.removeLeadingX(line.toString());
                line = new StringBuffer();
                line.append(fixedLine);
            }
            openPos = line.indexOf("(");
            if (openPos >= 0) {
                StringBuffer newSB;
                String parenPrefix = line.substring(0, openPos + 1);
                int lastDot = line.lastIndexOf(".");
                if (lastDot >= 0) {
                    newSB = new StringBuffer();
                    if (parenPrefix.equalsIgnoreCase("v(")) {
                        newSB.append(line.substring(openPos + 1, lastDot + 1));
                        newSB.append(line.substring(lastDot + 1, line.length() - 1));
                    } else {
                        newSB.append(line.substring(openPos + 1, lastDot + 1));
                        newSB.append(parenPrefix);
                        newSB.append(line.substring(lastDot + 1));
                    }
                    line = newSB;
                } else if (parenPrefix.equalsIgnoreCase("v(")) {
                    newSB = new StringBuffer();
                    newSB.append(line.substring(openPos + 1, line.length() - 1));
                    line = newSB;
                }
            }
            l = k4 < nodcnt ? k4 + numnoi - 1 : k4 - nodcnt;
            signalNames[l] = line.toString();
        }
        for (int c = 0; c < cndcnt; ++c) {
            int j6 = 0;
            line = new StringBuffer();
            while (true) {
                if ((l = this.getByteFromFile()) == 10) {
                    continue;
                }
                if (l == 32) break;
                line.append((char)l);
                if (++j6 >= 16) break;
            }
            l = (j6 + 15) / 16 * 16 - 1;
            while (j6 < l) {
                i = this.getByteFromFile();
                if (!this.isTRACDCBinary && i == 10) {
                    --j6;
                }
                ++j6;
            }
        }
        line = new StringBuffer();
        if (!this.isTRACDCBinary) {
            int l5;
            j = 0;
            while ((l5 = this.getByteFromFile()) != 10) {
                if (j < 4) {
                    line.append(l5);
                }
                ++j;
            }
        } else {
            for (j = 0; j < 4; ++j) {
                line.append((char)this.getByteFromFile());
            }
        }
        if (!line.toString().equals("$&%#")) {
            System.out.println("HSpice header improperly terminated (got " + line.toString() + ")");
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        this.resetBinaryTRACDCReader();
        boolean isComplex = analysisType == Analysis.ANALYSIS_AC;
        double[] minValues = new double[numSignals];
        double[] maxValues = new double[numSignals];
        Arrays.fill(minValues, Double.POSITIVE_INFINITY);
        Arrays.fill(maxValues, Double.NEGATIVE_INFINITY);
        int sweepCounter = sweepcnt;
        while (true) {
            if (sweepcnt > 0) {
                float sweepValue = this.getHSpiceFloat(false);
                if (this.eofReached) {
                    System.out.println("EOF before sweep data");
                    break;
                }
                String sweepName = TextUtils.formatDouble(sweepValue);
                for (int i2 = 2; i2 < cndcnt; ++i2) {
                    float anotherSweepValue = this.getHSpiceFloat(false);
                    if (this.eofReached) {
                        System.out.println("EOF reading sweep header");
                        break;
                    }
                    sweepName = sweepName + "," + TextUtils.formatDouble(anotherSweepValue);
                }
                an.addSweep(sweepName);
            }
            ArrayList<float[]> allTheData = new ArrayList<float[]>();
            while (true) {
                float time = this.getHSpiceFloat(true);
                if (this.eofReached) break;
                float[] oneSetOfData = new float[isComplex ? numSignals * 2 + 1 : numSignals + 1];
                oneSetOfData[0] = time;
                for (int k5 = 0; k5 < numSignals; ++k5) {
                    double value;
                    int numSignal = (k5 + numnoi) % numSignals;
                    if (isComplex) {
                        float realPart = this.getHSpiceFloat(false);
                        float imagPart = this.getHSpiceFloat(false);
                        oneSetOfData[numSignal * 2 + 1] = realPart;
                        oneSetOfData[numSignal * 2 + 2] = imagPart;
                        value = Math.hypot(realPart, imagPart);
                    } else {
                        float f = this.getHSpiceFloat(false);
                        oneSetOfData[numSignal + 1] = f;
                        value = f;
                    }
                    if (this.eofReached) {
                        System.out.println("EOF in the middle of the data (at " + k5 + " out of " + numSignals + " after " + allTheData.size() + " sets of data)");
                        break;
                    }
                    if (value < minValues[numSignal]) {
                        minValues[numSignal] = value;
                    }
                    if (!(value > maxValues[numSignal])) continue;
                    maxValues[numSignal] = value;
                }
                if (this.eofReached) {
                    System.out.println("EOF before the end of the data");
                    break;
                }
                allTheData.add(oneSetOfData);
            }
            an.theSweeps.add(allTheData);
            if (--sweepCounter <= 0) break;
            this.eofReached = false;
        }
        this.closeInput();
        an.commonTime = new double[an.theSweeps.size()][];
        double minTime = Double.POSITIVE_INFINITY;
        double maxTime = Double.NEGATIVE_INFINITY;
        for (int sweepNum = 0; sweepNum < an.commonTime.length; ++sweepNum) {
            List<float[]> allTheData = an.theSweeps.get(sweepNum);
            an.commonTime[sweepNum] = new double[allTheData.size()];
            for (int eventNum = 0; eventNum < allTheData.size(); ++eventNum) {
                double time;
                an.commonTime[sweepNum][eventNum] = time = (double)allTheData.get(eventNum)[0];
                if (time < minTime) {
                    minTime = time;
                }
                if (!(time > maxTime)) continue;
                maxTime = time;
            }
        }
        String constantPrefix = null;
        boolean hasPrefix = true;
        for (int k6 = 0; k6 < numSignals; ++k6) {
            String name = signalNames[k6];
            int dotPos = name.indexOf(46);
            if (dotPos < 0) continue;
            String prefix = name.substring(0, dotPos);
            if (constantPrefix == null) {
                constantPrefix = prefix;
            }
            if (constantPrefix.equals(prefix)) continue;
            hasPrefix = false;
            break;
        }
        if (!hasPrefix) {
            constantPrefix = null;
        } else {
            String fileName = fileURL.getFile();
            int pos = fileName.lastIndexOf(File.separatorChar);
            if (pos >= 0) {
                fileName = fileName.substring(pos + 1);
            }
            if ((pos = fileName.lastIndexOf(47)) >= 0) {
                fileName = fileName.substring(pos + 1);
            }
            if ((pos = fileName.indexOf(46)) >= 0) {
                fileName = fileName.substring(0, pos);
            }
            constantPrefix = fileName.equals(constantPrefix) ? constantPrefix + "." : null;
        }
        for (int k7 = 0; k7 < numSignals; ++k7) {
            String name = signalNames[k7];
            if (constantPrefix != null && name.startsWith(constantPrefix)) {
                name = name.substring(constantPrefix.length());
            }
            String context = null;
            int lastDotPos = name.lastIndexOf(46);
            if (lastDotPos >= 0) {
                context = name.substring(0, lastDotPos);
                name = name.substring(lastDotPos + 1);
            }
            an.addSignal(name, context, minTime, maxTime, minValues[k7], maxValues[k7]);
        }
        HSpiceOut.stopProgressDialog();
        System.out.println("Done reading " + analysisType.toString() + " analysis");
    }

    private void resetBinaryTRACDCReader() {
        this.binaryTRACDCSize = 0;
        this.binaryTRACDCPosition = 0;
    }

    private boolean readBinaryTRACDCBlock(boolean firstbyteread) throws IOException {
        int amtread;
        int i;
        if (!firstbyteread) {
            if (this.dataInputStream.read() == -1) {
                return true;
            }
            this.updateProgressDialog(1);
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(3);
        int blocks = 0;
        for (i = 0; i < 4; ++i) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            blocks = this.isTRACDCBinarySwapped ? blocks >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : blocks << 8 | uval;
        }
        this.updateProgressDialog(4);
        for (i = 0; i < 4; ++i) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(4);
        int bytes = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            bytes = this.isTRACDCBinarySwapped ? bytes >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : bytes << 8 | uval;
        }
        this.updateProgressDialog(4);
        if (bytes > 8192) {
            System.out.println("ERROR: block is " + bytes + " long, but limit is 8192");
            bytes = 8192;
        }
        if ((amtread = this.dataInputStream.read(this.binaryTRACDCBuffer, 0, bytes)) != bytes) {
            System.out.println("Expected to read " + bytes + " bytes but got only " + amtread);
            return true;
        }
        this.updateProgressDialog(bytes);
        int trailer = 0;
        for (int i4 = 0; i4 < 4; ++i4) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            trailer = this.isTRACDCBinarySwapped ? trailer >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : trailer << 8 | uval;
        }
        if (trailer != bytes) {
            System.out.println("Block trailer claims block had " + trailer + " bytes but block really had " + bytes);
            return true;
        }
        this.updateProgressDialog(4);
        this.binaryTRACDCPosition = 0;
        this.binaryTRACDCSize = bytes;
        return false;
    }

    private int getByteFromFile() throws IOException {
        int i;
        if (this.byteCount == 0L) {
            i = this.dataInputStream.read();
            if (i == -1) {
                return i;
            }
            this.updateProgressDialog(1);
            if (i == 0 || i == 4) {
                this.isTRACDCBinary = true;
                this.isTRACDCBinarySwapped = false;
                if (i == 4) {
                    this.isTRACDCBinarySwapped = true;
                }
                this.binaryTRACDCBuffer = new byte[8192];
                if (this.readBinaryTRACDCBlock(true)) {
                    return -1;
                }
            } else {
                this.isTRACDCBinary = false;
                return i;
            }
        }
        if (this.isTRACDCBinary) {
            if (this.binaryTRACDCPosition >= this.binaryTRACDCSize && this.readBinaryTRACDCBlock(false)) {
                return -1;
            }
            byte val = this.binaryTRACDCBuffer[this.binaryTRACDCPosition];
            ++this.binaryTRACDCPosition;
            return val & 0xFF;
        }
        i = this.dataInputStream.read();
        this.updateProgressDialog(1);
        return i;
    }

    private int getHSpiceInt() throws IOException {
        StringBuffer line = new StringBuffer();
        for (int j = 0; j < 4; ++j) {
            line.append((char)this.getByteFromFile());
        }
        return TextUtils.atoi(line.toString().trim(), 0, 10);
    }

    private float getHSpiceFloat(boolean testEOFValue) throws IOException {
        if (!this.isTRACDCBinary) {
            StringBuffer line = new StringBuffer();
            for (int j = 0; j < 11; ++j) {
                int l = this.getByteFromFile();
                if (l == -1) {
                    this.eofReached = true;
                    return 0.0f;
                }
                line.append((char)l);
                if (l != 10) continue;
                --j;
            }
            String result = line.toString();
            if (testEOFValue && result.equals("0.10000E+31")) {
                this.eofReached = true;
                return 0.0f;
            }
            return (float)TextUtils.atof(result);
        }
        int fi0 = this.getByteFromFile();
        int fi1 = this.getByteFromFile();
        int fi2 = this.getByteFromFile();
        int fi3 = this.getByteFromFile();
        if (fi0 < 0 || fi1 < 0 || fi2 < 0 || fi3 < 0) {
            this.eofReached = true;
            return 0.0f;
        }
        int fi = 0;
        fi = this.isTRACDCBinarySwapped ? fi3 << 24 | fi2 << 16 | fi1 << 8 | fi0 : (fi0 &= 0xFF) << 24 | (fi1 &= 0xFF) << 16 | (fi2 &= 0xFF) << 8 | (fi3 &= 0xFF);
        float f = Float.intBitsToFloat(fi);
        if (testEOFValue && (double)f > 1.0E30 && (double)f < 1.00000002E30) {
            this.eofReached = true;
            return 0.0f;
        }
        return f;
    }

    private static class SweepAnalysis
    extends AnalogAnalysis {
        double[][] commonTime;
        List<List<float[]>> theSweeps = new ArrayList<List<float[]>>();

        private SweepAnalysis(Stimuli sd, Analysis.AnalysisType type) {
            super(sd, type, false);
        }

        protected Waveform[] loadWaveforms(AnalogSignal signal) {
            int sigIndex = signal.getIndexInAnalysis();
            Waveform[] waveforms = new Waveform[this.commonTime.length];
            for (int sweep = 0; sweep < waveforms.length; ++sweep) {
                WaveformImpl waveform;
                double[] times = this.commonTime[sweep];
                List<float[]> theSweep = this.theSweeps.get(sweep);
                if (this.getAnalysisType() == ANALYSIS_AC) {
                    double[] realValues = new double[times.length];
                    double[] imagValues = new double[times.length];
                    for (int eventNum = 0; eventNum < realValues.length; ++eventNum) {
                        float[] eventValues = theSweep.get(eventNum);
                        realValues[eventNum] = eventValues[sigIndex * 2 + 1];
                        imagValues[eventNum] = eventValues[sigIndex * 2 + 2];
                    }
                    waveform = new ComplexWaveform(times, realValues, imagValues);
                } else {
                    double[] values = new double[times.length];
                    for (int eventNum = 0; eventNum < values.length; ++eventNum) {
                        values[eventNum] = theSweep.get(eventNum)[sigIndex + 1];
                    }
                    waveform = new WaveformImpl(times, values);
                }
                waveforms[sweep] = waveform;
            }
            return waveforms;
        }
    }

    private static class PALine {
        int number;
        String string;

        private PALine() {
        }
    }
}

