/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.KeeperHigh;
import com.sun.electric.tool.generator.layout.KeeperLow;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Placer;
import com.sun.electric.tool.generator.layout.PortFilter;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.generator.layout.gates.Inv;
import com.sun.electric.tool.generator.layout.gates.Inv2i;
import com.sun.electric.tool.generator.layout.gates.Inv2iKn;
import com.sun.electric.tool.generator.layout.gates.Inv2iKp;
import com.sun.electric.tool.generator.layout.gates.InvCTLn;
import com.sun.electric.tool.generator.layout.gates.InvHT;
import com.sun.electric.tool.generator.layout.gates.InvLT;
import com.sun.electric.tool.generator.layout.gates.Inv_passgate;
import com.sun.electric.tool.generator.layout.gates.Nand2;
import com.sun.electric.tool.generator.layout.gates.Nand2HLT;
import com.sun.electric.tool.generator.layout.gates.Nand2HLT_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2LT;
import com.sun.electric.tool.generator.layout.gates.Nand2LT_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2PH;
import com.sun.electric.tool.generator.layout.gates.Nand2PHfk;
import com.sun.electric.tool.generator.layout.gates.Nand2_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2en;
import com.sun.electric.tool.generator.layout.gates.Nand2en_sy;
import com.sun.electric.tool.generator.layout.gates.Nand3;
import com.sun.electric.tool.generator.layout.gates.Nand3LT;
import com.sun.electric.tool.generator.layout.gates.Nand3LT_sy3;
import com.sun.electric.tool.generator.layout.gates.Nand3MLT;
import com.sun.electric.tool.generator.layout.gates.Nand3_sy3;
import com.sun.electric.tool.generator.layout.gates.Nand3en_sy;
import com.sun.electric.tool.generator.layout.gates.Nand3en_sy3;
import com.sun.electric.tool.generator.layout.gates.Nms1;
import com.sun.electric.tool.generator.layout.gates.Nms2;
import com.sun.electric.tool.generator.layout.gates.Nms2_sy;
import com.sun.electric.tool.generator.layout.gates.Nms3_sy3;
import com.sun.electric.tool.generator.layout.gates.Nor2;
import com.sun.electric.tool.generator.layout.gates.Nor2LT;
import com.sun.electric.tool.generator.layout.gates.Nor2kresetV;
import com.sun.electric.tool.generator.layout.gates.Pms1;
import com.sun.electric.tool.generator.layout.gates.Pms2;
import com.sun.electric.tool.generator.layout.gates.Pms2_sy;
import com.sun.electric.tool.generator.layout.gates.TieHi;
import com.sun.electric.tool.generator.layout.gates.VertTrack;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemToLay {
    static final PortFilter SKIP_WIRE_PORTINSTS = new SkipWirePortInsts();

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private static double getNumericVal(Object val) {
        if (val == null) {
            System.out.println("null value detected, using 40");
            return 40.0;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        SchemToLay.error(true, "not a numeric value: " + val);
        return 0.0;
    }

    private static Cell getPurpleLay(NodeInst iconInst, VarContext context, StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        NodeProto prot = iconInst.getProto();
        String pNm = prot.getName();
        if (!iconInst.isCellInstance()) {
            if (pNm.equals("Power")) {
                return TieHi.makePart(stdCell);
            }
            if (pNm.equals("Ground")) {
                // empty if block
            }
            SchemToLay.error(true, "can't generate layout for PrimitiveNode: " + pNm);
        }
        if (pNm.equals("keeper_high{ic}")) {
            Cell npe = ((Cell)iconInst.getProto()).getEquivalent();
            return KeeperHigh.makePart(npe, context.push(iconInst), stdCell);
        }
        if (pNm.equals("keeper_low{ic}")) {
            Cell npe = ((Cell)iconInst.getProto()).getEquivalent();
            return KeeperLow.makePart(npe, context.push(iconInst), stdCell);
        }
        Variable var = iconInst.getParameterOrVariable(tech.getAttrS());
        if (var == null) {
            var = iconInst.getParameterOrVariable(tech.getAttrSP());
        }
        if (var == null) {
            var = iconInst.getParameterOrVariable(tech.getAttrSN());
        }
        if (var == null) {
            var = iconInst.getParameterOrVariable(tech.getAttrX());
        }
        double x = SchemToLay.getNumericVal(context.evalVar(var));
        StdCellParams sc = stdCell;
        if (pNm.equals("nms1{ic}")) {
            return Nms1.makePart(x, sc);
        }
        if (pNm.equals("nms1K{ic}")) {
            return Nms1.makePart(x, sc);
        }
        if (pNm.equals("nms2{ic}")) {
            return Nms2.makePart(x, sc);
        }
        if (pNm.equals("nms2_sy{ic}")) {
            return Nms2_sy.makePart(x, sc);
        }
        if (pNm.equals("nms3_sy3{ic}")) {
            return Nms3_sy3.makePart(x, sc);
        }
        if (pNm.equals("pms1{ic}")) {
            return Pms1.makePart(x, sc);
        }
        if (pNm.equals("pms1K{ic}")) {
            return Pms1.makePart(x, sc);
        }
        if (pNm.equals("pms2{ic}")) {
            return Pms2.makePart(x, sc);
        }
        if (pNm.equals("pms2_sy{ic}")) {
            return Pms2_sy.makePart(x, sc);
        }
        if (pNm.equals("inv{ic}")) {
            return Inv.makePart(x, sc);
        }
        if (pNm.equals("invCTLn{ic}")) {
            return InvCTLn.makePart(x, sc);
        }
        if (pNm.equals("inv_ll{ic}")) {
            return Inv.makePart(x, sc);
        }
        if (pNm.equals("inv_passgate{ic}")) {
            return Inv_passgate.makePart(x, sc);
        }
        if (pNm.equals("inv2i{ic}")) {
            return Inv2i.makePart(x, sc);
        }
        if (pNm.equals("inv2iKp{ic}")) {
            return Inv2iKp.makePart(x, sc);
        }
        if (pNm.equals("inv2iKn{ic}")) {
            return Inv2iKn.makePart(x, sc);
        }
        if (pNm.equals("invLT{ic}")) {
            return InvLT.makePart(x, sc);
        }
        if (pNm.equals("invHT{ic}")) {
            return InvHT.makePart(x, sc);
        }
        if (pNm.equals("nand2{ic}")) {
            return Nand2.makePart(x, sc);
        }
        if (pNm.equals("nand2k{ic}")) {
            return Nand2.makePart(x, sc);
        }
        if (pNm.equals("nand2en{ic}")) {
            return Nand2en.makePart(x, sc);
        }
        if (pNm.equals("nand2en_sy{ic}")) {
            return Nand2en_sy.makePart(x, sc);
        }
        if (pNm.equals("nand2HLT{ic}")) {
            return Nand2HLT.makePart(x, sc);
        }
        if (pNm.equals("nand2LT{ic}")) {
            return Nand2LT.makePart(x, sc);
        }
        if (pNm.equals("nand2_sy{ic}")) {
            return Nand2_sy.makePart(x, sc);
        }
        if (pNm.equals("nand2HLT_sy{ic}")) {
            return Nand2HLT_sy.makePart(x, sc);
        }
        if (pNm.equals("nand2LT_sy{ic}")) {
            return Nand2LT_sy.makePart(x, sc);
        }
        if (pNm.equals("nand2PH{ic}")) {
            return Nand2PH.makePart(x, sc);
        }
        if (pNm.equals("nand2PHfk{ic}")) {
            return Nand2PHfk.makePart(x, sc);
        }
        if (pNm.equals("nand3{ic}")) {
            return Nand3.makePart(x, sc);
        }
        if (pNm.equals("nand3MLT{ic}")) {
            return Nand3MLT.makePart(x, sc);
        }
        if (pNm.equals("nand3LT{ic}")) {
            return Nand3LT.makePart(x, sc);
        }
        if (pNm.equals("nand3_sy3{ic}")) {
            return Nand3_sy3.makePart(x, sc);
        }
        if (pNm.equals("nand3en_sy{ic}")) {
            return Nand3en_sy.makePart(x, sc);
        }
        if (pNm.equals("nand3LT_sy3{ic}")) {
            return Nand3LT_sy3.makePart(x, sc);
        }
        if (pNm.equals("nand3en_sy3{ic}")) {
            return Nand3en_sy3.makePart(x, sc);
        }
        if (pNm.equals("nor2{ic}")) {
            return Nor2.makePart(x, sc);
        }
        if (pNm.equals("nor2LT{ic}")) {
            return Nor2LT.makePart(x, sc);
        }
        if (pNm.equals("nor2kresetV{ic}")) {
            return Nor2kresetV.makePart(x, sc);
        }
        if (pNm.equals("invK{ic}")) {
            return Inv.makePart(x, sc);
        }
        SchemToLay.error(true, "Don't know how to generate layout for schematic icon: " + pNm);
        return null;
    }

    private static boolean isNstkNm(String nm) {
        return nm.startsWith("nms1") || nm.startsWith("nms2") || nm.startsWith("NmosWellTie");
    }

    private static boolean isPstkNm(String nm) {
        return nm.startsWith("pms1") || nm.startsWith("pms2") || nm.startsWith("PmosWellTie");
    }

    private static boolean isNstk(NodeInst ni) {
        return SchemToLay.isNstkNm(ni.getProto().getName());
    }

    private static boolean isPstk(NodeInst ni) {
        return SchemToLay.isPstkNm(ni.getProto().getName());
    }

    private static boolean isUsefulIconInst(NodeInst ni, Cell schematic) {
        if (ni.isIconOfParent()) {
            return false;
        }
        NodeProto np = ni.getProto();
        if (!ni.isCellInstance()) {
            return np.getName().equals("Power") || np.getName().equals("Ground");
        }
        Cell c = (Cell)np;
        if (!c.getView().getFullName().equals("icon")) {
            return false;
        }
        return !c.getName().equals("wire{ic}");
    }

    private static void makeLayoutInsts(ArrayList<NodeInst> layInsts, HashMap<NodeInst, NodeInst> iconToLay, Cell schematic, Cell gasp, VarContext context, StdCellParams stdCell) {
        Iterator<NodeInst> iconInsts = schematic.getNodes();
        while (iconInsts.hasNext()) {
            NodeInst iconInst = iconInsts.next();
            if (!SchemToLay.isUsefulIconInst(iconInst, schematic)) continue;
            Cell lay = SchemToLay.getPurpleLay(iconInst, context, stdCell);
            NodeInst layInst = LayoutLib.newNodeInst(lay, 0.0, 0.0, 1.0, 1.0, 0.0, gasp);
            iconToLay.put(iconInst, layInst);
            layInsts.add(layInst);
        }
    }

    private static ArrayList<Network> sortNets(Iterator<Network> nets) {
        ArrayList<Network> sortedNets = new ArrayList<Network>();
        while (nets.hasNext()) {
            sortedNets.add(nets.next());
        }
        Comparator<Network> netNmComp = new Comparator<Network>(){

            @Override
            public int compare(Network n1, Network n2) {
                Iterator<String> nms1 = n1.getNames();
                Iterator<String> nms2 = n2.getNames();
                if (!nms1.hasNext() && !nms2.hasNext()) {
                    return 0;
                }
                if (!nms1.hasNext()) {
                    return 1;
                }
                if (!nms2.hasNext()) {
                    return -1;
                }
                String nm1 = nms1.next();
                String nm2 = nms2.next();
                return nm1.compareTo(nm2);
            }
        };
        Collections.sort(sortedNets, netNmComp);
        return sortedNets;
    }

    private static void buildRouteSegs(ArrayList<RouteSeg> stkSegs, ArrayList<RouteSeg> noStkSegs, ArrayList<NodeInst> vertTracks, Iterator<Network> nets, HashMap<NodeInst, NodeInst> iconToLay, HashMap<String, Object> expTrkAsgn, StdCellParams stdCell, Cell gasp) {
        ArrayList<Network> sortedNets = SchemToLay.sortNets(nets);
        for (int i = 0; i < sortedNets.size(); ++i) {
            Network net = sortedNets.get(i);
            RouteSeg r = new RouteSeg(net, iconToLay, expTrkAsgn);
            if (r.getAllPorts().size() == 0) continue;
            if (r.hasNstk() && r.hasPstk()) {
                RouteSeg pr = r.splitOffPstkRouteSeg(vertTracks, stdCell, gasp);
                stkSegs.add(r);
                stkSegs.add(pr);
                continue;
            }
            if (r.hasNstk() || r.hasPstk()) {
                stkSegs.add(r);
                continue;
            }
            noStkSegs.add(r);
        }
    }

    private static void sortPortsLeftToRight(ArrayList<PortInst> ports) {
        Comparator<PortInst> compare = new Comparator<PortInst>(){

            @Override
            public int compare(PortInst p1, PortInst p2) {
                double diff = LayoutLib.roundCenterX(p1) - LayoutLib.roundCenterX(p2);
                if (diff < 0.0) {
                    return -1;
                }
                if (diff == 0.0) {
                    return 0;
                }
                return 1;
            }
        };
        Collections.sort(ports, compare);
    }

    private static void metal1route(PortInst prev, PortInst port, TechType tech) {
        NodeInst prevInst = prev.getNodeInst();
        if (SchemToLay.isNstk(prevInst) || SchemToLay.isPstk(prevInst)) {
            LayoutLib.newArcInst(tech.m1(), 4.0, prev, port);
        } else {
            LayoutLib.newArcInst(tech.m1(), 4.0, port, prev);
        }
    }

    private static void metal1route(ArrayList<PortInst> ports, TechType tech) {
        double ADJACENT_DIST = 7.0;
        for (int i = 1; i < ports.size(); ++i) {
            PortInst prev = ports.get(i - 1);
            PortInst port = ports.get(i);
            double dx = LayoutLib.roundCenterX(port) - LayoutLib.roundCenterX(prev);
            SchemToLay.error(dx <= 0.0, "metal1route: ports not sorted left to right!");
            if (dx <= 7.0) {
                SchemToLay.metal1route(prev, port, tech);
                ports.remove(--i);
            }
            prev = port;
        }
    }

    private static void connectSegment(RouteSeg r, TrackAllocator trackAlloc, StdCellParams stdCell, Cell gasp) {
        TechType tech = stdCell.getTechType();
        ArrayList<PortInst> ports = r.getAllPorts();
        SchemToLay.sortPortsLeftToRight(ports);
        SchemToLay.metal1route(ports, tech);
        if (ports.size() <= 1 && !r.hasExports()) {
            return;
        }
        double trackY = r.hasExpTrk() ? stdCell.getPhysTrackY(r.getExpTrk()) : trackAlloc.getTrackY(r, 4.0);
        TrackRouterH route = new TrackRouterH(tech.m2(), 4.0, trackY, tech, gasp);
        Iterator<Export> expIt = r.findExports();
        while (expIt.hasNext()) {
            Export exp = expIt.next();
            String expNm = exp.getName();
            SchemToLay.error(ports.size() == 0, "No device ports on this net?: " + expNm);
            double x = LayoutLib.roundCenterX(ports.get(0));
            LayoutLib.newExport(gasp, expNm, exp.getCharacteristic(), tech.m2(), 4.0, x, trackY);
            route.connect(gasp.findExport(expNm));
        }
        route.connect(ports);
    }

    private static void connectSegments(TrackAllocator trackAlloc, ArrayList<RouteSeg> segs, boolean exports, StdCellParams stdCell, Cell gasp) {
        for (int i = 0; i < segs.size(); ++i) {
            RouteSeg r = segs.get(i);
            if (exports != r.hasExports()) continue;
            SchemToLay.connectSegment(r, trackAlloc, stdCell, gasp);
        }
    }

    private static void buildPlacerNetlist(Placer placer, ArrayList<NodeInst> insts, ArrayList<RouteSeg> routeSegs) {
        int i;
        HashMap<PortInst, Placer.Port> portToPlacerPort = new HashMap<PortInst, Placer.Port>();
        for (i = 0; i < insts.size(); ++i) {
            NodeInst inst = insts.get(i);
            int type = SchemToLay.isNstk(inst) ? 1 : (SchemToLay.isPstk(inst) ? 0 : 2);
            double w = inst.getBounds().getWidth();
            Placer.Inst plInst = placer.addInst(type, w, inst);
            Iterator<PortInst> it = inst.getPortInsts();
            while (it.hasNext()) {
                PortInst port = it.next();
                double x = LayoutLib.roundCenterX(port);
                double y = LayoutLib.roundCenterY(port);
                Placer.Port plPort = plInst.addPort(x, y);
                portToPlacerPort.put(port, plPort);
            }
        }
        for (i = 0; i < routeSegs.size(); ++i) {
            RouteSeg seg = routeSegs.get(i);
            Placer.Net plNet = placer.addNet();
            ArrayList<PortInst> ports = seg.getAllPorts();
            for (int j = 0; j < ports.size(); ++j) {
                PortInst port = ports.get(j);
                Placer.Port plPort = (Placer.Port)portToPlacerPort.get(port);
                SchemToLay.error(plPort == null, "can't find placer port");
                plNet.addPort(plPort);
            }
        }
    }

    private static ArrayList<NodeInst> place(ArrayList<NodeInst> insts, ArrayList<RouteSeg> routeSegs, StdCellParams stdCell, Cell gasp) {
        Placer placer = new Placer(stdCell, gasp);
        SchemToLay.buildPlacerNetlist(placer, insts, routeSegs);
        ArrayList<NodeInst> ans = placer.place1row();
        return ans;
    }

    private static void connectWellTies(ArrayList<NodeInst> layInsts, StdCellParams stdCell, Cell gasp) {
        TechType tech = stdCell.getTechType();
        if (stdCell.getSeparateWellTies()) {
            TrackRouterH nTie = new TrackRouterH(tech.m2(), stdCell.getNmosWellTieWidth(), stdCell.getNmosWellTieY(), tech, gasp);
            LayoutLib.newExport(gasp, stdCell.getNmosWellTieName(), stdCell.getNmosWellTieRole(), tech.m2(), 4.0, stdCell.getNmosWellTieWidth() / 2.0 + 1.5, stdCell.getNmosWellTieY());
            nTie.connect(gasp.findExport(stdCell.getNmosWellTieName()));
            nTie.connect(layInsts, stdCell.getNmosWellTieName());
            TrackRouterH pTie = new TrackRouterH(tech.m2(), stdCell.getPmosWellTieWidth(), stdCell.getPmosWellTieY(), tech, gasp);
            LayoutLib.newExport(gasp, stdCell.getPmosWellTieName(), stdCell.getPmosWellTieRole(), tech.m2(), 4.0, stdCell.getPmosWellTieWidth() / 2.0 + 1.5, stdCell.getPmosWellTieY());
            pTie.connect(gasp.findExport(stdCell.getPmosWellTieName()));
            pTie.connect(layInsts, stdCell.getPmosWellTieName());
        }
    }

    private static String stripBusNotation(String instNm) {
        int openBrack = instNm.indexOf("[");
        return openBrack >= 0 ? instNm.substring(0, openBrack) : instNm;
    }

    private static void instPath1(StringBuffer path, VarContext context) {
        Nodable ni = context.getNodable();
        if (ni == null) {
            return;
        }
        SchemToLay.instPath1(path, context.pop());
        String me = ni.getName();
        SchemToLay.error(me == null, "instance in VarContext with no name!!!");
        String noBus = SchemToLay.stripBusNotation(me);
        path.append("/" + noBus);
    }

    private static String instPath(VarContext context) {
        StringBuffer path = new StringBuffer();
        SchemToLay.instPath1(path, context);
        return path.toString();
    }

    private static PortInst findFirstPort(ArrayList<NodeInst> layInsts, String nm) {
        for (int i = 0; i < layInsts.size(); ++i) {
            NodeInst pi = layInsts.get(i);
            PortInst port = pi.findPortInst(nm);
            if (port == null) continue;
            return port;
        }
        SchemToLay.error(true, "no NodeInst with port found: " + nm);
        return null;
    }

    private static String layoutCellName(Cell schematic, VarContext context) {
        String schemNm = schematic.getName();
        int sfxPos = schemNm.indexOf("{sch}");
        SchemToLay.error(sfxPos == -1, "SchemToLay: no {sch} suffix on Cell schematic name?");
        schemNm = schemNm.substring(0, sfxPos);
        return schemNm + "__" + SchemToLay.instPath(context) + "{lay}";
    }

    private static void blockAssignedTracks(TrackAllocator trackAlloc, ArrayList<RouteSeg> routeSegs, StdCellParams stdCell) {
        for (int i = 0; i < routeSegs.size(); ++i) {
            RouteSeg r = routeSegs.get(i);
            if (!r.hasExpTrk()) continue;
            trackAlloc.occupyTrack(r, stdCell.getPhysTrackY(r.getExpTrk()), 4.0);
        }
    }

    private static HashMap<String, Object> mergeTrackAssign(Cell schem, HashMap<String, Object> progAsgn, StdCellParams stdCell) {
        HashMap<String, Object> schAsgn = stdCell.getSchemTrackAssign(schem);
        HashMap<String, Object> combAsgn = new HashMap<String, Object>(schAsgn);
        combAsgn.putAll(progAsgn);
        stdCell.validateTrackAssign(progAsgn, schem);
        stdCell.validateTrackAssign(combAsgn, schem);
        return combAsgn;
    }

    public static Cell makePart(Cell schem, VarContext context, StdCellParams stdCell) {
        return SchemToLay.makePart(schem, context, new HashMap<String, Object>(), stdCell);
    }

    public static Cell makePart(Cell schem, VarContext context, HashMap<String, Object> exportTrackAssign, StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        SchemToLay.error(!schem.getView().getFullName().equals("schematic"), "not a schematic: " + schem.getName());
        String nm = SchemToLay.layoutCellName(schem, context);
        System.out.println("SchemToLay making: " + nm);
        Cell gasp = stdCell.findPart(nm);
        if (gasp != null) {
            return gasp;
        }
        gasp = stdCell.newPart(nm);
        HashMap<NodeInst, NodeInst> iconToLay = new HashMap<NodeInst, NodeInst>();
        ArrayList<NodeInst> layInsts = new ArrayList<NodeInst>();
        SchemToLay.makeLayoutInsts(layInsts, iconToLay, schem, gasp, context, stdCell);
        HashMap<String, Object> combTrkAsgn = SchemToLay.mergeTrackAssign(schem, exportTrackAssign, stdCell);
        Netlist netlist = schem.getNetlist(Netlist.ShortResistors.PARASITIC);
        ArrayList<RouteSeg> stkSegs = new ArrayList<RouteSeg>();
        ArrayList<RouteSeg> noStkSegs = new ArrayList<RouteSeg>();
        ArrayList<NodeInst> vertTracks = new ArrayList<NodeInst>();
        SchemToLay.buildRouteSegs(stkSegs, noStkSegs, vertTracks, netlist.getNetworks(), iconToLay, combTrkAsgn, stdCell, gasp);
        layInsts.addAll(vertTracks);
        ArrayList<RouteSeg> allSegs = new ArrayList<RouteSeg>(stkSegs);
        allSegs.addAll(noStkSegs);
        layInsts = SchemToLay.place(layInsts, allSegs, stdCell, gasp);
        TrackRouterH gnd = new TrackRouterH(tech.m2(), stdCell.getGndWidth(), stdCell.getGndY(), tech, gasp);
        TrackRouterH vdd = new TrackRouterH(tech.m2(), stdCell.getVddWidth(), stdCell.getVddY(), tech, gasp);
        Export.newInstance(gasp, SchemToLay.findFirstPort(layInsts, "gnd"), "gnd").setCharacteristic(PortCharacteristic.GND);
        gnd.connect(gasp.findExport("gnd"));
        Export.newInstance(gasp, SchemToLay.findFirstPort(layInsts, "vdd"), "vdd").setCharacteristic(PortCharacteristic.PWR);
        vdd.connect(gasp.findExport("vdd"));
        vdd.connect(layInsts, "vdd");
        gnd.connect(layInsts, "gnd");
        SchemToLay.connectWellTies(layInsts, stdCell, gasp);
        TrackAllocator trackAlloc = new TrackAllocator(stdCell);
        SchemToLay.blockAssignedTracks(trackAlloc, stkSegs, stdCell);
        SchemToLay.blockAssignedTracks(trackAlloc, noStkSegs, stdCell);
        for (int i = 0; i < 2; ++i) {
            boolean exports = i != 0;
            SchemToLay.connectSegments(trackAlloc, stkSegs, exports, stdCell, gasp);
            SchemToLay.connectSegments(trackAlloc, noStkSegs, exports, stdCell, gasp);
        }
        return gasp;
    }

    private static class SkipWirePortInsts
    extends PortFilter.SchemPortFilter {
        private SkipWirePortInsts() {
        }

        public boolean skipPort(PortInst pi) {
            if (super.skipPort(pi)) {
                return true;
            }
            NodeProto np = pi.getNodeInst().getProto();
            if (np instanceof Cell && np.getName().equals("wire{ic}")) {
                return true;
            }
            return np instanceof PrimitiveNode && np.getName().equals("Global-Signal");
        }
    }

    private static class TrackAllocator {
        private static final double FULL_TRACK_XLO = -2.147483647E9;
        private static final double FULL_TRACK_WID = 4.294967294E9;
        private static final boolean PMOS = true;
        private static final boolean NMOS = false;
        private final int nbNmosTracks;
        private final int nbPmosTracks;
        private StdCellParams stdCell;
        private ArrayList<Rectangle2D> blockages = new ArrayList();

        public TrackAllocator(StdCellParams stdCell) {
            this.stdCell = stdCell;
            this.nbNmosTracks = stdCell.nbNmosTracks();
            this.nbPmosTracks = stdCell.nbPmosTracks();
        }

        private boolean isBlocked(double x, double y, double w, double h) {
            for (int i = 0; i < this.blockages.size(); ++i) {
                Rectangle2D block = this.blockages.get(i);
                if (!block.intersects(x, y, w, h)) continue;
                return true;
            }
            return false;
        }

        private int findClearTrack(RouteSeg r, boolean isPmos, double wireWid) {
            boolean ext = r.hasExports();
            double xLo = ext ? -2.147483647E9 : r.getLoX() - wireWid / 2.0;
            double wid = ext ? 4.294967294E9 : r.getHiX() - r.getLoX() + wireWid;
            int maxTrack = isPmos ? this.nbPmosTracks : this.nbNmosTracks;
            int dir = isPmos ? 1 : -1;
            for (int track = 1; track <= maxTrack; ++track) {
                double yLo = this.stdCell.getTrackY(dir * track) - wireWid / 2.0;
                if (this.isBlocked(xLo, yLo, wid, wireWid)) continue;
                return track * dir;
            }
            return 0;
        }

        public void occupyTrack(RouteSeg r, double y, double wireWid) {
            boolean ext = r.hasExports();
            double xLo = ext ? -2.147483647E9 : r.getLoX() - wireWid / 2.0;
            double wid = ext ? 4.294967294E9 : r.getHiX() - r.getLoX() + wireWid;
            double yLo = y - wireWid / 2.0;
            Rectangle2D.Double block = new Rectangle2D.Double(xLo, yLo, wid, wireWid);
            this.blockages.add(block);
        }

        public void occupyTrack(RouteSeg r, int trkNdx, double wireWid) {
            this.occupyTrack(r, this.stdCell.getTrackY(trkNdx), wireWid);
        }

        public double getTrackY(RouteSeg r, double wireWid) {
            int track;
            if (r.hasPstk()) {
                SchemToLay.error(r.hasNstk(), "RouteSeg requires 2 tracks");
                track = this.findClearTrack(r, true, wireWid);
                SchemToLay.error(track == -1, "ran out of PMOS routing tracks");
            } else if (r.hasNstk()) {
                track = this.findClearTrack(r, false, wireWid);
                SchemToLay.error(track == 0, "ran out of NMOS routing tracks");
            } else {
                int pTrack = this.findClearTrack(r, true, wireWid);
                int nTrack = this.findClearTrack(r, false, wireWid);
                SchemToLay.error(pTrack == 0 && nTrack == 0, "ran out of routing tracks");
                track = pTrack != 0 && nTrack != 0 ? (pTrack < -nTrack ? pTrack : nTrack) : (nTrack != 0 ? nTrack : pTrack);
            }
            this.occupyTrack(r, track, wireWid);
            return this.stdCell.getTrackY(track);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RouteSeg {
        private static final Iterator<Export> NO_EXPORTS = new ArrayList().iterator();
        private ArrayList<PortInst> pStkPorts = new ArrayList();
        private ArrayList<PortInst> nStkPorts = new ArrayList();
        private ArrayList<PortInst> nonStkPorts = new ArrayList();
        private Iterator<Export> exports = NO_EXPORTS;
        private Integer exportTrack = null;

        private boolean hasExpTrk() {
            return this.exportTrack != null;
        }

        private int getExpTrk() {
            return this.exportTrack;
        }

        private boolean hasPmosExpTrk() {
            return this.hasExpTrk() && this.getExpTrk() > 0;
        }

        private boolean hasNmosExpTrk() {
            return this.hasExpTrk() && this.getExpTrk() < 0;
        }

        private static ArrayList<PortInst> schemNetToLayPorts(Network net, HashMap<NodeInst, NodeInst> iconToLay) {
            ArrayList<PortInst> layPorts = new ArrayList<PortInst>();
            Iterator<PortInst> iPorts = SKIP_WIRE_PORTINSTS.filter(net.getPorts());
            while (iPorts.hasNext()) {
                PortInst iconPort = iPorts.next();
                NodeInst layInst = iconToLay.get(iconPort.getNodeInst());
                SchemToLay.error(layInst == null, "SchemToLay: no layout instance for Icon? " + iconPort.getNodeInst());
                String portNm = iconPort.getPortProto().getName();
                PortInst layPort = layInst.findPortInst(portNm);
                SchemToLay.error(layPort == null, "Port: " + portNm + " missing from Part: " + layInst.getProto().getName());
                layPorts.add(layPort);
            }
            return layPorts;
        }

        private static Integer findExportTrack(Network net, HashMap<String, Object> expTrkAsgn) {
            Integer expTrk = null;
            Iterator<Export> it = net.getExports();
            while (it.hasNext()) {
                String expNm = it.next().getName();
                if (!expTrkAsgn.containsKey(expNm)) continue;
                SchemToLay.error(expTrk != null, "more than one track assigned to segment!");
                expTrk = (Integer)expTrkAsgn.get(expNm);
            }
            return expTrk;
        }

        private boolean hasNstk() {
            return this.nStkPorts.size() != 0 || this.hasNmosExpTrk();
        }

        private boolean hasPstk() {
            return this.pStkPorts.size() != 0 || this.hasPmosExpTrk();
        }

        private Iterator<Export> removeExports() {
            this.exportTrack = null;
            Iterator<Export> oldExports = this.exports;
            this.exports = NO_EXPORTS;
            return oldExports;
        }

        private RouteSeg(ArrayList<PortInst> layPorts, Iterator<Export> exports, Integer expTrk) {
            this.exports = exports;
            this.exportTrack = expTrk;
            for (int i = 0; i < layPorts.size(); ++i) {
                PortInst p = layPorts.get(i);
                if (SchemToLay.isNstk(p.getNodeInst())) {
                    this.nStkPorts.add(p);
                    continue;
                }
                if (SchemToLay.isPstk(p.getNodeInst())) {
                    this.pStkPorts.add(p);
                    continue;
                }
                this.nonStkPorts.add(p);
            }
        }

        public RouteSeg(Network net, HashMap<NodeInst, NodeInst> iconToLay, HashMap<String, Object> expTrkAsgn) {
            this(RouteSeg.schemNetToLayPorts(net, iconToLay), net.getExports(), RouteSeg.findExportTrack(net, expTrkAsgn));
        }

        public boolean hasExports() {
            return this.exports.hasNext();
        }

        public Iterator<Export> findExports() {
            return this.exports;
        }

        public boolean hasNonStk() {
            return this.nonStkPorts.size() != 0;
        }

        public RouteSeg splitOffPstkRouteSeg(ArrayList<NodeInst> vertTracks, StdCellParams stdCell, Cell gasp) {
            SchemToLay.error(!this.hasPstk() || !this.hasNstk(), "can't split off anything");
            if (!this.hasNonStk()) {
                Cell vtProt = VertTrack.makePart(stdCell);
                NodeInst vtInst = LayoutLib.newNodeInst(vtProt, 0.0, 0.0, 0.0, 0.0, 0.0, gasp);
                vertTracks.add(vtInst);
                this.nonStkPorts.add(vtInst.findPortInst("in"));
            }
            ArrayList<PortInst> pPorts = this.pStkPorts;
            this.pStkPorts = new ArrayList();
            pPorts.add(this.nonStkPorts.get(0));
            Integer pExpTrk = this.hasPmosExpTrk() ? new Integer(this.getExpTrk()) : null;
            Iterator<Export> pExports = this.hasPmosExpTrk() ? this.removeExports() : NO_EXPORTS;
            return new RouteSeg(pPorts, pExports, pExpTrk);
        }

        public ArrayList<PortInst> getAllPorts() {
            ArrayList<PortInst> ports = new ArrayList<PortInst>(this.pStkPorts);
            ports.addAll(this.nStkPorts);
            ports.addAll(this.nonStkPorts);
            return ports;
        }

        public double estimateLength() {
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            ArrayList<PortInst> ports = this.getAllPorts();
            for (int i = 0; i < ports.size(); ++i) {
                double x = LayoutLib.roundCenterX(ports.get(i));
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
            }
            double weight = this.hasExports() ? 1.0 : 1.0;
            return weight * (maxX - minX);
        }

        public double getLoX() {
            double minX = Double.POSITIVE_INFINITY;
            ArrayList<PortInst> ports = this.getAllPorts();
            for (int i = 0; i < ports.size(); ++i) {
                double x = LayoutLib.roundCenterX(ports.get(i));
                minX = Math.min(minX, x);
            }
            return minX;
        }

        public double getHiX() {
            double maxX = Double.NEGATIVE_INFINITY;
            ArrayList<PortInst> ports = this.getAllPorts();
            for (int i = 0; i < ports.size(); ++i) {
                double x = LayoutLib.roundCenterX(ports.get(i));
                maxX = Math.max(maxX, x);
            }
            return maxX;
        }
    }
}

