/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LEFDEF;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LEF
extends LEFDEF {
    private LEFPreferences localPrefs;
    private Technology curTech;

    LEF(LEFPreferences ap) {
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.curTech = tech;
        firstViaDefFromLEF = null;
        widthsFromLEF = new HashMap();
        knownLayers = new HashMap();
        this.initKeywordParsing();
        try {
            if (this.readFile(lib)) {
                return null;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR reading LEF libraries");
        }
        return lib;
    }

    @Override
    protected String preprocessLine(String line) {
        int sharpPos = line.indexOf(35);
        if (sharpPos >= 0) {
            return line.substring(0, sharpPos);
        }
        return line;
    }

    private boolean readFile(Library lib) throws IOException {
        String key;
        while ((key = this.getAKeyword()) != null) {
            if (key.equalsIgnoreCase("LAYER") && this.readLayer(lib)) {
                return true;
            }
            if (key.equalsIgnoreCase("MACRO") && this.readMacro(lib)) {
                return true;
            }
            if (key.equalsIgnoreCase("VIA") && this.readVia(lib)) {
                return true;
            }
            if (key.equalsIgnoreCase("VIARULE") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("ARRAY")) {
                String name = this.getAKeyword();
                this.ignoreToEnd(name);
                continue;
            }
            if (key.equalsIgnoreCase("SPACING")) {
                this.ignoreToEnd(key);
                continue;
            }
            if (!key.equalsIgnoreCase("MINFEATURE")) continue;
            this.ignoreToSemicolon(key);
        }
        return false;
    }

    private boolean readVia(Library lib) throws IOException {
        String key;
        LEFDEF.ViaDef vd;
        block18: {
            String viaName = this.getAKeyword();
            if (viaName == null) {
                return true;
            }
            vd = new LEFDEF.ViaDef();
            vd.viaName = viaName;
            vd.sY = 0.0;
            vd.sX = 0.0;
            vd.via = null;
            vd.lay2 = null;
            vd.lay1 = null;
            vd.nextViaDef = firstViaDefFromLEF;
            firstViaDefFromLEF = vd;
            boolean ignoreDefault = true;
            while (true) {
                if ((key = this.getAKeyword()) == null) {
                    return true;
                }
                if (ignoreDefault) {
                    ignoreDefault = false;
                    if (key.equalsIgnoreCase("DEFAULT")) continue;
                }
                if (key.equalsIgnoreCase("END")) break block18;
                if (key.equalsIgnoreCase("RESISTANCE")) {
                    if (!this.ignoreToSemicolon(key)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    LEFDEF.GetLayerInformation li = this.getLayerInformation(key);
                    if (li.arc != null) {
                        if (vd.lay1 == null) {
                            vd.lay1 = li.arc;
                        } else {
                            vd.lay2 = li.arc;
                        }
                    }
                    if (!this.ignoreToSemicolon("LAYER")) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double lX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double lY = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double hX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double hY = this.convertLEFString(key);
                if (hX - lX > vd.sX) {
                    vd.sX = hX - lX;
                }
                if (hY - lY > vd.sY) {
                    vd.sY = hY - lY;
                }
                if (this.ignoreToSemicolon("RECT")) break;
            }
            return true;
        }
        key = this.getAKeyword();
        if (vd.lay1 != null && vd.lay2 != null) {
            Iterator<PrimitiveNode> it = this.curTech.getNodes();
            while (it.hasNext()) {
                PrimitivePort pp;
                PrimitiveNode np = it.next();
                if (!np.getFunction().isContact() || !(pp = np.getPort(0)).connectsTo(vd.lay1) || !pp.connectsTo(vd.lay2)) continue;
                vd.via = np;
                break;
            }
        }
        return false;
    }

    private boolean readMacro(Library lib) throws IOException {
        String key;
        block18: {
            block19: {
                String cellName = this.getAKeyword();
                if (cellName == null) {
                    System.out.println("EOF parsing MACRO header");
                    return true;
                }
                Cell cell = Cell.makeInstance(lib, cellName = cellName + "{lay.sk}");
                if (cell == null) {
                    System.out.println("Cannot create cell '" + cellName + "'");
                    return true;
                }
                while (true) {
                    if ((key = this.getAKeyword()) == null) {
                        System.out.println("EOF parsing MACRO");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block18;
                    if (key.equalsIgnoreCase("SOURCE") || key.equalsIgnoreCase("FOREIGN") || key.equalsIgnoreCase("SYMMETRY") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("CLASS") || key.equalsIgnoreCase("LEQ") || key.equalsIgnoreCase("POWER")) {
                        if (!this.ignoreToSemicolon(key)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("ORIGIN")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading ORIGIN X");
                            return true;
                        }
                        double oX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading ORIGIN Y");
                            return true;
                        }
                        double oY = this.convertLEFString(key);
                        if (this.ignoreToSemicolon("ORIGIN")) {
                            return true;
                        }
                        Geometric ccNi = null;
                        Iterator<NodeInst> it = cell.getNodes();
                        while (it.hasNext()) {
                            NodeInst ni = it.next();
                            if (ni.getProto() != Generic.tech().cellCenterNode) continue;
                            ccNi = ni;
                            break;
                        }
                        if (ccNi == null) {
                            double sY;
                            double sX = Generic.tech().cellCenterNode.getDefWidth();
                            ccNi = NodeInst.makeInstance(Generic.tech().cellCenterNode, new Point2D.Double(oX, oY), sX, sY = Generic.tech().cellCenterNode.getDefHeight(), cell);
                            if (ccNi == null) {
                                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create cell center node");
                                return true;
                            }
                            ((NodeInst)ccNi).setHardSelect();
                            ((NodeInst)ccNi).setVisInside();
                            continue;
                        }
                        double dX = oX - ccNi.getTrueCenterX();
                        double dY = oY - ccNi.getTrueCenterY();
                        ((NodeInst)ccNi).move(dX, dY);
                        continue;
                    }
                    if (key.equalsIgnoreCase("SIZE")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE X");
                            return true;
                        }
                        double wid = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE 'BY'");
                            return true;
                        }
                        if (!key.equalsIgnoreCase("BY")) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Expected 'by' in SIZE");
                            return true;
                        }
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE Y");
                            return true;
                        }
                        double hei = this.convertLEFString(key);
                        cell.newVar(prXkey, (Object)new Double(wid));
                        cell.newVar(prYkey, (Object)new Double(hei));
                        if (!this.ignoreToSemicolon("SIZE")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("PIN")) {
                        if (!this.readPin(cell)) continue;
                        return true;
                    }
                    if (!key.equalsIgnoreCase("OBS")) break block19;
                    if (this.readObs(cell)) break;
                }
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown MACRO keyword (" + key + ")");
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readObs(Cell cell) throws IOException {
        block11: {
            NodeProto np = null;
            while (true) {
                double sY;
                String key;
                if ((key = this.getAKeyword()) == null) {
                    System.out.println("EOF parsing OBS");
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block11;
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        System.out.println("EOF reading LAYER clause");
                        return true;
                    }
                    LEFDEF.GetLayerInformation li = this.getLayerInformation(key);
                    np = li.pure;
                    if (li.layerFun == Layer.Function.UNKNOWN || np == null) {
                        System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown layer name (" + key + ")");
                        return true;
                    }
                    if (!this.ignoreToSemicolon("LAYER")) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT low X");
                    return true;
                }
                double lX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT low Y");
                    return true;
                }
                double lY = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT high X");
                    return true;
                }
                double hX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT high Y");
                    return true;
                }
                double hY = this.convertLEFString(key);
                if (this.ignoreToSemicolon("RECT")) {
                    return true;
                }
                if (np == null) {
                    System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for RECT");
                    return true;
                }
                Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                double sX = Math.abs(hX - lX);
                NodeInst ni = NodeInst.makeInstance(np, ctr, sX, sY = Math.abs(hY - lY), cell);
                if (ni == null) break;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create node for RECT");
            return true;
        }
        return false;
    }

    private boolean readPin(Cell cell) throws IOException {
        String key;
        block22: {
            block23: {
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF parsing PIN name");
                    return true;
                }
                String pinName = key.replace('<', '[').replace('>', ']');
                PortCharacteristic useCharacteristics = PortCharacteristic.UNKNOWN;
                PortCharacteristic portCharacteristics = PortCharacteristic.UNKNOWN;
                while (true) {
                    if ((key = this.getAKeyword()) == null) {
                        System.out.println("EOF parsing PIN");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block22;
                    if (key.equalsIgnoreCase("SHAPE") || key.equalsIgnoreCase("CAPACITANCE") || key.equalsIgnoreCase("ANTENNASIZE")) {
                        if (!this.ignoreToSemicolon(key)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("USE")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading USE clause");
                            return true;
                        }
                        if (key.equalsIgnoreCase("POWER")) {
                            useCharacteristics = PortCharacteristic.PWR;
                        } else if (key.equalsIgnoreCase("GROUND")) {
                            useCharacteristics = PortCharacteristic.GND;
                        } else if (key.equalsIgnoreCase("CLOCK")) {
                            useCharacteristics = PortCharacteristic.CLK;
                        } else if (!key.equalsIgnoreCase("SIGNAL") && !key.equalsIgnoreCase("DATA")) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown USE keyword (" + key + ")");
                        }
                        if (!this.ignoreToSemicolon("USE")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("DIRECTION")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading DIRECTION clause");
                            return true;
                        }
                        if (key.equalsIgnoreCase("INPUT")) {
                            portCharacteristics = PortCharacteristic.IN;
                        } else if (key.equalsIgnoreCase("OUTPUT")) {
                            portCharacteristics = PortCharacteristic.OUT;
                        } else if (key.equalsIgnoreCase("INOUT")) {
                            portCharacteristics = PortCharacteristic.BIDIR;
                        } else {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown DIRECTION keyword (" + key + ")");
                        }
                        if (!this.ignoreToSemicolon("DIRECTION")) continue;
                        return true;
                    }
                    if (!key.equalsIgnoreCase("PORT")) break block23;
                    if (useCharacteristics != PortCharacteristic.UNKNOWN) {
                        portCharacteristics = useCharacteristics;
                    }
                    if (this.readPort(cell, pinName, portCharacteristics)) break;
                }
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown PIN keyword (" + key + ")");
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readPort(Cell cell, String portname, PortCharacteristic portCharacteristics) throws IOException {
        PrimitiveNode pin;
        Point2D.Double singlePathPoint;
        boolean first;
        LEFPath lefPaths;
        ArcProto ap;
        block43: {
            String key;
            block44: {
                ap = null;
                NodeProto pureNp = null;
                lefPaths = null;
                first = true;
                double intWidth = 0.0;
                double lastIntX = 0.0;
                double lastIntY = 0.0;
                singlePathPoint = null;
                block0: while (true) {
                    double sY;
                    if ((key = this.getAKeyword()) == null) {
                        System.out.println("EOF parsing PORT");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block43;
                    if (key.equalsIgnoreCase("CLASS")) {
                        if (!this.ignoreToSemicolon("LAYER")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("LAYER")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading LAYER clause");
                            return true;
                        }
                        LEFDEF.GetLayerInformation li = this.getLayerInformation(key);
                        ap = li.arc;
                        pureNp = li.pure;
                        if (!this.ignoreToSemicolon("LAYER")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("WIDTH")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading WIDTH clause");
                            return true;
                        }
                        intWidth = this.convertLEFString(key);
                        if (!this.ignoreToSemicolon("WIDTH")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("RECT")) {
                        double sY2;
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT low X");
                            return true;
                        }
                        double lX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT low Y");
                            return true;
                        }
                        double lY = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT high X");
                            return true;
                        }
                        double hX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT high Y");
                            return true;
                        }
                        double hY = this.convertLEFString(key);
                        if (this.ignoreToSemicolon("RECT")) {
                            return true;
                        }
                        if (pureNp == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for RECT");
                            return true;
                        }
                        Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                        double sX = Math.abs(hX - lX);
                        NodeInst ni = NodeInst.makeInstance(pureNp, ctr, sX, sY2 = Math.abs(hY - lY), cell);
                        if (ni == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for RECT");
                            return true;
                        }
                        if (!first) continue;
                        first = false;
                        Export pp = this.newPort(cell, ni, pureNp.getPort(0), portname);
                        if (pp == null) continue;
                        pp.setCharacteristic(portCharacteristics);
                        continue;
                    }
                    if (key.equalsIgnoreCase("PATH")) {
                        if (ap == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for PATH");
                            return true;
                        }
                        int i = 0;
                        while (true) {
                            if ((key = this.getAKeyword()) == null) {
                                System.out.println("EOF reading PATH clause");
                                return true;
                            }
                            if (key.equals(";")) continue block0;
                            double intx = this.convertLEFString(key);
                            key = this.getAKeyword();
                            if (key == null) {
                                System.out.println("EOF reading PATH clause");
                                return true;
                            }
                            double inty = this.convertLEFString(key);
                            if (i == 0) {
                                singlePathPoint = new Point2D.Double(intx, inty);
                            } else {
                                LEFPath lp = new LEFPath();
                                ((LEFPath)lp).pt[0] = new Point2D.Double(lastIntX, lastIntY);
                                ((LEFPath)lp).pt[1] = new Point2D.Double(intx, inty);
                                ((LEFPath)lp).ni[0] = null;
                                ((LEFPath)lp).ni[1] = null;
                                lp.width = intWidth;
                                lp.arc = ap;
                                lp.nextLEFPath = lefPaths;
                                lefPaths = lp;
                            }
                            lastIntX = intx;
                            lastIntY = inty;
                            ++i;
                        }
                    }
                    if (!key.equalsIgnoreCase("VIA")) break block44;
                    key = this.getAKeyword();
                    if (key == null) {
                        System.out.println("EOF reading VIA clause");
                        return true;
                    }
                    double intX = this.convertLEFString(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        System.out.println("EOF reading VIA clause");
                        return true;
                    }
                    double intY = this.convertLEFString(key);
                    key = this.getAKeyword();
                    LEFDEF.GetLayerInformation li = this.getLayerInformation(key);
                    if (li.pin == null) {
                        System.out.println("Line " + this.lineReader.getLineNumber() + ": No Via in current technology for '" + key + "'");
                        return true;
                    }
                    if (this.ignoreToSemicolon("VIA")) {
                        return true;
                    }
                    double sX = li.pin.getDefWidth();
                    NodeInst ni = NodeInst.makeInstance(li.pin, new Point2D.Double(intX, intY), sX, sY = li.pin.getDefHeight(), cell);
                    if (ni == null) break;
                }
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create VIA for PATH");
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown PORT keyword (" + key + ")");
            return true;
        }
        LEFPath lp = lefPaths;
        while (lp != null) {
            for (int i = 0; i < 2; ++i) {
                if (lp.ni[i] != null) continue;
                Rectangle2D.Double bounds = new Rectangle2D.Double(lp.pt[i].getX(), lp.pt[i].getY(), 0.0, 0.0);
                Iterator<RTBounds> sea = cell.searchIterator(bounds);
                while (sea.hasNext()) {
                    NodeInst ni;
                    RTBounds geom = sea.next();
                    if (!(geom instanceof NodeInst) || !DBMath.areEquals((ni = (NodeInst)geom).getTrueCenter(), lp.pt[i])) continue;
                    ((LEFPath)lp).ni[i] = ni;
                    break;
                }
                if (lp.ni[i] == null) continue;
                LEFPath oLp = lefPaths;
                while (oLp != null) {
                    for (int j = 0; j < 2; ++j) {
                        if (oLp.ni[j] != null || !DBMath.areEquals(oLp.pt[j], lp.pt[i])) continue;
                        ((LEFPath)oLp).ni[j] = lp.ni[i];
                    }
                    oLp = oLp.nextLEFPath;
                }
            }
            lp = lp.nextLEFPath;
        }
        lp = lefPaths;
        while (lp != null) {
            for (int i = 0; i < 2; ++i) {
                PrimitiveNode pin2;
                if (lp.ni[i] != null || (pin2 = lp.arc.findPinProto()) == null) continue;
                double sX = pin2.getDefWidth();
                double sY = pin2.getDefHeight();
                ((LEFPath)lp).ni[i] = NodeInst.makeInstance(pin2, lp.pt[i], sX, sY, cell);
                if (lp.ni[i] == null) {
                    System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for PATH");
                    return true;
                }
                if (first) {
                    first = false;
                    Export pp = this.newPort(cell, lp.ni[i], pin2.getPort(0), portname);
                    if (pp != null) {
                        pp.setCharacteristic(portCharacteristics);
                    }
                }
                LEFPath oLp = lefPaths;
                while (oLp != null) {
                    for (int j = 0; j < 2; ++j) {
                        if (oLp.ni[j] != null || !DBMath.areEquals(oLp.pt[j], lp.pt[i])) continue;
                        ((LEFPath)oLp).ni[j] = lp.ni[i];
                    }
                    oLp = oLp.nextLEFPath;
                }
            }
            lp = lp.nextLEFPath;
        }
        lp = lefPaths;
        while (lp != null) {
            PortInst head = lp.ni[0].getPortInst(0);
            PortInst tail = lp.ni[1].getPortInst(0);
            Point2D headPt = lp.pt[0];
            Point2D tailPt = lp.pt[1];
            ArcInst ai = ArcInst.makeInstanceBase(lp.arc, lp.width, head, tail, headPt, tailPt, null);
            if (ai == null) {
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create arc for PATH");
                return true;
            }
            lp = lp.nextLEFPath;
        }
        if (lefPaths == null && singlePathPoint != null && ap != null && first && (pin = ap.findPinProto()) != null) {
            double sY;
            double sX = pin.getDefWidth();
            NodeInst ni = NodeInst.makeInstance(pin, singlePathPoint, sX, sY = pin.getDefHeight(), cell);
            if (ni == null) {
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for PATH");
                return true;
            }
            Export pp = this.newPort(cell, ni, pin.getPort(0), portname);
            if (pp != null) {
                pp.setCharacteristic(portCharacteristics);
            }
        }
        return false;
    }

    private Export newPort(Cell cell, NodeInst ni, PortProto pp, String thename) {
        String portName = thename;
        String newName = null;
        int i = 0;
        while (true) {
            Export e;
            if ((e = (Export)cell.findPortProto(portName)) == null) {
                PortInst pi = ni.findPortInstFromProto(pp);
                return Export.newInstance(cell, pi, portName);
            }
            portName = newName = thename + "-" + i;
            ++i;
        }
    }

    private boolean readLayer(Library lib) throws IOException {
        String key;
        double defWidth;
        String layerType;
        String layerName;
        block7: {
            layerName = this.getAKeyword();
            if (layerName == null) {
                System.out.println("EOF parsing LAYER header");
                return true;
            }
            layerType = null;
            defWidth = -1.0;
            while (true) {
                if ((key = this.getAKeyword()) == null) {
                    System.out.println("EOF parsing LAYER");
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block7;
                if (key.equalsIgnoreCase("WIDTH")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        System.out.println("EOF reading WIDTH");
                        return true;
                    }
                    defWidth = this.convertLEFString(key);
                    if (!this.ignoreToSemicolon("WIDTH")) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("TYPE")) {
                    layerType = this.getAKeyword();
                    if (!this.ignoreToSemicolon("TYPE")) continue;
                    return true;
                }
                if ((key.equalsIgnoreCase("SPACING") || key.equalsIgnoreCase("PITCH") || key.equalsIgnoreCase("DIRECTION") || key.equalsIgnoreCase("CAPACITANCE") || key.equalsIgnoreCase("RESISTANCE")) && this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(layerName, layerType);
        knownLayers.put(layerName, li);
        ArcProto ap = li.arc;
        if (ap != null && defWidth > 0.0) {
            widthsFromLEF.put(ap, new Double(defWidth));
        }
        return false;
    }

    private boolean ignoreToSemicolon(String command) throws IOException {
        String key;
        do {
            if ((key = this.getAKeyword()) != null) continue;
            System.out.println("EOF parsing " + command);
            return true;
        } while (!key.equals(";"));
        return false;
    }

    private boolean ignoreToEnd(String endName) throws IOException {
        boolean findEnd = true;
        while (true) {
            String key;
            if ((key = this.getAKeyword()) == null) {
                System.out.println("EOF parsing " + endName);
                return true;
            }
            if (findEnd && key.equalsIgnoreCase("END")) {
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF parsing " + endName);
                    return true;
                }
                if (!key.equals(endName)) continue;
                break;
            }
            if (key.equals(";")) {
                findEnd = true;
                continue;
            }
            findEnd = false;
        }
        return false;
    }

    private double convertLEFString(String key) {
        double v = TextUtils.atof(key) * 1.0;
        return TextUtils.convertFromDistance(v, this.curTech, TextUtils.UnitScale.MICRO);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LEFPreferences
    extends Input.InputPreferences {
        public LEFPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            LEF in = new LEF(this);
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }
    }

    private static class LEFPath {
        private Point2D[] pt = new Point2D[2];
        private NodeInst[] ni = new NodeInst[2];
        private double width;
        private ArcProto arc;
        private LEFPath nextLEFPath;

        private LEFPath() {
        }
    }
}

