/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakReferences<E> {
    private final ArrayList<WeakReference<E>> references = new ArrayList();

    public boolean add(E o) {
        this.references.add(new WeakReference<E>(o));
        return true;
    }

    public boolean remove(E o) {
        Iterator<WeakReference<E>> it = this.references.iterator();
        while (it.hasNext()) {
            WeakReference<E> ref = it.next();
            Object i = ref.get();
            if (i == null) {
                it.remove();
                continue;
            }
            if (i != o) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public Iterator<E> iterator() {
        return this.iterator(false);
    }

    public Iterator<E> reverseIterator() {
        return this.iterator(true);
    }

    private Iterator<E> iterator(boolean reverse) {
        ArrayList items = new ArrayList();
        Iterator<WeakReference<E>> it = this.references.iterator();
        while (it.hasNext()) {
            WeakReference<E> ref = it.next();
            Object i = ref.get();
            if (i != null) {
                items.add(i);
                continue;
            }
            it.remove();
        }
        if (reverse) {
            Collections.reverse(items);
        }
        return items.iterator();
    }
}

