/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.Environment;
import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.UserInterfaceExec;
import com.sun.electric.tool.io.input.NewEpicAnalysis;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.BTreeNewSignal;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.Waveform;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class NewEpicOutProcess
extends Simulate
implements Runnable {
    private Thread readerProcess;
    private PipedInputStream pis;
    private PipedOutputStream pos;
    private PipedInputStream epis;
    private PipedOutputStream epos;
    private DataInputStream stdOut;
    private ArrayList<String> strings = new ArrayList();
    private final Environment launcherEnvironment = Environment.getThreadEnvironment();
    private final UserInterfaceExec userInterface = new UserInterfaceExec();
    NewEpicAnalysis epicAnalysis = null;
    private double timeResolution;
    private double voltageResolution;
    private double currentResolution;

    NewEpicOutProcess() {
    }

    protected void readSimulationOutput(Stimuli sd, URL fileURL, Cell cell) throws IOException {
        NewEpicOutProcess.startProgressDialog("EPIC output", fileURL.getFile());
        boolean eof = false;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.epos = new PipedOutputStream();
        this.epis = new PipedInputStream(this.epos);
        char separator = '.';
        sd.setSeparatorChar(separator);
        this.epicAnalysis = new NewEpicAnalysis(sd);
        this.readerProcess = new NewEpicReader(this.pos, this.epos, fileURL.getFile());
        try {
            this.stdOut = new DataInputStream(this.pis);
            new Thread((Runnable)this, "EpicReaderErrors").start();
            sd = this.readEpicFile(sd);
            sd.setCell(cell);
        }
        catch (EOFException e) {
            eof = true;
        }
        if (this.readerProcess != null) {
            try {
                this.readerProcess.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (eof) {
            // empty if block
        }
        NewEpicOutProcess.stopProgressDialog();
        this.strings = null;
        this.stdOut.close();
        this.stdOut = null;
        this.readerProcess = null;
    }

    private Stimuli readEpicFile(Stimuli sd) throws IOException {
        int sigNum;
        byte b;
        NewEpicAnalysis an = this.epicAnalysis;
        int numSignals = 0;
        ContextBuilder contextBuilder = new ContextBuilder();
        ArrayList<ContextBuilder> contextStack = new ArrayList<ContextBuilder>();
        contextStack.add(contextBuilder);
        int contextStackDepth = 1;
        boolean DEBUG = false;
        while ((b = this.stdOut.readByte()) != 70) {
            switch (b) {
                case 73: 
                case 86: {
                    int sigNum2 = this.stdOut.readInt();
                    String name = this.readString();
                    contextBuilder.strings.add(name);
                    byte type = b == 86 ? (byte)1 : 2;
                    contextBuilder.contexts.add(NewEpicAnalysis.getContext(type));
                    NewEpicAnalysis.EpicSignal s = new NewEpicAnalysis.EpicSignal(an, type, numSignals++, sigNum2);
                    s.setSignalName(name, null);
                    break;
                }
                case 68: {
                    String down = this.readString();
                    contextBuilder.strings.add(down);
                    if (contextStackDepth >= contextStack.size()) {
                        contextStack.add(new ContextBuilder());
                    }
                    contextBuilder = (ContextBuilder)contextStack.get(contextStackDepth++);
                    break;
                }
                case 85: {
                    NewEpicAnalysis.Context newContext = an.getContext(contextBuilder.strings, contextBuilder.contexts);
                    contextBuilder.clear();
                    contextBuilder = (ContextBuilder)contextStack.get(--contextStackDepth - 1);
                    contextBuilder.contexts.add(newContext);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (contextBuilder == contextStack.get(contextStackDepth - 1));
        }
        assert (contextStackDepth == 1);
        an.setRootContext(an.getContext(contextBuilder.strings, contextBuilder.contexts));
        an.setTimeResolution(this.stdOut.readDouble());
        an.setVoltageResolution(this.stdOut.readDouble());
        an.setCurrentResolution(this.stdOut.readDouble());
        an.setMaxTime(this.stdOut.readDouble());
        List<AnalogSignal> signals = an.getSignals();
        assert (numSignals == signals.size());
        an.waveStarts = new int[numSignals];
        an.waveLengths = new int[numSignals];
        ArrayList<SigInfo> sigInfoByEpicIndex = new ArrayList<SigInfo>();
        int start = 0;
        while ((sigNum = this.stdOut.readInt()) != -1) {
            while (sigNum >= sigInfoByEpicIndex.size()) {
                sigInfoByEpicIndex.add(null);
            }
            int minV = this.stdOut.readInt();
            int maxV = this.stdOut.readInt();
            int len = this.stdOut.readInt();
            assert (sigInfoByEpicIndex.get(sigNum) == null);
            sigInfoByEpicIndex.set(sigNum, new SigInfo(minV, maxV, start, len));
            assert (len >= 0);
            start += len;
        }
        an.setWaveFile(new File(this.stdOut.readUTF()));
        return sd;
    }

    private void printDebug(int level, char cmd, String arg) {
        StringBuilder sb = new StringBuilder();
        while (level-- > 0) {
            sb.append(' ');
        }
        sb.append(cmd);
        if (arg != null) {
            sb.append(' ');
            sb.append(arg);
        }
        System.out.println(sb);
    }

    private String readString() throws IOException {
        int stringIndex = this.stdOut.readInt();
        if (stringIndex == -1) {
            return null;
        }
        if (stringIndex == this.strings.size()) {
            String s = this.stdOut.readUTF();
            this.strings.add(s);
        }
        return this.strings.get(stringIndex);
    }

    public void run() {
        Environment.setThreadEnvironment(this.launcherEnvironment);
        Job.setUserInterface(this.userInterface);
        String progressKey = "**PROGRESS ";
        BufferedReader stdErr = new BufferedReader(new InputStreamReader(this.epis));
        try {
            String line = null;
            while ((line = stdErr.readLine()) != null) {
                if (line.startsWith("**PROGRESS ")) {
                    if ((line = line.substring("**PROGRESS ".length())).startsWith("!")) {
                        NewEpicOutProcess.setProgressValue(0);
                        NewEpicOutProcess.setProgressNote(line.substring(1));
                        continue;
                    }
                    NewEpicOutProcess.setProgressValue(TextUtils.atoi(line));
                    continue;
                }
                System.out.println("EpicReader: " + line);
            }
            stdErr.close();
        }
        catch (IOException e) {
            if (e.toString().indexOf("Write end dead") != -1) {
                return;
            }
            ActivityLogger.logException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EpicReaderSignal {
        int lastT;
        int lastV;
        int minV = Integer.MAX_VALUE;
        int maxV = Integer.MIN_VALUE;
        byte[] waveform = new byte[512];
        int len;
        int evmin = 0;
        int evmax = 0;
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        BTree<Double, Double, Serializable> tree;
        int sigNum;
        int count = 0;

        public EpicReaderSignal(int sigNum, BTree<Double, Double, Serializable> tree) {
            this.sigNum = sigNum;
            this.tree = tree;
        }

        public Waveform getBWaveform() {
            return new BTreeNewSignal(this.evmin, this.evmax, this.tree);
        }

        void putEvent(int t, int v) {
            double value = (double)v * NewEpicOutProcess.this.voltageResolution;
            if (value < this.minValue) {
                this.minValue = value;
                this.evmin = this.count;
            }
            if (value > this.maxValue) {
                this.maxValue = value;
                this.evmax = this.count;
            }
            ++this.count;
            this.tree.insert(new Double((double)t * NewEpicOutProcess.this.timeResolution), new Double(value));
        }

        void putUnsigned(int value) {
            if (value < 192) {
                this.ensureCapacity(1);
                this.putByte(value);
            } else if (value < 16128) {
                this.ensureCapacity(2);
                this.putByte(value + 49152 >> 8);
                this.putByte(value);
            } else {
                this.ensureCapacity(5);
                this.putByte(255);
                this.putByte(value >> 24);
                this.putByte(value >> 16);
                this.putByte(value >> 8);
                this.putByte(value);
            }
        }

        void putSigned(int value) {
            if (-96 <= value && value < 96) {
                this.ensureCapacity(1);
                this.putByte(value + 96);
            } else if (-7936 <= value && value < 8192) {
                this.ensureCapacity(2);
                this.putByte(value + 57088 >> 8);
                this.putByte(value);
            } else {
                this.ensureCapacity(5);
                this.putByte(255);
                this.putByte(value >> 24);
                this.putByte(value >> 16);
                this.putByte(value >> 8);
                this.putByte(value);
            }
        }

        int[] getWaveform() {
            int count = 0;
            int i = 0;
            while (i < this.len) {
                int b;
                int l = (b = this.waveform[i++] & 0xFF) < 192 ? 0 : (b < 255 ? 1 : 4);
                i += l;
                b = this.waveform[i++] & 0xFF;
                l = b < 192 ? 0 : (b < 255 ? 1 : 4);
                i += l;
                ++count;
            }
            int[] w = new int[count * 2];
            count = 0;
            int t = 0;
            int v = 0;
            int i2 = 0;
            while (i2 < this.len) {
                int l;
                int b;
                if ((b = this.waveform[i2++] & 0xFF) < 192) {
                    l = 0;
                } else if (b < 255) {
                    l = 1;
                    b -= 192;
                } else {
                    l = 4;
                }
                while (l > 0) {
                    b = b << 8 | this.waveform[i2++] & 0xFF;
                    --l;
                }
                w[count * 2] = t += b;
                if ((b = this.waveform[i2++] & 0xFF) < 192) {
                    l = 0;
                    b -= 96;
                } else if (b < 255) {
                    l = 1;
                    b -= 223;
                } else {
                    l = 4;
                }
                while (l > 0) {
                    b = b << 8 | this.waveform[i2++] & 0xFF;
                    --l;
                }
                w[count * 2 + 1] = v += b;
                ++count;
            }
            assert (count * 2 == w.length);
            return w;
        }

        void putByte(int value) {
            this.waveform[this.len++] = (byte)value;
        }

        void ensureCapacity(int l) {
            if (this.len + l <= this.waveform.length) {
                return;
            }
            byte[] newWaveform = new byte[this.waveform.length * 3 / 2];
            System.arraycopy(this.waveform, 0, newWaveform, 0, this.waveform.length);
            this.waveform = newWaveform;
            assert (this.len + l <= this.waveform.length);
        }
    }

    class EpicReaderSig {
        final byte type;
        final String name;
        final int sigNum;

        EpicReaderSig(byte type, String name, int sigNum) {
            this.type = type;
            this.name = name;
            this.sigNum = sigNum;
        }
    }

    class EpicReaderContext {
        private ArrayList<EpicReaderSig> signals = new ArrayList();
        private LinkedHashMap<String, EpicReaderContext> subs = new LinkedHashMap();

        EpicReaderContext() {
        }

        EpicReaderSig addSig(String path, char separator, byte type, int sigNum) {
            EpicReaderContext ctx;
            int indexOfSep = path.indexOf(separator);
            if (indexOfSep == -1) {
                if (type == 73) {
                    path = "i(" + path + ")";
                }
                EpicReaderSig sig = new EpicReaderSig(type, path, sigNum);
                this.signals.add(sig);
                return sig;
            }
            String subName = path.substring(0, indexOfSep);
            if (subName.length() > 0 && subName.charAt(0) == 'x') {
                subName = subName.substring(1);
            }
            if ((ctx = this.subs.get(subName)) == null) {
                ctx = new EpicReaderContext();
                this.subs.put(subName, ctx);
            }
            path = path.substring(indexOfSep + 1);
            return ctx.addSig(path, separator, type, sigNum);
        }

        void writeSigs(NewEpicReader reader) throws IOException {
            DataOutputStream stdOut = reader.stdOut;
            for (EpicReaderSig epicReaderSig : this.signals) {
                stdOut.writeByte(epicReaderSig.type);
                stdOut.writeInt(epicReaderSig.sigNum);
                reader.writeString(epicReaderSig.name);
            }
            for (Map.Entry entry : this.subs.entrySet()) {
                String subName = (String)entry.getKey();
                EpicReaderContext sub = (EpicReaderContext)entry.getValue();
                stdOut.writeByte(68);
                reader.writeString(subName);
                sub.writeSigs(reader);
                stdOut.writeByte(85);
            }
        }
    }

    private class NewEpicReader
    extends Thread {
        private InputStream inputStream;
        private long fileLength;
        private long byteCount;
        private byte[] buf = new byte[65536];
        private int bufL;
        private int bufP;
        private int lineNum;
        private StringBuilder builder = new StringBuilder();
        private Pattern whiteSpace = Pattern.compile("[ \t]+");
        private byte lastProgress;
        private EpicReaderContext rootCtx = new EpicReaderContext();
        private HashMap<String, Integer> stringIds = new HashMap();
        private ArrayList<EpicReaderSignal> signalsByEpicIndex = new ArrayList();
        private int curTime = 0;
        private ArrayList<String> contextStack = new ArrayList();
        private int timesC = 0;
        private int eventsC = 0;
        DataOutputStream stdOut;
        private static final String VERSION_STRING50 = ";! output_format 5.0";
        private static final String VERSION_STRING53 = ";! output_format 5.3";
        private static final char separator = '.';
        private PrintStream err;
        private String urlName;

        private NewEpicReader(OutputStream os, OutputStream eos, String urlName) throws IOException {
            this.err = new PrintStream(eos);
            this.stdOut = new DataOutputStream(new PrintStream(os));
            this.urlName = urlName;
            this.start();
        }

        public void run() {
            BTree.clearStats();
            try {
                URL fileURL = new URL("file:" + this.urlName);
                long startTime = System.currentTimeMillis();
                URLConnection urlCon = fileURL.openConnection();
                urlCon.setConnectTimeout(10000);
                urlCon.setReadTimeout(1000);
                String contentLength = urlCon.getHeaderField("content-length");
                this.fileLength = -1L;
                try {
                    this.fileLength = Long.parseLong(contentLength);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.inputStream = urlCon.getInputStream();
                this.byteCount = 0L;
                String firstLine = this.getLine();
                if (firstLine == null || !firstLine.equals(VERSION_STRING50) && !firstLine.equals(VERSION_STRING53)) {
                    this.message("Unknown Epic Version: " + firstLine);
                }
                while (this.bufP < this.bufL || !this.readBuf()) {
                    int startLine = this.bufP;
                    if (this.parseNumLineFast()) continue;
                    this.bufP = startLine;
                    String line = this.getLine();
                    assert (this.bufP <= this.bufL);
                    if (line == null) break;
                    this.parseNumLine(line);
                }
                this.rootCtx.writeSigs(this);
                this.inputStream.close();
                long stopTime = System.currentTimeMillis();
                int numSignals = 0;
                for (EpicReaderSignal s : this.signalsByEpicIndex) {
                    if (s == null) continue;
                    ++numSignals;
                }
                this.err.println((double)(stopTime - startTime) / 1000.0 + " sec to read " + this.byteCount + " bytes " + numSignals + " signals (max " + (this.signalsByEpicIndex.size() - 1) + " ) " + this.stringIds.size() + " strings " + this.timesC + " timepoints " + this.eventsC + " events from " + this.urlName);
                BTree.dumpStats(this.err);
                this.writeOut();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void parseNumLine(String line) throws IOException {
            if (line.length() == 0) {
                return;
            }
            char ch = line.charAt(0);
            if (ch == '.') {
                String[] split = this.whiteSpace.split(line);
                if (split[0].equals(".index") && split.length == 4) {
                    byte type;
                    if (split[3].equals("v")) {
                        type = 86;
                    } else if (split[3].equals("i")) {
                        type = 73;
                    } else {
                        this.message("Unknown waveform type: " + line);
                        return;
                    }
                    String name = split[1];
                    int sigNum = this.atoi(split[2]);
                    while (this.signalsByEpicIndex.size() <= sigNum) {
                        this.signalsByEpicIndex.add(null);
                    }
                    EpicReaderSignal s = this.signalsByEpicIndex.get(sigNum);
                    if (s == null) {
                        s = new EpicReaderSignal(sigNum, NewEpicAnalysis.getTree());
                        this.signalsByEpicIndex.set(sigNum, s);
                    }
                    if (name.startsWith("v(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    } else if (name.startsWith("i(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    } else if (name.startsWith("i1(") && name.endsWith(")")) {
                        name = name.substring(3, name.length() - 1);
                    }
                    this.rootCtx.addSig(name, '.', type, sigNum);
                } else if (!split[0].equals(".vdd") || split.length != 2) {
                    if (split[0].equals(".time_resolution") && split.length == 2) {
                        NewEpicOutProcess.this.timeResolution = this.atof(split[1]) * 1.0E-9;
                    } else if (split[0].equals(".current_resolution") && split.length == 2) {
                        NewEpicOutProcess.this.currentResolution = this.atof(split[1]);
                    } else if (split[0].equals(".voltage_resolution") && split.length == 2) {
                        NewEpicOutProcess.this.voltageResolution = this.atof(split[1]);
                    } else if (!(split[0].equals(".simulation_time") && split.length == 2 || split[0].equals(".high_threshold") && split.length == 2 || split[0].equals(".low_threshold") && split.length == 2 || split[0].equals(".nnodes") && split.length == 2 || split[0].equals(".nelems") && split.length == 2 || split[0].equals(".extra_nodes") && split.length == 2 || split[0].equals(".bus_notation") && split.length == 4 || split[0].equals(".hier_separator") && split.length == 2 || split[0].equals(".case") && split.length == 2)) {
                        this.message("Unrecognized Epic line: " + line);
                    }
                }
            } else if (ch >= '0' && ch <= '9') {
                String[] split = this.whiteSpace.split(line);
                int num = this.atoi(split[0]);
                if (split.length > 1) {
                    this.putValue(num, this.atoi(split[1]));
                } else {
                    this.putTime(num);
                }
            } else if (ch != ';' && !Character.isSpaceChar(ch)) {
                this.message("Unrecognized Epic line: " + line);
            }
        }

        private void writeContext(String s) throws IOException {
            int matchSeps = 0;
            int pos = 0;
            block0: while (matchSeps < this.contextStack.size()) {
                String si = this.contextStack.get(matchSeps);
                if (pos < s.length() && s.charAt(pos) == 'x') {
                    ++pos;
                }
                if (pos + si.length() >= s.length() || s.charAt(pos + si.length()) != '.') break;
                for (int k = 0; k < si.length(); ++k) {
                    if (s.charAt(pos + k) != si.charAt(k)) break block0;
                }
                ++matchSeps;
                pos += si.length() + 1;
            }
            while (this.contextStack.size() > matchSeps) {
                this.stdOut.writeByte(85);
                this.contextStack.remove(this.contextStack.size() - 1);
            }
            assert (this.contextStack.size() == matchSeps);
            while (pos < s.length()) {
                int indexOfSep = s.indexOf(46, pos);
                assert (indexOfSep >= pos);
                this.stdOut.writeByte(68);
                if (pos < indexOfSep && s.charAt(pos) == 'x') {
                    ++pos;
                }
                String si = s.substring(pos, indexOfSep);
                this.writeString(si);
                this.contextStack.add(si);
                pos = indexOfSep + 1;
            }
            assert (pos == s.length());
        }

        void writeString(String s) throws IOException {
            if (s == null) {
                this.stdOut.writeInt(-1);
                return;
            }
            Integer i = this.stringIds.get(s);
            if (i != null) {
                this.stdOut.writeInt(i);
                return;
            }
            this.stdOut.writeInt(this.stringIds.size());
            i = new Integer(this.stringIds.size());
            s = new String(s);
            this.stringIds.put(s, i);
            this.stdOut.writeUTF(s);
        }

        private boolean parseNumLineFast() {
            byte ch;
            int MAX_DIGITS = 9;
            if (this.bufP + 22 >= this.bufL) {
                return false;
            }
            if ((ch = this.buf[this.bufP++]) < 48 || ch > 57) {
                return false;
            }
            int num1 = ch - 48;
            ch = this.buf[this.bufP++];
            int lim = this.bufP + 8;
            while (48 <= ch && ch <= 57 && this.bufP < lim) {
                num1 = num1 * 10 + (ch - 48);
                ch = this.buf[this.bufP++];
            }
            boolean twoNumbers = false;
            int num2 = 0;
            if (ch == 32) {
                ch = this.buf[this.bufP++];
                boolean sign = false;
                if (ch == 45) {
                    sign = true;
                    ch = this.buf[this.bufP++];
                }
                if (ch < 48 || ch > 57) {
                    return false;
                }
                num2 = ch - 48;
                ch = this.buf[this.bufP++];
                int lim2 = this.bufP + 8;
                while (48 <= ch && ch <= 57 && this.bufP < lim2) {
                    num2 = num2 * 10 + (ch - 48);
                    ch = this.buf[this.bufP++];
                }
                if (sign) {
                    num2 = -num2;
                }
                twoNumbers = true;
            }
            if (ch != 10) {
                if (ch == 13) {
                    if (this.buf[this.bufP] == 10) {
                        ++this.bufP;
                    }
                } else {
                    return false;
                }
            }
            if (twoNumbers) {
                this.putValue(num1, num2);
            } else {
                this.putTime(num1);
            }
            ++this.lineNum;
            return true;
        }

        private void putTime(int time) {
            ++this.timesC;
            this.curTime = Math.max(this.curTime, time);
        }

        private void putValue(int sigNum, int value) {
            EpicReaderSignal s = this.signalsByEpicIndex.get(sigNum);
            if (s == null) {
                this.message("Signal " + sigNum + " not defined");
                return;
            }
            s.putEvent(this.curTime, value);
            ++this.eventsC;
        }

        private String getLine() throws IOException {
            this.builder.setLength(0);
            while (true) {
                if (this.bufP < this.bufL) {
                    int ch;
                    if ((ch = this.buf[this.bufP++] & 0xFF) == 10) {
                        return this.builder.toString();
                    }
                    if (ch == 13) {
                        if (this.bufP == this.bufL) {
                            this.readBuf();
                        }
                        if (this.bufP < this.bufL && this.buf[this.bufP] == 10) {
                            ++this.bufP;
                        }
                        return this.builder.toString();
                    }
                    this.builder.append((char)ch);
                    continue;
                }
                if (this.readBuf()) break;
            }
            if (this.builder.length() == 0) {
                return null;
            }
            ++this.lineNum;
            return this.builder.toString();
        }

        private double atof(String s) {
            double value = 0.0;
            try {
                value = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                this.message("Bad float format: " + s);
            }
            return value;
        }

        private int atoi(String s) {
            int value = 0;
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.message("Bad integer format: " + s);
            }
            return value;
        }

        private boolean readBuf() throws IOException {
            assert (this.bufP == this.bufL);
            this.bufL = 0;
            this.bufP = 0;
            this.bufL = this.inputStream.read(this.buf, 0, this.buf.length);
            if (this.bufL <= 0) {
                this.bufL = 0;
                return true;
            }
            this.byteCount += (long)this.bufL;
            this.showProgress(this.fileLength != 0L ? (double)this.byteCount / (double)this.fileLength : 0.0);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeOut() throws IOException {
            File tempFile;
            block8: {
                tempFile = null;
                FilterOutputStream waveStream = null;
                boolean ok = false;
                try {
                    long startTime = System.currentTimeMillis();
                    tempFile = File.createTempFile("elec", ".epic");
                    waveStream = new BufferedOutputStream(new FileOutputStream(tempFile));
                    this.showProgressNote("Writing " + tempFile);
                    this.stdOut.writeByte(70);
                    this.stdOut.writeDouble(NewEpicOutProcess.this.timeResolution);
                    this.stdOut.writeDouble(NewEpicOutProcess.this.voltageResolution);
                    this.stdOut.writeDouble(NewEpicOutProcess.this.currentResolution);
                    this.stdOut.writeDouble((double)this.curTime * NewEpicOutProcess.this.timeResolution);
                    for (EpicReaderSignal s : this.signalsByEpicIndex) {
                        if (s == null) continue;
                        NewEpicOutProcess.this.epicAnalysis.putWaveform(s.sigNum, s.getBWaveform());
                    }
                    this.stdOut.writeInt(-1);
                    waveStream.close();
                    this.stdOut.writeUTF(tempFile.toString());
                    this.stdOut.close();
                    ok = true;
                    long stopTime = System.currentTimeMillis();
                    this.err.println((double)(stopTime - startTime) / 1000.0 + " sec to write " + tempFile.length() + " bytes to " + tempFile);
                    Object var9_8 = null;
                    if (ok) {
                        return;
                    }
                    if (waveStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (ok) {
                        return;
                    }
                    if (waveStream != null) {
                        waveStream.close();
                    }
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                    throw throwable;
                }
                waveStream.close();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }

        private void showProgress(double ratio) {
            byte progress = (byte)(ratio * 100.0);
            if (progress == this.lastProgress) {
                return;
            }
            this.err.println("**PROGRESS " + progress);
            this.lastProgress = progress;
        }

        private void showProgressNote(String note) {
            this.err.println("**PROGRESS !" + note);
            this.lastProgress = 0;
        }

        private void message(String s) {
            this.err.println(s + " in line " + (this.lineNum + 1));
        }
    }

    private static class ContextBuilder {
        ArrayList<String> strings = new ArrayList();
        ArrayList<NewEpicAnalysis.Context> contexts = new ArrayList();

        private ContextBuilder() {
        }

        void clear() {
            this.strings.clear();
            this.contexts.clear();
        }
    }

    private static class SigInfo {
        private final int minV;
        private final int maxV;
        private final int start;
        private final int len;

        private SigInfo(int minV, int maxV, int start, int len) {
            this.minV = minV;
            this.maxV = maxV;
            this.start = start;
            this.len = len;
        }
    }
}

