/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.tool.ncc.basic.CellContext;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PassedNcc {
    private Set<Pair> passed = new HashSet<Pair>();
    private Date lastNccRunDate;

    public synchronized void setPassed(Cell c1, Cell c2) {
        this.passed.add(new Pair(c1, c2));
    }

    public synchronized boolean getPassed(Cell c1, Cell c2) {
        return this.passed.contains(new Pair(c1, c2));
    }

    public synchronized void removeCellsChangedSinceLastNccRun(CellContext[] cellContexts) {
        HashMap<Cell, Date> treeRevisionDates = new HashMap<Cell, Date>();
        for (CellContext cellContext : cellContexts) {
            TreeRevisionDates.addTreeRevisionDates(treeRevisionDates, cellContext);
        }
        Iterator<Pair> pIt = this.passed.iterator();
        while (pIt.hasNext()) {
            Pair p = pIt.next();
            if (!p.changedAfter(treeRevisionDates, this.lastNccRunDate)) continue;
            pIt.remove();
        }
        this.lastNccRunDate = new Date();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeRevisionDates
    extends HierarchyEnumerator.Visitor {
        private Map<Cell, Date> treeRevisionDates;

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (this.treeRevisionDates.containsKey(cell)) {
                return false;
            }
            this.treeRevisionDates.put(cell, cell.getRevisionDate());
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell parent;
            Date parentTreeDate;
            Cell me;
            Date myTreeDate;
            if (!info.isRootCell() && (myTreeDate = this.treeRevisionDates.get(me = info.getCell())).after(parentTreeDate = this.treeRevisionDates.get(parent = info.getParentInfo().getCell()))) {
                this.treeRevisionDates.put(parent, myTreeDate);
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }

        private TreeRevisionDates(Map<Cell, Date> treeRevisionDates) {
            this.treeRevisionDates = treeRevisionDates;
        }

        public static void addTreeRevisionDates(Map<Cell, Date> treeRevisionDates, CellContext root) {
            TreeRevisionDates visitor = new TreeRevisionDates(treeRevisionDates);
            HierarchyEnumerator.enumerateCell(root.cell, root.context, (HierarchyEnumerator.Visitor)visitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair {
        private Cell c1;
        private Cell c2;

        public Pair(Cell c1, Cell c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair p = (Pair)o;
            return this.c1 == p.c1 && this.c2 == p.c2 || this.c1 == p.c2 && this.c2 == p.c1;
        }

        public int hashCode() {
            return this.c1.hashCode() * this.c2.hashCode();
        }

        public boolean changedAfter(Map<Cell, Date> treeRevisionDates, Date date) {
            Date d1 = treeRevisionDates.get(this.c1);
            Date d2 = treeRevisionDates.get(this.c2);
            return d1 == null || d2 == null || d1.after(date) || d2.after(date);
        }
    }
}

