/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.Logger;
import com.sun.electric.tool.simulation.test.Netscan4JNI;
import com.sun.electric.tool.simulation.test.NetscanGeneric;

class Netscan4Driver
extends Logger {
    public static final int MIN_TAP = 1;
    public static final int MAX_TAP = 4;
    public static final int NUM_OUTPUT_PINS = 3;
    public static final int POD_IO_OUTPUT = 1;
    public static final int[] POD_GPIO = new int[]{13, 14, 15};
    private static String addressIP;
    private static int numPortsRegistered;

    private Netscan4Driver() {
    }

    static void registerPort(String addressIP, int jtagPort) {
        Netscan4Driver.checkJtagPort(jtagPort);
        ++numPortsRegistered;
        if (Netscan4Driver.addressIP != null) {
            if (addressIP.equals(Netscan4Driver.addressIP)) {
                return;
            }
            Infrastructure.fatal("Attempt to connect to Netscan4 at IP address " + addressIP + ", when one at " + Netscan4Driver.addressIP + " is already connected.  Corelis Netscan SFL" + " library only supports one JTAG tester at a time");
        }
        Netscan4Driver.addressIP = addressIP;
        NetscanGeneric.incrementNumTesters();
        Logger.logInit("Connecting to Netscan4 at " + addressIP);
        int status = Netscan4JNI.netUSB_Connect(addressIP);
        if (status <= 0) {
            Infrastructure.fatal("Netscan4JNI.net_connect returned error code " + status);
        }
    }

    static void checkJtagPort(int jtagPort) {
        if (jtagPort < 1 || jtagPort > 4) {
            Infrastructure.fatal("JTAG port number " + jtagPort + " not in allowed range " + 1 + ".." + 4);
        }
    }

    static void configure(float tapVolt, long kiloHerz, Logger logger) {
        int milliVolt = Math.round(tapVolt * 1000.0f);
        logger.logSet("Netscan4 configuring " + kiloHerz + " kHz and " + milliVolt + " mV");
        int status = Netscan4JNI.netUSB_hard_reset(kiloHerz, milliVolt);
        if (status == 0) {
            Infrastructure.fatal("Netscan4JNI.netUSB_hard_reset returned " + status);
        }
        if ((status = Netscan4JNI.netUSB_set_scan_clk(kiloHerz)) != 0) {
            Infrastructure.fatal("Netscan4JNI.netUSB_set_scan_clk returned " + status);
        }
        Netscan4Driver.reset();
    }

    static String getAddressIP() {
        return addressIP;
    }

    static void reset() {
        int status = Netscan4JNI.netUSB_set_trst(0);
        if (status != 0) {
            Infrastructure.fatal("Netscan4JNI.net_set_trst(0) returned error code " + status);
        }
        if ((status = Netscan4JNI.netUSB_set_trst(1)) != 0) {
            Infrastructure.fatal("Netscan4JNI.net_set_trst(1) returned error code " + status);
        }
    }

    static void tms_reset(int jtagPort) {
        int status = Netscan4JNI.netUSB_tms_reset(jtagPort);
        if (status != 0) {
            Infrastructure.fatal("Netscan4JNI.net_tms_reset(" + jtagPort + ") returned error code " + status);
        }
    }

    static void deregisterPort() {
        int status;
        if (--numPortsRegistered == 0 && (status = Netscan4JNI.netUSB_Disconnect()) != 0) {
            Infrastructure.fatal("Netscan4JNI.net_disconnect() returned error code " + status);
        }
    }

    protected static int hw_net_scan_ir(int jtagPort, int numBits, short[] scanIn, short[] scanOut, Logger logger) {
        Netscan4Driver.checkJtagPort(jtagPort);
        logger.logOther("IR into TAP " + jtagPort + ": # shorts=" + scanIn.length + ", # bits=" + numBits + ", " + NetscanGeneric.shortsToString(scanIn));
        int result = Netscan4JNI.netUSB_scan_ir(scanIn, numBits, scanOut, jtagPort);
        logger.logOther("IR out: # shorts=" + scanOut.length + ", " + NetscanGeneric.shortsToString(scanOut));
        return result;
    }

    protected static int hw_net_scan_dr(int jtagPort, int numBits, short[] scanIn, short[] scanOut, Logger logger) {
        Netscan4Driver.checkJtagPort(jtagPort);
        logger.logOther("DR into TAP " + jtagPort + ":  # shorts=" + scanIn.length + ", " + NetscanGeneric.shortsToString(scanIn));
        logger.logOther("   lentgth=" + numBits);
        int result = Netscan4JNI.netUSB_scan_dr(scanIn, numBits, scanOut, jtagPort);
        logger.logOther("DR out: # shorts=" + scanOut.length + ", " + NetscanGeneric.shortsToString(scanOut));
        return result;
    }

    static void checkGpioID(int jtagPort, int index) {
        Netscan4Driver.checkJtagPort(jtagPort);
        if (index < 0 || index >= POD_GPIO.length) {
            Infrastructure.fatal("Index " + index + " not in allowed range 0.." + (POD_GPIO.length - 1));
        }
    }

    static void setParallelIO(int jtagPort, int index, boolean newLevel) {
        Netscan4Driver.checkGpioID(jtagPort, index);
        int value = newLevel ? 1 : 0;
        int status = Netscan4JNI.netUSB_AccessScanGPIO(jtagPort, POD_GPIO[index], 1, value);
        if (status != 0) {
            Infrastructure.fatal("net_access_gpio returned error code" + status);
        }
    }

    static {
        numPortsRegistered = 0;
    }
}

