/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.waveform.DragButton;
import com.sun.electric.tool.user.waveform.Panel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class WaveSignal {
    private Panel wavePanel;
    private Signal sSig;
    private Color color;
    private double[] controlPointsSelected;
    private boolean highlighted;
    private JButton sigButton;
    private static Color[] colorArray = new Color[]{new Color(255, 0, 0), new Color(255, 127, 0), new Color(255, 255, 0), new Color(127, 255, 0), new Color(0, 235, 0), new Color(0, 255, 102), new Color(0, 255, 255), new Color(0, 127, 255), new Color(80, 80, 255), new Color(127, 0, 255), new Color(255, 0, 255), new Color(255, 0, 127)};

    public WaveSignal(Panel wavePanel, Signal sSig) {
        int sigNo = wavePanel.getNumSignals();
        this.wavePanel = wavePanel;
        this.sSig = sSig;
        this.controlPointsSelected = null;
        this.highlighted = false;
        String sigName = sSig.getFullName();
        if (wavePanel.isAnalog()) {
            this.color = colorArray[sigNo % colorArray.length];
            this.sigButton = new DragButton(sigName, wavePanel.getPanelNumber());
            this.sigButton.setBorderPainted(false);
            this.sigButton.setDefaultCapable(false);
            this.sigButton.setForeground(this.color);
            wavePanel.getSignalButtons().add(this.sigButton);
            wavePanel.addSignal(this, this.sigButton);
            this.sigButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WaveSignal.this.signalNameClicked(evt);
                }
            });
            this.sigButton.addMouseListener(new SignalButton(this));
        } else {
            this.color = new Color(User.getColor(User.ColorPrefType.WAVE_STIMULI));
            this.sigButton = wavePanel.getDigitalSignalButton();
            this.sigButton.setText(wavePanel.getPanelNumber() + ": " + sigName);
            wavePanel.addSignal(this, this.sigButton);
            this.sigButton.setForeground(this.color);
        }
    }

    public static WaveSignal addSignalToPanel(Signal sSig, Panel panel, Color newColor) {
        WaveSignal ws = panel.findWaveSignal(sSig);
        if (ws != null) {
            int index;
            Color color = ws.color;
            for (index = 0; index < colorArray.length; ++index) {
                if (!color.equals(colorArray[index])) continue;
                ++index;
                break;
            }
            if (index >= colorArray.length) {
                index = 0;
            }
            ws.color = colorArray[index];
            JButton but = panel.findButton(ws);
            but.setForeground(colorArray[index]);
            panel.getSignalButtons().repaint();
            panel.repaintContents();
            return null;
        }
        int sigNo = panel.getNumSignals();
        WaveSignal wsig = new WaveSignal(panel, sSig);
        if (newColor == null) {
            newColor = colorArray[sigNo % colorArray.length];
        }
        wsig.color = newColor;
        wsig.getButton().setForeground(newColor);
        panel.getSignalButtons().validate();
        panel.getSignalButtons().repaint();
        if (panel.getSignalButtonsPane() != null) {
            panel.getSignalButtonsPane().validate();
        }
        if (sigNo == 0) {
            panel.fitToSignal(sSig);
        }
        panel.repaintContents();
        return wsig;
    }

    public Signal getSignal() {
        return this.sSig;
    }

    public void setSignal(Signal sig) {
        this.sSig = sig;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
        this.sigButton.setForeground(c);
    }

    public double[] getSelectedControlPoints() {
        return this.controlPointsSelected;
    }

    public void clearSelectedControlPoints() {
        this.controlPointsSelected = null;
    }

    public void addSelectedControlPoint(double controlXValue) {
        if (this.controlPointsSelected == null) {
            this.controlPointsSelected = new double[1];
            this.controlPointsSelected[0] = controlXValue;
            return;
        }
        for (int i = 0; i < this.controlPointsSelected.length; ++i) {
            if (this.controlPointsSelected[i] != controlXValue) continue;
            return;
        }
        double[] newPoints = new double[this.controlPointsSelected.length + 1];
        for (int i = 0; i < this.controlPointsSelected.length; ++i) {
            newPoints[i] = this.controlPointsSelected[i];
        }
        newPoints[this.controlPointsSelected.length] = controlXValue;
        this.controlPointsSelected = newPoints;
    }

    public void removeSelectedControlPoint(double controlXValue) {
        if (this.controlPointsSelected == null) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < this.controlPointsSelected.length; ++i) {
            if (this.controlPointsSelected[i] != controlXValue) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        double[] newPoints = new double[this.controlPointsSelected.length - 1];
        int j = 0;
        for (int i = 0; i < this.controlPointsSelected.length; ++i) {
            if (this.controlPointsSelected[i] == controlXValue) continue;
            newPoints[j++] = this.controlPointsSelected[i];
        }
        this.controlPointsSelected = newPoints;
    }

    private void signalNameClicked(ActionEvent evt) {
        JButton signal = (JButton)evt.getSource();
        WaveSignal ws = this.wavePanel.findWaveSignal(signal);
        if ((evt.getModifiers() & 1) == 0) {
            ws.wavePanel.clearHighlightedSignals();
            ws.wavePanel.addHighlightedSignal(ws, true);
            ws.wavePanel.makeSelectedPanel(-1, -1);
        } else if (ws.highlighted) {
            ws.wavePanel.removeHighlightedSignal(ws, true);
        } else {
            ws.wavePanel.addHighlightedSignal(ws, true);
        }
        ws.wavePanel.getWaveWindow().crossProbeWaveformToEditWindow();
    }

    public Panel getPanel() {
        return this.wavePanel;
    }

    public JButton getButton() {
        return this.sigButton;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    static class ChangeSignalColorListener
    implements ActionListener {
        WaveSignal signal;
        Color col;

        ChangeSignalColorListener(WaveSignal signal, Color col) {
            this.signal = signal;
            this.col = col;
        }

        public void actionPerformed(ActionEvent evt) {
            this.signal.color = this.col;
            this.signal.sigButton.setForeground(this.col);
            this.signal.wavePanel.repaintContents();
            this.signal.wavePanel.getWaveWindow().saveSignalOrder();
        }
    }

    private static class SignalButton
    extends MouseAdapter {
        private static final int BUTTON_SIZE = 15;
        private WaveSignal signal;

        SignalButton(WaveSignal signal) {
            this.signal = signal;
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 4) != 0) {
                if (!this.signal.highlighted) {
                    this.signal.wavePanel.clearHighlightedSignals();
                    this.signal.wavePanel.addHighlightedSignal(this.signal, true);
                    this.signal.wavePanel.makeSelectedPanel(e.getX(), e.getY());
                }
                JPopupMenu menu = new JPopupMenu("Color");
                for (int i = 0; i < colorArray.length; ++i) {
                    this.addColoredButton(menu, colorArray[i]);
                }
                menu.show(this.signal.sigButton, e.getX(), e.getY());
            }
        }

        private void addColoredButton(JPopupMenu menu, Color color) {
            BufferedImage bi = new BufferedImage(15, 15, 1);
            for (int y = 0; y < 15; ++y) {
                for (int x = 0; x < 15; ++x) {
                    bi.setRGB(x, y, color.getRGB());
                }
            }
            ImageIcon redIcon = new ImageIcon(bi);
            JMenuItem menuItem = new JMenuItem(redIcon);
            menu.add(menuItem);
            menuItem.addActionListener(new ChangeSignalColorListener(this.signal, color));
        }
    }
}

