/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.forceDirected.staged;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.CalculateForcesStageWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.EndWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.OverlapWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlaceNodesStageWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.StartUpStage;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingPattern;
import com.sun.electric.tool.placement.forceDirected2.metrics.BBMetric;
import com.sun.electric.tool.placement.forceDirected2.utils.PlacementProperties;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.Stage;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;
import com.sun.electric.tool.placement.forceDirected2.utils.output.PNGOutput;
import com.sun.electric.util.math.GenMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartUpStageWorker
extends StageWorker {
    protected static Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, GenMath.MutableInteger>> connectivityMap = null;
    private double velocityFactor;
    private List<PlacementFrame.PlacementNode> nodesToPlace;
    private List<PlacementFrame.PlacementNetwork> allNetworks;
    private int widthCheckBoarding;
    private int heightCheckBoarding;
    private double fieldSize;
    private CheckboardingPattern checkPattern;

    public StartUpStageWorker(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.nodesToPlace = nodesToPlace;
        this.allNetworks = allNetworks;
    }

    protected double bestSize() {
        double result2 = 0.0;
        for (PlacementFrame.PlacementNode node : this.nodesToPlace) {
            double cellMax = node.getHeight() > node.getWidth() ? node.getHeight() : node.getWidth();
            result2 = cellMax > result2 ? cellMax : result2;
        }
        return result2;
    }

    protected void calculateVelocityFactor() {
        this.velocityFactor = 1.0;
        double tmp = this.nodesToPlace.size();
        while (tmp > 1.0) {
            tmp /= 10.0;
            this.velocityFactor /= 10.0;
        }
    }

    protected void createCheckboardingPattern() {
        int findBestSizeMax = (int)Math.ceil(Math.sqrt(this.nodesToPlace.size()));
        int bestField = this.nodesToPlace.size() * 2;
        int bestIdx = 0;
        int divergence = PlacementProperties.getInstance().getDivergence();
        int start = findBestSizeMax - divergence < 1 ? 1 : findBestSizeMax - divergence;
        int end = findBestSizeMax + divergence > this.nodesToPlace.size() ? this.nodesToPlace.size() : findBestSizeMax + divergence;
        for (int i = start; i < end; ++i) {
            int field2 = i * (int)Math.ceil((double)this.nodesToPlace.size() / (double)i);
            if (field2 >= bestField) continue;
            bestField = field2;
            bestIdx = i;
        }
        this.widthCheckBoarding = bestIdx * 1;
        this.heightCheckBoarding = (int)(Math.ceil((double)this.nodesToPlace.size() / (double)bestIdx) * 1.0);
        this.checkPattern = new CheckboardingPattern(this.widthCheckBoarding, this.heightCheckBoarding, this.fieldSize, this.fieldSize);
    }

    protected void fillCheckboardingPattern() {
        Random rand = new Random(System.currentTimeMillis());
        ArrayList<Integer> places = new ArrayList<Integer>(this.heightCheckBoarding * this.widthCheckBoarding);
        for (int i = 0; i < this.heightCheckBoarding * this.widthCheckBoarding; ++i) {
            places.add(new Integer(i));
        }
        for (PlacementFrame.PlacementNode node : this.nodesToPlace) {
            int listPos = rand.nextInt(places.size());
            int nodePos = (Integer)places.remove(listPos);
            int x = nodePos % this.widthCheckBoarding;
            int y = nodePos / this.widthCheckBoarding;
            CheckboardingField field2 = this.checkPattern.getField(x, y);
            node.setPlacement(field2.getLocation().getX(), field2.getLocation().getY());
            field2.setNode(node);
        }
    }

    @Override
    public void run() {
        this.calculateVelocityFactor();
        this.fieldSize = this.bestSize();
        this.createCheckboardingPattern();
        this.fillCheckboardingPattern();
        PlacementForceDirectedStaged.setCheckboardingPattern(this.checkPattern);
        if (PlacementProperties.getInstance().getIterations() != 0) {
            PlacementProperties properties = PlacementProperties.getInstance();
            ArrayList<StageWorker> forces = new ArrayList<StageWorker>();
            ArrayList<StageWorker> move = new ArrayList<StageWorker>();
            ArrayList<StageWorker> overlap = new ArrayList<StageWorker>();
            ArrayList<StageWorker> endWorker = new ArrayList<StageWorker>();
            double threshold = PlacementProperties.getInstance().getOverlappingThreshold();
            for (int i = 0; i < properties.getNumOfThreads(); ++i) {
                forces.add(new CalculateForcesStageWorker(connectivityMap, this.allNetworks));
                move.add(new PlaceNodesStageWorker(this.velocityFactor));
                overlap.add(new OverlapWorker(threshold, i));
            }
            long finalTimeStamp = System.currentTimeMillis() + (long)(PlacementProperties.getInstance().getTimeout() * 1000);
            BBMetric bb = new BBMetric(this.nodesToPlace, this.allNetworks);
            PNGOutput out = new PNGOutput(this.nodesToPlace, this.allNetworks);
            endWorker.add(new EndWorker(PlacementProperties.getInstance().getIterations(), (StartUpStage)this.stage, this.widthCheckBoarding, this.heightCheckBoarding, this.checkPattern, this.velocityFactor, out, bb, finalTimeStamp));
            Stage calculateForces = new Stage(forces);
            Stage moveNodes = new Stage(move);
            Stage resolveOverlap = new Stage(overlap);
            Stage endStage = new Stage(endWorker);
            calculateForces.getNextStages().add(moveNodes);
            moveNodes.getNextStages().add(resolveOverlap);
            resolveOverlap.getNextStages().add(endStage);
            endStage.getNextStages().add(calculateForces);
            ((StartUpStage)this.stage).getStages().add(calculateForces);
            ((StartUpStage)this.stage).getStages().add(moveNodes);
            ((StartUpStage)this.stage).getStages().add(resolveOverlap);
            ((StartUpStage)this.stage).getStages().add(endStage);
            calculateForces.start();
            moveNodes.start();
            resolveOverlap.start();
            endStage.start();
            int totalNumOfPorts = 0;
            for (PlacementFrame.PlacementNode node : this.nodesToPlace) {
                totalNumOfPorts += node.getPorts().size();
            }
            int stepWidth = 10;
            for (int i = 0; i < this.heightCheckBoarding; i += stepWidth) {
                for (int j = 0; j < this.widthCheckBoarding; j += stepWidth) {
                    CheckboardingField[][] fields = this.checkPattern.getFields(j, i, stepWidth, stepWidth);
                    calculateForces.getInput(this).add(new PlacementDTO(fields, i * this.widthCheckBoarding + j));
                }
            }
            try {
                calculateForces.join();
                moveNodes.join();
                resolveOverlap.join();
                endStage.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            this.stage.stop();
        }
    }

    public void setStage(StartUpStage stage) {
        this.stage = stage;
    }
}

