/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SweptSample<S extends Sample>
implements Sample {
    private final Sample[] vals;

    public SweptSample(Sample[] vals) {
        this.vals = new Sample[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            this.vals[i] = vals[i];
        }
    }

    public int getWidth() {
        return this.vals.length;
    }

    public S getSweep(int i) {
        return (S)this.vals[i];
    }

    public double getMin() {
        double minVal = Double.MAX_VALUE;
        for (int i = 0; i < this.vals.length; ++i) {
            if (this.vals[i] == null) continue;
            minVal = Math.min(minVal, ((ScalarSample)this.vals[i]).getValue());
        }
        return minVal;
    }

    public double getMax() {
        double maxVal = -1.7976931348623157E308;
        for (int i = 0; i < this.vals.length; ++i) {
            if (this.vals[i] == null) continue;
            maxVal = Math.max(maxVal, ((ScalarSample)this.vals[i]).getValue());
        }
        return maxVal;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SweptSample)) {
            return false;
        }
        SweptSample bo = (SweptSample)o;
        if (bo.vals.length != this.vals.length) {
            return false;
        }
        for (int i = 0; i < this.vals.length; ++i) {
            if (this.vals[i] == null) {
                if (bo.vals[i] == null) continue;
                return false;
            }
            if (bo.vals[i] == null) {
                return false;
            }
            if (this.vals[i].equals(bo.vals[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        for (int i = 0; i < this.vals.length; ++i) {
            if (this.vals[i] == null) continue;
            ret ^= this.vals[i].hashCode();
        }
        return ret;
    }

    @Override
    public boolean isLogicX() {
        return false;
    }

    @Override
    public boolean isLogicZ() {
        return false;
    }

    @Override
    public Sample lub(Sample s) {
        if (!(s instanceof SweptSample)) {
            throw new RuntimeException("tried to call SweptSample.lub(" + s.getClass().getName() + ")");
        }
        SweptSample ds = (SweptSample)s;
        if (ds.vals.length != this.vals.length) {
            throw new RuntimeException("tried to call lub() on SweptSamples of different width");
        }
        Sample[] ret = new Sample[this.vals.length];
        for (int i = 0; i < ret.length; ++i) {
            if (this.vals[i] == null || ds.vals[i] == null) continue;
            ret[i] = this.vals[i].lub(ds.vals[i]);
        }
        return new SweptSample<S>(ret);
    }

    @Override
    public Sample glb(Sample s) {
        if (!(s instanceof SweptSample)) {
            throw new RuntimeException("tried to call SweptSample.glb(" + s.getClass().getName() + ")");
        }
        SweptSample ds = (SweptSample)s;
        if (ds.vals.length != this.vals.length) {
            throw new RuntimeException("tried to call glb() on SweptSamples of different width");
        }
        Sample[] ret = new Sample[this.vals.length];
        for (int i = 0; i < ret.length; ++i) {
            if (this.vals[i] == null || ds.vals[i] == null) continue;
            ret[i] = this.vals[i].glb(ds.vals[i]);
        }
        return new SweptSample<S>(ret);
    }

    @Override
    public double getMinValue() {
        double min2 = Double.MAX_VALUE;
        for (int i = 0; i < this.vals.length; ++i) {
            min2 = Math.min(min2, this.vals[i].getMinValue());
        }
        return min2;
    }

    @Override
    public double getMaxValue() {
        double max2 = -1.7976931348623157E308;
        for (int i = 0; i < this.vals.length; ++i) {
            max2 = Math.max(max2, this.vals[i].getMaxValue());
        }
        return max2;
    }

    public static <SS extends Sample> Signal<SweptSample<SS>> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, int width) {
        throw new RuntimeException("not implemented");
    }

    public static <SS extends Sample> Signal<SweptSample<SS>> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, boolean digital, final Signal<SS>[] subsignals) {
        final String scName = sc.getName();
        return new Signal<SweptSample<SS>>(sc, sd, signalName, signalContext, digital){

            @Override
            public boolean isEmpty() {
                for (Signal sig : subsignals) {
                    if (sig.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Signal.View<RangeSample<SweptSample<SS>>> getRasterView(double t0, double t1, int numPixels) {
                Signal.View[] subviews = new Signal.View[subsignals.length];
                for (int i = 0; i < subviews.length; ++i) {
                    subviews[i] = subsignals[i].getRasterView(t0, t1, numPixels);
                }
                TreeMap<Double, HashSet<Integer>> tm = new TreeMap<Double, HashSet<Integer>>();
                for (int i = 0; i < subviews.length; ++i) {
                    Signal.View view = subviews[i];
                    for (int j = 0; j < view.getNumEvents(); ++j) {
                        double t = view.getTime(j);
                        HashSet<Integer> hs = (HashSet<Integer>)tm.get(t);
                        if (hs == null) {
                            hs = new HashSet<Integer>();
                            tm.put(t, hs);
                        }
                        hs.add(i);
                    }
                }
                final double[] times2 = new double[tm.size()];
                final RangeSample[] vals = new RangeSample[tm.size()];
                int i = 0;
                int[] event = new int[subviews.length];
                Sample[] minvals = new Sample[subviews.length];
                Sample[] maxvals = new Sample[subviews.length];
                Iterator i$ = tm.keySet().iterator();
                while (i$.hasNext()) {
                    double t;
                    times2[i] = t = ((Double)i$.next()).doubleValue();
                    HashSet hs = (HashSet)tm.get(t);
                    Iterator i$2 = hs.iterator();
                    while (i$2.hasNext()) {
                        int v = (Integer)i$2.next();
                        assert (subviews[v].getTime(event[v]) == t);
                        RangeSample rs = (RangeSample)subviews[v].getSample(event[v]);
                        if (rs != null) {
                            minvals[v] = rs.getMin();
                            maxvals[v] = rs.getMax();
                        }
                        int n = v;
                        event[n] = event[n] + 1;
                    }
                    vals[i] = new RangeSample(new SweptSample(minvals), new SweptSample(maxvals));
                    ++i;
                }
                return new Signal.View<RangeSample<SweptSample<SS>>>(){

                    @Override
                    public int getNumEvents() {
                        return times2.length;
                    }

                    @Override
                    public double getTime(int event) {
                        return times2[event];
                    }

                    @Override
                    public RangeSample<SweptSample<SS>> getSample(int event) {
                        return vals[event];
                    }
                };
            }

            @Override
            public Signal.View<SweptSample<SS>> getExactView() {
                Signal.View[] subviews = new Signal.View[subsignals.length];
                for (int i = 0; i < subviews.length; ++i) {
                    subviews[i] = subsignals[i].getExactView();
                }
                TreeMap<Double, HashSet<Integer>> tm = new TreeMap<Double, HashSet<Integer>>();
                for (int i = 0; i < subviews.length; ++i) {
                    Signal.View view = subviews[i];
                    for (int j = 0; j < view.getNumEvents(); ++j) {
                        double t = view.getTime(j);
                        HashSet<Integer> hs = (HashSet<Integer>)tm.get(t);
                        if (hs == null) {
                            hs = new HashSet<Integer>();
                            tm.put(t, hs);
                        }
                        hs.add(i);
                    }
                }
                final double[] times2 = new double[tm.size()];
                final SweptSample[] vals = new SweptSample[tm.size()];
                int i = 0;
                int[] event = new int[subviews.length];
                Sample[] sampleVals = new Sample[subviews.length];
                Iterator i$ = tm.keySet().iterator();
                while (i$.hasNext()) {
                    double t;
                    times2[i] = t = ((Double)i$.next()).doubleValue();
                    HashSet hs = (HashSet)tm.get(t);
                    Iterator i$2 = hs.iterator();
                    while (i$2.hasNext()) {
                        int v = (Integer)i$2.next();
                        assert (subviews[v].getTime(event[v]) == t);
                        Object rs = subviews[v].getSample(event[v]);
                        if (rs != null) {
                            sampleVals[v] = rs;
                        }
                        int n = v;
                        event[n] = event[n] + 1;
                    }
                    vals[i] = new SweptSample(sampleVals);
                    ++i;
                }
                return new Signal.View<SweptSample<SS>>(){

                    @Override
                    public int getNumEvents() {
                        return times2.length;
                    }

                    @Override
                    public double getTime(int event) {
                        return times2[event];
                    }

                    @Override
                    public SweptSample<SS> getSample(int event) {
                        return vals[event];
                    }
                };
            }

            @Override
            public double getMinTime() {
                double min2 = Double.MAX_VALUE;
                for (Signal sig : subsignals) {
                    min2 = Math.min(min2, sig.getMinTime());
                }
                return min2;
            }

            @Override
            public double getMaxTime() {
                double max2 = -1.7976931348623157E308;
                for (Signal sig : subsignals) {
                    max2 = Math.max(max2, sig.getMaxTime());
                }
                return max2;
            }

            @Override
            public double getMinValue() {
                double min2 = Double.MAX_VALUE;
                for (Signal sig : subsignals) {
                    min2 = Math.min(min2, sig.getMinValue());
                }
                return min2;
            }

            @Override
            public double getMaxValue() {
                double max2 = -1.7976931348623157E308;
                for (Signal sig : subsignals) {
                    max2 = Math.max(max2, sig.getMaxValue());
                }
                return max2;
            }

            @Override
            public void plot(Panel panel, Graphics g, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
                for (int i = 0; i < subsignals.length; ++i) {
                    if (!panel.getWaveWindow().isSweepSignalIncluded(scName, i)) continue;
                    ScalarSample.plotSig((MutableSignal)subsignals[i], panel, g, ws, light, forPs, bounds, selectedObjects, xAxisSignal);
                }
            }
        };
    }
}

