/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.Main;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.io.OutputStream;
import java.io.PrintStream;

public class MessagesStream
extends PrintStream {
    private static MessagesStream messagesStream;

    private static void initializeMessageStream() {
        if (messagesStream == null) {
            messagesStream = new MessagesStream();
        }
    }

    public static MessagesStream getMessagesStream() {
        MessagesStream.initializeMessageStream();
        return messagesStream;
    }

    public MessagesStream() {
        super(new OutputStream(){

            public void write(int c) {
                throw new UnsupportedOperationException();
            }
        });
        System.setProperty("line.separator", "\n");
        System.setOut(this);
    }

    public void flush() {
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public boolean checkError() {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] b) {
        this.print(new String(b));
    }

    public void write(int b) {
        this.print((char)b);
    }

    public void write(byte[] b, int off, int len) {
        this.print(new String(b, off, len));
    }

    public void print(boolean b) {
        this.print(b ? "true" : "false", false);
    }

    public void print(char c) {
        this.print(String.valueOf(c), false);
    }

    public void print(int i) {
        this.print(String.valueOf(i), false);
    }

    public void print(long l) {
        this.print(String.valueOf(l), false);
    }

    public void print(float f) {
        this.print(String.valueOf(f), false);
    }

    public void print(double d) {
        this.print(String.valueOf(d), false);
    }

    public void print(char[] s) {
        this.print(String.valueOf(s), false);
    }

    public void print(String s) {
        this.print(s != null ? s : "null", false);
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj), false);
    }

    public void println() {
        this.print("", true);
    }

    public void println(char c) {
        this.print(String.valueOf(c), true);
    }

    public void println(int i) {
        this.print(String.valueOf(i), true);
    }

    public void println(long l) {
        this.print(String.valueOf(l), true);
    }

    public void println(float f) {
        this.print(String.valueOf(f), true);
    }

    public void println(double d) {
        this.print(String.valueOf(d), true);
    }

    public void println(char[] s) {
        this.print(String.valueOf(s), true);
    }

    public void println(String s) {
        this.print(s != null ? s : "null", true);
    }

    public void println(Object obj) {
        this.print(String.valueOf(obj), true);
    }

    private void print(String s, boolean newLine) {
        if (Main.isBatch()) {
            if (newLine) {
                Main.UserInterfaceDummy.stdout.println(s);
            } else {
                Main.UserInterfaceDummy.stdout.print(s);
            }
        } else {
            UserInterface ui = Job.getUserInterface();
            if (ui != null) {
                ui.printMessage(s, newLine);
                return;
            }
            ui = Job.getExtendedUserInterface();
            if (ui != null) {
                ui.printMessage(s, newLine);
                return;
            }
            if (newLine) {
                System.err.println(s);
            } else {
                System.err.print(s);
            }
        }
    }

    public void save() {
        this.save(OpenFile.chooseOutputFile(FileType.TEXT, null, "emessages.txt"));
    }

    public void save(String filePath) {
        Job.getUserInterface().saveMessages(filePath);
    }
}

