/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config;

import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.config.ConstructorInject;
import com.sun.electric.util.config.CreateBy;
import com.sun.electric.util.config.FactoryMethodInject;
import com.sun.electric.util.config.SetterInject;
import com.sun.electric.util.config.annotations.Inject;
import com.sun.electric.util.config.cache.TypeCache;
import com.sun.electric.util.config.model.ParameterEntry;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectStrategy<T> {
    public TypeCache typeCache = TypeCache.getInstance();

    public abstract T inject(Class<T> var1, ParameterEntry ... var2) throws Exception;

    protected Class<?>[] convertParametersToTypes(Class<?>[] signature, Object ... parameters) throws ParameterDoesntFit {
        if (parameters == null) {
            return null;
        }
        if (parameters.length != signature.length) {
            return null;
        }
        LinkedList<Class> parameterTypes = CollectionFactory.createLinkedList();
        int i = 0;
        for (Object obj : parameters) {
            Class<?> tmpClass = obj.getClass();
            if (!tmpClass.equals(signature[i])) {
                this.typeCache.createTypeHierarchy(tmpClass);
                if (this.typeCache.contains(tmpClass, signature[i])) {
                    tmpClass = signature[i];
                } else {
                    throw new ParameterDoesntFit();
                }
            }
            parameterTypes.add(tmpClass);
            ++i;
        }
        return parameterTypes.toArray(new Class[parameterTypes.size()]);
    }

    protected void convertParameterEntires(Inject inject, Object[] result2, ParameterEntry ... parameters) throws Exception {
        String[] order = inject.parameterOrder();
        if (order.length == 0) {
            for (int i = 0; i < parameters.length; ++i) {
                result2[i] = parameters[i].getValue().getInstance();
            }
        } else {
            if (order.length != result2.length) {
                throw new ParameterDoesntFit();
            }
            for (int i = 0; i < order.length; ++i) {
                result2[i] = null;
                for (int j = 0; j < parameters.length; ++j) {
                    if (!parameters[j].getName().equals(order[i])) continue;
                    result2[i] = parameters[j].getValue().getInstance();
                }
                if (result2[i] != null) continue;
                throw new Exception("Could not find parameter: " + order[i]);
            }
        }
    }

    public static <T> InjectStrategy<T> getForConstructor(Class<T> clazz) {
        return new ConstructorInject();
    }

    public static <T> InjectStrategy<T> getForFactoryMethod(Class<T> clazz, String factoryMethod) {
        return new FactoryMethodInject(factoryMethod);
    }

    public static <T> InjectStrategy<T> getForSetter(Class<T> clazz, CreateBy createBy, String factoryMethod) {
        return new SetterInject(createBy, factoryMethod);
    }

    public static <T> InjectStrategy<T> getDefault(Class<T> clazz, CreateBy createBy, String factoryMethod) {
        return InjectStrategy.getForSetter(clazz, createBy, factoryMethod);
    }

    public static class ParameterDoesntFit
    extends Exception {
    }
}

