/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config.model;

import com.sun.electric.util.config.CreateBy;
import com.sun.electric.util.config.InjectStrategy;
import com.sun.electric.util.config.annotations.Inject;
import com.sun.electric.util.config.annotations.InjectionMethod;
import com.sun.electric.util.config.model.ParameterEntry;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigEntry<T> {
    protected boolean singleton = false;
    protected T singletonInstance = null;
    protected ParameterEntry[] parameters;
    protected Class<T> clazz;

    public ConfigEntry(Class<T> clazz, boolean singleton, ParameterEntry ... parameter) {
        this.singleton = singleton;
        this.parameters = parameter;
        this.clazz = clazz;
    }

    public abstract T getInstance() throws Exception;

    protected void injectSetters(T instance) throws Exception {
        Method[] methods;
        block0: for (Method method : methods = this.clazz.getMethods()) {
            Inject inject = method.getAnnotation(Inject.class);
            if (inject == null) continue;
            String name = inject.name();
            String paramName = "";
            paramName = name.equals("") ? (method.getName().startsWith("set") ? method.getName().substring(3).toLowerCase() : name) : name;
            for (ParameterEntry entry : this.parameters) {
                if (!entry.getName().equals(paramName)) continue;
                method.invoke(instance, entry.getValue().getInstance());
                continue block0;
            }
        }
    }

    public static <T> ConfigEntry<T> createForConstructor(Class<T> clazz, boolean singleton, ParameterEntry ... parameters) {
        return new ConfigEntryConstructor<T>(clazz, singleton, parameters);
    }

    public static <T> ConfigEntry<T> createForFactoryMethod(Class<T> clazz, String factoryMethod, boolean singleton, ParameterEntry ... parameters) {
        return new ConfigEntryFactoryMethod<T>(clazz, factoryMethod, singleton, parameters);
    }

    public static <T extends Enum<T>> ConfigEntry<T> createForEnum(Class<T> clazz, String value2) {
        return new ConfigEntryEnum<T>(clazz, value2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigEntryEnum<T extends Enum<T>>
    extends ConfigEntry<T> {
        private T value;

        public ConfigEntryEnum(Class<T> clazz, String value2) {
            super(null, false, new ParameterEntry[0]);
            for (Enum tmp : (Enum[])clazz.getEnumConstants()) {
                if (!tmp.name().equals(value2)) continue;
                this.value = tmp;
                return;
            }
        }

        @Override
        public T getInstance() throws Exception {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigEntryPrimitive<T>
    extends ConfigEntry<T> {
        private T value;
        private boolean runtime;

        public ConfigEntryPrimitive(T value2, boolean runtime) {
            super(null, false, new ParameterEntry[0]);
            this.value = value2;
            this.runtime = runtime;
        }

        @Override
        public T getInstance() throws Exception {
            return this.value;
        }

        public boolean getRuntime() {
            return this.runtime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigEntryFactoryMethod<T>
    extends ConfigEntry<T> {
        private String factoryMethod;

        public ConfigEntryFactoryMethod(Class<T> clazz, String factoryMethod, boolean singleton, ParameterEntry ... parameters) {
            super(clazz, singleton, parameters);
            this.factoryMethod = factoryMethod;
        }

        @Override
        public T getInstance() throws Exception {
            Object instance = null;
            if (!this.singleton || this.singletonInstance == null) {
                InjectionMethod inWay = this.clazz.getAnnotation(InjectionMethod.class);
                InjectStrategy strategy = null;
                strategy = inWay != null ? (inWay.injectionStrategy().equals((Object)InjectionMethod.InjectionStrategy.initialization) ? InjectStrategy.getForFactoryMethod(this.clazz, this.factoryMethod) : InjectStrategy.getForSetter(this.clazz, CreateBy.factoryMethod, this.factoryMethod)) : InjectStrategy.getDefault(this.clazz, CreateBy.factoryMethod, this.factoryMethod);
                instance = strategy.inject(this.clazz, this.parameters);
                if (this.singleton) {
                    this.singletonInstance = instance;
                }
            } else {
                instance = this.singletonInstance;
            }
            return (T)instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigEntryConstructor<T>
    extends ConfigEntry<T> {
        public ConfigEntryConstructor(Class<T> clazz, boolean singleton, ParameterEntry ... parameters) {
            super(clazz, singleton, parameters);
        }

        @Override
        public T getInstance() throws Exception {
            Object instance = null;
            if (!this.singleton || this.singletonInstance == null) {
                InjectionMethod inWay = this.clazz.getAnnotation(InjectionMethod.class);
                InjectStrategy strategy = null;
                strategy = inWay != null ? (inWay.injectionStrategy().equals((Object)InjectionMethod.InjectionStrategy.initialization) ? InjectStrategy.getForConstructor(this.clazz) : InjectStrategy.getForSetter(this.clazz, CreateBy.constructor, null)) : InjectStrategy.getDefault(this.clazz, CreateBy.constructor, null);
                instance = strategy.inject(this.clazz, this.parameters);
                if (this.singleton) {
                    this.singletonInstance = instance;
                }
            } else {
                instance = this.singletonInstance;
            }
            return (T)instance;
        }
    }
}

