/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.bool;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableIconInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.util.math.Orientation;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class VectorCache {
    private static boolean DEBUG = false;
    private static final boolean USE_ELECTRICAL = false;
    private static final boolean WIPE_PINS = true;
    private Set<Layer> layers = new TreeSet<Layer>();
    private Set<Layer> badLayers = new HashSet<Layer>();
    private final Snapshot snapshot;
    private final TechPool techPool;
    private HashMap<CellId, MyVectorCell> cells = new HashMap();
    private final PrimitivePortId busPinPortId;
    private final PrimitiveNodeId cellCenterId;
    private final PrimitiveNodeId essentialBoundsId;
    private final ShapeBuilder shapeBuilder = new ShapeBuilder();
    private final HashMap<Layer, VectorManhattanBuilder> boxBuilders = new HashMap();
    private static final int[] NULL_INT_ARRAY = new int[0];

    public Collection<Layer> getLayers() {
        return new ArrayList<Layer>(this.layers);
    }

    public Collection<Layer> getBadLayers() {
        return new ArrayList<Layer>(this.badLayers);
    }

    public boolean isBadLayer(Layer layer) {
        return this.badLayers.contains(layer);
    }

    public VectorCache(Snapshot snapshot) {
        this.snapshot = snapshot;
        this.techPool = snapshot.getTechPool();
        this.busPinPortId = this.techPool.getSchematics().busPinNode.getPort(0).getId();
        this.cellCenterId = this.techPool.getGeneric().cellCenterNode.getId();
        this.essentialBoundsId = this.techPool.getGeneric().essentialBoundsNode.getId();
    }

    public void scanLayers(CellId topCellId) {
        HashSet<CellId> visited = new HashSet<CellId>();
        this.scanLayers(topCellId, visited);
    }

    public List<ImmutableNodeInst> getSubcells(CellId cellId) {
        return this.findVectorCell(cellId).unmodifiebleSubCells;
    }

    public int getNumBoxes(CellId cellId, Layer layer) {
        CellLayer cellLayer = (CellLayer)this.findVectorCell(cellId).layers.get(layer);
        return cellLayer != null ? cellLayer.boxCoords.length / 4 : 0;
    }

    public int getNumFlatBoxes(CellId cellId, Layer layer) {
        return this.getNumFlatBoxes(cellId, layer, new HashMap<CellId, Integer>());
    }

    public ERectangle getLocalBounds(CellId cellId, Layer layer) {
        CellLayer cellLayer = (CellLayer)this.findVectorCell(cellId).layers.get(layer);
        return cellLayer != null ? cellLayer.localBounds : null;
    }

    public void getBoxes(CellId cellId, Layer layer, int offset, int size2, int[] result2) {
        CellLayer cellLayer = (CellLayer)this.findVectorCell(cellId).layers.get(layer);
        if (cellLayer == null || offset < 0 || size2 < 0 || offset + size2 > cellLayer.boxCoords.length / 4 || size2 > result2.length / 4) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(cellLayer.boxCoords, offset * 4, result2, 0, size2 * 4);
    }

    public void collectLayer(Layer layer, CellId cellId, boolean rotate, PutRectangle putRectangle) {
        Orientation orient = (rotate ? Orientation.XR : Orientation.IDENT).canonic();
        this.collectLayer(layer, this.findVectorCell(cellId), new Point(0, 0), orient, putRectangle);
    }

    private void scanLayers(CellId cellId, HashSet<CellId> visited) {
        if (!visited.add(cellId)) {
            return;
        }
        MyVectorCell mvc = this.findVectorCell(cellId);
        for (ImmutableNodeInst n : mvc.subCells) {
            this.scanLayers((CellId)n.protoId, visited);
        }
    }

    private MyVectorCell findVectorCell(CellId cellId) {
        MyVectorCell mvc = this.cells.get(cellId);
        if (mvc == null) {
            mvc = new MyVectorCell(cellId);
            this.cells.put(cellId, mvc);
        }
        return mvc;
    }

    private int getNumFlatBoxes(CellId cellId, Layer layer, HashMap<CellId, Integer> numFlatBoxes) {
        Integer num = numFlatBoxes.get(cellId);
        if (num == null) {
            int count2 = this.getNumBoxes(cellId, layer);
            for (ImmutableNodeInst n : this.getSubcells(cellId)) {
                count2 += this.getNumFlatBoxes((CellId)n.protoId, layer, numFlatBoxes);
            }
            num = count2;
            numFlatBoxes.put(cellId, num);
        }
        return num;
    }

    private void addBoxesFromBuilder(MyVectorCell vc, HashMap<Layer, VectorManhattanBuilder> boxBuilders) {
        for (Map.Entry<Layer, VectorManhattanBuilder> e : boxBuilders.entrySet()) {
            Layer layer = e.getKey();
            VectorManhattanBuilder b = e.getValue();
            if (b.size == 0) continue;
            CellLayer cellLayer = vc.getCellLayer(layer);
            assert (cellLayer.boxCoords.length == 0);
            cellLayer.setBoxCoords(b.toArray());
        }
    }

    private void collectLayer(Layer layer, MyVectorCell vc, Point anchor, Orientation orient, PutRectangle putRectangle) {
        int[] coords = new int[4];
        CellLayer cellLayer = (CellLayer)vc.layers.get(layer);
        if (cellLayer != null) {
            int[] boxCoords = cellLayer.boxCoords;
            for (int i = 0; i < boxCoords.length; i += 4) {
                coords[0] = boxCoords[i + 0];
                coords[1] = boxCoords[i + 1];
                coords[2] = boxCoords[i + 2];
                coords[3] = boxCoords[i + 3];
                orient.rectangleBounds(coords);
                int lx = anchor.x + coords[0];
                int ly = anchor.y + coords[1];
                int hx = anchor.x + coords[2];
                int hy = anchor.y + coords[3];
                assert (lx <= hx && ly <= hy);
                putRectangle.put(lx, ly, hx, hy);
            }
        }
        for (ImmutableNodeInst n : vc.subCells) {
            assert (n.orient.isManhattan());
            coords[0] = (int)n.anchor.getGridX();
            coords[1] = (int)n.anchor.getGridY();
            orient.transformPoints(1, coords);
            Orientation subOrient = orient.concatenate(n.orient).canonic();
            MyVectorCell subCell = this.findVectorCell((CellId)n.protoId);
            this.collectLayer(layer, subCell, new Point(anchor.x + coords[0], anchor.y + coords[1]), subOrient, putRectangle);
        }
    }

    private boolean isCellParameterized(CellRevision cellRevision) {
        Variable var;
        Iterator<Variable> vIt;
        if (cellRevision.d.getNumParameters() > 0) {
            return true;
        }
        for (ImmutableNodeInst n : cellRevision.nodes) {
            if (n instanceof ImmutableIconInst) {
                vIt = ((ImmutableIconInst)n).getDefinedParameters();
                while (vIt.hasNext()) {
                    var = vIt.next();
                    if (!var.isCode()) continue;
                    return true;
                }
            }
            vIt = n.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isCode()) continue;
                return true;
            }
        }
        for (ImmutableArcInst a : cellRevision.arcs) {
            vIt = a.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isCode()) continue;
                return true;
            }
        }
        for (ImmutableExport e : cellRevision.exports) {
            if (e.originalPortId != this.busPinPortId) continue;
            return true;
        }
        return false;
    }

    private void badLayer(Layer layer) {
        if (this.badLayers.add(layer)) {
            // empty if block
        }
    }

    private static void putBox(Layer layer, HashMap<Layer, VectorManhattanBuilder> boxBuilders, int lX, int lY, int hX, int hY) {
        VectorManhattanBuilder b = boxBuilders.get(layer);
        if (b == null) {
            b = new VectorManhattanBuilder();
            boxBuilders.put(layer, b);
        }
        assert (lX <= hX && lY <= hY);
        if (lX < hX && lY < hY) {
            b.add(lX, lY, hX, hY);
        }
    }

    static /* synthetic */ int[] access$100() {
        return NULL_INT_ARRAY;
    }

    static class VectorManhattanBuilder {
        int size;
        int[] coords = new int[4];

        VectorManhattanBuilder() {
        }

        private void add(int lX, int lY, int hX, int hY) {
            if (this.size * 4 >= this.coords.length) {
                int[] newCoords = new int[this.coords.length * 2];
                System.arraycopy(this.coords, 0, newCoords, 0, this.coords.length);
                this.coords = newCoords;
            }
            int i = this.size * 4;
            this.coords[i] = lX;
            this.coords[i + 1] = lY;
            this.coords[i + 2] = hX;
            this.coords[i + 3] = hY;
            ++this.size;
        }

        int[] toArray() {
            int[] a = new int[this.size * 4];
            System.arraycopy(this.coords, 0, a, 0, a.length);
            return a;
        }

        private void clear() {
            this.size = 0;
        }
    }

    static class MyVectorPolygon {
        final Layer layer;
        final Poly.Type style;
        final Point2D[] points;

        private MyVectorPolygon(Poly.Type style, Layer layer, Point2D[] points) {
            this.layer = layer;
            this.style = style;
            this.points = points;
        }
    }

    private class ShapeBuilder
    extends AbstractShapeBuilder {
        private Layer polyLayer;

        private ShapeBuilder() {
        }

        @Override
        public void pushPoly(Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
            if (layer.getFunction() == Layer.Function.GATE && this.polyLayer != null) {
                layer = this.polyLayer;
            }
            super.pushPoly(style, layer, null, null);
        }

        @Override
        public void addPoly(int numPoints, Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
            if (numPoints == 2) {
                return;
            }
            if (layer.isPseudoLayer()) {
                return;
            }
            if (style == Poly.Type.FILLED && graphicsOverride == null && pp == null && this.isManhattan(numPoints, layer)) {
                return;
            }
            VectorCache.this.badLayer(layer);
        }

        @Override
        public void addTextPoly(int numPoints, Poly.Type style, Layer layer, PrimitivePort pp, String message, TextDescriptor descriptor) {
            VectorCache.this.badLayer(layer);
        }

        @Override
        public void addBox(Layer layer) {
            int lX = (int)(this.coords[0] >> 20);
            int lY = (int)(this.coords[1] >> 20);
            int hX = (int)(this.coords[2] >> 20);
            int hY = (int)(this.coords[3] >> 20);
            if (this.coords[0] == (long)lX << 20 && this.coords[1] == (long)lY << 20 && this.coords[2] == (long)hX << 20 && this.coords[3] == (long)hY << 20) {
                VectorCache.this.layers.add(layer);
                VectorCache.putBox(layer, VectorCache.this.boxBuilders, lX, lY, hX, hY);
            } else {
                VectorCache.this.badLayer(layer);
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean isManhattan(int numPoints, Layer layer) {
            void var13_20;
            if (numPoints % 2 != 0) {
                return false;
            }
            TreeMap xcoords = new TreeMap();
            TreeMap ycoords = new TreeMap();
            int minI = 0;
            int minX = (int)(this.coords[0] >> 20);
            int minY = (int)(this.coords[1] >> 20);
            if ((long)minX << 20 != this.coords[0] || (long)minY << 20 != this.coords[1]) {
                return false;
            }
            xcoords.put(minX, null);
            ycoords.put(minY, null);
            for (int i = 1; i < numPoints; ++i) {
                int x2 = (int)(this.coords[i * 2 + 0] >> 20);
                int y = (int)(this.coords[i * 2 + 1] >> 20);
                if ((long)x2 << 20 != this.coords[i * 2 + 0] || (long)y << 20 != this.coords[i * 2 + 1]) {
                    return false;
                }
                if (x2 < minX || x2 == minX && y < minY) {
                    minI = i;
                    minX = x2;
                    minY = y;
                }
                xcoords.put(x2, null);
                ycoords.put(y, null);
            }
            int[] xvals = new int[xcoords.size()];
            int ix = 0;
            for (Map.Entry entry : xcoords.entrySet()) {
                int xv;
                xvals[ix] = xv = ((Integer)entry.getKey()).intValue();
                entry.setValue(ix);
                ++ix;
            }
            int[] yvals = new int[ycoords.size()];
            boolean bl = false;
            for (Map.Entry entry : ycoords.entrySet()) {
                void var11_15;
                int yv;
                yvals[var11_15] = yv = ((Integer)entry.getKey()).intValue();
                entry.setValue((int)var11_15);
                ++var11_15;
            }
            ArrayList accum = new ArrayList();
            boolean bl2 = false;
            while (var13_20 < xcoords.size()) {
                accum.add(new ArrayList());
                ++var13_20;
            }
            boolean bl3 = this.coords[(minI + 1) % numPoints * 2] >> 20 != (long)minX;
            for (int i = 0; i < numPoints / 2; ++i) {
                int x1i;
                int x0i;
                int yi;
                int x0 = (int)(this.coords[(minI + i * 2) % numPoints * 2 + 0] >> 20);
                int y0 = (int)(this.coords[(minI + i * 2) % numPoints * 2 + 1] >> 20);
                int x1 = (int)(this.coords[(minI + i * 2 + 1) % numPoints * 2 + 0] >> 20);
                int y1 = (int)(this.coords[(minI + i * 2 + 1) % numPoints * 2 + 1] >> 20);
                int x2 = (int)(this.coords[(minI + i * 2 + 2) % numPoints * 2 + 0] >> 20);
                int y2 = (int)(this.coords[(minI + i * 2 + 2) % numPoints * 2 + 1] >> 20);
                if (bl3) {
                    if (x1 == x0 || y1 != y0 || y2 == y1 || x2 != x1) {
                        return false;
                    }
                    yi = (Integer)ycoords.get(y0);
                    x0i = (Integer)xcoords.get(x0);
                    x1i = (Integer)xcoords.get(x1);
                } else {
                    if (x1 != x0 || y1 == y0 || y2 != y1 || x2 == x1) {
                        return false;
                    }
                    yi = (Integer)ycoords.get(y1);
                    x0i = (Integer)xcoords.get(x2);
                    x1i = (Integer)xcoords.get(x1);
                }
                assert (x0i != x1i);
                if (x0i < x1i) {
                    for (int x3 = x0i; x3 < x1i; ++x3) {
                        ((List)accum.get(x3)).add((long)yi << 1);
                    }
                    continue;
                }
                for (int x3 = x1i; x3 < x0i; ++x3) {
                    ((List)accum.get(x3)).add((long)yi << 1 | 1L);
                }
            }
            for (int x4 = 0; x4 < accum.size(); ++x4) {
                List yl = (List)accum.get(x4);
                Collections.sort(yl);
                Integer prevY = null;
                for (Long y : yl) {
                    int thisY = (int)(y >> 1);
                    if ((y & 1L) != 0L) {
                        if (prevY == null) {
                            return false;
                        }
                        for (int yi = prevY.intValue(); yi < thisY; ++yi) {
                            VectorCache.putBox(layer, VectorCache.this.boxBuilders, xvals[x4], yvals[yi], xvals[x4 + 1], yvals[yi + 1]);
                        }
                        prevY = null;
                        continue;
                    }
                    if (prevY != null) {
                        return false;
                    }
                    prevY = thisY;
                }
            }
            return true;
        }
    }

    public static interface PutRectangle {
        public void put(int var1, int var2, int var3, int var4);
    }

    private class MyVectorCell {
        private final TechId techId;
        private final TreeMap<Layer, CellLayer> layers = new TreeMap();
        private final ArrayList<ImmutableNodeInst> subCells = new ArrayList();
        private final List<ImmutableNodeInst> unmodifiebleSubCells = Collections.unmodifiableList(this.subCells);

        MyVectorCell(CellId cellId) {
            CellBackup cellBackup = VectorCache.this.snapshot.getCell(cellId);
            this.techId = cellBackup.cellRevision.d.techId;
            Technology tech = VectorCache.this.techPool.getTech(this.techId);
            if (VectorCache.this.isCellParameterized(cellBackup.cellRevision)) {
                throw new IllegalArgumentException();
            }
            long startTime = DEBUG ? System.currentTimeMillis() : 0L;
            for (VectorManhattanBuilder b : VectorCache.this.boxBuilders.values()) {
                b.clear();
            }
            VectorCache.this.shapeBuilder.setup(cellBackup, Orientation.IDENT, false, true, false, null);
            VectorCache.this.shapeBuilder.polyLayer = null;
            for (Layer layer : tech.getLayersSortedByHeight()) {
                if (layer.getFunction() != Layer.Function.POLY1) continue;
                VectorCache.this.shapeBuilder.polyLayer = layer;
            }
            for (ImmutableArcInst a : cellBackup.cellRevision.arcs) {
                VectorCache.this.shapeBuilder.genShapeOfArc(a);
            }
            for (ImmutableNodeInst n : cellBackup.cellRevision.nodes) {
                if (n.protoId instanceof CellId) {
                    if (!n.orient.isManhattan()) {
                        throw new IllegalArgumentException();
                    }
                    this.subCells.add(n);
                    continue;
                }
                boolean hideOnLowLevel = n.is(ImmutableNodeInst.VIS_INSIDE) || n.protoId == VectorCache.this.cellCenterId || n.protoId == VectorCache.this.essentialBoundsId;
                if (hideOnLowLevel) continue;
                PrimitiveNode pn = VectorCache.this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId);
                pn.genShape(VectorCache.this.shapeBuilder, n);
            }
            VectorCache.this.addBoxesFromBuilder(this, VectorCache.this.boxBuilders);
            if (DEBUG) {
                long stopTime = System.currentTimeMillis();
                System.out.println(stopTime - startTime + " init " + cellBackup.cellRevision.d.cellId);
            }
        }

        private CellLayer getCellLayer(Layer layer) {
            CellLayer cellLayer = this.layers.get(layer);
            if (cellLayer == null) {
                cellLayer = new CellLayer(layer);
                this.layers.put(layer, cellLayer);
            }
            return cellLayer;
        }
    }

    private static class CellLayer {
        final Layer layer;
        int[] boxCoords = VectorCache.access$100();
        ERectangle localBounds;
        ArrayList<MyVectorPolygon> polys = new ArrayList();

        private CellLayer(Layer layer) {
            this.layer = layer;
        }

        private void setBoxCoords(int[] boxCoords) {
            this.boxCoords = boxCoords;
            int lX = Integer.MAX_VALUE;
            int lY = Integer.MAX_VALUE;
            int hX = Integer.MIN_VALUE;
            int hY = Integer.MIN_VALUE;
            for (int i = 0; i < boxCoords.length; i += 4) {
                lX = Math.min(lX, boxCoords[i + 0]);
                lY = Math.min(lY, boxCoords[i + 1]);
                hX = Math.max(hX, boxCoords[i + 2]);
                hY = Math.max(hY, boxCoords[i + 3]);
            }
            this.localBounds = ERectangle.fromGrid(lX, hY, (long)hX - (long)lX, (long)hY - (long)lY);
        }
    }
}

