/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.GenerateLayoutForGatesInSchematic;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.StdCellParams350;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.gates.Inv350;
import com.sun.electric.tool.generator.layout.gates.MoCMOSGenerator;
import com.sun.electric.tool.user.User;
import java.lang.reflect.Method;
import java.util.Map;

public class GateLayoutGenerator {
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        @Override
        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };

    public static Cell generateCell(Library outputLib, StdCellParams stdCell, String type, double Xstrength) {
        if (outputLib == null) {
            return null;
        }
        TechType tech = stdCell.getTechType();
        stdCell.setOutputLibrary(outputLib);
        if (Xstrength < 0.0) {
            return null;
        }
        int pwr = type.indexOf("_pwr");
        if (pwr != -1) {
            type = type.substring(0, pwr);
        }
        Cell c = null;
        if (tech.getTechnology() == Technology.getCMOS90Technology()) {
            try {
                Class<?> cmos90GeneratorClass = Class.forName("com.sun.electric.plugins.tsmc.gates90nm.CMOS90Generator");
                Class[] parameterTypes = new Class[]{String.class, Double.class, StdCellParams.class};
                Method makeGateMethod = cmos90GeneratorClass.getDeclaredMethod("makeGate", parameterTypes);
                c = (Cell)makeGateMethod.invoke(null, type, new Double(Xstrength), stdCell);
            }
            catch (Exception e) {
                System.out.println("ERROR invoking the CMOS90 gate generator");
            }
        } else if (tech.getTechnology().getTechName().equals("MIMOS_035")) {
            if (type.equals("inv")) {
                c = Inv350.makePart(Xstrength, "", stdCell);
            } else {
                System.out.println("Can't generate cell " + type + " for technology " + tech.name());
            }
        } else {
            c = MoCMOSGenerator.makeGate(type, Xstrength, stdCell);
        }
        return c;
    }

    public static Map<Nodable, Cell> generateLayoutFromSchematics(Library outLib, Cell cell, VarContext context, StdCellParams stdCell, boolean topLevelOnly) {
        stdCell.setOutputLibrary(outLib);
        GenerateLayoutForGatesInSchematic visitor = new GenerateLayoutForGatesInSchematic(stdCell, topLevelOnly);
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)visitor);
        Map<Nodable, Cell> result2 = visitor.getGeneratedCells();
        if (result2.size() > 0) {
            Cell gallery = Gallery.makeGallery(outLib, stdCell.getEditingPreferences());
            DrcRings.addDrcRings(gallery, FILTER, stdCell);
        }
        return result2;
    }

    public static void generateFromSchematicsJob(Technology technology) {
        GenerateFromSchematicsJob job = new GenerateFromSchematicsJob(technology);
        job.startJob();
    }

    public static StdCellParams locoParams(EditingPreferences ep) {
        StdCellParams stdCell = new StdCellParams(Technology.getMocmosTechnology(), ep);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams sportParams(EditingPreferences ep) {
        return GateLayoutGenerator.sportParams(ep, true);
    }

    public static StdCellParams sportParams(EditingPreferences ep, boolean enableNCC) {
        StdCellParams stdCell = new StdCellParams(Technology.getCMOS90Technology(), ep);
        if (enableNCC) {
            stdCell.enableNCC("purpleFour");
        }
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(24.5);
        stdCell.setGndY(-24.5);
        stdCell.setNmosWellHeight(84.0);
        stdCell.setPmosWellHeight(84.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams dividerParams(Technology technology, EditingPreferences ep) {
        return GateLayoutGenerator.dividerParams(technology, ep, true);
    }

    public static StdCellParams dividerParams(Technology technology, EditingPreferences ep, boolean enableNCC) {
        StdCellParams stdCell = new StdCellParams(technology, ep);
        if (enableNCC) {
            stdCell.enableNCC("purpleFour");
        }
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(84.0);
        stdCell.setPmosWellHeight(84.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams fastProxParams(Technology technology, EditingPreferences ep) {
        StdCellParams stdCell = new StdCellParams(technology, ep);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(24.0);
        stdCell.setGndY(-24.0);
        stdCell.setVddWidth(9.0);
        stdCell.setGndWidth(9.0);
        stdCell.setNmosWellHeight(60.0);
        stdCell.setPmosWellHeight(60.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams justinParams(Technology technology, EditingPreferences ep) {
        StdCellParams stdCell = new StdCellParams(technology, ep);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static class GenerateFromSchematicsJob
    extends Job {
        static final long serialVersionUID = 0L;
        private Technology technology;
        private Cell cell;
        private VarContext context;

        public GenerateFromSchematicsJob(Technology technology) {
            super("Generate gate layouts", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
            this.technology = technology;
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.needCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            this.cell = wnd.getCell();
            this.context = wnd.getVarContext();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            String outLibNm = "autoGenLib" + this.technology;
            Library outLib = LayoutLib.openLibForWrite(outLibNm);
            StdCellParams stdCell = this.technology == Technology.getCMOS90Technology() ? GateLayoutGenerator.sportParams(ep) : (this.technology.getTechName().equals("MIMOS_035") ? StdCellParams350.invParams(this.technology, ep) : GateLayoutGenerator.dividerParams(this.technology, ep));
            if (this.cell == null) {
                System.out.println("Please open the schematic for which you want to generate gate layouts.");
                return false;
            }
            if (!this.cell.isSchematic()) {
                System.out.println("The current cell isn't a schematic. This command only works on schematics.");
                return false;
            }
            System.out.println("Generating layouts for gates in the schematic: " + this.cell.getName() + " and its descendents");
            System.out.println("Output goes to library: " + outLibNm);
            GateLayoutGenerator.generateLayoutFromSchematics(outLib, this.cell, this.context, stdCell, false);
            System.out.println("done.");
            return true;
        }
    }
}

