/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LEF
extends Output {
    private Layer io_lefoutcurlayer;
    private Set<NodeInst> nodesSeen;
    private Set<ArcInst> arcsSeen;
    private LEFPreferences localPrefs;

    LEF(LEFPreferences lp) {
        this.localPrefs = lp;
    }

    private void init(Netlist netList) {
        int i;
        Cell cell = netList.getCell();
        Technology tech = cell.getTechnology();
        double nanometersPerUnit = tech.getScale();
        ECoord resolution = tech.getFactoryResolution();
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("# Electric VLSI Design System, version " + Version.getVersion());
            this.printWriter.println("# " + TextUtils.formatDate(new Date()));
        } else {
            this.printWriter.println("# Electric VLSI Design System");
        }
        this.emitCopyright("# ", "");
        this.printWriter.println("");
        this.printWriter.println("NAMESCASESENSITIVE ON ;");
        this.printWriter.println("UNITS");
        this.printWriter.println("  DATABASE MICRONS " + TextUtils.formatDouble(nanometersPerUnit / 1000.0) + " ;");
        this.printWriter.println("END UNITS");
        this.printWriter.println("MANUFACTURINGGRID " + resolution + " ;");
        this.printWriter.println("");
        for (i = 0; i < 8; ++i) {
            this.printWriter.println("LAYER METAL" + (i + 1));
            this.printWriter.println("  TYPE ROUTING ;");
            this.printWriter.println("END METAL" + (i + 1));
            this.printWriter.println("");
        }
        this.printWriter.println("LAYER CONT");
        this.printWriter.println("  TYPE CUT ;");
        this.printWriter.println("END CONT");
        this.printWriter.println("");
        for (i = 0; i < 3; ++i) {
            this.printWriter.println("LAYER VIA" + (i + 1) + (i + 2));
            this.printWriter.println("  TYPE CUT ;");
            this.printWriter.println("END VIA: " + (i + 1) + (i + 2));
            this.printWriter.println("");
        }
        for (i = 0; i < 3; ++i) {
            this.printWriter.println("LAYER POLY" + (i + 1));
            this.printWriter.println("  TYPE MASTERSLICE ;");
            this.printWriter.println("END POLY" + (i + 1));
            this.printWriter.println("");
        }
        this.printWriter.println("LAYER PDIFF");
        this.printWriter.println("  TYPE MASTERSLICE ;");
        this.printWriter.println("END PDIFF");
        this.printWriter.println("");
        this.printWriter.println("LAYER NDIFF");
        this.printWriter.println("  TYPE MASTERSLICE ;");
        this.printWriter.println("END NDIFF");
        this.printWriter.println("");
        this.printWriter.println("MACRO " + cell.getName());
        this.printWriter.println("  CLASS CORE ;");
        this.printWriter.println("  FOREIGN " + cell.getName() + " 0 0 ;");
        this.printWriter.println("  ORIGIN 0 0 ;");
        ERectangle bounds = cell.getBounds();
        double width = TextUtils.convertDistance(((RectangularShape)bounds).getWidth(), tech, TextUtils.UnitScale.MICRO);
        double height = TextUtils.convertDistance(((RectangularShape)bounds).getHeight(), tech, TextUtils.UnitScale.MICRO);
        this.printWriter.println("  SIZE " + TextUtils.formatDouble(width) + " BY " + TextUtils.formatDouble(height) + " ;");
        this.printWriter.println("  SYMMETRY X Y ;");
        this.printWriter.println("  SITE " + cell.getName() + " ;");
        this.nodesSeen = new HashSet<NodeInst>();
        this.arcsSeen = new HashSet<ArcInst>();
        HashMap<Network, ArrayList<Export>> unconnectedExports = new HashMap<Network, ArrayList<Export>>();
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            Network net = netList.getNetwork(e, 0);
            ArrayList<Export> exportsOnNet = (ArrayList<Export>)unconnectedExports.get(net);
            if (exportsOnNet == null) {
                exportsOnNet = new ArrayList<Export>();
                unconnectedExports.put(net, exportsOnNet);
            }
            exportsOnNet.add(e);
        }
        ArrayList<Network> netsToWrite = new ArrayList<Network>();
        for (Network net : unconnectedExports.keySet()) {
            netsToWrite.add(net);
        }
        Collections.sort(netsToWrite, new TextUtils.NetworksByName());
        boolean first = true;
        for (Network net : netsToWrite) {
            List exportsOnNet = (List)unconnectedExports.get(net);
            Export main2 = null;
            for (Export e : exportsOnNet) {
                if (main2 == null) {
                    main2 = e;
                    continue;
                }
                if (main2.getName().length() <= e.getName().length()) continue;
                main2 = e;
            }
            if (first) {
                first = false;
            } else {
                this.printWriter.println();
            }
            this.printWriter.println("  PIN " + main2.getName());
            HashSet<NodeInst> nodesUnderExports = new HashSet<NodeInst>();
            PortCharacteristic type = PortCharacteristic.UNKNOWN;
            for (Export e : exportsOnNet) {
                type = e.getCharacteristic();
                nodesUnderExports.add(e.getOriginalPort().getNodeInst());
            }
            if (type == PortCharacteristic.IN || type.isClock() || type == PortCharacteristic.REFIN) {
                this.printWriter.println("    DIRECTION INPUT ;");
            } else if (type == PortCharacteristic.OUT || type == PortCharacteristic.REFOUT) {
                this.printWriter.println("    DIRECTION OUTPUT ;");
            } else if (type == PortCharacteristic.BIDIR) {
                this.printWriter.println("    DIRECTION INOUT ;");
            } else if (type == PortCharacteristic.GND) {
                this.printWriter.println("    DIRECTION INOUT ;\n    USE GROUND ;");
            } else if (type == PortCharacteristic.PWR) {
                this.printWriter.println("    DIRECTION INOUT ;\n    USE POWER ;");
            }
            for (Export e : exportsOnNet) {
                PrimitiveNode np;
                Technology.NodeLayer[] nls;
                PortOriginal fp = new PortOriginal(e.getOriginalPort());
                NodeInst rni = fp.getBottomNodeInst();
                PrimitivePort rpp = fp.getBottomPortProto();
                FixpTransform trans = fp.getTransformToTop();
                this.printWriter.println("    PORT");
                this.io_lefoutcurlayer = null;
                Poly[] polys = tech.getShapeOfNode(rni, true, false, null);
                if (polys.length == 0 && (nls = (np = (PrimitiveNode)rni.getProto()).getNodeLayers()).length > 0) {
                    polys = new Poly[]{new Poly(rni.getAnchorCenterX(), rni.getAnchorCenterY(), rni.getXSize(), rni.getYSize())};
                    polys[0].setLayer(nls[0].getLayer().getNonPseudoLayer());
                    polys[0].setPort(rpp);
                }
                for (int i2 = 0; i2 < polys.length; ++i2) {
                    Poly poly = polys[i2];
                    if (poly.getPort() != rpp) continue;
                    this.io_lefwritepoly(poly, trans, tech, true);
                }
                if (e == main2) {
                    this.io_lefoutspread(cell, net, nodesUnderExports, netList);
                }
                this.printWriter.println("    END");
            }
            if (main2.getCharacteristic() == PortCharacteristic.PWR) {
                this.printWriter.println("    USE POWER ;");
            }
            if (main2.getCharacteristic() == PortCharacteristic.GND) {
                this.printWriter.println("    USE GROUND ;");
            }
            this.printWriter.println("  END " + main2.getName());
        }
        this.printWriter.println("");
        this.printWriter.println("  OBS");
        this.io_lefoutcurlayer = null;
    }

    private void term(Cell cell) {
        this.printWriter.println("  END");
        this.printWriter.println("");
        this.printWriter.println("END " + cell.getName());
        this.printWriter.println("");
        this.printWriter.println("END LIBRARY");
    }

    private void writeCellContents(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        FixpTransform trans = info.getTransformToRoot();
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance() || info.isRootCell() && this.nodesSeen.contains(ni)) continue;
            FixpTransform rot = ni.rotateOut(trans);
            Technology tech = ni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, rot, tech, false);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (info.isRootCell() && this.arcsSeen.contains(ai)) continue;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, trans, tech, false);
            }
        }
    }

    void io_lefoutspread(Cell cell, Network net, Set<NodeInst> nodesUnderExports, Netlist netList) {
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            PrimitiveNode.Function fun;
            NodeInst ni = it.next();
            if (ni.isCellInstance() || nodesUnderExports.contains(ni) || !(fun = ni.getFunction()).isPin() && !fun.isContact() && fun != PrimitiveNode.Function.NODE && fun != PrimitiveNode.Function.WELL && fun != PrimitiveNode.Function.SUBSTRATE && fun != PrimitiveNode.Function.CONNECT) continue;
            boolean found = true;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                Network pNet = netList.getNetwork(pi);
                if (pNet == net) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.nodesSeen.add(ni);
            FixpTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, trans, tech, true);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Network aNet = netList.getNetwork(ai, 0);
            if (aNet != net) continue;
            this.arcsSeen.add(ai);
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                this.io_lefwritepoly(poly, GenMath.MATID, tech, true);
            }
        }
    }

    private void io_lefwritepoly(Poly poly, FixpTransform trans, Technology tech, boolean extraIndent) {
        Layer layer = poly.getLayer();
        if (layer == null) {
            return;
        }
        String layername = this.io_lefoutlayername(layer);
        if (layername.length() == 0) {
            return;
        }
        poly.transform(trans);
        FixpRectangle polyBounds = poly.getBox();
        if (polyBounds == null) {
            return;
        }
        double flx = TextUtils.convertDistance(((RectangularShape)polyBounds).getMinX(), tech, TextUtils.UnitScale.MICRO);
        double fly = TextUtils.convertDistance(((RectangularShape)polyBounds).getMinY(), tech, TextUtils.UnitScale.MICRO);
        double fhx = TextUtils.convertDistance(((RectangularShape)polyBounds).getMaxX(), tech, TextUtils.UnitScale.MICRO);
        double fhy = TextUtils.convertDistance(((RectangularShape)polyBounds).getMaxY(), tech, TextUtils.UnitScale.MICRO);
        if (layer != this.io_lefoutcurlayer) {
            if (extraIndent) {
                this.printWriter.print("  ");
            }
            this.printWriter.println("    LAYER " + layername + " ;");
            this.io_lefoutcurlayer = layer;
        }
        if (extraIndent) {
            this.printWriter.print("  ");
        }
        this.printWriter.println("      RECT " + TextUtils.formatDouble(flx) + " " + TextUtils.formatDouble(fly) + " " + TextUtils.formatDouble(fhx) + " " + TextUtils.formatDouble(fhy) + " ;");
    }

    private String io_lefoutlayername(Layer layer) {
        Layer.Function fun = (layer = layer.getNonPseudoLayer()).getFunction();
        if (fun.isMetal()) {
            return "METAL" + fun.getLevel();
        }
        if (fun == Layer.Function.GATE) {
            return "POLY1";
        }
        if (fun.isPoly()) {
            return "POLY" + fun.getLevel();
        }
        if (fun.isContact()) {
            int level = fun.getLevel();
            if (level == 1) {
                return "CONT";
            }
            if (level < 10) {
                return "VIA" + (level - 1) + level;
            }
            if (level == 10) {
                return "VIA9";
            }
            return "VIA" + (level - 1);
        }
        if (fun == Layer.Function.DIFFN) {
            return "NDIFF";
        }
        if (fun == Layer.Function.DIFFP) {
            return "PDIFF";
        }
        if (fun == Layer.Function.DIFF) {
            return "DIFF";
        }
        return "";
    }

    private static class Visitor
    extends HierarchyEnumerator.Visitor {
        private LEF generator;

        public Visitor(LEF generator) {
            this.generator = generator;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            this.generator.writeCellContents(info);
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }

    public static class LEFPreferences
    extends Output.OutputPreferences {
        public LEFPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            LEF out = new LEF(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            Netlist netlist = cell.getNetlist(Netlist.ShortResistors.ALL);
            out.init(netlist);
            HierarchyEnumerator.enumerateCell(netlist, context, (HierarchyEnumerator.Visitor)new Visitor(out));
            out.term(cell);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

